/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.commons.mib.editor;

import com.agentpp.common.SearchReplacePanel;
import com.agentpp.common.StandardDialog;
import com.agentpp.common.TableSorter;
import com.agentpp.common.font.FontStyle;
import com.agentpp.common.images.ToolBarUtils;
import com.agentpp.common.smi.editor.LineNumberRowHeaderView;
import com.agentpp.common.smi.editor.SmiContext;
import com.agentpp.common.smi.editor.SmiDocument;
import com.agentpp.common.smi.editor.SmiEditorKit;
import com.agentpp.common.smi.print.SmiTextPrintable;
import com.agentpp.common.table.ExtendedListTable;
import com.agentpp.common.table.TableUtils;
import com.agentpp.commons.mib.SmiParserLogPanel;
import com.agentpp.commons.mib.editor.AnnotationBar;
import com.agentpp.commons.mib.editor.AnnotationBarDataModel;
import com.agentpp.commons.mib.editor.AnnotationMark;
import com.agentpp.commons.mib.editor.AnnotationMarkListener;
import com.agentpp.commons.mib.editor.ElementTreePanel;
import com.agentpp.commons.mib.editor.ErrorUnderlineHighlightPainter;
import com.agentpp.commons.mib.editor.SmiEditorImportListener;
import com.agentpp.commons.mib.editor.SmiEditorValidationListener;
import com.agentpp.commons.ui.InstantSearchAction;
import com.agentpp.commons.ui.InstantSearchListener;
import com.agentpp.commons.ui.InstantSearchPanel;
import com.agentpp.commons.ui.JListPopupFindAction;
import com.agentpp.commons.ui.JTextComponentFindAction;
import com.agentpp.commons.ui.PopupSearchKeyListener;
import com.agentpp.mib.MIBModule;
import com.agentpp.smiparser.SMIParserConstants;
import com.agentpp.smiparser.SMIRepository;
import com.agentpp.util.Regex;
import com.agentpp.util.UserConfigFile;
import com.klg.jclass.table.JCSelectEvent;
import com.klg.jclass.table.JCSelectListener;
import com.klg.jclass.table.TableDataModel;
import com.klg.jclass.table.data.JCVectorDataSource;
import com.snmp4j.smi.CompilationMonitor;
import com.snmp4j.smi.CompilationResult;
import com.snmp4j.smi.NamedInputStream;
import com.snmp4j.smi.SmiCompiler;
import com.snmp4j.smi.SmiError;
import com.snmp4j.smi.SmiErrorInfo;
import com.snmp4j.smibridge.ExtCompilationResult;
import com.snmp4j.smibridge.SmiManagerBridge;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.SortedMap;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.Segment;
import javax.swing.text.TextAction;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternCompiler;
import org.apache.oro.text.regex.PatternMatcher;
import org.apache.oro.text.regex.PatternMatcherInput;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.apache.oro.text.regex.Perl5Substitution;
import org.apache.oro.text.regex.Substitution;
import org.apache.oro.text.regex.Util;

public class SmiEditorPanel
extends JPanel
implements JCSelectListener,
CompilationMonitor,
AnnotationMarkListener,
InstantSearchListener {
    private static final String CFG_SEARCH = "com.agentpp.commons.mib.editor.searchExpression";
    private static final String CFG_REPLACE = "com.agentpp.commons.mib.editor.substitution";
    protected ResourceBundle resources;
    private ExtendedListTable errorTable = new ExtendedListTable();
    private List<AnnotatedSmiError> auxErrors;
    private JCVectorDataSource errorModel = new JCVectorDataSource();
    private TableSorter tableSorter;
    private JScrollPane scroller;
    private JFrame myFrame;
    String lastSearch = "";
    private SmiCompiler importer = null;
    private UserConfigFile config = new UserConfigFile();
    PatternMatcher matcher = new Perl5Matcher();
    PatternCompiler compiler = new Perl5Compiler();
    Pattern lastPattern;
    PatternMatcherInput input;
    MatchResult result;
    JSplitPane splitPane = new JSplitPane(0);
    private InstantSearchPanel searchPanel;
    private String title = "";
    private MIBModule lookupData;
    private JPopupMenu ccPopup;
    private AnnotationBar errorStripe;
    private AnnotationBarDataModel annotationModel;
    protected File file;
    private final LinkedList<PropertyChangeListener> propertyChangeListeners = new LinkedList();
    static final String[] COLUMN_NAMES = new String[]{"#", "Error ID", "Description"};
    static final int COL_NR = 0;
    static final int COL_ERROR = 1;
    static final int COL_TEXT = 2;
    protected boolean defaultCompileLenient;
    protected boolean backgroundChecksEnabled;
    protected long lastKeyPressedTime;
    protected Timer backgroundCheckTimer;
    private Regex lastSearchExpression;
    private boolean searchPanelEnabled = true;
    private final List<SmiEditorValidationListener> validationListeners = new ArrayList<SmiEditorValidationListener>(2);
    private final List<SmiEditorImportListener> importListeners = new ArrayList<SmiEditorImportListener>(2);
    private JEditorPane editor;
    private Map<String, Action> commands;
    private Map<String, JMenuItem> menuItems;
    private Map<String, AbstractButton> buttons;
    private JMenuBar menubar;
    private JToolBar toolbar;
    protected StatusBar status;
    private JFrame elementTreeFrame;
    protected ElementTreePanel elementTreePanel;
    protected FileDialog fileDialog;
    protected UndoableEditListener undoHandler = new UndoHandler();
    protected UndoManager undo = new UndoManager();
    public static final String imageSuffix = "Image";
    public static final String toggleSuffix = "Toggle";
    public static final String labelSuffix = "Label";
    public static final String actionSuffix = "Action";
    public static final String accelSuffix = "Accelerator";
    public static final String tipSuffix = "Tooltip";
    public static final String openAction = "open";
    public static final String newAction = "new";
    public static final String backgroundValidationAction = "backgroundValidation";
    public static final String saveAction = "save";
    public static final String saveAsAction = "saveAs";
    public static final String exitAction = "exit";
    public static final String printAction = "print";
    public static final String findAction = "find";
    public static final String exportErrorsAction = "exportErrors";
    public static final String replaceAction = "replace";
    public static final String showElementTreeAction = "showElementTree";
    private UndoAction undoAction = new UndoAction();
    private RedoAction redoAction = new RedoAction();
    private ImportAction importAction = new ImportAction();
    private ImportAccurateAction importAccurateAction = new ImportAccurateAction();
    private ImportLenientAction importLenientAction = new ImportLenientAction();
    private ExportSelectedErrorsAction exportAllErrorsAction = new ExportSelectedErrorsAction("exportErrors", false);
    private BackgroundValidationAction backgroundValidation = new BackgroundValidationAction();
    private Action[] defaultActions = new Action[]{new NewAction(), new OpenAction(), new SaveAction(), new SaveAsAction(), new FindAction(), new ReplaceAction(), this.backgroundValidation, this.importAction, this.importAccurateAction, this.importLenientAction, new CheckAccurateAction(), new CheckLenientAction(), this.exportAllErrorsAction, new FindNextAction(), new PrintAction(), this.undoAction, this.redoAction, new PasteAction(), new CutAction(), new ExitAction()};
    private boolean lenientParserMode;
    private int tabSize = 8;

    public SmiEditorPanel(JFrame frame) {
        this(frame, ResourceBundle.getBundle("com.agentpp.commons.mib.editor.SmiEditorPanel", Locale.getDefault()));
    }

    public SmiEditorPanel(JFrame frame, boolean searchPanelEnabled) {
        this(frame, ResourceBundle.getBundle("com.agentpp.commons.mib.editor.SmiEditorPanel", Locale.getDefault()), searchPanelEnabled);
    }

    public List<AnnotatedSmiError> getAuxErrors() {
        return this.auxErrors;
    }

    public void setAuxErrors(List<AnnotatedSmiError> auxErrors) {
        this.auxErrors = auxErrors;
        if (this.auxErrors != null) {
            SortedMap<Integer, List<AnnotationMark>> errorMarks = this.annotationModel.getMarks();
            this.addAuxSmiErrorMarks(auxErrors, errorMarks);
            this.updateErrorDisplay(this.errorModel.getNumRows() > 0, false, errorMarks);
        }
    }

    private void addAuxSmiErrorMarks(List<AnnotatedSmiError> auxErrors, SortedMap<Integer, List<AnnotationMark>> errorMarks) {
        if (auxErrors == null) {
            return;
        }
        HashSet<Integer> errorIDs = new HashSet<Integer>(this.errorModel.getNumRows());
        for (int i2 = 0; i2 < this.errorModel.getNumRows(); ++i2) {
            SmiErrorInfo error = (SmiErrorInfo)this.errorModel.getTableRowLabel(i2);
            errorIDs.add(error.getErrorNumber());
        }
        for (AnnotatedSmiError smiError : auxErrors) {
            if (errorIDs.contains(smiError.getErrorNumber())) continue;
            this.addRow(smiError);
            List markList = errorMarks.computeIfAbsent(smiError.getRow(), k2 -> new LinkedList());
            markList.add(smiError);
        }
    }

    protected SmiEditorPanel(JFrame frame, ResourceBundle resourceBundle) {
        this(frame, resourceBundle, true);
    }

    public SmiEditorPanel(JFrame frame, ResourceBundle resourceBundle, boolean searchPanelEnabled) {
        this.searchPanelEnabled = searchPanelEnabled;
        this.myFrame = frame;
        this.resources = resourceBundle;
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.updateEditorState();
    }

    public void addSmiEditorValidationListener(SmiEditorValidationListener validationListener) {
        this.validationListeners.add(validationListener);
    }

    public void removeSmiEditorValidationListener(SmiEditorValidationListener validationListener) {
        this.validationListeners.remove(validationListener);
    }

    public void addSmiEditorImportListener(SmiEditorImportListener importListener) {
        this.importListeners.add(importListener);
    }

    public void removeSmiEditorImportListener(SmiEditorImportListener importListener) {
        this.importListeners.remove(importListener);
    }

    public boolean hasUncommitedChanges() {
        return this.undo.canUndo();
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public boolean isDefaultCompileLenient() {
        return this.defaultCompileLenient;
    }

    public void setDefaultCompileLenient(boolean defaultCompileLenient) {
        this.defaultCompileLenient = defaultCompileLenient;
    }

    public boolean isBackgroundChecksEnabled() {
        return this.backgroundChecksEnabled;
    }

    public void setBackgroundChecksEnabled(boolean backgroundChecksEnabled) {
        if (backgroundChecksEnabled != this.backgroundChecksEnabled) {
            if (!backgroundChecksEnabled) {
                if (this.backgroundCheckTimer != null) {
                    this.backgroundCheckTimer.cancel();
                }
            } else {
                this.backgroundCheckTimer = new Timer();
                long delay = this.config.getInteger("com.agentpp.smi.editor.background.check.frequency", 500);
                this.backgroundCheckTimer.schedule((TimerTask)new BackgroundCheckTask(), delay, delay);
            }
        }
        this.backgroundChecksEnabled = backgroundChecksEnabled;
        this.backgroundValidation.setSelection(backgroundValidationAction);
    }

    public void setLookupModule(MIBModule lookup) {
        this.lookupData = lookup;
    }

    public void setConfig(UserConfigFile config) {
        this.config = config;
        SmiContext s2 = ((SmiEditorKit)this.getEditor().getEditorKit()).getStylePreferences(this.editor.getForeground());
        List<FontStyle> v = SmiContext.getStyles(config);
        s2.setSyntaxHighlighting(SmiContext.loadSyntaxHighlighting(config));
        s2.setStyles(v);
    }

    private void jbInit() {
        Action[] actions;
        this.createErrorTable();
        this.setLayout(new BorderLayout());
        this.editor = this.createEditor();
        this.editor.setFont(new Font("monospaced", 0, 12));
        this.editor.getDocument().addUndoableEditListener(this.undoHandler);
        this.annotationModel = new AnnotationBarDataModel();
        this.commands = new Hashtable<String, Action>();
        for (Action a2 : actions = this.getActions()) {
            this.commands.put((String)a2.getValue("Name"), a2);
        }
        this.scroller = new JScrollPane();
        this.scroller.setRowHeaderView(new LineNumberRowHeaderView(this.editor));
        JViewport port = this.scroller.getViewport();
        port.add(this.editor);
        port.setScrollMode(1);
        this.errorStripe = new AnnotationBar(this.editor, this.annotationModel, this);
        this.menuItems = new HashMap<String, JMenuItem>();
        this.buttons = new HashMap<String, AbstractButton>();
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add(this.createToolbar(), "North");
        panel.add((Component)this.splitPane, "Center");
        JPanel editorPanel = new JPanel(new BorderLayout());
        editorPanel.add((Component)this.scroller, "Center");
        editorPanel.add((Component)this.errorStripe, "East");
        this.splitPane.setTopComponent(editorPanel);
        this.splitPane.setBottomComponent(this.errorTable);
        this.splitPane.setOneTouchExpandable(true);
        this.add("Center", panel);
        this.status = this.createStatusbar();
        this.editor.addCaretListener(this.status);
        this.add("South", this.status);
        panel.setPreferredSize(new Dimension(600, 600));
        this.splitPane.setDividerLocation(1.0);
        this.splitPane.setResizeWeight(0.7);
    }

    public SmiEditorPanel(JFrame f2, String text, int row, int col, int sel) {
        this(f2);
        this.setText(text, row, col, sel);
    }

    public int getCaretPosition() {
        return this.getEditor().getCaretPosition();
    }

    public static String getCompilerLogText(List<CompilationResult> compilerResults) {
        StringBuilder message = new StringBuilder();
        String lineSeparator = System.getProperty("line.separator");
        List<String> failed = CompilationResult.getFailedFiles(compilerResults);
        message.append(MessageFormat.format("## Compiled {0} {0,choice,0#files|1#file|1<files}, thereof {1} {1,choice,0#files|1#file|1<files} had errors. [{2}]", compilerResults.size(), failed.size(), new Date()));
        message.append(lineSeparator);
        message.append(lineSeparator);
        for (CompilationResult fileResult : compilerResults) {
            if (fileResult.hasErrors()) {
                message.append(MessageFormat.format("## Compilation of {0} failed with the following {1,choice,0#errors|1#error|1<errors}:", fileResult.getFileName(), fileResult.getSmiErrorList().size()));
                message.append(lineSeparator);
                for (SmiError error : fileResult.getSmiErrorList()) {
                    message.append(error.getMessage());
                    message.append(lineSeparator);
                }
            } else {
                message.append(MessageFormat.format("## Compiled {0} successfully and returned: {1} MIB {2,choice,0#modules|1#module|1<modules}", fileResult.getFileName() + (String)(fileResult.getZipFileName() == null ? "" : "#" + fileResult.getZipFileName()), SmiParserLogPanel.toString(fileResult.getModuleNames(), ", "), fileResult.getModuleNames().size()));
                message.append(lineSeparator);
            }
            message.append(lineSeparator);
        }
        return message.toString();
    }

    public boolean replace(Pattern pattern, String s2) {
        int numSubs = 1;
        Perl5Substitution substitution = new Perl5Substitution(s2);
        int r2 = -1;
        int start = -1;
        int stop = -1;
        block8: while (r2 != 1 && this.searchPattern(pattern)) {
            start = this.getEditor().getSelectionStart();
            stop = this.getEditor().getSelectionEnd();
            StringBuffer buf = new StringBuffer();
            String[] text = new String[]{"Replace?"};
            Object[] options = new String[]{"Yes", "Yes to All", "No", "Cancel"};
            r2 = JOptionPane.showOptionDialog(this, text, "Confirm Substitution", 1, 3, null, options, options[0]);
            switch (r2) {
                case 0: {
                    break;
                }
                case 1: {
                    stop = ((SmiDocument)this.editor.getDocument()).getEndPosition().getOffset();
                    numSubs = -1;
                    break;
                }
                case 2: {
                    continue block8;
                }
                case 3: {
                    return false;
                }
            }
            SmiDocument doc = (SmiDocument)this.editor.getDocument();
            int length = stop - start;
            Segment seg = new Segment();
            try {
                doc.getText(start, length, seg);
            }
            catch (BadLocationException blex) {
                blex.printStackTrace();
            }
            this.input = new PatternMatcherInput(new String(seg.array, seg.offset, seg.count));
            Util.substitute(buf, this.matcher, pattern, (Substitution)substitution, this.input, numSubs);
            this.getEditor().setSelectionStart(start);
            this.getEditor().setSelectionEnd(stop);
            this.getEditor().replaceSelection(buf.toString());
            this.getEditor().setCaretPosition(start + buf.toString().length());
        }
        if (r2 == 0 || r2 == 1) {
            this.setCaretPosition(start);
        }
        return true;
    }

    public boolean searchPattern(Pattern pattern) {
        if (pattern == null) {
            return false;
        }
        this.lastPattern = pattern;
        int start = 0;
        if (this.getEditor().getCaretPosition() > 0) {
            start = this.getEditor().getCaretPosition();
        }
        SmiDocument doc = (SmiDocument)this.editor.getDocument();
        int length = doc.getEndPosition().getOffset() - start;
        Segment seg = new Segment();
        try {
            doc.getText(start, length, seg);
        }
        catch (BadLocationException blex) {
            blex.printStackTrace();
        }
        this.input = new PatternMatcherInput(new String(seg.array, seg.offset, length));
        if (this.matcher.contains(this.input, pattern)) {
            int pos = this.input.getMatchBeginOffset() + start;
            int len = this.input.getMatchEndOffset() - this.input.getMatchBeginOffset();
            this.editor.getCaret().setSelectionVisible(true);
            this.editor.setCaretPosition(pos);
            this.editor.moveCaretPosition(pos + len);
            return true;
        }
        this.status.setText("Search complete!");
        return false;
    }

    private Pattern makePattern(String s2, boolean quite) {
        Pattern pattern;
        block2: {
            pattern = null;
            try {
                pattern = this.compiler.compile(s2);
            }
            catch (MalformedPatternException e2) {
                if (quite) break block2;
                JOptionPane.showMessageDialog(this, e2.getMessage(), "Malformed Expression", 0);
            }
        }
        return pattern;
    }

    public boolean searchString(String s2) {
        Pattern p2 = this.makePattern(s2, true);
        if (p2 != null) {
            return this.searchPattern(p2);
        }
        return false;
    }

    public void setCaretPosition(int pos) {
        this.getEditor().setCaretPosition(pos);
    }

    public void moveCaretPosition(int pos) {
        this.getEditor().moveCaretPosition(pos);
    }

    public boolean setCaretPosition(int row, int col) {
        try {
            SmiDocument smidoc = (SmiDocument)this.getEditor().getDocument();
            this.editor.setCaretPosition(smidoc.getLineStartOffset(row - 1) + col - 1);
        }
        catch (Exception ble) {
            return false;
        }
        return true;
    }

    public boolean setSelectionEnd(int row, int col) {
        try {
            SmiDocument smidoc = (SmiDocument)this.getEditor().getDocument();
            int startPos = this.editor.getCaret().getDot();
            int endPos = smidoc.getLineStartOffset(row - 1) + col - 1;
            this.setSelectionLength(endPos - startPos + 1);
        }
        catch (Exception ble) {
            return false;
        }
        return true;
    }

    public void setSelectionLength(int sel) {
        this.editor.getCaret().setSelectionVisible(true);
        int len = sel;
        while (true) {
            try {
                this.editor.moveCaretPosition(this.editor.getCaretPosition() + len);
            }
            catch (IllegalArgumentException iaex) {
                if (--len > 0) continue;
            }
            break;
        }
    }

    protected void loadFile(File file, int row, int col, int sel) {
        this.setEnabled(false);
        this.file = file;
        Document oldDoc = this.getEditor().getDocument();
        if (oldDoc != null) {
            oldDoc.removeUndoableEditListener(this.undoHandler);
        }
        if (this.elementTreePanel != null) {
            this.elementTreePanel.setEditor(null);
        }
        try {
            if (oldDoc != null) {
                oldDoc.remove(0, oldDoc.getLength());
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        FileLoader loader = new FileLoader(file, this.editor.getDocument());
        loader.selection = sel;
        loader.start();
    }

    public void setText(String text, int row, int col, int sel) {
        this.setEnabled(false);
        Document oldDoc = this.getEditor().getDocument();
        if (oldDoc != null) {
            oldDoc.removeUndoableEditListener(this.undoHandler);
        }
        if (this.elementTreePanel != null) {
            this.elementTreePanel.setEditor(null);
        }
        try {
            if (oldDoc != null) {
                oldDoc.remove(0, oldDoc.getLength());
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        Document doc = this.editor.getDocument();
        try {
            doc.insertString(0, text, null);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        try {
            this.setCaretPosition(row, col);
            this.setSelectionLength(sel);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (this.elementTreeFrame != null) {
            this.elementTreePanel.setEditor(this.getEditor());
        }
        doc.addUndoableEditListener(this.undoHandler);
        this.status.removeAll();
        this.status.revalidate();
        this.resetUndoManager();
        this.auxErrors = null;
        this.setEnabled(true);
    }

    @Override
    public boolean search(String text, InstantSearchListener.Direction direction, boolean caseSensitive) {
        this.editor.setSelectionStart(0);
        this.editor.setSelectionEnd(0);
        return this.searchAgain(text, direction, caseSensitive);
    }

    @Override
    public boolean searchAgain(String text, InstantSearchListener.Direction direction, boolean caseSensitive) {
        if (text == null || text.trim().length() == 0) {
            return false;
        }
        this.lastSearchExpression = new Regex();
        Object s2 = text;
        if (!caseSensitive) {
            s2 = "(?i)" + (String)s2;
        }
        try {
            this.lastSearchExpression.compile((String)s2);
            return SmiEditorPanel.selectNextMatch(this.lastSearchExpression, this.editor, direction);
        }
        catch (ParseException pex) {
            return false;
        }
    }

    public Action[] getActions() {
        return TextAction.augmentList(this.editor.getActions(), this.defaultActions);
    }

    protected void createErrorTable() {
        this.errorModel.setNumColumns(COLUMN_NAMES.length);
        this.errorModel.setNumRows(0);
        this.errorModel.setColumnLabels(COLUMN_NAMES);
        this.tableSorter = new TableSorter(this.errorTable, this.errorModel);
        this.errorTable.setDataSource(this.errorModel);
        this.errorTable.setPixelHeight(-997, 33001);
        this.errorTable.setRowLabelDisplay(false);
        for (int i2 = 0; i2 < this.errorModel.getNumColumns(); ++i2) {
            this.errorTable.setPixelWidth(i2, 33001);
        }
        this.errorTable.addSelectListener(this);
    }

    protected JEditorPane createEditor() {
        try {
            final JEditorPane editor = new JEditorPane(){

                @Override
                public String getToolTipText(MouseEvent event) {
                    int pos = this.viewToModel(event.getPoint());
                    if (pos < 0) {
                        return null;
                    }
                    AnnotationMark mark = SmiEditorPanel.this.annotationModel.getTopLevelMarkForPosition(pos);
                    if (mark == null) {
                        return null;
                    }
                    return mark.getDescription();
                }
            };
            editor.setToolTipText("");
            SmiEditorKit kit = new SmiEditorKit();
            editor.setEditorKit(kit);
            editor.setFont(new Font("Courier", 0, 12));
            editor.setEditable(true);
            editor.addKeyListener(new KeyListener(){

                @Override
                public void keyPressed(KeyEvent e2) {
                }

                @Override
                public void keyReleased(KeyEvent e2) {
                    if (SmiEditorPanel.this.importer != null && editor.isEditable() && e2.getModifiersEx() == 128) {
                        if (e2.getKeyCode() == 90) {
                            if (SmiEditorPanel.this.undo.canUndo()) {
                                SmiEditorPanel.this.undoAction.undo();
                            }
                        } else if (e2.getKeyCode() == 89 && SmiEditorPanel.this.undo.canRedo()) {
                            SmiEditorPanel.this.redoAction.redo();
                        }
                    }
                }

                @Override
                public void keyTyped(KeyEvent e2) {
                    if (e2.getKeyChar() == '\u001b') {
                        if (SmiEditorPanel.this.ccPopup != null) {
                            SmiEditorPanel.this.disposeCodeCompletionPopup();
                        }
                    } else if (SmiEditorPanel.this.importer != null && editor.isEditable() && (e2.getModifiersEx() & 0x80) != 0 && e2.getKeyChar() == ' ') {
                        SmiEditorPanel.this.codeCompletion();
                    }
                }
            });
            return editor;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public JEditorPane getEditor() {
        return this.editor;
    }

    private void disposeCodeCompletionPopup() {
        this.ccPopup.setVisible(false);
    }

    protected JMenuBar createMenubar() {
        JMenuBar mb = new JMenuBar();
        String[] menuKeys = this.tokenize(this.getResourceString("menubar"));
        for (int i2 = 0; i2 < menuKeys.length; ++i2) {
            JMenu m3 = this.createMenu(menuKeys[i2]);
            if (m3 == null) continue;
            mb.add(m3);
        }
        return mb;
    }

    protected JMenu createMenu(String key) {
        String[] itemKeys = this.tokenize(this.getResourceString(key));
        JMenu menu = new JMenu(this.getResourceString(key + labelSuffix));
        for (String itemKey : itemKeys) {
            if (itemKey.equals("-")) {
                menu.addSeparator();
                continue;
            }
            JMenuItem mi = this.createMenuItem(itemKey);
            menu.add(mi);
        }
        return menu;
    }

    protected JMenuItem createMenuItem(String cmd) {
        String astr;
        String sstr;
        boolean isToggle = Boolean.valueOf(this.getResourceString(cmd + toggleSuffix));
        JMenuItem mi = isToggle ? new JCheckBoxMenuItem(this.getResourceString(cmd + labelSuffix)) : new JMenuItem(this.getResourceString(cmd + labelSuffix));
        URL url = this.getResource(cmd + imageSuffix);
        if (url != null) {
            mi.setHorizontalTextPosition(4);
            mi.setIcon(new ImageIcon(url));
        }
        if ((sstr = this.getResourceString(cmd + accelSuffix)) != null) {
            mi.setAccelerator(KeyStroke.getKeyStroke(sstr));
        }
        if ((astr = this.getResourceString(cmd + actionSuffix)) == null) {
            astr = cmd;
        }
        mi.setActionCommand(astr);
        Action a2 = this.getAction(astr);
        if (a2 != null) {
            mi.addActionListener(a2);
            a2.addPropertyChangeListener(this.createActionChangeListener(mi));
            mi.setEnabled(a2.isEnabled());
        } else {
            mi.setEnabled(false);
        }
        this.menuItems.put(cmd, mi);
        return mi;
    }

    protected JMenuItem getMenuItem(String cmd) {
        return this.menuItems.get(cmd);
    }

    protected Action getAction(String cmd) {
        return this.commands.get(cmd);
    }

    protected String getResourceString(String nm) {
        String str;
        try {
            str = this.resources.getString(nm);
        }
        catch (MissingResourceException mre) {
            str = null;
        }
        return str;
    }

    protected URL getResource(String key) {
        String name = this.getResourceString(key);
        if (name != null) {
            return this.getClass().getResource(name);
        }
        return null;
    }

    protected Container getToolbar() {
        return this.toolbar;
    }

    protected JMenuBar getMenubar() {
        return this.menubar;
    }

    protected StatusBar createStatusbar() {
        this.status = new StatusBar();
        return this.status;
    }

    protected void resetUndoManager() {
        this.undo.discardAllEdits();
        this.undoAction.update();
        this.redoAction.update();
    }

    private Component createToolbar() {
        this.toolbar = new JToolBar();
        String[] toolKeys = this.tokenize(this.getResourceString("toolbar"));
        for (int i2 = 0; i2 < toolKeys.length; ++i2) {
            if (toolKeys[i2].equals("-")) {
                this.toolbar.add(Box.createHorizontalStrut(5));
                continue;
            }
            this.toolbar.add(this.createTool(toolKeys[i2]));
        }
        this.toolbar.add(Box.createHorizontalStrut(10));
        this.toolbar.setFloatable(false);
        if (this.searchPanelEnabled) {
            this.searchPanel = new InstantSearchPanel(this, 10);
            this.toolbar.add(this.searchPanel.getPanel());
            InstantSearchAction searchAction = new InstantSearchAction(this.searchPanel, true);
            searchAction.setComponent(this.getEditor());
            InstantSearchAction.installActions(this.getEditor(), new Action[]{searchAction});
        }
        this.toolbar.add(Box.createHorizontalGlue());
        ToolBarUtils.setMinimumButtonSize(this.toolbar);
        return this.toolbar;
    }

    protected Component createTool(String key) {
        return this.createToolbarButton(key);
    }

    protected AbstractButton createToolbarButton(String key) {
        Action a2;
        URL url = this.getResource(key + imageSuffix);
        boolean isToggle = Boolean.valueOf(this.getResourceString(key + toggleSuffix));
        ImageIcon icon = null;
        try {
            icon = new ImageIcon(url);
        }
        catch (NullPointerException npex) {
            System.err.println("Icon '" + key + "Image' not found");
        }
        AbstractButton b2 = isToggle ? new JToggleButton((Icon)icon){

            @Override
            public float getAlignmentY() {
                return 0.5f;
            }
        } : new JButton((Icon)new ImageIcon(url)){

            @Override
            public float getAlignmentY() {
                return 0.5f;
            }
        };
        b2.setRequestFocusEnabled(false);
        b2.setMargin(new Insets(1, 1, 1, 1));
        String astr = this.getResourceString(key + actionSuffix);
        if (astr == null) {
            astr = key;
        }
        if ((a2 = this.getAction(astr)) != null) {
            b2.setActionCommand(astr);
            a2.addPropertyChangeListener(this.createActionChangeListener(b2));
            b2.addActionListener(a2);
            b2.setEnabled(a2.isEnabled());
        } else {
            b2.setEnabled(false);
        }
        String tip = this.getResourceString(key + tipSuffix);
        if (tip != null) {
            b2.setToolTipText(tip);
        }
        this.buttons.put(key, b2);
        return b2;
    }

    protected String[] tokenize(String input) {
        Vector<String> v = new Vector<String>();
        StringTokenizer t = new StringTokenizer(input);
        while (t.hasMoreTokens()) {
            v.add(t.nextToken());
        }
        String[] cmd = new String[v.size()];
        for (int i2 = 0; i2 < cmd.length; ++i2) {
            cmd[i2] = (String)v.get(i2);
        }
        return cmd;
    }

    protected PropertyChangeListener createActionChangeListener(JMenuItem b2) {
        ActionChangedListener listener = new ActionChangedListener(b2);
        this.propertyChangeListeners.add(listener);
        return listener;
    }

    protected PropertyChangeListener createActionChangeListener(AbstractButton b2) {
        ButtonActionChangedListener listener = new ButtonActionChangedListener(b2);
        this.propertyChangeListeners.add(listener);
        return listener;
    }

    public void setImporter(SmiCompiler newImporter) {
        this.importer = newImporter;
        this.updateEditorState();
    }

    private void updateEditorState() {
        if (this.importer == null) {
            this.editor.setEditable(false);
            this.setNonReadOnlyActionsEnabled(false);
            this.errorStripe.resetCache();
            this.errorStripe.setStatusUpdateInProgress(true);
        } else {
            this.errorStripe.resetCache();
            this.errorStripe.setStatusUpdateInProgress(true);
            this.editor.setEditable(true);
            this.setNonReadOnlyActionsEnabled(true);
            this.redoAction.setEnabled(this.undo.canRedo());
            this.undoAction.setEnabled(this.undo.canUndo());
            this.importAction.setEnabled(this.undo.canUndo());
        }
    }

    private void setNonReadOnlyActionsEnabled(boolean enabled) {
        Action[] actions = this.getActions();
        for (int i2 = 0; i2 < actions.length; ++i2) {
            if (!(actions[i2] instanceof ModifyAction)) continue;
            actions[i2].setEnabled(enabled);
        }
    }

    private void saveAsAction() {
        JFileChooser fileChooser = new JFileChooser(new File(this.title).getParent());
        fileChooser.setSelectedFile(new File(this.title));
        fileChooser.setDialogType(1);
        fileChooser.setDialogTitle("Save MIB Text As");
        fileChooser.setFileSelectionMode(0);
        if (fileChooser.showSaveDialog(this) == 0) {
            try {
                FileOutputStream fos = new FileOutputStream(fileChooser.getSelectedFile());
                fos.write(this.getDocumentBytes());
                fos.close();
            }
            catch (FileNotFoundException e2) {
                JOptionPane.showMessageDialog(this, "Could find/create file '" + fileChooser.getSelectedFile() + "': " + e2.getMessage(), "Save Error", 0);
            }
            catch (IOException iox) {
                JOptionPane.showMessageDialog(this, "Could not save file to '" + fileChooser.getSelectedFile() + "': " + iox.getMessage(), "Save Error", 0);
            }
        }
    }

    public SmiCompiler getImporter() {
        return this.importer;
    }

    public void setLenientParserMode(boolean lenientParserMode) {
    }

    public boolean isLenientParserMode() {
        return this.lenientParserMode;
    }

    @Override
    public boolean loadingProgress(String s2, int i2, int i22) {
        return true;
    }

    @Override
    public boolean sortingProgress(String s2, int i2, int i22) {
        return true;
    }

    @Override
    public boolean compilationProgress(String s2, int i2, int i22) {
        return true;
    }

    @Override
    public void annotationMarkSelected(AnnotationMark mark) {
        if (mark instanceof AnnotatedSmiError) {
            this.setCurrentErrorLocation((AnnotatedSmiError)mark, true);
        } else {
            this.setCaretPosition(mark.getPosition());
            this.moveCaretPosition(mark.getEndPosition());
        }
    }

    private Frame getFrame() {
        return this.myFrame;
    }

    private boolean importAction(boolean lenientParserMode) {
        ByteArrayInputStream bis = new ByteArrayInputStream(this.getDocumentBytes());
        NamedInputStream namedInputStream = new NamedInputStream(bis, this.getTitle());
        List<CompilationResult> result = null;
        boolean close = false;
        try {
            result = this.importer.compile(new NamedInputStream[]{namedInputStream}, this, SmiCompiler.TargetMode.storeIntoRepositoryAndLoad, SmiCompiler.OverwriteMode.overwriteAlways, lenientParserMode ? SmiCompiler.Strictness.lenient : SmiCompiler.Strictness.standard);
            close = this.fireImportEvent(result);
            if (close) {
                this.doExit();
            }
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        try {
            bis.close();
        }
        catch (IOException e3) {
            e3.printStackTrace();
        }
        if (result != null) {
            this.setErrors((CompilationResult)result.get(0), true, this.fireSmiEditorValidationEvent(result));
            if (result.get(0).hasErrors()) {
                this.status.setText("SMI not imported, see errors above for details.");
                return false;
            }
            this.status.setText("SMI imported.");
        }
        return true;
    }

    private boolean fireImportEvent(List<CompilationResult> result) {
        boolean close = false;
        if (this.importListeners != null) {
            for (SmiEditorImportListener importListener : this.importListeners) {
                close |= importListener.checkForClosingEditorAfterImportPerformed(result);
            }
        }
        return close;
    }

    private List<AnnotationMark> fireSmiEditorValidationEvent(List<CompilationResult> result) {
        ArrayList<AnnotationMark> marks = new ArrayList<AnnotationMark>();
        for (SmiEditorValidationListener listener : this.validationListeners) {
            marks.addAll(listener.processValidationResult(result));
        }
        return marks;
    }

    public void setSelectionColor(Color c2) {
        this.editor.setSelectionColor(c2);
    }

    /*
     * Unable to fully structure code
     */
    public int checkText(boolean lenient, final boolean updateSelection) {
        try {
            errors = 0;
            bis = new ByteArrayInputStream(this.getDocumentBytes());
            namedInputStream = new NamedInputStream(bis, this.getTitle());
            if (this.importer != null) {
                try {
                    result = this.importer.compile(new NamedInputStream[]{namedInputStream}, null, SmiCompiler.TargetMode.dryRun, SmiCompiler.OverwriteMode.overwriteAlways, lenient != false ? SmiCompiler.Strictness.lenient : SmiCompiler.Strictness.standard);
                    if (!result.isEmpty() && result.get(0).hasErrors()) {
                        errors = result.get(0).getSmiErrorList().size();
                    }
                    this.errorStripe.resetCache();
                    additonalMarks = this.fireSmiEditorValidationEvent(result);
                    if (result.isEmpty()) ** GOTO lbl21
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SmiEditorPanel.this.setErrors((CompilationResult)result.get(0), updateSelection, additonalMarks);
                            if (updateSelection && ((CompilationResult)result.get(0)).hasErrors()) {
                                SmiEditorPanel.this.displayErrorStatus(result);
                            }
                        }
                    });
                }
                catch (IOException e) {
                    e.printStackTrace();
                    bis.close();
                    return -1;
                }
            } else {
                this.errorStripe.resetCache();
                this.setErrors(new CompilationResult(namedInputStream.getName(), Collections.emptyList(), null), false, null);
            }
lbl21:
            // 3 sources

            bis.close();
            return errors;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return 1;
        }
    }

    private int displayErrorStatus(List<CompilationResult> results) {
        int errCount;
        this.status.setText("Detected " + errCount + " SMI syntax error" + ((errCount = results.get(0).getSmiErrorList().size()) > 1 ? "s" : "") + ", see error list above for details.");
        return errCount;
    }

    public void clearErrors() {
        this.errorModel.setNumRows(0);
        this.splitPane.setDividerLocation(1.0);
        this.errorStripe.resetCache();
    }

    public boolean hasUncommittedChanges() {
        return this.undo.canUndo();
    }

    public synchronized void setErrors(CompilationResult compilationResult, boolean updateSelection, List<AnnotationMark> additionalMarks) {
        List<AnnotationMark> markList;
        this.errorModel.setNumRows(0);
        if (!this.errorStripe.isCacheInvalidated()) {
            this.errorStripe.resetCache();
        }
        if (this.file == null && compilationResult.getFileName() != null) {
            this.file = new File(compilationResult.getFileName());
        }
        this.removeErrorUnderlines();
        TreeMap<Integer, List<AnnotationMark>> errorMarks = new TreeMap<Integer, List<AnnotationMark>>();
        if (compilationResult.hasErrors()) {
            for (SmiError smiError : compilationResult.getSmiErrorList()) {
                this.addRow(smiError);
                markList = errorMarks.get(smiError.getRow());
                if (markList == null) {
                    markList = new LinkedList<AnnotationMark>();
                    errorMarks.put(smiError.getRow(), markList);
                }
                markList.add(new AnnotatedSmiError(smiError));
            }
        }
        this.addAuxSmiErrorMarks(this.auxErrors, errorMarks);
        if (additionalMarks != null && !additionalMarks.isEmpty()) {
            for (AnnotationMark annotationMark : additionalMarks) {
                markList = errorMarks.get(annotationMark.getStartLine());
                if (markList == null) {
                    markList = new LinkedList<AnnotationMark>();
                    errorMarks.put(annotationMark.getStartLine(), markList);
                }
                markList.add(annotationMark);
            }
        }
        this.updateErrorDisplay(this.errorModel.getNumRows() > 0, updateSelection, errorMarks);
    }

    private void updateErrorDisplay(boolean hasErrors, boolean updateSelection, SortedMap<Integer, List<AnnotationMark>> errorMarks) {
        this.annotationModel.setMarks(errorMarks);
        this.errorStripe.setStatusUpdateInProgress(false);
        this.errorStripe.repaint();
        this.addErrorUnderlines(this.annotationModel);
        if (hasErrors) {
            this.splitPane.setDividerLocation(0.7);
            if (updateSelection && !this.isBackgroundChecksEnabled()) {
                this.setCurrentErrorLocation(0);
                this.errorTable.setRowSelection(0, 0);
            } else {
                this.errorTable.clearSelection();
            }
        } else {
            this.splitPane.setDividerLocation(1.0);
            if (updateSelection) {
                // empty if block
            }
        }
    }

    private void removeErrorUnderlines() {
        Highlighter highlighter = this.editor.getHighlighter();
        highlighter.removeAllHighlights();
    }

    private void addErrorUnderlines(AnnotationBarDataModel annotationModel) {
        Highlighter highlighter = this.editor.getHighlighter();
        Iterator<AnnotationMark> it = annotationModel.iterator();
        while (it.hasNext()) {
            AnnotationMark mark = it.next();
            ErrorUnderlineHighlightPainter underlineHighlightPainter = new ErrorUnderlineHighlightPainter(Color.RED);
            try {
                highlighter.addHighlight(mark.getPosition(), mark.getEndPosition(), underlineHighlightPainter);
            }
            catch (BadLocationException badLocationException) {}
        }
    }

    public ExtendedListTable getErrorTable() {
        return this.errorTable;
    }

    protected void setCurrentErrorLocation(int rowIndex) {
        SmiErrorInfo smiError = (SmiErrorInfo)this.errorModel.getTableRowLabel(rowIndex);
        this.setCurrentErrorLocation(smiError, false);
    }

    private synchronized void setCurrentErrorLocation(SmiErrorInfo smiError, boolean updateTableSelection) {
        if (smiError.getRow() >= 0) {
            this.setCaretPosition(smiError.getPosition());
            this.moveCaretPosition(smiError.getPosition() + smiError.getDefectiveText().length());
        } else if (smiError.getDefectiveText() != null) {
            int pos = this.getCaretPosition();
            this.setCaretPosition(0);
            if (!this.searchString(smiError.getDefectiveText())) {
                this.setCaretPosition(pos);
            }
        } else {
            this.setCaretPosition(0);
        }
        if (updateTableSelection) {
            for (int i2 = 0; i2 < this.errorModel.getRowLabels().size(); ++i2) {
                if (smiError != this.errorModel.getRowLabels().get(i2)) continue;
                this.errorTable.setRowSelection(i2, i2);
            }
        }
    }

    public void doExit() {
        if (this.backgroundCheckTimer != null) {
            this.backgroundCheckTimer.cancel();
        }
        this.setVisible(false);
    }

    ExportSelectedErrorsAction createExportSelectedErrorsAction(String name, boolean selectedOnly) {
        return new ExportSelectedErrorsAction(name, selectedOnly);
    }

    public void print() {
        SmiContext ctx = new SmiContext();
        ctx.setSyntaxHighlighting(true);
        ctx.setStyles(SmiContext.getDefaultStyles(this.getBackground()));
        SmiTextPrintable smiPrintable = new SmiTextPrintable((SmiDocument)this.getEditor().getDocument(), new Font("SansSerif", 0, 10), this.config.getBoolean("print.header", true) ? this.getTitle() : null, this.config.getBoolean("print.footer", true) ? this.config.get("print.footerText", "{0} -- page {1}") : null, this.config.getBoolean("print.colored", false), this.config.getBoolean("print.lineNumbers", true), ctx, this.getTabSize());
        PrinterJob pj = PrinterJob.getPrinterJob();
        pj.setJobName(this.getTitle());
        PageFormat pf = new PageFormat();
        pj.pageDialog(pf);
        pj.setPrintable(smiPrintable, pf);
        try {
            if (pj.printDialog()) {
                pj.print();
            }
        }
        catch (PrinterException ex) {
            System.out.println(ex);
        }
    }

    protected byte[] getDocumentBytes() {
        SmiDocument doc = (SmiDocument)this.editor.getDocument();
        try {
            String text = doc.getText(0, doc.getLength());
            return text.getBytes();
        }
        catch (BadLocationException blex) {
            blex.printStackTrace();
            return new byte[0];
        }
    }

    public void setTabSize(int tabSize) {
        this.tabSize = tabSize;
    }

    public int getTabSize() {
        return this.tabSize;
    }

    public String getText() {
        SmiDocument doc = (SmiDocument)this.editor.getDocument();
        try {
            return doc.getText(0, doc.getLength());
        }
        catch (BadLocationException ex) {
            return null;
        }
    }

    protected void addRow(SmiErrorInfo smiError) {
        int startPos;
        Vector<Object> row = new Vector<Object>(COLUMN_NAMES.length);
        row.add(this.errorModel.getNumRows() + 1);
        row.add(smiError.getErrorNumber());
        String errMessage = smiError.getMessage();
        if (errMessage != null && (startPos = errMessage.indexOf(": ")) >= 0) {
            errMessage = errMessage.substring(startPos + 2);
        }
        row.add(errMessage);
        this.errorModel.addRow(Integer.MAX_VALUE, smiError, row);
    }

    @Override
    public void beforeSelect(JCSelectEvent jCSelectEvent) {
    }

    @Override
    public void select(JCSelectEvent jCSelectEvent) {
    }

    @Override
    public void afterSelect(JCSelectEvent jCSelectEvent) {
        int row = TableUtils.getFirstSelectedRow(this.errorTable);
        if (row >= 0) {
            this.setCurrentErrorLocation(row);
        }
    }

    public void dispose() {
        for (Object e2 : this.propertyChangeListeners) {
            PropertyChangeListener l2 = (PropertyChangeListener)e2;
            for (Action a2 : this.commands.values()) {
                a2.removePropertyChangeListener(l2);
            }
        }
        this.propertyChangeListeners.clear();
    }

    public boolean importText() {
        boolean importOK = this.importAction(this.defaultCompileLenient);
        if (importOK) {
            this.undo.discardAllEdits();
            this.undoAction.update();
            this.redoAction.update();
            this.importAction.update();
        }
        return importOK;
    }

    public boolean importText(boolean lenientParserMode) {
        boolean importOK = this.importAction(lenientParserMode);
        if (importOK) {
            this.undo.discardAllEdits();
            this.undoAction.update();
            this.redoAction.update();
            this.importAction.update();
        }
        return importOK;
    }

    private static boolean isTokenSeparator(char c2) {
        return Character.isWhitespace(c2) || c2 == ',';
    }

    private ExtCompilationResult getCompletion(String text, int maxLength) {
        try {
            int size = Math.min(maxLength, this.getCaretPosition());
            for (int i2 = size - 1; i2 >= 0; --i2) {
                if (Character.isWhitespace(text.charAt(i2))) continue;
                size = i2 + 1;
                break;
            }
            Boolean forwardSetting = null;
            if (this.importer instanceof SmiManagerBridge) {
                forwardSetting = ((SmiManagerBridge)this.importer).isForwardTokenTree();
                ((SmiManagerBridge)this.importer).setForwardTokenTree(true);
            }
            ByteArrayInputStream bis = new ByteArrayInputStream(text.substring(0, size).getBytes());
            NamedInputStream namedInputStream = new NamedInputStream(bis, "code-completion");
            List<CompilationResult> result = this.importer.compile(new NamedInputStream[]{namedInputStream}, null, SmiCompiler.TargetMode.dryRunWithoutErrorLimit, SmiCompiler.OverwriteMode.overwriteAlways, SmiCompiler.Strictness.standard);
            if (forwardSetting != null) {
                ((SmiManagerBridge)this.importer).setForwardTokenTree(forwardSetting);
            }
            if (result != null && !result.isEmpty()) {
                return (ExtCompilationResult)result.get(0);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public void codeCompletion() {
        String text = this.getText();
        int startPos = this.getCaretPosition();
        for (int i2 = startPos - 1; i2 >= 1; --i2) {
            if (SmiEditorPanel.isTokenSeparator(text.charAt(i2))) {
                this.editor.setCaretPosition(i2 + 1);
                break;
            }
            if (i2 != 1) continue;
            this.editor.setCaretPosition(1);
            break;
        }
        ExtCompilationResult errors = this.getCompletion(text, this.editor.getDocument().getLength());
        SmiError foundSmiError = null;
        HashSet<String> completions = new HashSet<String>();
        String[] exp = null;
        if (errors != null) {
            if (errors.hasErrors()) {
                boolean found = false;
                for (SmiError smiError : errors.getSmiErrorList()) {
                    if (smiError.getPosition() < this.getCaretPosition()) continue;
                    foundSmiError = smiError;
                    found = true;
                    break;
                }
                if (!found) {
                    for (SmiError smiError : errors.getSmiErrorList()) {
                        if (smiError.getExpectedText() == null || smiError.getExpectedText().length <= 0) continue;
                        foundSmiError = smiError;
                        exp = foundSmiError.getExpectedText();
                        break;
                    }
                }
            }
            if (foundSmiError == null || foundSmiError.getRow() < 0) {
                for (SmiError smiError : errors.getSmiErrorList()) {
                    if (!smiError.getMessage().contains("<EOF> after : \"\\\"")) continue;
                    exp = new String[]{"\""};
                    completions.addAll(this.lookupData.getLowerCaseNames());
                    completions.addAll(this.lookupData.getUpperCaseNames());
                    break;
                }
                if (exp == null) {
                    return;
                }
            } else {
                for (int i3 = startPos; i3 < text.length(); ++i3) {
                    if (!SmiEditorPanel.isTokenSeparator(text.charAt(i3))) continue;
                    this.editor.moveCaretPosition(i3);
                    break;
                }
            }
            for (void var10_18 : exp) {
                StringTokenizer st = new StringTokenizer((String)var10_18, "\"", true);
                boolean lastWasQuote = false;
                StringBuilder buf = new StringBuilder(var10_18.length());
                while (st.hasMoreTokens()) {
                    String token = st.nextToken();
                    if ("\"".equals(token)) {
                        if (!lastWasQuote) continue;
                        lastWasQuote = true;
                    } else {
                        lastWasQuote = false;
                    }
                    buf.append(token);
                }
                this.addCompletions(buf.toString(), completions, errors.getParserTree());
            }
            if (this.ccPopup != null) {
                this.ccPopup.setVisible(false);
            }
            if (completions.isEmpty()) {
                return;
            }
            if (completions.size() == 1 && !completions.contains("lowerCaseName") && !completions.contains("UpperCaseName")) {
                boolean addSpace = false;
                this.replaceCurrentSelection((String)completions.iterator().next(), addSpace);
            } else {
                this.ccPopup = new JPopupMenu("SMI Completion");
                Vector completionVector = new Vector(completions);
                Collections.sort(completionVector);
                this.ccPopup.setLayout(new BorderLayout(5, 5));
                JScrollPane spane = new JScrollPane(20, 31);
                JList<String> completionSelection = new JList<String>(completionVector){

                    @Override
                    public void setSelectedIndex(int selectionIndex) {
                        super.setSelectedIndex(selectionIndex);
                        super.ensureIndexIsVisible(selectionIndex);
                    }
                };
                completionSelection.registerKeyboardAction(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e2) {
                        SmiEditorPanel.this.ccPopup.setVisible(false);
                    }
                }, KeyStroke.getKeyStroke(27, 0), 0);
                boolean bl = false;
                final CodeCompletionListener ccl = new CodeCompletionListener(this.ccPopup, completionSelection, bl);
                JListPopupFindAction findAction = new JListPopupFindAction(false, false, false){

                    @Override
                    protected void commitSearch() {
                        ccl.replace();
                    }
                };
                this.ccPopup.add((Component)findAction.getSearchPopupPanel().getSearchPanel(), "North");
                completionSelection.addKeyListener(new PopupSearchKeyListener(findAction));
                completionSelection.setSelectedIndex(0);
                findAction.setComponent(completionSelection);
                findAction.connectSearchField();
                completionSelection.addMouseListener(ccl);
                completionSelection.addKeyListener(ccl);
                spane.getViewport().add(completionSelection);
                this.ccPopup.add((Component)spane, "Center");
                try {
                    this.ccPopup.pack();
                    Point p2 = this.getEditor().modelToView(this.getEditor().getCaretPosition()).getLocation();
                    Point portPos = this.scroller.getViewport().getViewPosition();
                    this.ccPopup.show(this, p2.x, p2.y - portPos.y + 12);
                }
                catch (Exception ex1) {
                    ex1.printStackTrace();
                }
                completionSelection.requestFocusInWindow();
            }
        }
    }

    private void replaceCurrentSelection(String replacement, boolean addSpace) {
        Object r2 = addSpace ? " " : "";
        r2 = (String)r2 + replacement;
        this.editor.replaceSelection((String)r2);
    }

    private static boolean isTokenImage(String s2, int id) {
        return s2.startsWith(SMIParserConstants.tokenImage[id]);
    }

    private void addCompletions(String string, Set<String> completions, SMIRepository parserTree) {
        if (string.trim().length() == 0) {
            return;
        }
        if (this.lookupData != null) {
            if (SmiEditorPanel.isTokenImage(string, 120)) {
                completions.addAll(this.lookupData.getLowerCaseNames());
                return;
            }
            if (SmiEditorPanel.isTokenImage(string, 119)) {
                completions.addAll(this.lookupData.getUpperCaseNames());
                return;
            }
        } else if (parserTree != null) {
            if (SmiEditorPanel.isTokenImage(string, 120)) {
                completions.addAll(parserTree.getKnownLowerCaseNames());
                return;
            }
            if (SmiEditorPanel.isTokenImage(string, 119)) {
                completions.addAll(parserTree.getKnownUpperCaseNames());
                return;
            }
        } else {
            if (SmiEditorPanel.isTokenImage(string, 120)) {
                completions.add("lowerCaseName");
                return;
            }
            if (SmiEditorPanel.isTokenImage(string, 119)) {
                completions.add("UpperCaseName");
                return;
            }
        }
        if (SmiEditorPanel.isTokenImage(string, 8)) {
            completions.add("OBJECT IDENTIFIER");
        } else if (SmiEditorPanel.isTokenImage(string, 9)) {
            completions.add("OCTET STRING");
        } else if (SmiEditorPanel.isTokenImage(string, 11)) {
            completions.add("''h");
        } else if (SmiEditorPanel.isTokenImage(string, 10)) {
            completions.add("''b");
        } else if (SmiEditorPanel.isTokenImage(string, 16)) {
            completions.add("-1");
        } else if (SmiEditorPanel.isTokenImage(string, 15)) {
            completions.add("1");
        } else if (SmiEditorPanel.isTokenImage(string, 13)) {
            completions.add("\"\"");
        } else if (SmiEditorPanel.isTokenImage(string, 12)) {
            completions.add("\"\"");
        } else {
            completions.add(string);
        }
    }

    public static String replaceTabs(String tabbedString, int tabSize) {
        String tabs = "        ";
        if (tabSize < tabs.length()) {
            tabs = tabs.substring(tabs.length() - tabSize);
        }
        String[] lines = tabbedString.split("\n");
        StringBuilder result = new StringBuilder();
        for (int i2 = 0; i2 < lines.length; ++i2) {
            StringBuilder newLine = new StringBuilder();
            StringTokenizer st = new StringTokenizer(lines[i2], "\t", true);
            while (st.hasMoreTokens()) {
                String s2 = st.nextToken();
                if (s2.equals("\t")) {
                    newLine.append(tabs.substring(newLine.length() % tabSize));
                    continue;
                }
                newLine.append(s2);
            }
            result.append((CharSequence)newLine);
            if (i2 + 1 >= lines.length) continue;
            result.append('\n');
        }
        return result.toString();
    }

    protected String replaceTabs(String text) {
        return SmiEditorPanel.replaceTabs(text, 8);
    }

    public static void highlightMatches(Regex regex, JEditorPane textComponent) {
        try {
            if (regex == null || textComponent == null || textComponent.getDocument().getLength() <= 0) {
                return;
            }
            ErrorUnderlineHighlightPainter underlineHighlightPainter = new ErrorUnderlineHighlightPainter(Color.RED);
            Highlighter highlighter = textComponent.getHighlighter();
            highlighter.removeAllHighlights();
            try {
                List<int[]> matches = regex.allMatchPositions(textComponent.getDocument().getText(0, textComponent.getDocument().getLength()));
                for (int[] pos : matches) {
                    highlighter.addHighlight(pos[0], pos[1], underlineHighlightPainter);
                }
            }
            catch (BadLocationException e2) {
                e2.printStackTrace();
            }
        }
        catch (NullPointerException npx) {
            npx.printStackTrace();
        }
    }

    public static boolean selectNextMatch(Regex regex, JEditorPane textComponent, InstantSearchListener.Direction direction) {
        return JTextComponentFindAction.selectNextMatch(regex, textComponent, direction);
    }

    class ImportAction
    extends AbstractAction
    implements ModifyAction {
        ImportAction() {
            super("Import");
        }

        ImportAction(String nm) {
            super(nm);
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            SmiEditorPanel.this.importText();
        }

        public void update() {
            if (SmiEditorPanel.this.undo.canUndo()) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }
    }

    class RedoAction
    extends AbstractAction
    implements ModifyAction {
        public RedoAction() {
            super("Redo");
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            this.redo();
        }

        public void redo() {
            if (SmiEditorPanel.this.undo.canRedo()) {
                try {
                    SmiEditorPanel.this.undo.redo();
                }
                catch (CannotRedoException ex) {
                    System.out.println("Unable to redo: " + ex);
                    ex.printStackTrace();
                }
            }
            this.update();
            SmiEditorPanel.this.undoAction.update();
            SmiEditorPanel.this.importAction.update();
            SmiEditorPanel.this.lastKeyPressedTime = System.nanoTime();
        }

        protected void update() {
            if (SmiEditorPanel.this.undo.canRedo()) {
                this.setEnabled(true);
                this.putValue("Name", SmiEditorPanel.this.undo.getRedoPresentationName());
            } else {
                this.setEnabled(false);
                this.putValue("Name", "Redo");
            }
        }
    }

    class UndoAction
    extends AbstractAction
    implements ModifyAction {
        public UndoAction() {
            super("Undo");
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            this.undo();
        }

        protected void update() {
            if (SmiEditorPanel.this.undo.canUndo()) {
                this.setEnabled(true);
                this.putValue("Name", SmiEditorPanel.this.undo.getUndoPresentationName());
            } else {
                this.setEnabled(false);
                this.putValue("Name", "Undo");
            }
        }

        public void undo() {
            if (SmiEditorPanel.this.undo.canUndo()) {
                try {
                    SmiEditorPanel.this.undo.undo();
                }
                catch (CannotUndoException ex) {
                    System.out.println("Unable to undo: " + ex);
                    ex.printStackTrace();
                }
            }
            this.update();
            SmiEditorPanel.this.redoAction.update();
            SmiEditorPanel.this.importAction.update();
            SmiEditorPanel.this.lastKeyPressedTime = System.nanoTime();
        }
    }

    public static class AnnotatedSmiError
    implements AnnotationMark,
    SmiErrorInfo {
        private SmiError error;
        private int rowOffset = 0;
        private int positionOffset = 0;

        public AnnotatedSmiError(SmiError error) {
            this.error = error;
        }

        public AnnotatedSmiError(SmiError error, int rowOffset, int positionOffset) {
            this.error = error;
            this.rowOffset = rowOffset;
            this.positionOffset = positionOffset;
        }

        @Override
        public int getStartLine() {
            return this.rowOffset + this.error.getRow();
        }

        @Override
        public int getEndLine() {
            return this.rowOffset + this.error.getEndRow();
        }

        @Override
        public AnnotationMark.MarkSeverity getSeverity() {
            return AnnotationMark.MarkSeverity.error;
        }

        @Override
        public int getPriority() {
            return AnnotationMark.MarkSeverity.error.ordinal();
        }

        @Override
        public String getDescription() {
            return "<html>" + this.error.getShortMessage().replace("&", "&amp;").replace("<", "&lt;").replace("\n", "<br>") + "</html>";
        }

        @Override
        public int getColumn() {
            return this.error.getColumn();
        }

        @Override
        public int getEndColumn() {
            return this.error.getEndColumn();
        }

        @Override
        public int getErrorNumber() {
            return this.error.getErrorNumber();
        }

        @Override
        public String getMessage() {
            return this.error.getMessage();
        }

        @Override
        public String getShortMessage() {
            return this.error.getShortMessage();
        }

        @Override
        public String getDefectiveText() {
            return this.error.getDefectiveText();
        }

        @Override
        public int getRow() {
            return this.rowOffset + this.error.getRow();
        }

        @Override
        public int getEndRow() {
            return this.rowOffset + this.error.getEndRow();
        }

        @Override
        public int getPosition() {
            return this.positionOffset + this.error.getPosition();
        }

        @Override
        public String getModuleName() {
            return this.error.getModuleName();
        }

        @Override
        public String[] getExpectedText() {
            return this.error.getExpectedText();
        }

        @Override
        public int getEndPosition() {
            return this.positionOffset + this.error.getPosition() + (this.error.getDefectiveText() != null ? this.error.getDefectiveText().length() : 1);
        }

        public String toString() {
            return "AnnotatedSmiError{error=" + this.error + ", rowOffset=" + this.rowOffset + ", positionOffset=" + this.positionOffset + "}";
        }
    }

    class UndoHandler
    implements UndoableEditListener {
        UndoHandler() {
        }

        @Override
        public void undoableEditHappened(UndoableEditEvent e2) {
            SmiEditorPanel.this.undo.addEdit(e2.getEdit());
            SmiEditorPanel.this.undoAction.update();
            SmiEditorPanel.this.redoAction.update();
            SmiEditorPanel.this.importAction.update();
            SmiEditorPanel.this.lastKeyPressedTime = System.nanoTime();
        }
    }

    class ImportAccurateAction
    extends AbstractAction
    implements ModifyAction {
        ImportAccurateAction() {
            super("ImportAccurate");
        }

        ImportAccurateAction(String nm) {
            super(nm);
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            SmiEditorPanel.this.importText(false);
        }

        public void update() {
        }
    }

    class ImportLenientAction
    extends AbstractAction
    implements ModifyAction {
        ImportLenientAction() {
            super("ImportLenient");
        }

        ImportLenientAction(String nm) {
            super(nm);
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            SmiEditorPanel.this.importText(true);
        }

        public void update() {
        }
    }

    class ExportSelectedErrorsAction
    extends AbstractAction {
        private boolean selectedOnly;

        public ExportSelectedErrorsAction(String name, boolean selectedOnly) {
            super(name);
            this.selectedOnly = selectedOnly;
            this.setEnabled(selectedOnly);
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            int[] rows = TableUtils.getSelectedRows(SmiEditorPanel.this.errorTable);
            JFileChooser fc = new JFileChooser();
            fc.setFileSelectionMode(0);
            if (fc.showSaveDialog(SmiEditorPanel.this.myFrame) == 0) {
                if (fc.getSelectedFile().exists()) {
                    Object[] options = new Object[]{"Yes", "Cancel"};
                    int n2 = JOptionPane.showOptionDialog(SmiEditorPanel.this.myFrame, "File already exists! Replace it?", "Confirm Replace", 0, 3, null, options, options[1]);
                    if (n2 == 1) {
                        return;
                    }
                }
                try {
                    FileOutputStream fos = new FileOutputStream(fc.getSelectedFile());
                    TableDataModel data = SmiEditorPanel.this.errorTable.getDataSource();
                    Arrays.sort(rows);
                    ArrayList<SmiError> results = new ArrayList<SmiError>();
                    for (int i2 = 0; i2 < data.getNumRows(); ++i2) {
                        if (this.selectedOnly && Arrays.binarySearch(rows, i2) < 0 || data.getTableDataItem(i2, 0) instanceof String) continue;
                        SmiError smiError = (SmiError)data.getTableRowLabel(i2);
                        results.add(smiError);
                    }
                    CompilationResult compilationResult = new CompilationResult(SmiEditorPanel.this.getTitle(), Collections.emptyList(), results);
                    fos.write(SmiEditorPanel.getCompilerLogText(Collections.singletonList(compilationResult)).getBytes());
                    fos.close();
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(SmiEditorPanel.this.myFrame, "Error writing report: " + ex.getMessage(), "File Error", 0);
                }
            }
        }
    }

    class BackgroundValidationAction
    extends AbstractAction {
        BackgroundValidationAction() {
            super(SmiEditorPanel.backgroundValidationAction);
            this.setEnabled(true);
            this.setSelection(SmiEditorPanel.backgroundValidationAction);
        }

        BackgroundValidationAction(String nm) {
            super(nm);
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            SmiEditorPanel.this.setBackgroundChecksEnabled(!SmiEditorPanel.this.isBackgroundChecksEnabled());
            this.setSelection(e2.getActionCommand());
        }

        public void setSelection(String command) {
            AbstractButton button;
            if (command == null || SmiEditorPanel.this.menuItems == null || SmiEditorPanel.this.buttons == null) {
                return;
            }
            JMenuItem menuItem = (JMenuItem)SmiEditorPanel.this.menuItems.get(command);
            if (menuItem != null) {
                menuItem.setSelected(SmiEditorPanel.this.isBackgroundChecksEnabled());
            }
            if ((button = (AbstractButton)SmiEditorPanel.this.buttons.get(command)) instanceof JToggleButton) {
                button.setSelected(SmiEditorPanel.this.isBackgroundChecksEnabled());
            }
        }
    }

    class NewAction
    extends AbstractAction {
        NewAction() {
            super(SmiEditorPanel.newAction);
        }

        NewAction(String nm) {
            super(nm);
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            Document oldDoc = SmiEditorPanel.this.getEditor().getDocument();
            if (oldDoc != null) {
                oldDoc.removeUndoableEditListener(SmiEditorPanel.this.undoHandler);
            }
            SmiEditorPanel.this.getEditor().setDocument(new SmiDocument());
            SmiEditorPanel.this.getEditor().getDocument().addUndoableEditListener(SmiEditorPanel.this.undoHandler);
            SmiEditorPanel.this.resetUndoManager();
        }
    }

    class OpenAction
    extends NewAction {
        OpenAction() {
            super(SmiEditorPanel.openAction);
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            Frame frame = SmiEditorPanel.this.getFrame();
            if (SmiEditorPanel.this.fileDialog == null) {
                SmiEditorPanel.this.fileDialog = new FileDialog(frame);
            }
            SmiEditorPanel.this.fileDialog.setMode(0);
            SmiEditorPanel.this.fileDialog.setVisible(true);
            String file = SmiEditorPanel.this.fileDialog.getFile();
            if (file == null) {
                return;
            }
            String directory = SmiEditorPanel.this.fileDialog.getDirectory();
            File f2 = new File(directory, file);
            if (f2.exists()) {
                SmiEditorPanel.this.setTitle(file);
                SmiEditorPanel.this.loadFile(f2, 0, 0, 0);
            }
        }
    }

    class SaveAction
    extends AbstractAction {
        SaveAction() {
            super(SmiEditorPanel.saveAction);
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            try {
                FileOutputStream fo = new FileOutputStream(SmiEditorPanel.this.file);
                fo.write(SmiEditorPanel.this.getDocumentBytes());
                fo.close();
                SmiEditorPanel.this.status.setText("Saved '" + SmiEditorPanel.this.file.getPath() + "'");
            }
            catch (IOException iox) {
                SmiEditorPanel.this.status.setText("Could not save file '" + SmiEditorPanel.this.file.getPath() + "'");
            }
        }
    }

    class SaveAsAction
    extends AbstractAction
    implements ModifyAction {
        SaveAsAction() {
            super("SaveAs");
        }

        SaveAsAction(String nm) {
            super(nm);
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            SmiEditorPanel.this.saveAsAction();
        }

        public void update() {
        }
    }

    class FindAction
    extends AbstractAction {
        FindAction() {
            super("Find");
        }

        private String getSelection() {
            if (SmiEditorPanel.this.getEditor().getSelectedText() != null) {
                return SmiEditorPanel.this.getEditor().getSelectedText();
            }
            return null;
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            SearchReplacePanel sp = new SearchReplacePanel();
            sp.setReplaceEnabled(false);
            Vector<String> v = SmiEditorPanel.this.config.getArray(SmiEditorPanel.CFG_SEARCH);
            if (this.getSelection() != null) {
                v.insertElementAt(this.getSelection(), 0);
            }
            sp.setSearchExpressions(v);
            StandardDialog sd = new StandardDialog((Frame)SmiEditorPanel.this.myFrame, "Find", true, true);
            sd.setCenterPanel(sp);
            sd.setLocationRelativeTo(SmiEditorPanel.this.myFrame);
            do {
                Pattern p2;
                sp.selectAll();
                sd.setVisible(true);
                if (sd.getResult() != 0 || (p2 = SmiEditorPanel.this.makePattern(sp.getSearchExpression(), false)) == null) continue;
                SmiEditorPanel.this.config.putArray(SmiEditorPanel.CFG_SEARCH, sp.getSearchExpressions());
                SmiEditorPanel.this.searchPattern(p2);
                break;
            } while (sd.getResult() == 0);
        }
    }

    class ReplaceAction
    extends AbstractAction
    implements ModifyAction {
        ReplaceAction() {
            super("Replace");
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            SearchReplacePanel sp = new SearchReplacePanel();
            sp.setReplaceEnabled(true);
            sp.setSearchExpressions(SmiEditorPanel.this.config.getArray(SmiEditorPanel.CFG_SEARCH));
            sp.setSubstitutionStrings(SmiEditorPanel.this.config.getArray(SmiEditorPanel.CFG_REPLACE));
            StandardDialog sd = new StandardDialog((Frame)SmiEditorPanel.this.myFrame, "Replace", true, true);
            sd.setCenterPanel(sp);
            sd.setLocationRelativeTo(SmiEditorPanel.this.myFrame);
            do {
                Pattern p2;
                sp.selectAll();
                sd.setVisible(true);
                if (sd.getResult() != 0 || (p2 = SmiEditorPanel.this.makePattern(sp.getSearchExpression(), false)) == null) continue;
                SmiEditorPanel.this.config.putArray(SmiEditorPanel.CFG_SEARCH, sp.getSearchExpressions());
                SmiEditorPanel.this.config.putArray(SmiEditorPanel.CFG_REPLACE, sp.getSubstitutionStrings());
                SmiEditorPanel.this.replace(p2, sp.getSubstitutionString());
                break;
            } while (sd.getResult() == 0);
        }
    }

    class CheckAccurateAction
    extends AbstractAction {
        CheckAccurateAction() {
            super("CheckAccurate");
        }

        CheckAccurateAction(String nm) {
            super(nm);
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            if (SmiEditorPanel.this.importer != null) {
                int errCount = SmiEditorPanel.this.checkText(false, true);
                if (errCount == 0) {
                    SmiEditorPanel.this.status.setText("SMI check OK - no errors found.");
                } else {
                    SmiEditorPanel.this.status.setText("Found " + errCount + " SMI syntax error" + (errCount > 1 ? "s" : "") + ", see error list above for details.");
                }
            }
        }
    }

    class CheckLenientAction
    extends AbstractAction {
        CheckLenientAction() {
            super("CheckLenient");
        }

        CheckLenientAction(String nm) {
            super(nm);
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            if (SmiEditorPanel.this.importer != null) {
                int errCount = SmiEditorPanel.this.checkText(true, true);
                if (errCount == 0) {
                    SmiEditorPanel.this.status.setText("Lenient SMI check OK - no errors found.");
                } else {
                    SmiEditorPanel.this.status.setText("Lenient SMI check detected " + errCount + " SMI fatal syntax error" + (errCount > 1 ? "s" : "") + ", see error list above for details.");
                }
            }
        }
    }

    class FindNextAction
    extends AbstractAction {
        FindNextAction() {
            super("FindNext");
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            SmiEditorPanel.this.searchPattern(SmiEditorPanel.this.lastPattern);
        }
    }

    class PrintAction
    extends AbstractAction {
        PrintAction() {
            super(SmiEditorPanel.printAction);
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            SmiEditorPanel.this.print();
        }
    }

    static class PasteAction
    extends TextAction
    implements ModifyAction {
        public PasteAction() {
            super("paste-from-clipboard");
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            JTextComponent target = this.getTextComponent(e2);
            if (target != null) {
                target.paste();
            }
        }
    }

    public static class CutAction
    extends TextAction
    implements ModifyAction {
        public CutAction() {
            super("cut-to-clipboard");
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            JTextComponent target = this.getTextComponent(e2);
            if (target != null) {
                target.cut();
            }
        }
    }

    class ExitAction
    extends AbstractAction {
        ExitAction() {
            super(SmiEditorPanel.exitAction);
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            SmiEditorPanel.this.doExit();
        }
    }

    private class BackgroundCheckTask
    extends TimerTask {
        private BackgroundCheckTask() {
        }

        @Override
        public void run() {
            if (SmiEditorPanel.this.lastKeyPressedTime > 0L && System.nanoTime() - SmiEditorPanel.this.lastKeyPressedTime > (long)SmiEditorPanel.this.config.getInteger("com.agentpp.smi.editor.background.check.idle", 750000000)) {
                SmiEditorPanel.this.lastKeyPressedTime = 0L;
                try {
                    SwingUtilities.invokeAndWait(new RepaintErrorStripe(true));
                }
                catch (InterruptedException e2) {
                    e2.printStackTrace();
                }
                catch (InvocationTargetException e3) {
                    e3.printStackTrace();
                }
                SmiEditorPanel.this.checkText(SmiEditorPanel.this.defaultCompileLenient, false);
                SmiEditorPanel.this.lastKeyPressedTime = 0L;
                SwingUtilities.invokeLater(new RepaintErrorStripe(false));
            }
        }
    }

    class StatusBar
    extends JLabel
    implements CaretListener {
        public StatusBar() {
            super(" ");
            this.setLayout(new BoxLayout(this, 0));
        }

        @Override
        public void caretUpdate(CaretEvent e2) {
            int dot = e2.getDot();
            SmiDocument smidoc = (SmiDocument)SmiEditorPanel.this.editor.getDocument();
            int line = smidoc.getLineOfOffset(dot) + 1;
            int col = dot + 1 - smidoc.getLineStartOffset(smidoc.getLineOfOffset(dot));
            this.setText(line + ":" + col);
            this.setToolTipText("Cursor is located at row " + line + ", column " + col);
        }

        @Override
        public void paint(Graphics g2) {
            super.paint(g2);
        }
    }

    class FileLoader
    extends Thread {
        public int selection = 0;
        Document doc;
        File f;

        FileLoader(File f2, Document doc) {
            this.setPriority(4);
            this.f = f2;
            this.doc = doc;
        }

        @Override
        public void run() {
            try {
                int nch;
                SmiEditorPanel.this.status.removeAll();
                final JProgressBar progress = new JProgressBar();
                progress.setMinimum(0);
                progress.setMaximum((int)this.f.length());
                SmiEditorPanel.this.status.add(progress);
                SmiEditorPanel.this.status.revalidate();
                this.doc.putProperty("__EndOfLine__", "\n");
                FileReader in = new FileReader(this.f);
                char[] buff = new char[65535];
                String lastline = "";
                while ((nch = ((Reader)in).read(buff, 0, buff.length)) != -1) {
                    Object s2 = new String(buff, 0, nch);
                    if (lastline.length() > 0) {
                        int nl = lastline.indexOf(10);
                        if (nl >= 0) {
                            String begin = lastline.substring(0, nl);
                            s2 = SmiEditorPanel.this.replaceTabs(lastline + begin) + SmiEditorPanel.this.replaceTabs(((String)s2).substring(nl));
                        } else {
                            s2 = SmiEditorPanel.this.replaceTabs((String)s2);
                        }
                    }
                    s2 = SmiEditorPanel.this.replaceTabs((String)s2);
                    int el = ((String)(s2 = ((String)s2).replace("\r", ""))).lastIndexOf(10);
                    lastline = el >= 0 ? ((String)s2).substring(el + 1) : "";
                    final String text = s2;
                    final int psize = nch;
                    try {
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    FileLoader.this.doc.insertString(FileLoader.this.doc.getLength(), text, null);
                                    SmiEditorPanel.this.editor.setCaretPosition(0);
                                }
                                catch (BadLocationException e2) {
                                    e2.printStackTrace();
                                }
                                progress.setValue(progress.getValue() + psize);
                            }
                        });
                    }
                    catch (InterruptedException | InvocationTargetException e2) {
                        e2.printStackTrace();
                    }
                }
                ((Reader)in).close();
            }
            catch (IOException e3) {
                System.err.println(e3.toString());
            }
            if (SmiEditorPanel.this.elementTreePanel != null) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SmiEditorPanel.this.elementTreePanel.setEditor(SmiEditorPanel.this.getEditor());
                    }
                });
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    FileLoader.this.doc.addUndoableEditListener(SmiEditorPanel.this.undoHandler);
                    SmiEditorPanel.this.status.removeAll();
                    SmiEditorPanel.this.status.revalidate();
                    SmiEditorPanel.this.resetUndoManager();
                    SmiEditorPanel.this.setEnabled(true);
                    SmiEditorPanel.this.editor.setEditable(true);
                    Thread checkThread = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            SmiEditorPanel.this.checkText(false, true);
                            SwingUtilities.invokeLater(new RepaintErrorStripe(false));
                        }
                    });
                    checkThread.start();
                }
            });
        }
    }

    private class ActionChangedListener
    implements PropertyChangeListener {
        JMenuItem menuItem;

        ActionChangedListener(JMenuItem mi) {
            this.menuItem = mi;
        }

        @Override
        public void propertyChange(PropertyChangeEvent e2) {
            String propertyName = e2.getPropertyName();
            if (e2.getPropertyName().equals("Name")) {
                String text = (String)e2.getNewValue();
                this.menuItem.setText(text);
            } else if (propertyName.equals("enabled")) {
                Boolean enabledState = (Boolean)e2.getNewValue();
                this.menuItem.setEnabled(enabledState);
            }
        }
    }

    private class ButtonActionChangedListener
    implements PropertyChangeListener {
        AbstractButton button;

        ButtonActionChangedListener(AbstractButton b2) {
            this.button = b2;
        }

        @Override
        public void propertyChange(PropertyChangeEvent e2) {
            String propertyName = e2.getPropertyName();
            if (propertyName.equals("enabled")) {
                Boolean enabledState = (Boolean)e2.getNewValue();
                this.button.setEnabled(enabledState);
            }
        }
    }

    static interface ModifyAction {
    }

    private class CodeCompletionListener
    implements MouseListener,
    KeyListener {
        private JPopupMenu popup;
        private JList list;
        private boolean addSpace;

        public CodeCompletionListener(JPopupMenu popup, JList list, boolean addSpace) {
            this.popup = popup;
            this.list = list;
            this.addSpace = addSpace;
        }

        @Override
        public void mouseClicked(MouseEvent e2) {
            if (e2.getClickCount() == 2) {
                this.replace();
            }
        }

        @Override
        public void mouseEntered(MouseEvent e2) {
        }

        @Override
        public void mouseExited(MouseEvent e2) {
        }

        @Override
        public void mousePressed(MouseEvent e2) {
        }

        @Override
        public void mouseReleased(MouseEvent e2) {
        }

        @Override
        public void keyPressed(KeyEvent e2) {
            if (e2.getKeyCode() == 10) {
                this.replace();
            } else if (e2.getKeyCode() == 27) {
                this.popup.setVisible(false);
            }
        }

        @Override
        public void keyReleased(KeyEvent e2) {
        }

        @Override
        public void keyTyped(KeyEvent e2) {
        }

        private void replace() {
            String s2 = (String)this.list.getSelectedValue();
            if (s2 == null) {
                return;
            }
            SmiEditorPanel.this.replaceCurrentSelection(s2, this.addSpace);
            this.popup.setVisible(false);
        }
    }

    private class RepaintErrorStripe
    implements Runnable {
        private boolean newStatus;

        private RepaintErrorStripe(boolean newStatus) {
            this.newStatus = newStatus;
        }

        @Override
        public void run() {
            SmiEditorPanel.this.errorStripe.setStatusUpdateInProgress(this.newStatus);
            SmiEditorPanel.this.errorStripe.repaint();
        }
    }

    class ShowElementTreeAction
    extends AbstractAction {
        ShowElementTreeAction() {
            super(SmiEditorPanel.showElementTreeAction);
        }

        ShowElementTreeAction(String nm) {
            super(nm);
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            if (SmiEditorPanel.this.elementTreeFrame == null) {
                try {
                    String title = SmiEditorPanel.this.resources.getString("ElementTreeFrameTitle");
                    SmiEditorPanel.this.elementTreeFrame = new JFrame(title);
                }
                catch (MissingResourceException mre) {
                    SmiEditorPanel.this.elementTreeFrame = new JFrame();
                }
                SmiEditorPanel.this.elementTreeFrame.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent weeee) {
                        SmiEditorPanel.this.elementTreeFrame.setVisible(false);
                    }
                });
                Container fContentPane = SmiEditorPanel.this.elementTreeFrame.getContentPane();
                fContentPane.setLayout(new BorderLayout());
                SmiEditorPanel.this.elementTreePanel = new ElementTreePanel(SmiEditorPanel.this.getEditor());
                fContentPane.add(SmiEditorPanel.this.elementTreePanel);
                SmiEditorPanel.this.elementTreeFrame.pack();
            }
            SmiEditorPanel.this.elementTreeFrame.setVisible(true);
        }
    }
}

