/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.commons.mib.editor;

import com.agentpp.commons.ui.JListPopupFindAction;
import com.agentpp.commons.ui.PopupSearchKeyListener;
import com.agentpp.mib.MIBModule;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Collections;
import java.util.HashSet;
import java.util.Vector;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;

public class MIBObjectNameCompletion
implements KeyListener {
    private JPopupMenu ccPopup;
    private MIBModule lookupData;
    private JTextArea textArea;
    private JScrollPane scrollPane;

    public MIBObjectNameCompletion(MIBModule lookupData, JTextArea textArea, JScrollPane scrollPane) {
        this.lookupData = lookupData;
        this.textArea = textArea;
        this.scrollPane = scrollPane;
    }

    @Override
    public void keyTyped(KeyEvent e2) {
        if (e2.getKeyChar() == '\u001b') {
            if (this.ccPopup != null) {
                this.disposeCodeCompletionPopup();
            }
        } else if (this.textArea.isEditable() && (e2.getModifiersEx() & 0x80) != 0 && e2.getKeyChar() == ' ') {
            this.codeCompletion();
        }
    }

    @Override
    public void keyPressed(KeyEvent e2) {
    }

    @Override
    public void keyReleased(KeyEvent e2) {
    }

    private void disposeCodeCompletionPopup() {
        this.ccPopup.setVisible(false);
    }

    public void codeCompletion() {
        if (this.ccPopup != null) {
            this.ccPopup.setVisible(false);
        }
        HashSet<String> completions = new HashSet<String>();
        completions.addAll(this.lookupData.getLowerCaseNames());
        completions.addAll(this.lookupData.getUpperCaseNames());
        this.ccPopup = new JPopupMenu("SMI Completion");
        Vector completionVector = new Vector(completions);
        Collections.sort(completionVector);
        this.ccPopup.setLayout(new BorderLayout(5, 5));
        JScrollPane spane = new JScrollPane(20, 31);
        JList<String> completionSelection = new JList<String>(completionVector){

            @Override
            public void setSelectedIndex(int selectionIndex) {
                super.setSelectedIndex(selectionIndex);
                super.ensureIndexIsVisible(selectionIndex);
            }
        };
        completionSelection.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                MIBObjectNameCompletion.this.ccPopup.setVisible(false);
            }
        }, KeyStroke.getKeyStroke(27, 0), 0);
        boolean addSpace = false;
        final CodeCompletionListener ccl = new CodeCompletionListener(this.ccPopup, completionSelection, addSpace);
        JListPopupFindAction findAction = new JListPopupFindAction(false, false, false){

            @Override
            protected void commitSearch() {
                ccl.replace();
            }
        };
        this.ccPopup.add((Component)findAction.getSearchPopupPanel().getSearchPanel(), "North");
        completionSelection.addKeyListener(new PopupSearchKeyListener(findAction));
        completionSelection.setSelectedIndex(0);
        findAction.setComponent(completionSelection);
        findAction.connectSearchField();
        completionSelection.addMouseListener(ccl);
        completionSelection.addKeyListener(ccl);
        spane.getViewport().add(completionSelection);
        this.ccPopup.add((Component)spane, "Center");
        try {
            this.ccPopup.pack();
            Point p2 = this.textArea.modelToView(this.textArea.getCaretPosition()).getBounds().getLocation();
            Point portPos = this.scrollPane.getViewport().getViewPosition();
            this.ccPopup.show(this.textArea, p2.x, p2.y - portPos.y + 12);
        }
        catch (Exception ex1) {
            ex1.printStackTrace();
        }
        completionSelection.requestFocusInWindow();
    }

    private void replaceCurrentSelection(String replacement, boolean addSpace) {
        Object r2 = addSpace ? " " : "";
        r2 = (String)r2 + replacement;
        this.textArea.replaceSelection((String)r2);
    }

    private class CodeCompletionListener
    implements MouseListener,
    KeyListener {
        private JPopupMenu popup;
        private JList list;
        private boolean addSpace;

        public CodeCompletionListener(JPopupMenu popup, JList list, boolean addSpace) {
            this.popup = popup;
            this.list = list;
            this.addSpace = addSpace;
        }

        @Override
        public void mouseClicked(MouseEvent e2) {
            if (e2.getClickCount() == 2) {
                this.replace();
            }
        }

        @Override
        public void mouseEntered(MouseEvent e2) {
        }

        @Override
        public void mouseExited(MouseEvent e2) {
        }

        @Override
        public void mousePressed(MouseEvent e2) {
        }

        @Override
        public void mouseReleased(MouseEvent e2) {
        }

        @Override
        public void keyPressed(KeyEvent e2) {
            if (e2.getKeyCode() == 10) {
                this.replace();
            } else if (e2.getKeyCode() == 27) {
                this.popup.setVisible(false);
            }
        }

        @Override
        public void keyReleased(KeyEvent e2) {
        }

        @Override
        public void keyTyped(KeyEvent e2) {
        }

        private void replace() {
            String s2 = (String)this.list.getSelectedValue();
            if (s2 == null) {
                return;
            }
            MIBObjectNameCompletion.this.replaceCurrentSelection(s2, this.addSpace);
            this.popup.setVisible(false);
        }
    }
}

