/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.commons.mib;

import com.snmp4j.smi.CompilationResult;
import com.snmp4j.smi.SmiCompiler;
import java.awt.Component;
import java.util.List;
import javax.swing.JOptionPane;

public class SmiParserResultDialog {
    public static UserChoice showDialog(Component parentComponent, List<CompilationResult> compilationResultList, SmiCompiler.OverwriteMode overwriteMode) {
        if (CompilationResult.hasErrors(compilationResultList)) {
            List<String> failed = CompilationResult.getFailedFiles(compilationResultList);
            Object[] options = new String[]{"OK", "Details..."};
            String overwriteModeString = "[Add New]";
            switch (overwriteMode) {
                case overwriteIfNewer: {
                    overwriteModeString = "[Overwrite If Newer]";
                    break;
                }
                case overwriteAlways: {
                    overwriteModeString = "[Overwrite]";
                }
            }
            int option = JOptionPane.showOptionDialog(parentComponent, new String[]{"Compilation failed for " + failed.size() + " out of " + compilationResultList.size() + " MIB files.", "Click on 'Details...' to correct errors or retry failed."}, "Compilation Overview " + overwriteModeString, options.length == 3 ? 1 : 0, 0, null, options, options[options.length - 1]);
            switch (option) {
                case 1: {
                    return UserChoice.details;
                }
            }
            return UserChoice.cancel;
        }
        if (compilationResultList.size() == 0) {
            String[] options = new String[]{"OK", "Details..."};
            JOptionPane.showMessageDialog(parentComponent, "Selected files did not contain any " + (overwriteMode == SmiCompiler.OverwriteMode.overwriteIfNewer ? "new " : "") + "  MIB modules.", "Nothing To Do", 2);
            return UserChoice.cancel;
        }
        Object[] options = new String[]{"OK", "Details..."};
        int option = JOptionPane.showOptionDialog(parentComponent, "Successfully compiled all " + compilationResultList.size() + " MIB files.", "Compilation Success", 0, 1, null, options, options[0]);
        switch (option) {
            case 1: {
                return UserChoice.details;
            }
        }
        return UserChoice.cancel;
    }

    public static enum UserChoice {
        cancel,
        details;

    }
}

