/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.commons.mib;

import com.agentpp.common.TableSorter;
import com.agentpp.common.table.ExtendedListTable;
import com.agentpp.mib.MIBAgentCaps;
import com.agentpp.mib.MIBCompliance;
import com.agentpp.mib.MIBGroup;
import com.agentpp.mib.MIBModule;
import com.agentpp.mib.MIBNotifyType;
import com.agentpp.mib.MIBObject;
import com.agentpp.mib.MIBObjectType;
import com.agentpp.mib.MIBRepository;
import com.agentpp.repository.RepositoryManager;
import com.klg.jclass.table.JCTable;
import com.klg.jclass.table.data.JCEditableVectorDataSource;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.snmp4j.util.ThreadPool;
import org.snmp4j.util.WorkerTask;

public class MIBModulesStatistics
implements ActionListener {
    public static final String[] COLUMNS = new String[]{"MIB Module", "Total", "Names", "Identities", "Types", "Scalar", "Tables", "Columns", "Traps", "Conventions", "Groups", "Compliance", "Agent-Caps", "Released", "Uneleased"};
    private ThreadPool threadPool;
    private JCTable table;
    private JPanel panel;
    private JCEditableVectorDataSource model;
    private RepositoryManager repositoryManager;

    public MIBModulesStatistics() {
        this.$$$setupUI$$$();
        this.threadPool = ThreadPool.create("ModuleStatistics", Runtime.getRuntime().availableProcessors());
    }

    private void $$$setupUI$$$() {
        this.createUIComponents();
        this.panel.setLayout(new GridBagLayout());
        JPanel spacer1 = new JPanel();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 15;
        this.panel.add((Component)spacer1, gbc);
        JScrollPane scrollPane1 = new JScrollPane();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(10, 10, 10, 10);
        this.panel.add((Component)scrollPane1, gbc);
        scrollPane1.setViewportView(this.table);
    }

    public JComponent $$$getRootComponent$$$() {
        return this.panel;
    }

    private void createUIComponents() {
        this.panel = new JPanel();
        this.table = new ExtendedListTable();
        this.model = new JCEditableVectorDataSource();
        this.model.setNumColumns(COLUMNS.length);
        this.model.setColumnLabels(COLUMNS);
        this.model.setNumRows(0);
        this.table.setDataSource(this.model);
        this.table.setPixelWidth(-997, 33002);
        this.table.setPixelHeight(-997, 33002);
        this.table.setRowLabelDisplay(false);
        this.table.setSelectionPolicy(2);
        this.table.setAutoEdit(false);
        this.table.getDefaultCellStyle().setEditable(false);
        TableSorter tableSorter = new TableSorter(this.table, this.model);
        KeyStroke copy = KeyStroke.getKeyStroke(67, 2, false);
        this.table.registerKeyboardAction(this, "copy", copy, 0);
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        String cmd = e2.getActionCommand();
        if (cmd.equals("copy")) {
            ((ExtendedListTable)this.table).copySelectionToClipBoard();
        }
    }

    public JPanel getPanel() {
        return this.panel;
    }

    public RepositoryManager getRepositoryManager() {
        return this.repositoryManager;
    }

    public void setRepositoryManager(RepositoryManager repositoryManager) {
        this.repositoryManager = repositoryManager;
    }

    public void stop() {
        this.threadPool.stop();
    }

    public void addModule(final String moduleName, final MIBModule mibModule) {
        WorkerTask workerTask = new WorkerTask(){

            @Override
            public void terminate() {
            }

            @Override
            public void join() throws InterruptedException {
            }

            @Override
            public void interrupt() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                MIBModule module = mibModule;
                if (module == null && MIBModulesStatistics.this.repositoryManager != null) {
                    try {
                        MIBObject[] objects = MIBModulesStatistics.this.repositoryManager.getObjects(moduleName);
                        MIBRepository rep = new MIBRepository(objects);
                        rep.structureChanged();
                        module = rep.getModule(moduleName);
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
                MIBModule m3 = module;
                MIBModulesStatistics mIBModulesStatistics = MIBModulesStatistics.this;
                synchronized (mIBModulesStatistics) {
                    MIBModulesStatistics.this.table.setRepaintEnabled(false);
                    if (m3 != null) {
                        Integer[] stats = MIBModulesStatistics.computeModuleStats(m3);
                        Vector<Object> rowData = new Vector<Object>(COLUMNS.length);
                        rowData.add(m3.getModuleName());
                        rowData.addAll(Arrays.asList(stats));
                        MIBModulesStatistics.this.model.addRow(Integer.MAX_VALUE, m3.getModuleName(), rowData);
                    } else {
                        Object[] emptyStats = new Integer[COLUMNS.length - 1];
                        Arrays.fill(emptyStats, (Object)0);
                        Vector<Object> v = new Vector<Object>(COLUMNS.length);
                        v.add(moduleName);
                        v.addAll(Arrays.asList(emptyStats));
                        MIBModulesStatistics.this.model.addRow(Integer.MAX_VALUE, moduleName, v);
                    }
                    SwingUtilities.invokeLater(() -> MIBModulesStatistics.this.table.setRepaintEnabled(true));
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            workerTask.run();
        } else {
            this.threadPool.execute(workerTask);
        }
    }

    public void setRepaintEnabled(boolean enabled) {
        this.table.setRepaintEnabled(enabled);
    }

    public static Integer[] computeModuleStats(MIBModule mibModule) {
        Object[] stats = new Integer[COLUMNS.length - 1];
        Arrays.fill(stats, (Object)0);
        for (MIBObject object : mibModule.getObjectsVector()) {
            Object object2;
            int n2;
            Object[] objectArray = stats;
            Object object3 = objectArray[0];
            objectArray[0] = (Integer)objectArray[0] + 1;
            if (object.isReleased()) {
                objectArray = stats;
                n2 = StatisticColumns.released.ordinal() - 1;
                object2 = objectArray[n2];
                objectArray[n2] = (Integer)objectArray[n2] + 1;
            } else {
                objectArray = stats;
                n2 = StatisticColumns.unreleased.ordinal() - 1;
                object2 = objectArray[n2];
                objectArray[n2] = (Integer)objectArray[n2] + 1;
            }
            if (object.getClass().equals(MIBObject.class)) {
                if (object.getType() == 0) {
                    objectArray = stats;
                    n2 = StatisticColumns.identities.ordinal() - 1;
                    object2 = objectArray[n2];
                    objectArray[n2] = (Integer)objectArray[n2] + 1;
                    continue;
                }
                objectArray = stats;
                n2 = StatisticColumns.names.ordinal() - 1;
                object2 = objectArray[n2];
                objectArray[n2] = (Integer)objectArray[n2] + 1;
                continue;
            }
            if (object instanceof MIBObjectType) {
                Object object4;
                objectArray = stats;
                n2 = StatisticColumns.types.ordinal() - 1;
                object2 = objectArray[n2];
                objectArray[n2] = (Integer)objectArray[n2] + 1;
                MIBObjectType ot = (MIBObjectType)object;
                if (ot.isColumnarObject()) {
                    Object[] objectArray2 = stats;
                    int n3 = StatisticColumns.columns.ordinal() - 1;
                    object4 = objectArray2[n3];
                    objectArray2[n3] = (Integer)objectArray2[n3] + 1;
                    continue;
                }
                if (ot.isTable()) {
                    Object[] objectArray3 = stats;
                    int n4 = StatisticColumns.tables.ordinal() - 1;
                    object4 = objectArray3[n4];
                    objectArray3[n4] = (Integer)objectArray3[n4] + 1;
                    continue;
                }
                if (!ot.isScalar()) continue;
                Object[] objectArray4 = stats;
                int n5 = StatisticColumns.scalars.ordinal() - 1;
                object4 = objectArray4[n5];
                objectArray4[n5] = (Integer)objectArray4[n5] + 1;
                continue;
            }
            if (object instanceof MIBNotifyType) {
                objectArray = stats;
                n2 = StatisticColumns.traps.ordinal() - 1;
                object2 = objectArray[n2];
                objectArray[n2] = (Integer)objectArray[n2] + 1;
                continue;
            }
            if (object instanceof MIBCompliance) {
                objectArray = stats;
                n2 = StatisticColumns.compliance.ordinal() - 1;
                object2 = objectArray[n2];
                objectArray[n2] = (Integer)objectArray[n2] + 1;
                continue;
            }
            if (object instanceof MIBGroup) {
                objectArray = stats;
                n2 = StatisticColumns.groups.ordinal() - 1;
                object2 = objectArray[n2];
                objectArray[n2] = (Integer)objectArray[n2] + 1;
                continue;
            }
            if (!(object instanceof MIBAgentCaps)) continue;
            objectArray = stats;
            n2 = StatisticColumns.agentcaps.ordinal() - 1;
            object2 = objectArray[n2];
            objectArray[n2] = (Integer)objectArray[n2] + 1;
        }
        return stats;
    }

    public static enum StatisticColumns {
        module,
        total,
        names,
        identities,
        types,
        scalars,
        tables,
        columns,
        traps,
        conventions,
        groups,
        compliance,
        agentcaps,
        released,
        unreleased;

    }
}

