/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.commons.mib;

import java.awt.Color;
import java.awt.Component;

public class MIBColors {
    public static final String C_SMI_IMPORTS = "smi.imports";
    public static final String C_SMI_READONLY = "smi.readonly";
    public static final String C_SMI_READWRITE = "smi.readwrite";
    public static final String C_SMI_READCREATE = "smi.readcreate";
    public static final String C_SMI_NOTIFICAION = "smi.notification";
    public static final String C_SMI_DEPRECATED = "smi.deprecated";
    public static final String C_PIB_INSTALL = "pib.install";
    public static final String C_PIB_INSTALL_NOTIFY = "pib.install.notify";
    public static final String C_PIB_NOTIFY = "pib.notify";
    public static final String C_DIFF_INSERT = "diff.insert";
    public static final String C_DIFF_DELETE = "diff.delete";
    public static final String C_DIFF_CHANGE = "diff.change";
    public static final String C_DIFF_NEW = "diff.new";
    public static final String C_DIFF_TYPE_CHANGE = "diff.typeChange";
    public static final String C_SYNTAX_CLAUSE = "syntax.clause";
    public static final String C_SYNTAX_COMMENTS = "syntax.comments";
    public static final String C_SYNTAX_IDENTIFIER = "syntax.identifier";
    public static final String C_SYNTAX_KEYWORD = "syntax.keyword";
    public static final String C_SYNTAX_TEXT = "syntax.text";
    public static final String C_SYNTAX_TYPES = "syntax.types";
    public static final String C_SYNTAX_VALUES = "syntax.values";

    public static Color increaseContrast(Color c2, Color background) {
        if (background == null) {
            return c2;
        }
        if (c2 == null) {
            return null;
        }
        boolean i2 = false;
        double contrast = MIBColors.contrast(c2, background);
        if (contrast < 2.5) {
            boolean lighten = MIBColors.contrast(Color.black, background) < 2000.0;
            c2 = lighten ? c2.brighter() : c2.darker();
        }
        return c2;
    }

    private static double brightness(Color c2) {
        return (double)c2.getRed() * 0.2126 + (double)c2.getGreen() * 0.7152 + (double)c2.getBlue() * 0.0722;
    }

    private static double contrast(Color a2, Color b2) {
        double brightnessA = MIBColors.brightness(a2);
        double brightnessB = MIBColors.brightness(b2);
        double brightest = Math.max(brightnessA, brightnessB);
        double darkest = Math.min(brightnessA, brightnessB);
        return (brightest + 0.05) / (darkest + 0.05);
    }

    public static enum TreeColors {
        smiImports("smi.imports", new Color(100, 160, 160, 178)),
        smiReadOnly("smi.readonly", new Color(100, 200, 100, 200)),
        smiReadWrite("smi.readwrite", new Color(0xAA99EE)),
        smiReadCreate("smi.readcreate", new Color(255, 0, 0, 128)),
        smiNotification("smi.notification", new Color(245, 180, 0, 200)),
        smiDeprecated("smi.deprecated", Color.lightGray),
        pibInstall("pib.install", new Color(0xAA99EE)),
        pibInstallNotify("pib.install.notify", new Color(255, 200, 0, 220)),
        pibNotify("pib.notify", new Color(255, 0, 0, 128)),
        diffInsert("diff.insert", new Color(170, 200, 0, 128)),
        diffChange("diff.change", new Color(255, 221, 153, 128)),
        diffTypeChange("diff.typeChange", new Color(255, 0, 255, 128)),
        diffDelete("diff.delete", new Color(255, 153, 153, 128)),
        diffNew("diff.new", new Color(170, 238, 0, 128)),
        syntaxClause("syntax.clause", new Color(153, 51, 51, 128)),
        syntaxComments("syntax.comments", new Color(83, 163, 163, 128)),
        syntaxIdentifier("syntax.identifier", new Color(153, 68, 68, 187)),
        syntaxKeyword("syntax.keyword", LafColor.foreground),
        syntaxText("syntax.text", new Color(102, 102, 153, 128)),
        syntaxTypes("syntax.types", new Color(210, 147, 28, 128)),
        syntaxValues("syntax.values", new Color(0, 180, 153, 128));

        private final String key;
        private final Color color;
        private final LafColor lafColor;

        private TreeColors(String key, Color defaultColor) {
            this.key = key;
            this.color = defaultColor;
            this.lafColor = LafColor.none;
        }

        private TreeColors(String key, LafColor lafColor) {
            this.key = key;
            this.color = null;
            this.lafColor = lafColor;
        }

        public String getKey() {
            return this.key;
        }

        public Color getColor() {
            return this.color;
        }

        public LafColor getLafColor() {
            return this.lafColor;
        }

        public Color getColor(Component c2) {
            switch (this.lafColor) {
                case foreground: {
                    return c2.getForeground();
                }
                case background: {
                    return c2.getBackground();
                }
            }
            return this.getColor();
        }
    }

    public static enum LafColor {
        none,
        foreground,
        background;

    }
}

