/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.commons.log;

import com.agentpp.commons.log.CategoryTreeCellRenderer;
import com.agentpp.commons.log.LogAppender;
import com.agentpp.util.UserConfigFile;
import com.klg.jclass.field.DataProperties;
import com.klg.jclass.field.JCInvalidInfo;
import com.klg.jclass.field.JCSpinField;
import com.klg.jclass.field.validate.JCIntegerValidator;
import com.klg.jclass.util.value.MutableValueModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Enumeration;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.log.LogLevel;

public class LogPreferencesPanel
extends JPanel
implements TreeSelectionListener,
ItemListener {
    public static final String CFG_MAX_LOG_RECORDS = "com.agentpp.log.maxrecords";
    private final CategoryTreeCellRenderer categoryTreeCellRenderer = new CategoryTreeCellRenderer();
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel jPanelCenter = new JPanel();
    JPanel jPanelNorth = new JPanel();
    Border border1;
    TitledBorder titledBorder1;
    Border border2;
    Border border3;
    TitledBorder titledBorder2;
    Border border4;
    GridBagLayout gridBagLayout2 = new GridBagLayout();
    JLabel jLabelMaxRecords = new JLabel();
    DefaultTreeModel treeModel;
    DefaultMutableTreeNode root;
    private UserConfigFile config;
    private String[] categories;
    GridLayout gridLayout1 = new GridLayout();
    JCSpinField maxRecords = new JCSpinField();
    JSplitPane jSplitPane = new JSplitPane();
    JTree tree = new JTree();
    JScrollPane jScrollPane = new JScrollPane();
    JComboBox<Object> jComboBoxPriority = new JComboBox();
    JLabel jLabelPriority = new JLabel();
    JLabel jLabelChainedPriority = new JLabel();
    JTextField jTextFieldCategory = new JTextField();
    JLabel jLabelCategory = new JLabel();
    JTextField jTextFieldChainedPriority = new JTextField();
    JPanel jPanelSettings = new JPanel();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    private JPanel jPanel1 = new JPanel();
    private BorderLayout borderLayout2 = new BorderLayout();
    private Border border5;
    private TitledBorder titledBorder3;
    private LogAppender localAppender;
    private boolean enableExtendedLogging = true;

    public LogPreferencesPanel() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public LogPreferencesPanel(UserConfigFile config, String[] categories, LogAppender appender) {
        this(config, categories, appender, true);
    }

    public LogPreferencesPanel(UserConfigFile config, String[] categories, LogAppender appender, boolean extendedLogging) {
        this.config = config;
        this.categories = categories;
        this.localAppender = appender;
        this.enableExtendedLogging = extendedLogging;
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.jComboBoxPriority.addItem("none");
        this.jComboBoxPriority.addItem(LogLevel.OFF);
        this.jComboBoxPriority.addItem(LogLevel.ERROR);
        this.jComboBoxPriority.addItem(LogLevel.WARN);
        this.jComboBoxPriority.addItem(LogLevel.INFO);
        this.jComboBoxPriority.addItem(LogLevel.DEBUG);
        this.jComboBoxPriority.addItem(LogLevel.TRACE);
        this.load();
        this.tree.addTreeSelectionListener(this);
        this.categoryTreeCellRenderer.addNameFilter("org.snmp4j", "SNMP4J");
        this.tree.setCellRenderer(this.categoryTreeCellRenderer);
        this.tree.setShowsRootHandles(true);
        this.tree.setEditable(false);
        this.jComboBoxPriority.addItemListener(this);
    }

    @Override
    public void itemStateChanged(ItemEvent e2) {
        if (e2.getStateChange() == 1) {
            DefaultMutableTreeNode n2 = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
            if (n2 == null) {
                return;
            }
            LogAdapter c2 = (LogAdapter)n2.getUserObject();
            if (e2.getItem() instanceof String) {
                if (LogFactory.getLogFactory().getRootLogger().equals(c2)) {
                    LogFactory.getLogFactory().getRootLogger().setLogLevel(LogLevel.ERROR);
                } else {
                    c2.setLogLevel(null);
                }
            } else {
                c2.setLogLevel((LogLevel)e2.getItem());
            }
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent e2) {
        TreePath p2 = e2.getNewLeadSelectionPath();
        if (p2 == null) {
            this.jTextFieldCategory.setText(null);
            this.jComboBoxPriority.setEnabled(false);
            this.jComboBoxPriority.setSelectedIndex(0);
            return;
        }
        DefaultMutableTreeNode n2 = (DefaultMutableTreeNode)p2.getLastPathComponent();
        LogAdapter c2 = (LogAdapter)n2.getUserObject();
        this.jTextFieldCategory.setText(this.categoryTreeCellRenderer.displayName(c2));
        this.jTextFieldChainedPriority.setText(c2.getLogLevel().toString());
        if (c2.getLogLevel() != null) {
            this.jComboBoxPriority.setSelectedItem(c2.getLogLevel());
        } else {
            this.jComboBoxPriority.setSelectedItem("none");
        }
        this.jComboBoxPriority.setEnabled(true);
    }

    private void buildRoot() {
        if (this.root != null) {
            this.root.removeAllChildren();
        }
        this.root = new DefaultMutableTreeNode(LogFactory.getLogFactory().getRootLogger());
        this.treeModel = new DefaultTreeModel(this.root, false);
        this.tree.setModel(this.treeModel);
        this.tree.setFont(this.tree.getFont().deriveFont(1));
        this.tree.treeDidChange();
    }

    private String pathToString(List<String> path) {
        StringBuilder buf = new StringBuilder();
        for (String element : path) {
            buf.append(element);
            buf.append('.');
        }
        if (buf.length() > 0) {
            return buf.toString().substring(0, buf.length() - 1);
        }
        return "";
    }

    private void addPath(Vector<String> path, String category, DefaultMutableTreeNode parent) {
        boolean found = false;
        Enumeration<TreeNode> en = parent.children();
        block0: while (en.hasMoreElements()) {
            DefaultMutableTreeNode n2 = (DefaultMutableTreeNode)en.nextElement();
            for (int i2 = 1; i2 < path.size(); ++i2) {
                String parentPrefix = this.pathToString(path.subList(0, i2));
                if (!((LogAdapter)n2.getUserObject()).getName().endsWith(parentPrefix)) continue;
                found = true;
                int r2 = i2;
                while (r2-- > 0) {
                    path.remove(0);
                }
                if (path.size() <= 0) continue block0;
                this.addPath(path, category, n2);
                continue block0;
            }
        }
        if (!found) {
            DefaultMutableTreeNode child = new DefaultMutableTreeNode(LogFactory.getLogger(category));
            this.treeModel.insertNodeInto(child, parent, parent.getChildCount());
        }
    }

    public void load() {
        this.buildRoot();
        for (String s2 : this.categories) {
            StringTokenizer st = new StringTokenizer(s2, ".");
            Vector<String> path = new Vector<String>(st.countTokens() + 1);
            while (st.hasMoreTokens()) {
                path.add(st.nextToken());
            }
            this.addPath(path, s2, this.root);
        }
        if (this.config.get("log4j.rootCategory", null) == null && this.config.get("log4j.rootLogger", null) == null && this.config.get(LogFactory.getLogFactory().getLoggerConfigPrefix(), null) == null) {
            LogFactory.getLogFactory().getRootLogger().setLogLevel(LogLevel.OFF);
        }
        this.maxRecords.setValue(Integer.valueOf(this.config.get(CFG_MAX_LOG_RECORDS, "100")));
    }

    public int getMaxLogRecords() {
        return ((Number)this.maxRecords.getValue()).intValue();
    }

    public void reloadConfiguration() {
        LogFactory.getLogFactory().updateConfiguration(this.config.properties);
        Logger.getLogger("").addHandler(this.localAppender);
    }

    public void cancel() {
        this.reloadConfiguration();
    }

    public void save() {
        String oldRoot = this.config.get("log4j.rootLogger", null);
        if (oldRoot == null) {
            oldRoot = this.config.get("log.rootLogger", "");
        }
        oldRoot = oldRoot.indexOf(44) >= 0 ? oldRoot.substring(oldRoot.indexOf(44)) : "";
        this.config.put("log.rootLogger", LogFactory.getLogFactory().getRootLogger().getLogLevel().toString() + oldRoot);
        this.config.remove("log4j.rootLogger");
        Enumeration<TreeNode> en = this.root.depthFirstEnumeration();
        while (en.hasMoreElements()) {
            DefaultMutableTreeNode n2 = (DefaultMutableTreeNode)en.nextElement();
            LogAdapter c2 = (LogAdapter)n2.getUserObject();
            if (c2.getLogLevel() == null) {
                this.config.put(LogFactory.getLogFactory().getLoggerConfigPrefix() + "level." + c2.getName(), null);
                continue;
            }
            String old = this.config.get(LogFactory.getLogFactory().getLoggerConfigPrefix() + c2.getName(), "");
            old = old.indexOf(44) >= 0 ? old.substring(old.indexOf(44)) : "";
            this.config.put(LogFactory.getLogFactory().getLoggerConfigPrefix() + "level." + c2.getName(), c2.getLogLevel().toString());
        }
        this.config.put(CFG_MAX_LOG_RECORDS, "" + this.maxRecords.getValue());
        this.reloadConfiguration();
    }

    void jbInit() throws Exception {
        this.border1 = new EtchedBorder(0, Color.white, new Color(148, 145, 140));
        this.titledBorder1 = new TitledBorder(this.border1, "Categories");
        this.border2 = BorderFactory.createCompoundBorder(this.titledBorder1, BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.border3 = new EtchedBorder(0, Color.white, new Color(148, 145, 140));
        this.titledBorder2 = new TitledBorder(this.border3, "Output Properties");
        this.border4 = BorderFactory.createCompoundBorder(this.titledBorder2, BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.border5 = new EtchedBorder(0, Color.white, new Color(148, 145, 140));
        this.titledBorder3 = new TitledBorder(new EtchedBorder(0, Color.white, new Color(148, 145, 140)), "External Logging");
        this.setLayout(this.borderLayout1);
        this.jPanelCenter.setLayout(this.gridLayout1);
        this.jPanelCenter.setBorder(this.border2);
        this.jPanelNorth.setBorder(this.border4);
        this.jPanelNorth.setLayout(this.gridBagLayout2);
        this.jLabelMaxRecords.setText("Maximum number of log records:");
        this.gridLayout1.setColumns(2);
        this.gridLayout1.setHgap(5);
        this.maxRecords.setDataProperties(new DataProperties(new JCIntegerValidator(null, new Integer(0), new Integer(Integer.MAX_VALUE), null, false, null, new Integer(10), "#,##0.###;-#,##0.###", false, false, false, null, new Integer(100)), new MutableValueModel(Integer.class, new Integer("100")), new JCInvalidInfo(true, 1, new Color(0, 0, 0, 255), new Color(255, 255, 255, 255))));
        this.jLabelPriority.setText("Assigned Priority:");
        this.jLabelChainedPriority.setText("Inherited Priority:");
        this.jTextFieldCategory.setEnabled(false);
        this.jTextFieldCategory.setEditable(false);
        this.jTextFieldCategory.setColumns(20);
        this.jLabelCategory.setText("Category:");
        this.jTextFieldChainedPriority.setEnabled(false);
        this.jTextFieldChainedPriority.setToolTipText("Shows the priority inherited from parent nodes on the path to the root category");
        this.jPanelSettings.setLayout(this.gridBagLayout1);
        this.jPanel1.setLayout(this.borderLayout2);
        this.jPanel1.setBorder(this.titledBorder3);
        this.add((Component)this.jPanelCenter, "Center");
        this.jPanelCenter.add((Component)this.jSplitPane, null);
        this.jSplitPane.add((Component)this.jScrollPane, "left");
        this.jSplitPane.add((Component)this.jPanelSettings, "right");
        this.jPanelSettings.add((Component)this.jLabelCategory, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.jPanelSettings.add((Component)this.jTextFieldCategory, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 11, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.jPanelSettings.add((Component)this.jLabelPriority, new GridBagConstraints(0, 2, 1, 1, 0.0, 1.0, 18, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.jPanelSettings.add(this.jComboBoxPriority, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 11, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.jPanelSettings.add((Component)this.jLabelChainedPriority, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.jPanelSettings.add((Component)this.jTextFieldChainedPriority, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.jScrollPane.getViewport().add((Component)this.tree, null);
        this.add((Component)this.jPanelNorth, "North");
        this.jPanelNorth.add((Component)this.jLabelMaxRecords, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 10, 0), 0, 0));
        this.jPanelNorth.add((Component)this.maxRecords, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.jSplitPane.setDividerLocation(150);
    }

    public void setLocalAppender(LogAppender localAppender) {
        this.localAppender = localAppender;
    }

    public LogAppender getLocalAppender() {
        return this.localAppender;
    }

    public String[] getCategories() {
        return this.categories;
    }

    public Integer getCategoryOfAppender(String appender) {
        String c2 = this.config.get("log4j.rootLogger", null);
        for (int i2 = -1; i2 < this.categories.length; ++i2) {
            if (i2 >= 0) {
                c2 = this.config.get("log4j.logger." + this.categories[i2], null);
            }
            if (c2 == null) continue;
            StringTokenizer st = new StringTokenizer(c2, ",", false);
            while (st.hasMoreTokens()) {
                if (!st.nextToken().trim().equals(appender)) continue;
                return i2;
            }
        }
        return null;
    }

    public boolean isEnableExtendedLogging() {
        return this.enableExtendedLogging;
    }
}

