/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.commons.log;

import com.agentpp.common.StandardDialog;
import com.agentpp.common.StatusBar;
import com.agentpp.commons.log.LogPreferencesPanel;
import com.agentpp.commons.log.LoggingListener;
import com.agentpp.commons.ui.InstantSearchListener;
import com.agentpp.commons.ui.InstantSearchPanel;
import com.agentpp.util.Regex;
import com.agentpp.util.gui.VerticalFlowLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.logging.LogRecord;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import org.snmp4j.log.JavaLogAdapter;

public class LogPanel
extends JPanel
implements LoggingListener,
InstantSearchListener {
    public static final String CFG_EXPORT_PATH = "com.agentpp.log.exportPath";
    public static final String FILTER_SNMP4J_PREFIX = "org.snmp4j.";
    public static ImageIcon imageProperties16 = new ImageIcon(Thread.currentThread().getContextClassLoader().getResource("toolbarButtonGraphics/general/Properties16.gif"));
    public static ImageIcon imageSaveAs16 = new ImageIcon(Thread.currentThread().getContextClassLoader().getResource("toolbarButtonGraphics/general/SaveAs16.gif"));
    public static ImageIcon imageDelete16 = new ImageIcon(Thread.currentThread().getContextClassLoader().getResource("toolbarButtonGraphics/general/Delete16.gif"));
    public static ImageIcon imageRemove16 = new ImageIcon(Thread.currentThread().getContextClassLoader().getResource("toolbarButtonGraphics/general/Remove16.gif"));
    public static ImageIcon imageStop16 = new ImageIcon(Thread.currentThread().getContextClassLoader().getResource("toolbarButtonGraphics/general/Stop16.gif"));
    public static final char NEW_LINE_DELIM = '\n';
    public static final char TAB_DELIM = '\t';
    public static final String EMPTY_STRING = "";
    public static final String NEWLINE = "\n";
    public static final String NULL = "null";
    public static final String TAB = "\t";
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel jPanelButtons = new JPanel();
    VerticalFlowLayout verticalFlowLayout1 = new VerticalFlowLayout();
    JButton jButtonPreferences = new JButton();
    JButton jButtonClear = new JButton();
    JButton jButtonSaveAs = new JButton();
    JToggleButton jButtonStop = new JToggleButton();
    JPanel jPanelLogging = new JPanel();
    JTextArea logArea = new JTextArea();
    JScrollPane logScrollPane = new JScrollPane();
    BorderLayout borderLayout2 = new BorderLayout();
    private LogPreferencesPanel prefPanel;
    private JFrame myFrame;
    JButton jButtonDelete = new JButton();
    private int maxrecords = 100;
    private StatusBar statusBar;
    private Properties config;
    private final LinkedList<LogRecord> suspended = new LinkedList();
    private final LinkedList<LogRecord> queued = new LinkedList();
    private final Deque<Integer> loggedLines = new ArrayDeque<Integer>(this.maxrecords);
    private boolean suspend;
    private boolean isRepaintEnabled;
    private InstantSearchPanel instantSearchPanel;
    private Regex lastSearchExpression;
    private static final String SPACES_80 = "\t\t\t\t\t\t\t\t\t\t";
    private int maxLogLinePrefix = -1;

    public LogPanel(JFrame f2, StatusBar statusBar, Properties config) {
        this.statusBar = statusBar;
        this.config = config;
        this.myFrame = f2;
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public JTextArea getLogArea() {
        return this.logArea;
    }

    public void setPreferencesPanel(LogPreferencesPanel prefPanel) {
        this.prefPanel = prefPanel;
        this.maxrecords = prefPanel.getMaxLogRecords();
        prefPanel.reloadConfiguration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void log(LogRecord e2) {
        if (this.maxrecords == 0) {
            return;
        }
        if (!this.passesLogFilter(e2)) {
            return;
        }
        if (this.suspend) {
            this.suspended.addLast(e2);
            if (this.suspended.size() > this.maxrecords) {
                this.suspended.removeFirst();
            }
        } else {
            LinkedList<LogRecord> linkedList = this.queued;
            synchronized (linkedList) {
                this.queued.addLast(e2);
                this.processLogQueue();
            }
        }
    }

    private void processLogQueue() {
        if (this.queued.size() > 0 && this.isRepaintEnabled() && this.isVisible()) {
            SwingUtilities.invokeLater(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    LinkedList linkedList = LogPanel.this.queued;
                    synchronized (linkedList) {
                        while (LogPanel.this.queued.size() > 0) {
                            ArrayList chunk = new ArrayList(LogPanel.this.queued);
                            LogPanel.this.queued.clear();
                            LogPanel.this.addQueued(chunk);
                        }
                    }
                }
            });
        }
    }

    private void addQueued(List<LogRecord> chunk) {
        final StringBuilder logDelta = new StringBuilder();
        for (LogRecord logRecord : chunk) {
            String line = this.createLogLine(logRecord);
            this.loggedLines.add(line.length());
            logDelta.append(line);
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.logArea.append(logDelta.toString());
            this.applyLogAreaLimits();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    LogPanel.this.logArea.append(logDelta.toString());
                    LogPanel.this.applyLogAreaLimits();
                }
            });
        }
    }

    private boolean passesLogFilter(LogRecord logRecord) {
        String loggerName = logRecord.getLoggerName();
        return !loggerName.startsWith("java.awt.") && !loggerName.startsWith("sun") && !loggerName.startsWith("javax.swing");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyLogAreaLimits() {
        Deque<Integer> deque = this.loggedLines;
        synchronized (deque) {
            int end = 0;
            while (this.loggedLines.size() > this.maxrecords) {
                end += this.loggedLines.remove().intValue();
            }
            this.logArea.replaceRange(EMPTY_STRING, 0, end);
        }
    }

    private String createLogLine(LogRecord row) {
        Object line = row.getInstant().toString() + "  " + JavaLogAdapter.fromJavaToSnmp4jLevel(row.getLevel()) + TAB + this.filterLoggerName(row.getLoggerName());
        if (((String)(line = ((String)line).trim())).length() > this.maxLogLinePrefix) {
            this.maxLogLinePrefix = ((String)line).length() + this.logArea.getTabSize() - ((String)line).length() % this.logArea.getTabSize();
        }
        line = (String)line + this.spaces(this.maxLogLinePrefix - ((String)line).length() + 1) + row.getMessage().trim() + NEWLINE;
        return line;
    }

    private String spaces(int n2) {
        return SPACES_80.substring(0, Math.min(SPACES_80.length(), Math.max(1, n2) / this.logArea.getTabSize() + ((n2 - 1) % this.logArea.getTabSize() == 0 ? 1 : 1)));
    }

    private String filterLoggerName(String loggerName) {
        if (loggerName.startsWith(FILTER_SNMP4J_PREFIX)) {
            return "SNMP4J." + loggerName.substring(FILTER_SNMP4J_PREFIX.length());
        }
        return loggerName;
    }

    void jbInit() throws Exception {
        this.instantSearchPanel = new InstantSearchPanel(this, 10);
        this.logArea.setEditable(false);
        this.logArea.setLineWrap(false);
        this.logArea.setFont(new Font("Monospaced", 0, 12));
        this.setLayout(this.borderLayout1);
        this.jPanelButtons.setLayout(this.verticalFlowLayout1);
        this.jButtonPreferences.setIcon(imageProperties16);
        this.jButtonPreferences.setToolTipText("Configure logging priorities and other properties");
        this.jButtonPreferences.setHorizontalAlignment(2);
        this.jButtonPreferences.setText("Properties");
        this.jButtonPreferences.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                LogPanel.this.jButtonPreferences_actionPerformed(e2);
            }
        });
        this.jButtonClear.setIcon(imageDelete16);
        this.jButtonClear.setToolTipText("Clear log");
        this.jButtonClear.setHorizontalAlignment(2);
        this.jButtonClear.setText("Clear");
        this.jButtonClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                LogPanel.this.jButtonClear_actionPerformed(e2);
            }
        });
        this.jButtonStop.setIcon(imageStop16);
        this.jButtonStop.setToolTipText("Suspend logging");
        this.jButtonStop.setHorizontalAlignment(2);
        this.jButtonStop.setText("Suspend");
        this.jButtonStop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                LogPanel.this.jButtonStop_actionPerformed(e2);
            }
        });
        this.jButtonSaveAs.setIcon(imageSaveAs16);
        this.jButtonSaveAs.setToolTipText("Save logging output as text file");
        this.jButtonSaveAs.setHorizontalAlignment(2);
        this.jButtonSaveAs.setText("Save as...");
        this.jButtonSaveAs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                LogPanel.this.jButtonSaveAs_actionPerformed(e2);
            }
        });
        this.jPanelLogging.setLayout(this.borderLayout2);
        this.add((Component)this.jPanelButtons, "West");
        this.jPanelButtons.add((Component)this.jButtonPreferences, null);
        this.jPanelButtons.add((Component)this.jButtonClear, null);
        this.jPanelButtons.add((Component)this.jButtonSaveAs, null);
        this.jPanelButtons.add(new JSeparator());
        this.jPanelButtons.add((Component)this.jButtonStop, null);
        this.logScrollPane.getViewport().add(this.logArea);
        this.logScrollPane.setVerticalScrollBarPolicy(22);
        this.jPanelLogging.add((Component)this.instantSearchPanel.getPanel(), "South");
        this.jPanelLogging.add((Component)this.logScrollPane, "Center");
        this.jPanelLogging.setBorder(BorderFactory.createEtchedBorder(1));
        this.add((Component)this.jPanelLogging, "Center");
    }

    void jButtonPreferences_actionPerformed(ActionEvent e2) {
        StandardDialog sd = new StandardDialog(this.myFrame, "Logging Properties", true, true){

            @Override
            public boolean cancel() {
                LogPanel.this.prefPanel.cancel();
                return true;
            }

            @Override
            public boolean ok() {
                LogPanel.this.prefPanel.save();
                return true;
            }
        };
        sd.setCenterPanel(this.prefPanel);
        sd.setLocationRelativeTo(this.myFrame);
        sd.setVisible(true);
        this.maxrecords = this.prefPanel.getMaxLogRecords();
    }

    void jButtonClear_actionPerformed(ActionEvent e2) {
        this.logArea.setText(EMPTY_STRING);
        this.loggedLines.clear();
    }

    void jButtonStop_actionPerformed(ActionEvent event) {
        boolean old = this.suspend;
        this.suspend = this.jButtonStop.isSelected();
        if (old && !this.suspend) {
            for (LogRecord e2 : this.suspended) {
                this.log(e2);
            }
            this.suspended.clear();
        }
    }

    void jButtonSaveAs_actionPerformed(ActionEvent e2) {
        JFileChooser fc = new JFileChooser();
        fc.setSelectedFile(new File(this.config.getProperty(CFG_EXPORT_PATH, EMPTY_STRING)));
        fc.setFileSelectionMode(0);
        if (fc.showSaveDialog(this) == 0) {
            Object[] options;
            int n2;
            this.config.put(CFG_EXPORT_PATH, fc.getSelectedFile().getPath());
            if (fc.getSelectedFile().exists() && (n2 = JOptionPane.showOptionDialog(this, "File already exists. Overwrite it?", "Confirm Overwrite", 0, 3, null, options = new Object[]{"Yes", "No"}, options[1])) == 1) {
                return;
            }
            try {
                this.saveToFile(fc.getSelectedFile());
                this.statusBar.setMessage("Log records written to " + fc.getSelectedFile().getPath());
            }
            catch (IOException iox) {
                this.statusBar.setMessage("Cannot write file " + fc.getSelectedFile() + ": " + iox.getMessage());
            }
        }
    }

    public synchronized void saveToFile(File f2) throws IOException {
        BufferedWriter os = new BufferedWriter(new FileWriter(f2));
        this.logArea.write(os);
        os.flush();
        os.close();
    }

    public boolean isRepaintEnabled() {
        return this.isRepaintEnabled;
    }

    public void setRepaintEnabled(boolean repaintEnabled) {
        this.isRepaintEnabled = repaintEnabled;
        this.processLogQueue();
    }

    @Override
    public boolean search(String text, InstantSearchListener.Direction direction, boolean caseSensitive) {
        this.logArea.setSelectionStart(0);
        this.logArea.setSelectionEnd(0);
        return this.searchAgain(text, direction, caseSensitive);
    }

    @Override
    public boolean searchAgain(String text, InstantSearchListener.Direction direction, boolean caseSensitive) {
        if (text == null || text.trim().length() == 0) {
            return false;
        }
        this.lastSearchExpression = new Regex();
        Object s2 = text;
        if (!caseSensitive) {
            s2 = "(?i)" + (String)s2;
        }
        try {
            this.lastSearchExpression.compile((String)s2);
            return LogPanel.selectNextMatch(this.lastSearchExpression, this.logArea, direction);
        }
        catch (ParseException pex) {
            return false;
        }
    }

    public static boolean selectNextMatch(Regex regex, final JTextArea textComponent, final InstantSearchListener.Direction direction) {
        try {
            if (regex == null || textComponent == null || textComponent.getDocument().getLength() <= 0) {
                return false;
            }
            try {
                List<int[]> matches;
                final int offset = InstantSearchListener.Direction.up == direction || textComponent.getSelectionEnd() < 0 ? 0 : textComponent.getSelectionEnd();
                int endPos = textComponent.getDocument().getLength();
                if (InstantSearchListener.Direction.up == direction && textComponent.getSelectionStart() >= 0) {
                    endPos = textComponent.getSelectionStart() + 1;
                }
                if ((matches = regex.allMatchPositions(textComponent.getDocument().getText(offset, endPos - offset), direction == InstantSearchListener.Direction.down ? 1 : 0)).isEmpty()) {
                    return false;
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        textComponent.getCaret().setSelectionVisible(true);
                        if (InstantSearchListener.Direction.down == direction) {
                            textComponent.setCaretPosition(((int[])matches.get(0))[0] + offset);
                            textComponent.moveCaretPosition(((int[])matches.get(0))[1] + offset);
                        } else {
                            textComponent.setCaretPosition(((int[])matches.get(matches.size() - 1))[0] + offset);
                            textComponent.moveCaretPosition(((int[])matches.get(matches.size() - 1))[1] + offset);
                        }
                    }
                });
                return true;
            }
            catch (BadLocationException e2) {
                e2.printStackTrace();
            }
        }
        catch (NullPointerException npx) {
            npx.printStackTrace();
        }
        return false;
    }
}

