/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.commons.log;

import com.agentpp.common.PropertiesEditor;
import com.agentpp.common.table.ExtendedListTable;
import com.agentpp.common.table.TableUtils;
import com.agentpp.commons.log.LogPreferencesPanel;
import com.agentpp.util.UserConfigFile;
import com.klg.jclass.cell.editors.JCComboBoxCellEditor;
import com.klg.jclass.table.JCCellDisplayEvent;
import com.klg.jclass.table.JCCellDisplayListener;
import com.klg.jclass.table.JCCellStyle;
import com.klg.jclass.table.TablePopupMenu;
import com.klg.jclass.table.data.JCEditableVectorDataSource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.SimpleFormatter;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;

public class AppenderConfigPanel
extends JPanel
implements ActionListener,
JCCellDisplayListener {
    private static final String[] COLUMNS = new String[]{"Handler", "Type", "Category", ""};
    private static final int[] COLUMN_WIDTHS = new int[]{15, 8, 10, 0};
    private static final int COL_APPENDER = 0;
    private static final int COL_TYPE = 1;
    private static final int COL_CATEGORY = 2;
    private static final int COL_EDITOR = 3;
    private static final String TYPE_FILE = "java.util.logging.FileHandler";
    private static final String[] TYPES = new String[]{"File"};
    private static final String[] TYPE_CLASSES = new String[]{"java.util.logging.FileHandler"};
    private static final String POPUP_ADD_FILE = "Add File Handler...";
    private static final String POPUP_EDIT = "Edit...";
    private static final String POPUP_REMOVE = "Remove";
    private static final String PREFIX = "snmp4j.log.handler.";
    private static final String CFG_APPENDERS = "agentpp.appenders";
    private static final String[][] ROLLING_FILE_PROPS = new String[][]{{"pattern", "1", "limit", "level", "format", "formatter"}, {"File", "Backup File Count", "File Size Limit", "Threshold", "Format", null}, {"File name pattern (including path) of the log file", "The number of previously rolled files to preserve. If set to zero, no roll over will occur (file is truncated when max file size is reached)", "Maximum file size in bytes.", "Events below the threshold value will be ignored (not appended). Possible values are 'ALL', 'DEBUG', 'INFO', 'WARN', 'ERROR', 'FATAL', 'OFF'.", "The formatter class file", null}, {"%h/java%u.log", "1", "limit", "ALL", "%d{dd MMM yyyy HH:mm:ss,SSS} [%p] [%c] %m%n", SimpleFormatter.class.getName()}};
    private static final String[][][] PROPS = new String[][][]{ROLLING_FILE_PROPS};
    private BorderLayout borderLayout1 = new BorderLayout();
    private JPanel jPanelButtons = new JPanel();
    private ExtendedListTable table = new ExtendedListTable(){

        @Override
        public boolean isPopupAllowed(int x, int y) {
            TablePopupMenu menu = super.getPopupMenu();
            int row = TableUtils.getFirstSelectedRow(AppenderConfigPanel.this.table);
            if (row >= 0) {
                menu.getComponent(2).setEnabled(true);
                menu.getComponent(3).setEnabled(true);
            } else {
                menu.getComponent(2).setEnabled(false);
                menu.getComponent(3).setEnabled(false);
            }
            return true;
        }
    };
    private JCEditableVectorDataSource model = new JCEditableVectorDataSource();
    private UserConfigFile config;
    private Vector appenders;
    private LogPreferencesPanel logPreferences;
    private Vector victims = new Vector(2);

    public AppenderConfigPanel(LogPreferencesPanel pref) {
        this.logPreferences = pref;
        this.model.setNumColumns(COLUMNS.length);
        this.model.setColumnLabels(COLUMNS);
        this.model.setNumRows(5);
        this.table.setDataSource(this.model);
        this.table.setColumnHidden(3, true);
        this.table.setRowHidden(0, true);
        this.table.setRowLabelDisplay(false);
        this.table.setPopupMenuEnabled(true);
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        TablePopupMenu popup = this.table.getPopupMenu();
        popup.addItem(POPUP_ADD_FILE, this);
        popup.add(new JSeparator());
        popup.addItem(POPUP_EDIT, this);
        popup.addItem(POPUP_REMOVE, this);
        this.setStyle();
        this.table.addCellDisplayListener(this);
    }

    @Override
    public void cellDisplay(JCCellDisplayEvent e2) {
        if (e2.getRow() == -1 || e2.getDisplayData() == null) {
            return;
        }
        switch (e2.getColumn()) {
            case 2: {
                int c2 = ((Number)e2.getCellData()).intValue();
                if (c2 < 0) {
                    e2.setDisplayData("root");
                    break;
                }
                e2.setDisplayData(this.logPreferences.getCategories()[c2]);
                break;
            }
        }
    }

    private void setStyle() {
        int i2;
        JCCellStyle readonly = new JCCellStyle(this.table.getDefaultCellStyle());
        readonly.setEditable(false);
        JCCellStyle enumStyle = new JCCellStyle(this.table.getDefaultCellStyle());
        enumStyle.setEditable(true);
        String[] c2 = this.logPreferences.getCategories();
        Object[] cats = new String[c2.length + 1];
        int[] cn = new int[cats.length];
        cats[0] = "root";
        cn[0] = -1;
        for (i2 = 0; i2 < c2.length; ++i2) {
            cats[i2 + 1] = c2[i2];
            cn[i2 + 1] = i2;
        }
        enumStyle.setCellEditor(new JCComboBoxCellEditor(cats, cn));
        for (i2 = 0; i2 < COLUMNS.length; ++i2) {
            this.table.setCharWidth(i2, COLUMN_WIDTHS[i2]);
            if (i2 == 2 || i2 == 2) continue;
            this.table.setCellStyle(-997, i2, readonly);
        }
        this.table.setCellStyle(-997, 2, enumStyle);
    }

    void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.table.setToolTipText("To add, edit, and remove a log handler press right mouse button");
        this.add((Component)this.jPanelButtons, "South");
        this.add((Component)this.table, "Center");
    }

    private String[] createKeys(String name, int type) {
        String[] k2 = new String[PROPS[type][0].length];
        for (int i2 = 0; i2 < k2.length; ++i2) {
            k2[i2] = PREFIX + name + "." + PROPS[type][0][i2];
        }
        return k2;
    }

    private void initPropsEditor(PropertiesEditor pe, String name, int type) {
        pe.setKeys(this.createKeys(name, type));
        pe.setTitles(PROPS[type][1]);
        pe.setToolTips(PROPS[type][2]);
        pe.setDefaultValues(PROPS[type][3]);
        pe.setProperties(this.config.properties);
        pe.addHiddenProperty(PREFIX + name, TYPE_CLASSES[type]);
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        int row = TableUtils.getFirstSelectedRow(this.table);
        int type = 0;
        if (e2.getActionCommand().equals(POPUP_ADD_FILE)) {
            String name;
            do {
                if ((name = JOptionPane.showInputDialog(this, "Name: ", "Handler Name", 3)) == null) {
                    return;
                }
                if (!this.appenders.contains(name)) continue;
                JOptionPane.showMessageDialog(this, "Handler name '" + name + "' already used!", "Invalid Name", 0);
                name = null;
            } while (name == null);
            if (this.victims.contains(name)) {
                this.victims.remove(name);
            }
            PropertiesEditor pe = new PropertiesEditor();
            this.initPropsEditor(pe, name, type);
            if (JOptionPane.showConfirmDialog(this, pe, "Handler Properties - " + name, 2, -1, null) == 0) {
                Vector<Object> r2 = new Vector<Object>(COLUMNS.length);
                r2.add(name);
                r2.add(TYPES[type]);
                r2.add(-1);
                r2.add(pe);
                this.model.addRow(Integer.MAX_VALUE, name, r2);
            }
        } else if (row >= 0 && e2.getActionCommand().equals(POPUP_EDIT)) {
            PropertiesEditor pe;
            Properties p2 = new Properties();
            String name = (String)this.model.getTableDataItem(row, 0);
            if (this.model.getTableDataItem(row, 3) == null) {
                pe = new PropertiesEditor();
                for (int i2 = 0; i2 < TYPES.length; ++i2) {
                    if (!this.model.getTableDataItem(row, 1).equals(TYPES[i2])) continue;
                    this.initPropsEditor(pe, name, i2);
                }
                this.model.setTableDataItem(pe, row, 3);
            } else {
                pe = (PropertiesEditor)this.model.getTableDataItem(row, 3);
            }
            pe.getProperties(p2);
            if (JOptionPane.showConfirmDialog(this, pe, "Handler Properties - " + name, 2, -1, null) == 2) {
                pe.setProperties(p2);
            }
        } else if (row >= 0 && e2.getActionCommand().equals(POPUP_REMOVE)) {
            int[] rows = TableUtils.getSelectedRows(this.table);
            for (int i3 = 0; i3 < rows.length; ++i3) {
                this.victims.add(this.model.getTableDataItem(rows[i3], 0));
            }
            TableUtils.removeSelectedRows(this.table, this.model);
        }
    }

    public void setConfig(UserConfigFile config) {
        this.config = config;
    }

    public void load() {
        this.victims.removeAllElements();
        this.model.setNumRows(1);
        this.appenders = this.config.getArray(CFG_APPENDERS);
        Enumeration en = this.appenders.elements();
        while (en.hasMoreElements()) {
            String app = (String)en.nextElement();
            Vector<Object> row = new Vector<Object>(COLUMNS.length);
            row.add(app);
            String type = this.config.get(PREFIX + app, null);
            if (type == null) continue;
            for (int i2 = 0; i2 < TYPE_CLASSES.length; ++i2) {
                if (!type.equals(TYPE_CLASSES[i2])) continue;
                row.add(TYPES[i2]);
                break;
            }
            row.add(this.logPreferences.getCategoryOfAppender(app));
            this.model.addRow(Integer.MAX_VALUE, app, row);
        }
    }

    private void removeAppender(String victim) {
        for (int i2 = 0; i2 < PROPS.length; ++i2) {
            String[] k2 = this.createKeys(victim, i2);
            for (int j2 = 0; j2 < k2.length; ++j2) {
                this.config.remove(k2[j2]);
            }
        }
        this.config.remove(PREFIX + victim);
    }

    public String updateAppenderConfig(String category, String appenders) {
        String cat = null;
        Vector<Object> configuredAppenders = new Vector<Object>();
        for (int i2 = 1; i2 < this.model.getNumRows(); ++i2) {
            int c2 = ((Number)this.model.getTableDataItem(i2, 2)).intValue();
            if (c2 < 0) {
                cat = "";
            } else {
                try {
                    cat = this.logPreferences.getCategories()[c2];
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (cat == null || !cat.equals(category)) continue;
            configuredAppenders.add(this.model.getTableDataItem(i2, 0));
        }
        StringTokenizer st = new StringTokenizer(appenders, ",", false);
        StringBuffer buf = new StringBuffer();
        Enumeration en = configuredAppenders.elements();
        while (en.hasMoreElements()) {
            buf.append(',');
            buf.append((String)en.nextElement());
        }
        while (st.hasMoreTokens()) {
            String a2 = st.nextToken();
            String appender = a2.trim();
            if (this.appenders.contains(appender) || this.victims.contains(appender)) continue;
            buf.append(',');
            buf.append(appender);
        }
        return buf.toString();
    }

    public void save() {
        this.table.commitEdit(true);
        Enumeration en = this.appenders.elements();
        while (en.hasMoreElements()) {
            String app = (String)en.nextElement();
            boolean found = false;
            for (int i2 = 1; i2 < this.model.getNumRows(); ++i2) {
                if (!this.model.getTableRowLabel(i2).equals(app)) continue;
                found = true;
                break;
            }
            if (found) continue;
            this.removeAppender(app);
        }
        Vector<Object> v = new Vector<Object>(this.model.getNumRows());
        for (int i3 = 1; i3 < this.model.getNumRows(); ++i3) {
            v.add(this.model.getTableDataItem(i3, 0));
            PropertiesEditor pe = (PropertiesEditor)this.model.getTableDataItem(i3, 3);
            if (pe == null) continue;
            pe.getProperties(this.config.properties);
        }
        this.config.putArray(CFG_APPENDERS, v);
        this.victims.removeAllElements();
    }

    public void setAppenders(Vector appenders) {
        this.appenders = appenders;
    }

    public Vector getAppenders() {
        return this.appenders;
    }

    public void setLogPreferences(LogPreferencesPanel logPreferences) {
        this.logPreferences = logPreferences;
    }

    public LogPreferencesPanel getLogPreferences() {
        return this.logPreferences;
    }
}

