/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.common.xls;

import com.klg.jclass.table.CellStyleModel;
import com.klg.jclass.table.JCTable;
import com.klg.jclass.table.TableDataModel;
import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;

public class Table2XLS {
    private String sheedTitle = "untitled";
    private JCTable table;
    private HSSFWorkbook wb;
    private TableDataModel model;

    private static IndexedColors getFontColor(Color c2) {
        if (c2.equals(Color.blue)) {
            return IndexedColors.BLUE;
        }
        if (c2.equals(Color.black)) {
            return IndexedColors.BLACK;
        }
        if (c2.equals(Color.white)) {
            return IndexedColors.WHITE;
        }
        return IndexedColors.AUTOMATIC;
    }

    private HSSFCellStyle createStyle(CellStyleModel style) {
        HSSFCellStyle cs = this.wb.createCellStyle();
        HSSFFont font = this.wb.createFont();
        if (style.getBackground().equals(Color.white)) {
            font.setColor(IndexedColors.BLACK.getIndex());
        } else {
            font.setColor(Table2XLS.getFontColor(style.getBackground()).getIndex());
        }
        font.setFontHeightInPoints((short)10);
        cs.setAlignment(HorizontalAlignment.RIGHT);
        cs.setFont(font);
        return cs;
    }

    public void appendXLSFile(File f2) throws IOException {
        FileInputStream fis = new FileInputStream(f2);
        try {
            POIFSFileSystem fs = new POIFSFileSystem(fis);
            this.wb = new HSSFWorkbook(fs);
            fis.close();
        }
        catch (IOException iox) {
            fis.close();
            throw new IOException(iox.getMessage());
        }
        FileOutputStream fos = new FileOutputStream(f2);
        try {
            HSSFSheet ws = this.createSheed();
            this.wb.write(fos);
            fos.close();
        }
        catch (IOException iox) {
            fos.close();
            throw new IOException(iox.getMessage());
        }
    }

    private HSSFSheet createSheed() {
        int i2;
        int rowNum = 0;
        HSSFSheet ws = this.wb.createSheet(this.sheedTitle);
        HSSFFont headerFont = this.wb.createFont();
        headerFont.setColor(IndexedColors.AUTOMATIC.getIndex());
        headerFont.setFontHeightInPoints((short)10);
        headerFont.setBold(true);
        HSSFCellStyle headerStyle = this.wb.createCellStyle();
        headerStyle.setFont(headerFont);
        headerStyle.setLocked(true);
        Hashtable<CellStyleModel, HSSFCellStyle> styles = new Hashtable<CellStyleModel, HSSFCellStyle>();
        if (this.table != null) {
            for (CellStyleModel m3 : this.table.getCellStyles()) {
                styles.put(m3, this.createStyle(m3));
            }
        }
        if (this.model == null) {
            this.model = this.table.getDataView();
        }
        int n2 = rowNum;
        rowNum = (short)(rowNum + 1);
        HSSFRow row = ws.createRow(n2);
        for (i2 = 0; i2 < this.model.getNumColumns(); ++i2) {
            HSSFCell c2 = row.createCell((short)i2);
            c2.setCellStyle(headerStyle);
            c2.setCellValue(this.model.getTableColumnLabel(i2).toString());
        }
        if (this.table != null) {
            for (i2 = 0; i2 < this.model.getNumColumns(); ++i2) {
                ws.setColumnWidth((short)i2, (short)(this.table.getCharWidth(i2) * 256));
            }
        }
        ws.setFitToPage(true);
        for (i2 = 0; i2 < this.model.getNumRows(); ++i2) {
            if (this.table != null && this.table.isRowHidden(i2)) continue;
            row = ws.createRow((short)(i2 + 1));
            for (int j2 = 0; j2 < this.model.getNumColumns(); ++j2) {
                Object o2;
                HSSFCell c3 = row.createCell((short)j2);
                if (this.table != null) {
                    c3.setCellStyle((HSSFCellStyle)styles.get(this.table.getCellStyle(i2, j2)));
                }
                if ((o2 = this.model.getTableDataItem(i2, j2)) instanceof Number) {
                    c3.setCellType(CellType.NUMERIC);
                    c3.setCellValue(((Number)o2).doubleValue());
                    continue;
                }
                c3.setCellType(CellType.STRING);
                if (o2 == null) continue;
                c3.setCellValue(o2.toString());
            }
        }
        return ws;
    }

    public void writeXLS(OutputStream os) throws IOException {
        this.wb = new HSSFWorkbook();
        HSSFSheet ws = this.createSheed();
        this.wb.write(os);
    }

    public void writeXLSFile(File f2) throws IOException {
        FileOutputStream fos = new FileOutputStream(f2);
        try {
            this.wb = new HSSFWorkbook();
            HSSFSheet ws = this.createSheed();
            this.wb.write(fos);
            fos.close();
        }
        catch (IOException iox) {
            fos.close();
            throw new IOException(iox.getMessage());
        }
    }

    public void setSheedTitle(String sheedTitle) {
        this.sheedTitle = sheedTitle;
    }

    public String getSheedTitle() {
        return this.sheedTitle;
    }

    public void setTable(JCTable table) {
        this.table = table;
    }

    public JCTable getTable() {
        return this.table;
    }

    public void setModel(TableDataModel model) {
        this.model = model;
    }

    public TableDataModel getModel() {
        return this.model;
    }
}

