/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.common.tree;

import com.agentpp.mib.MIBImport;
import com.agentpp.mib.MIBModule;
import com.agentpp.mib.MIBObject;
import com.agentpp.mib.MIBRepository;
import com.agentpp.mib.ObjectID;
import com.klg.jclass.util.treetable.JCTreeTableModel;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class MIBTreeModel
implements JCTreeTableModel,
TableModel {
    private static final String[] COLUMNS = new String[]{"MIB Tree", "Object ID", "Object Type", "Status"};
    static final int COL_OID = 1;
    static final int COL_TYPE = 2;
    static final int COL_STATUS = 3;
    private MIBRepository repository;
    private TreeMap tree = new TreeMap();
    private DefaultMutableTreeNode rootNode;
    private MIBTreeNode[] values;
    private transient Vector treeModelListeners;
    private transient Vector tableModelListeners;
    private boolean registeredOnly = false;

    @Override
    public Object getValueAt(Object node, int column) {
        DefaultMutableTreeNode dmtn = (DefaultMutableTreeNode)node;
        MIBTreeNode values = (MIBTreeNode)dmtn.getUserObject();
        if (column == -1) {
            return values;
        }
        if (values != null) {
            return values.getColumn(column);
        }
        return null;
    }

    @Override
    public boolean isCellEditable(Object parm1, int parm2) {
        return false;
    }

    @Override
    public void setValueAt(Object parm1, Object parm2, int parm3) {
        throw new UnsupportedOperationException("Methode setValueAt() noch nicht implementiert.");
    }

    public Class getColumnClass(int column) {
        return String.class;
    }

    @Override
    public int getColumnCount() {
        return COLUMNS.length;
    }

    @Override
    public String getColumnName(int column) {
        return COLUMNS[column];
    }

    @Override
    public Object getRoot() {
        return this.rootNode;
    }

    @Override
    public Object getChild(Object parent, int index) {
        return ((DefaultMutableTreeNode)parent).getChildAt(index);
    }

    @Override
    public int getChildCount(Object parent) {
        return ((DefaultMutableTreeNode)parent).getChildCount();
    }

    @Override
    public boolean isLeaf(Object node) {
        return ((DefaultMutableTreeNode)node).isLeaf();
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        DefaultMutableTreeNode pNode = (DefaultMutableTreeNode)parent;
        DefaultMutableTreeNode cNode = (DefaultMutableTreeNode)child;
        if (pNode == null || cNode == null) {
            return -1;
        }
        return pNode.getIndex(cNode);
    }

    public MIBRepository getRepository() {
        return this.repository;
    }

    public boolean isRegisteredOnly() {
        return this.registeredOnly;
    }

    public void setRepository(MIBRepository repository) {
        this.repository = repository;
    }

    public void setRegisteredOnly(boolean registeredOnly) {
        this.registeredOnly = registeredOnly;
    }

    @Override
    public int getRowCount() {
        return this.tree.size();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.values[rowIndex].getColumn(columnIndex);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }

    private void addChild(DefaultMutableTreeNode node, MIBTreeNode child) {
        boolean added = false;
        for (int i2 = 0; i2 < node.getChildCount(); ++i2) {
            DefaultMutableTreeNode n2 = (DefaultMutableTreeNode)node.getChildAt(i2);
            if (child.compareTo((MIBTreeNode)n2.getUserObject()) > 0) continue;
            node.insert(child.getNode(), i2);
            added = true;
            break;
        }
        if (!added) {
            node.add(child.getNode());
        }
    }

    public void buildTree(MIBModule module) {
        this.tree.clear();
        this.rootNode = new DefaultMutableTreeNode();
        this.buildTreeForModule(this.rootNode, module);
        this.values = new MIBTreeNode[this.tree.size()];
        int i2 = 0;
        Iterator it = this.tree.values().iterator();
        while (it.hasNext()) {
            this.values[i2] = (MIBTreeNode)it.next();
            ++i2;
        }
    }

    private void buildTreeForModule(DefaultMutableTreeNode root, MIBModule module) {
        MIBObject current;
        LinkedList<MIBObject> base = new LinkedList<MIBObject>();
        if (module.hasImports()) {
            MIBImport[] imports = (MIBImport[])module.getImports();
            for (int i2 = 0; i2 < imports.length; ++i2) {
                Enumeration<String> en = imports[i2].getImportsVector().elements();
                while (en.hasMoreElements()) {
                    String is = en.nextElement().toString();
                    current = this.repository.getObject(imports[i2].getSource(), is);
                    if (current == null || current.getOid().size() < 1) continue;
                    base.add(current);
                    MIBTreeNode childNode = new MIBTreeNode(current);
                    this.tree.put(current.getObjectID(), childNode);
                    this.addChild(root, childNode);
                    this.buildSubTree(module, childNode.getNode(), this.repository.getChildren(current.getOid(), false));
                }
            }
        }
        current = null;
        Enumeration en = module.objectsByOid().elements();
        while (en.hasMoreElements()) {
            MIBObject parent;
            MIBObject o2 = (MIBObject)en.nextElement();
            if (current != null && current.getOid().isRootOf(o2.getOid()) || (parent = this.repository.getParent(current = o2)) != null) continue;
            DefaultMutableTreeNode child = new DefaultMutableTreeNode(current);
            MIBTreeNode childNode = new MIBTreeNode(current);
            this.addChild(root, childNode);
            this.buildSubTree(module, child, this.repository.getChildren(current));
        }
    }

    public int buildSubTree(MIBModule module, DefaultMutableTreeNode node, Vector children) {
        int i2 = 0;
        int n2 = 0;
        Enumeration e2 = children.elements();
        while (e2.hasMoreElements()) {
            MIBObject current = (MIBObject)e2.nextElement();
            if (!current.getModuleID().equals(module.getModuleID())) continue;
            MIBTreeNode childNode = new MIBTreeNode(current);
            this.tree.put(current.getObjectID(), childNode);
            this.addChild(node, childNode);
            ++i2;
            ++n2;
            n2 += this.buildSubTree(module, childNode.getNode(), this.repository.getChildren(current));
        }
        return n2;
    }

    @Override
    public synchronized void removeTreeModelListener(TreeModelListener l2) {
        if (this.treeModelListeners != null && this.treeModelListeners.contains(l2)) {
            Vector v = (Vector)this.treeModelListeners.clone();
            v.removeElement(l2);
            this.treeModelListeners = v;
        }
    }

    @Override
    public synchronized void addTreeModelListener(TreeModelListener l2) {
        Vector v;
        Vector vector = v = this.treeModelListeners == null ? new Vector(2) : (Vector)this.treeModelListeners.clone();
        if (!v.contains(l2)) {
            v.addElement(l2);
            this.treeModelListeners = v;
        }
    }

    protected void fireTreeNodesChanged(TreeModelEvent e2) {
        if (this.treeModelListeners != null) {
            Vector listeners = this.treeModelListeners;
            int count = listeners.size();
            for (int i2 = 0; i2 < count; ++i2) {
                ((TreeModelListener)listeners.elementAt(i2)).treeNodesChanged(e2);
            }
        }
    }

    protected void fireTreeNodesInserted(TreeModelEvent e2) {
        if (this.treeModelListeners != null) {
            Vector listeners = this.treeModelListeners;
            int count = listeners.size();
            for (int i2 = 0; i2 < count; ++i2) {
                ((TreeModelListener)listeners.elementAt(i2)).treeNodesInserted(e2);
            }
        }
    }

    protected void fireTreeNodesRemoved(TreeModelEvent e2) {
        if (this.treeModelListeners != null) {
            Vector listeners = this.treeModelListeners;
            int count = listeners.size();
            for (int i2 = 0; i2 < count; ++i2) {
                ((TreeModelListener)listeners.elementAt(i2)).treeNodesRemoved(e2);
            }
        }
    }

    protected void fireTreeStructureChanged(TreeModelEvent e2) {
        if (this.treeModelListeners != null) {
            Vector listeners = this.treeModelListeners;
            int count = listeners.size();
            for (int i2 = 0; i2 < count; ++i2) {
                ((TreeModelListener)listeners.elementAt(i2)).treeStructureChanged(e2);
            }
        }
    }

    @Override
    public synchronized void removeTableModelListener(TableModelListener l2) {
        if (this.tableModelListeners != null && this.tableModelListeners.contains(l2)) {
            Vector v = (Vector)this.tableModelListeners.clone();
            v.removeElement(l2);
            this.tableModelListeners = v;
        }
    }

    @Override
    public synchronized void addTableModelListener(TableModelListener l2) {
        Vector v;
        Vector vector = v = this.tableModelListeners == null ? new Vector(2) : (Vector)this.tableModelListeners.clone();
        if (!v.contains(l2)) {
            v.addElement(l2);
            this.tableModelListeners = v;
        }
    }

    protected void fireTableChanged(TableModelEvent e2) {
        if (this.tableModelListeners != null) {
            Vector listeners = this.tableModelListeners;
            int count = listeners.size();
            for (int i2 = 0; i2 < count; ++i2) {
                ((TableModelListener)listeners.elementAt(i2)).tableChanged(e2);
            }
        }
    }

    public static MIBTreeModel createModel(MIBRepository rep, MIBModule module, boolean registeredOnly) {
        MIBTreeModel mibTreeModel = new MIBTreeModel();
        mibTreeModel.setRegisteredOnly(registeredOnly);
        mibTreeModel.setRepository(rep);
        mibTreeModel.buildTree(module);
        return mibTreeModel;
    }

    class MIBTreeNode
    implements Comparable {
        private MIBObject ot;
        private DefaultMutableTreeNode node;

        public MIBTreeNode(MIBObject ot) {
            this.ot = ot;
        }

        public MIBObject getMIBObject() {
            return this.ot;
        }

        public int compareTo(Object o2) {
            return this.ot.getOid().compareTo(((MIBTreeNode)o2).getOID());
        }

        public ObjectID getOID() {
            return this.ot.getOid();
        }

        public DefaultMutableTreeNode getNode() {
            if (this.node == null) {
                this.node = new DefaultMutableTreeNode(this);
            }
            return this.node;
        }

        public void setNode(DefaultMutableTreeNode node) {
            this.node = node;
        }

        public Object getColumn(int column) {
            switch (column) {
                case 0: {
                    String name = MIBTreeModel.this.repository.getPathSuffix(this.getOID());
                    return name;
                }
                case 1: {
                    return this.ot.getOid();
                }
                case 2: {
                    return this.ot.getTypeString();
                }
                case 3: {
                    return this.ot.getStatus();
                }
            }
            return null;
        }
    }
}

