/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.common.table.print;

import com.agentpp.common.table.print.PageTableView;
import com.klg.jclass.page.JCDocument;
import com.klg.jclass.page.JCPageTable;
import com.klg.jclass.page.JCTextStyle;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.invoke.CallSite;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class VectorView
implements PageTableView {
    protected static int numRows = 25;
    protected static int numColumns = 5;
    protected static Vector vectorData;
    protected static Vector columnLabels;
    private JCTextStyle cellStyle;
    private JCTextStyle headerStyle;

    protected VectorView() {
        this.createVectorData();
    }

    @Override
    public JComponent createView() {
        return new TablePanel();
    }

    @Override
    public JCPageTable createPageTable(JCDocument doc) {
        return this.createVectorTable(doc);
    }

    public JCPageTable createVectorTable(JCDocument doc) {
        JCPageTable table = new JCPageTable(doc, numColumns);
        JCPageTable header = table.createHeaders();
        int column = 0;
        Enumeration e_col = columnLabels.elements();
        while (e_col.hasMoreElements()) {
            header.printToCell(0, column, (String)e_col.nextElement());
            ++column;
        }
        int row = 0;
        Enumeration e_row = vectorData.elements();
        while (e_row.hasMoreElements()) {
            column = 0;
            Vector row_vector = (Vector)e_row.nextElement();
            e_col = row_vector.elements();
            while (e_col.hasMoreElements()) {
                table.printToCell(row, column, (String)e_col.nextElement());
                ++column;
            }
            ++row;
        }
        return table;
    }

    @Override
    public void resetModel(boolean use_vector) {
        this.createVectorData();
    }

    @Override
    public JPanel getOptionsPanel() {
        return this.getVectorOptionsPanel();
    }

    public JPanel getVectorOptionsPanel() {
        return new VectorOptionsPanel();
    }

    public void createVectorData() {
        int i2;
        columnLabels = new Vector();
        for (i2 = 0; i2 < numColumns; ++i2) {
            columnLabels.addElement("Column " + (i2 + 1));
        }
        vectorData = new Vector(numRows);
        for (i2 = 0; i2 < numRows; ++i2) {
            Vector<CallSite> row = new Vector<CallSite>(numColumns);
            for (int j2 = 0; j2 < numColumns; ++j2) {
                row.addElement((CallSite)((Object)(i2 + "." + j2)));
            }
            vectorData.addElement(row);
        }
    }

    @Override
    public void setCellStyle(JCTextStyle cellStyle) {
        this.cellStyle = cellStyle;
    }

    public JCTextStyle getCellStyle() {
        return this.cellStyle;
    }

    @Override
    public void setHeaderStyle(JCTextStyle headerStyle) {
        this.headerStyle = headerStyle;
    }

    public JCTextStyle getHeaderStyle() {
        return this.headerStyle;
    }

    class TablePanel
    extends JScrollPane {
        TablePanel() {
            this.setBorder(new TitledBorder("Vector Data"));
            this.setPreferredSize(new Dimension(300, 200));
            JPanel panel = new JPanel();
            panel.setLayout(new GridLayout(0, 1, 5, 0));
            panel.add(new JLabel(" "));
            JLabel label = new JLabel("JClass PageLayout can create a report");
            Font lFont = new Font("TimesRoman", 1, 14);
            label.setFont(lFont);
            panel.add(label);
            label = new JLabel("directly from a Vecor or Array.");
            label.setFont(lFont);
            panel.add(label);
            panel.add(new JLabel(" "));
            label = new JLabel("Please click on the 'Preview' or 'Print' buttons.");
            label.setFont(lFont);
            panel.add(label);
            this.getViewport().add(panel);
        }

        @Override
        public void paint(Graphics g2) {
            g2.setFont(new Font("TimesRoman", 1, 14));
            g2.drawString("JClass PageLayout can create a report", 20, 60);
            g2.drawString("directly from a Vector or Array.", 20, 80);
            g2.drawString("Please click the Print button", 20, 120);
            super.paint(g2);
        }
    }

    public class VectorOptionsPanel
    extends JPanel
    implements ActionListener {
        JTextField rowsField;
        JTextField columnsField;
        JButton button;

        public VectorOptionsPanel() {
            this.setBorder(new TitledBorder("Vector options"));
            this.setLayout(new BorderLayout());
            JPanel top = new JPanel();
            top.setLayout(new GridLayout(2, 2));
            top.add(new JLabel("Rows"));
            this.rowsField = new JTextField("" + numRows);
            top.add(this.rowsField);
            top.add(new JLabel("Columns"));
            this.columnsField = new JTextField("" + numColumns);
            top.add(this.columnsField);
            this.add((Component)top, "North");
            JPanel bottom = new JPanel();
            this.button = new JButton(" Set Table Size ");
            bottom.add(this.button);
            this.button.addActionListener(this);
            this.button = new JButton("Reset");
            bottom.add(this.button);
            this.button.addActionListener(this);
            this.add((Component)bottom, "South");
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            String command = event.getActionCommand();
            if (command.equals(" Set Table Size ")) {
                int temp = numRows;
                try {
                    numRows = Integer.parseInt(this.rowsField.getText());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (numRows < 1) {
                    numRows = temp;
                }
                temp = numColumns;
                try {
                    numColumns = Integer.parseInt(this.columnsField.getText());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (numColumns < 1) {
                    numColumns = temp;
                }
                VectorView.this.resetModel(true);
            } else if (command.equals("Reset")) {
                System.out.println("Reset");
            }
        }
    }
}

