/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.common.table.filter;

import com.agentpp.common.table.ColumnFilter;
import com.agentpp.util.Regex;
import java.text.ParseException;

public class RegexColumnFilter
implements ColumnFilter {
    private String filterExpr;
    private Regex regex;

    public RegexColumnFilter(String filterExpr) {
        this.filterExpr = filterExpr;
    }

    @Override
    public boolean passesFilter(Object value) {
        if (this.filterExpr != null) {
            if (this.regex == null) {
                this.regex = new Regex();
                try {
                    this.regex.compile(this.filterExpr);
                }
                catch (ParseException ex) {
                    this.regex = null;
                    return true;
                }
            }
            if (value == null || !this.regex.match(value.toString())) {
                return false;
            }
        }
        return true;
    }

    public String toString() {
        return this.filterExpr;
    }
}

