/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.common.table;

import com.klg.jclass.table.EditableTableDataModel;
import com.klg.jclass.table.JCTableDataEvent;
import com.klg.jclass.table.JCTableDataListener;
import com.klg.jclass.table.data.JCVectorDataSource;
import java.util.Vector;

public class TransposableDataSource
implements EditableTableDataModel,
JCTableDataListener {
    protected EditableTableDataModel tableData;
    protected boolean transposed = false;
    private transient Vector JCTableDataListeners;

    public TransposableDataSource(EditableTableDataModel tableData) {
        this.tableData = tableData;
        tableData.addTableDataListener(this);
    }

    public void setTransposed(boolean value) {
        this.transposed = value;
        if (this.tableData instanceof JCVectorDataSource) {
            ((JCVectorDataSource)((Object)this.tableData)).setDataChanged(-998, -998, 0, 0, 14);
        }
    }

    public boolean getTransposed() {
        return this.transposed;
    }

    @Override
    public Object getTableDataItem(int row, int column) {
        if (this.tableData == null) {
            return null;
        }
        if (this.transposed) {
            return this.tableData.getTableDataItem(column, row);
        }
        return this.tableData.getTableDataItem(row, column);
    }

    @Override
    public boolean setTableDataItem(Object o2, int row, int column) {
        if (this.tableData == null) {
            return false;
        }
        if (this.transposed) {
            return this.tableData.setTableDataItem(o2, column, row);
        }
        return this.tableData.setTableDataItem(o2, row, column);
    }

    @Override
    public int getNumRows() {
        if (this.tableData == null) {
            return 0;
        }
        if (this.transposed) {
            return this.tableData.getNumColumns();
        }
        return this.tableData.getNumRows();
    }

    @Override
    public int getNumColumns() {
        if (this.tableData == null) {
            return 0;
        }
        if (this.transposed) {
            return this.tableData.getNumRows();
        }
        return this.tableData.getNumColumns();
    }

    @Override
    public Object getTableRowLabel(int row) {
        if (this.tableData == null) {
            return null;
        }
        if (this.transposed) {
            return this.tableData.getTableColumnLabel(row);
        }
        return this.tableData.getTableRowLabel(row);
    }

    @Override
    public Object getTableColumnLabel(int column) {
        if (this.tableData == null) {
            return null;
        }
        if (this.transposed) {
            return this.tableData.getTableRowLabel(column);
        }
        return this.tableData.getTableColumnLabel(column);
    }

    @Override
    public synchronized void removeTableDataListener(JCTableDataListener l2) {
        if (this.JCTableDataListeners != null && this.JCTableDataListeners.contains(l2)) {
            Vector v = (Vector)this.JCTableDataListeners.clone();
            v.removeElement(l2);
            this.JCTableDataListeners = v;
        }
    }

    @Override
    public synchronized void addTableDataListener(JCTableDataListener l2) {
        Vector v;
        Vector vector = v = this.JCTableDataListeners == null ? new Vector(2) : (Vector)this.JCTableDataListeners.clone();
        if (!v.contains(l2)) {
            v.addElement(l2);
            this.JCTableDataListeners = v;
        }
    }

    protected void fireDataChanged(JCTableDataEvent e2) {
        if (this.JCTableDataListeners != null) {
            Vector listeners = this.JCTableDataListeners;
            int count = listeners.size();
            for (int i2 = 0; i2 < count; ++i2) {
                ((JCTableDataListener)listeners.elementAt(i2)).dataChanged(e2);
            }
        }
    }

    @Override
    public void dataChanged(JCTableDataEvent event) {
        if (this.transposed) {
            int cmd = event.getCommand();
            switch (cmd) {
                case 6: {
                    cmd = 3;
                    break;
                }
                case 3: {
                    cmd = 6;
                    break;
                }
                case 5: {
                    cmd = 2;
                    break;
                }
                case 2: {
                    cmd = 5;
                    break;
                }
                case 9: {
                    cmd = 8;
                    break;
                }
                case 8: {
                    cmd = 9;
                    break;
                }
                case 11: {
                    cmd = 10;
                    break;
                }
                case 10: {
                    cmd = 11;
                    break;
                }
                case 7: {
                    cmd = 4;
                    break;
                }
                case 4: {
                    cmd = 7;
                    break;
                }
                case 13: {
                    cmd = 12;
                    break;
                }
                case 12: {
                    cmd = 13;
                }
            }
            JCTableDataEvent e2 = new JCTableDataEvent(this, event.getColumn(), event.getRow(), event.getNumAffected(), event.getDestination(), cmd);
            this.fireDataChanged(e2);
        } else {
            this.fireDataChanged(event);
        }
    }
}

