/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.common.table;

import com.agentpp.common.table.ExtendedListTable;
import com.agentpp.common.table.ExtendedTable;
import com.agentpp.common.table.MoveUpDownPanel;
import com.agentpp.common.table.TableUtils;
import com.klg.jclass.table.JCSelectEvent;
import com.klg.jclass.table.JCSelectListener;
import com.klg.jclass.table.JCTable;
import com.klg.jclass.table.data.JCVectorDataSource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JPanel;

public class TablePanel
extends JPanel {
    public static final int MOVE_PANE_NONE = 0;
    public static final int MOVE_PANE_LEFT = 1;
    public static final int MOVE_PANE_RIGHT = 2;
    public static final int MOVE_PANE_BOTTOM = 3;
    public static ImageIcon upIcon;
    public static ImageIcon downIcon;
    private BorderLayout borderLayout1 = new BorderLayout();
    private JCTable table = new ExtendedTable();
    private int movePane = 0;
    private MoveUpDownPanel movePanel;
    private MoveDownAction downAction;
    private MoveUpAction upAction;
    private boolean moveButtonsEnabled = true;
    private Vector moveActionListeners = new Vector(2);

    public TablePanel() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public TablePanel(boolean listTable, int movePaneMode) {
        if (listTable) {
            this.table = new ExtendedListTable();
        }
        this.movePane = movePaneMode;
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public TablePanel(int movePaneMode) {
        this.movePane = movePaneMode;
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.add((Component)this.table, "Center");
        this.table.setHorizSBDisplay(0);
        switch (this.movePane) {
            case 1: {
                this.movePanel = new MoveUpDownPanel();
                this.add((Component)this.movePanel, "West");
                break;
            }
            case 2: {
                this.movePanel = new MoveUpDownPanel();
                this.add((Component)this.movePanel, "East");
                break;
            }
            case 3: {
                this.movePanel = new MoveUpDownPanel(0);
                this.add((Component)this.movePanel, "South");
            }
        }
        if (this.movePanel != null) {
            this.upAction = new MoveUpAction();
            this.downAction = new MoveDownAction();
            this.movePanel.setUpAction(this.upAction);
            this.movePanel.setDownAction(this.downAction);
            this.table.addSelectListener(this.upAction);
            this.table.addSelectListener(this.downAction);
        }
    }

    public JCTable getTable() {
        return this.table;
    }

    public synchronized void addMoveActionListener(ActionListener listener) {
        this.moveActionListeners.add(listener);
    }

    public synchronized void removeMoveActionListener(ActionListener listener) {
        this.moveActionListeners.remove(listener);
    }

    protected synchronized void fireMoveAction(ActionEvent e2) {
        for (int i2 = 0; i2 < this.moveActionListeners.size(); ++i2) {
            ((ActionListener)this.moveActionListeners.get(i2)).actionPerformed(e2);
        }
    }

    public void setMoveButtonsEnabled(boolean enabled) {
        this.moveButtonsEnabled = enabled;
    }

    static {
        URL url = Thread.currentThread().getContextClassLoader().getResource("toolbarButtonGraphics/navigation/Down16.gif");
        downIcon = new ImageIcon(url);
        url = Thread.currentThread().getContextClassLoader().getResource("toolbarButtonGraphics/navigation/Up16.gif");
        upIcon = new ImageIcon(url);
    }

    public class MoveUpAction
    extends AbstractAction
    implements JCSelectListener {
        MoveUpAction() {
            super("Up  ", upIcon);
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            TableUtils.moveSelectedRow(TablePanel.this.table, (JCVectorDataSource)TablePanel.this.table.getDataSource(), -1);
            TablePanel.this.fireMoveAction(e2);
        }

        @Override
        public void beforeSelect(JCSelectEvent jCSelectEvent) {
        }

        @Override
        public void select(JCSelectEvent jCSelectEvent) {
            if (jCSelectEvent.getAction() == 3) {
                this.setEnabled(false);
            } else {
                this.setEnabled(jCSelectEvent.getStartRow() > 0 && TablePanel.this.moveButtonsEnabled);
            }
        }

        @Override
        public void afterSelect(JCSelectEvent jCSelectEvent) {
        }
    }

    public class MoveDownAction
    extends AbstractAction
    implements JCSelectListener {
        MoveDownAction() {
            super("Down", downIcon);
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            TableUtils.moveSelectedRow(TablePanel.this.table, (JCVectorDataSource)TablePanel.this.table.getDataSource(), 1);
            TablePanel.this.fireMoveAction(e2);
        }

        @Override
        public void beforeSelect(JCSelectEvent jCSelectEvent) {
        }

        @Override
        public void select(JCSelectEvent jCSelectEvent) {
            if (jCSelectEvent.getAction() == 3 || TablePanel.this.table == null || TablePanel.this.table.getDataSource() == null) {
                this.setEnabled(false);
            } else {
                this.setEnabled(jCSelectEvent.getEndRow() < TablePanel.this.table.getDataSource().getNumRows() - 1 && TablePanel.this.moveButtonsEnabled);
            }
        }

        @Override
        public void afterSelect(JCSelectEvent jCSelectEvent) {
        }
    }
}

