/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.common.table;

import com.klg.jclass.table.JCTable;
import java.awt.event.MouseWheelEvent;
import javax.swing.JScrollBar;

public class TableMouseWheelListener
extends com.klg.jclass.table.TableMouseWheelListener {
    private static final double EPSILON = 1.0E-5;

    public TableMouseWheelListener(JCTable table) {
        super(table);
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e2) {
        int direction;
        int n2 = direction = e2.getWheelRotation() > 0 ? 1 : -1;
        if (e2.getScrollType() == 1) {
            this.scrollByBlock(this.table.getVertSB(), direction);
        } else {
            this.scrollByUnitsPrecisely(e2, direction);
        }
    }

    @Override
    protected void scrollByBlock(JScrollBar scrollBar, int direction) {
        int newValue = scrollBar.getValue() + scrollBar.getBlockIncrement(direction);
        if (newValue >= scrollBar.getMinimum() && newValue <= scrollBar.getMaximum()) {
            scrollBar.setValue(newValue);
        } else if (newValue < scrollBar.getMinimum()) {
            scrollBar.setValue(scrollBar.getMinimum());
        } else if (newValue > scrollBar.getMaximum()) {
            scrollBar.setValue(scrollBar.getMaximum());
        }
    }

    protected void scrollByUnitsPrecisely(MouseWheelEvent e2, int direction) {
        JScrollBar scrollbar = e2.isShiftDown() ? this.table.getHorizSB() : this.table.getVertSB();
        double rotation = e2.getPreciseWheelRotation();
        int unitIncrement = scrollbar.getUnitIncrement(direction);
        double delta = rotation * (double)e2.getScrollAmount() * (double)unitIncrement;
        boolean limitDelta = Math.abs(rotation) < 1.00001;
        int blockIncrement = scrollbar.getBlockIncrement(direction);
        double adjustedDelta = limitDelta ? Math.max(-((double)blockIncrement), Math.min(delta, (double)blockIncrement)) : delta;
        int value = scrollbar.getValue();
        int newValue = Math.max(scrollbar.getMinimum(), Math.min((int)Math.round((double)value + adjustedDelta), scrollbar.getMaximum()));
        if (newValue != value) {
            scrollbar.setValue(newValue);
        }
    }

    @Override
    public void setTable(JCTable table) {
        this.table = table;
    }

    @Override
    public JCTable getTable() {
        return this.table;
    }
}

