/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.common.table;

import com.agentpp.common.table.TableMouseWheelListener;
import com.agentpp.util.UserConfigFile;
import com.klg.jclass.table.JCCellDisplayEvent;
import com.klg.jclass.table.JCCellPosition;
import com.klg.jclass.table.JCCellRange;
import com.klg.jclass.table.JCTable;
import com.klg.jclass.table.TablePopupMenu;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelListener;
import java.util.Collection;

public class PopupTable
extends JCTable {
    public static final char NEW_LINE_DELIM = '\n';
    public static final char TAB_DELIM = '\t';
    public static final String EMPTY_STRING = "";
    public static final String NEWLINE = "\n";
    public static final String NULL = "null";
    public static final String TAB = "\t";
    TablePopupMenu popup;
    private JCCellPosition popupPosition;
    private int upper_row_bound;
    private int upper_col_bound;

    public PopupTable() {
        this.setPixelHeight(-997, 33002);
        this.setVariableEstimateCount(10);
        this.popup = this.createPopupMenu();
        this.popup.removeAll();
        if (this.mouseWheelListener != null) {
            this.removeMouseWheelListener((MouseWheelListener)this.mouseWheelListener);
        }
        this.addMouseWheelListener(new TableMouseWheelListener(this));
    }

    @Override
    protected void setRecalcRequired(boolean b2) {
        super.setRecalcRequired(b2);
    }

    protected boolean isPopupAllowed(int x, int y) {
        return true;
    }

    @Override
    public void processMouseEvent(MouseEvent event) {
        if (event.getModifiersEx() == 4096 && this.isPopupMenuEnabled()) {
            if (this.isPopupAllowed(event.getX(), event.getY())) {
                this.popup.show(this, event.getX(), event.getY());
                this.popupPosition = this.XYToCell(event.getX(), event.getY());
            }
        } else {
            super.processMouseEvent(event);
        }
    }

    @Override
    public void processKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.isControlDown() && keyEvent.getKeyCode() == 65 && this.getSelectionPolicy() != 1 && this.getSelectionPolicy() != 0) {
            this.selectAll();
        } else {
            super.processKeyEvent(keyEvent);
        }
    }

    public TablePopupMenu getPopupMenu() {
        return this.popup;
    }

    public JCCellPosition getPopupCellPosition() {
        return this.popupPosition;
    }

    public Object getDisplayValue(int row, int column) {
        JCCellDisplayEvent e2 = new JCCellDisplayEvent(this, row, column, this.getDataView().getTableDataItem(row, column));
        super.fireJCCellDisplayEvent(e2);
        if (e2.getDisplayData() == null) {
            return e2.getCellData();
        }
        return e2.getDisplayData();
    }

    public void saveColumnWidths(UserConfigFile config, String tableName) {
        int i2;
        boolean anyUserPixelWidth = false;
        block3: for (i2 = 0; !anyUserPixelWidth && i2 < this.getNumColumns(); ++i2) {
            switch (this.getPixelWidth(i2)) {
                case 33001: 
                case 33002: {
                    continue block3;
                }
                default: {
                    anyUserPixelWidth = true;
                }
            }
        }
        if (anyUserPixelWidth) {
            for (i2 = 0; i2 < this.getNumColumns(); ++i2) {
                config.putInteger(tableName + i2, this.getPixelWidth(i2));
            }
        } else {
            for (i2 = 0; i2 < this.getNumColumns(); ++i2) {
                config.remove(tableName + i2);
            }
        }
    }

    public void restoreColumnWidths(UserConfigFile config, String tableName) {
        for (int i2 = 0; i2 < this.getNumColumns(); ++i2) {
            this.setPixelWidth(i2, config.getInteger(tableName + i2, this.getCharWidth(i2)));
        }
    }

    public void restoreColumnWidths(UserConfigFile config, String tableName, int defaultValue) {
        for (int i2 = 0; i2 < this.getNumColumns(); ++i2) {
            this.setPixelWidth(i2, config.getInteger(tableName + i2, defaultValue));
        }
    }

    public void resetColumnWidths(UserConfigFile config, String tableName) {
        for (int i2 = 0; i2 < this.getNumColumns(); ++i2) {
            config.remove(tableName + i2);
            this.setPixelWidth(i2, 33002);
        }
    }

    public void copySelectionToClipBoard() {
        JCCellRange range = null;
        String copy_value = null;
        StringBuilder buffer = new StringBuilder();
        try {
            Collection selection = this.getSelectedCells();
            for (Object aSelection : selection) {
                range = (JCCellRange)aSelection;
                this.setRangeAfterCopy(range);
                for (int row = range.start_row; row <= this.upper_row_bound; ++row) {
                    for (int column = range.start_column; column <= this.upper_col_bound; ++column) {
                        copy_value = this.getDataView().getObject(row, column).toString();
                        if (copy_value == null) {
                            copy_value = EMPTY_STRING;
                        } else {
                            copy_value = copy_value.replace('\t', ' ');
                            copy_value = copy_value.replace('\n', ' ');
                        }
                        if (NULL.equals(copy_value)) continue;
                        buffer.append(copy_value);
                        if (column < this.upper_col_bound) {
                            buffer.append(TAB);
                        }
                        if (column != this.upper_col_bound) continue;
                        buffer.append(NEWLINE);
                    }
                }
            }
            StringSelection string_selection = new StringSelection(buffer.toString());
            Clipboard clip_board = Toolkit.getDefaultToolkit().getSystemClipboard();
            clip_board.setContents(string_selection, string_selection);
        }
        catch (NullPointerException e2) {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    private void setRangeAfterCopy(JCCellRange range) {
        if (range.start_row == -1) {
            range.start_row = 0;
        }
        if (range.start_column == -1) {
            range.start_column = 0;
        }
        if (range.start_row > range.end_row) {
            int temp_row = range.start_row;
            range.start_row = range.end_row;
            range.end_row = temp_row;
        }
        if (range.start_column > range.end_column) {
            int temp_col = range.start_column;
            range.start_column = range.end_column;
            range.end_column = temp_col;
        }
        this.upper_row_bound = range.end_row;
        this.upper_col_bound = range.end_column;
        if (this.upper_row_bound > this.getNumRows()) {
            this.upper_row_bound = this.getNumRows() - 1;
        }
        if (this.upper_col_bound > this.getNumColumns()) {
            this.upper_col_bound = this.getNumColumns() - 1;
        }
    }
}

