/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.common.smi.editor;

import com.agentpp.common.smi.editor.SmiContext;
import com.agentpp.common.smi.editor.SmiEditorKit;
import com.agentpp.common.smi.editor.Token;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Font;
import java.io.File;
import java.io.FileReader;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;

public class SmiKitTest {
    public static void main(String[] args) {
        if (args.length != 1) {
            System.err.println("need filename argument");
            System.exit(1);
        }
        try {
            JEditorPane editor = new JEditorPane();
            SmiEditorKit kit = new SmiEditorKit();
            editor.setEditorKitForContentType("text/smi", kit);
            editor.setContentType("text/smi");
            editor.setFont(new Font("Courier", 0, 12));
            editor.setEditable(true);
            SmiContext styles = kit.getStylePreferences(editor.getForeground());
            Color keyword = Color.orange;
            for (int code = 0; code < Token.all.length; ++code) {
                Token t = Token.all[code];
                Style s2 = styles.getStyleForScanValue(t.getScanValue());
                if (s2 == null) continue;
                if (t instanceof Token.Statement) {
                    StyleConstants.setBold(s2, true);
                    StyleConstants.setForeground(s2, Color.black);
                    continue;
                }
                if (t instanceof Token.Clause) {
                    StyleConstants.setBold(s2, true);
                    StyleConstants.setForeground(s2, Color.gray);
                    continue;
                }
                if (t instanceof Token.Text) {
                    StyleConstants.setBold(s2, false);
                    StyleConstants.setForeground(s2, new Color(70, 70, 180));
                    continue;
                }
                if (t instanceof Token.Identifier) {
                    StyleConstants.setBold(s2, false);
                    StyleConstants.setForeground(s2, Color.darkGray);
                    continue;
                }
                if (t instanceof Token.Special) {
                    StyleConstants.setItalic(s2, true);
                    StyleConstants.setForeground(s2, Color.red);
                    continue;
                }
                if (!(t instanceof Token.Value)) continue;
                StyleConstants.setForeground(s2, new Color(150, 150, 155));
            }
            File file = new File(args[0]);
            editor.read(new FileReader(file), (Object)file);
            JScrollPane scroller = new JScrollPane();
            JViewport vp = scroller.getViewport();
            vp.add(editor);
            JFrame f2 = new JFrame("JavaEditorKit: " + args[0]);
            f2.getContentPane().setLayout(new BorderLayout());
            f2.getContentPane().add("Center", scroller);
            f2.pack();
            f2.setSize(600, 600);
            f2.setVisible(true);
        }
        catch (Throwable e2) {
            e2.printStackTrace();
            System.exit(1);
        }
    }
}

