/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.common.smi.editor;

import com.agentpp.common.font.FontStyle;
import com.agentpp.common.smi.editor.SmiDocument;
import com.agentpp.common.smi.editor.Token;
import com.agentpp.commons.mib.MIBColors;
import com.agentpp.util.UserConfigFile;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Shape;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Segment;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.WrappedPlainView;

public class SmiContext
extends StyleContext
implements ViewFactory {
    public static final String CFG_FONT_STYLE_COLOR = "agentpp.smi.editor.FontStyleColor";
    public static final String CFG_FONT_STYLE_ITALIC = "agentpp.smi.editor.FontStyleItalic";
    public static final String CFG_FONT_STYLE_BOLD = "agentpp.smi.editor.FontStyleBold";
    public static final String CFG_FONT_STYLE_ENABLED = "agentpp.smi.editor.SyntaxHighlighting";
    public static final String[] STYLE_CLASS_NAMES = new String[]{"Clauses", "Comments", "Identifier", "Keywords", "Text", "Types", "Values"};
    public static final Class[] STYLE_CLASSES = new Class[]{Token.Clause.class, Token.Special.class, Token.Identifier.class, Token.Statement.class, Token.Text.class, Token.Type.class, Token.Value.class};
    private final Color foreground;
    public static final Color[] STYLE_COLORS = new Color[]{MIBColors.TreeColors.syntaxClause.getColor(), MIBColors.TreeColors.syntaxComments.getColor(), MIBColors.TreeColors.syntaxIdentifier.getColor(), MIBColors.TreeColors.syntaxKeyword.getColor(new JLabel()), MIBColors.TreeColors.syntaxText.getColor(), MIBColors.TreeColors.syntaxTypes.getColor(), MIBColors.TreeColors.syntaxValues.getColor()};
    public static final boolean[] STYLE_ITALIC = new boolean[]{false, false, false, false, true, false, false, false};
    public static final boolean[] STYLE_BOLD = new boolean[]{true, false, false, true, false, false, false, false};
    Style[] tokenStyles;
    transient Color[] tokenColors;
    transient Font[] tokenFonts;
    private boolean syntaxHighlighting = true;

    public SmiContext() {
        this.foreground = new JTextArea().getForeground();
    }

    public SmiContext(Color foreground) {
        Token[] tokens;
        this.foreground = foreground;
        Style root = this.getStyle("default");
        this.tokenStyles = new Style[Token.MaximumScanValue + 1];
        Arrays.fill(this.tokenStyles, root);
        for (Token t : tokens = Token.all) {
            Style parent = this.getStyle(t.getCategory());
            if (parent == null) {
                parent = this.addStyle(t.getCategory(), root);
            }
            Style s2 = this.addStyle(null, parent);
            s2.addAttribute(Token.TokenAttribute, t);
            this.tokenStyles[t.getScanValue()] = s2;
        }
    }

    public static void saveSyntaxHighlighting(UserConfigFile config, boolean s2) {
        config.putBoolean(CFG_FONT_STYLE_ENABLED, s2);
    }

    public static boolean loadSyntaxHighlighting(UserConfigFile config) {
        return config.getBoolean(CFG_FONT_STYLE_ENABLED, true);
    }

    public static List<FontStyle> getStyles(UserConfigFile config) {
        ArrayList<FontStyle> v = new ArrayList<FontStyle>();
        for (int i2 = 0; i2 < STYLE_CLASS_NAMES.length; ++i2) {
            FontStyle fs = new FontStyle();
            fs.setName(STYLE_CLASS_NAMES[i2]);
            fs.setColor(new Color(config.getInteger("agentpp.smi.editor.FontStyleColor." + STYLE_CLASS_NAMES[i2], STYLE_COLORS[i2].getRGB())));
            fs.setItalic(config.getBoolean("agentpp.smi.editor.FontStyleItalic." + STYLE_CLASS_NAMES[i2], STYLE_ITALIC[i2]));
            fs.setBold(config.getBoolean("agentpp.smi.editor.FontStyleBold." + STYLE_CLASS_NAMES[i2], STYLE_BOLD[i2]));
            v.add(fs);
        }
        return v;
    }

    public static void setStyles(UserConfigFile config, List<FontStyle> fontStyles) {
        for (FontStyle fs : fontStyles) {
            config.putInteger("agentpp.smi.editor.FontStyleColor." + fs.getName(), fs.getColor().getRGB());
            config.putBoolean("agentpp.smi.editor.FontStyleItalic." + fs.getName(), fs.isItalic());
            config.putBoolean("agentpp.smi.editor.FontStyleBold." + fs.getName(), fs.isBold());
        }
    }

    public static List<FontStyle> getDefaultStyles(Color background) {
        ArrayList<FontStyle> v = new ArrayList<FontStyle>();
        for (int i2 = 0; i2 < STYLE_CLASS_NAMES.length; ++i2) {
            FontStyle fs = new FontStyle();
            fs.setName(STYLE_CLASS_NAMES[i2]);
            fs.setColor(MIBColors.increaseContrast(STYLE_COLORS[i2], background));
            fs.setItalic(STYLE_ITALIC[i2]);
            fs.setBold(STYLE_BOLD[i2]);
            v.add(fs);
        }
        return v;
    }

    public void setStyles(List<FontStyle> fontStyles) {
        for (int code = 0; code < Token.all.length; ++code) {
            Token t = Token.all[code];
            Style s2 = this.getStyleForScanValue(t.getScanValue());
            if (s2 == null) continue;
            for (int j2 = 0; j2 < STYLE_CLASSES.length; ++j2) {
                if (!STYLE_CLASSES[j2].isInstance(t)) continue;
                FontStyle fs = fontStyles.get(j2);
                StyleConstants.setBold(s2, fs.isBold());
                StyleConstants.setItalic(s2, fs.isItalic());
                StyleConstants.setForeground(s2, fs.getColor());
            }
        }
    }

    public Color getForeground(int code) {
        if (this.tokenColors == null) {
            this.tokenColors = new Color[Token.MaximumScanValue + 1];
        }
        if (code >= 0 && code < this.tokenColors.length) {
            Style s2;
            Color c2 = this.tokenColors[code];
            if (c2 == null && Color.black.equals(c2 = StyleConstants.getForeground(s2 = this.tokenStyles[code]))) {
                c2 = this.foreground;
            }
            if (c2 != null) {
                return c2;
            }
        }
        return this.foreground;
    }

    public Font getFont(int code) {
        if (this.tokenFonts == null) {
            this.tokenFonts = new Font[Token.MaximumScanValue + 1];
        }
        if (code < this.tokenFonts.length) {
            Font f2 = this.tokenFonts[code];
            if (f2 == null) {
                Style s2 = this.tokenStyles[code];
                f2 = this.getFont(s2);
            }
            return f2;
        }
        return null;
    }

    public Style getStyleForScanValue(int code) {
        if (code < this.tokenStyles.length) {
            return this.tokenStyles[code];
        }
        return null;
    }

    @Override
    public View create(Element elem) {
        return new SmiView(elem);
    }

    public void setSyntaxHighlighting(boolean syntaxHighlighting) {
        this.syntaxHighlighting = syntaxHighlighting;
    }

    public boolean isSyntaxHighlighting() {
        return this.syntaxHighlighting;
    }

    class SmiView
    extends WrappedPlainView {
        SmiDocument.Scanner lexer;
        boolean lexerValid;

        SmiView(Element elem) {
            super(elem);
            SmiDocument doc = (SmiDocument)this.getDocument();
            this.lexer = doc.createScanner();
            this.lexerValid = false;
        }

        @Override
        public void paint(Graphics g2, Shape a2) {
            super.paint(g2, a2);
            this.lexerValid = false;
        }

        @Override
        protected int drawUnselectedText(Graphics g2, int x, int y, int p0, int p1) throws BadLocationException {
            SmiDocument smidoc;
            if (!SmiContext.this.isSyntaxHighlighting()) {
                return super.drawUnselectedText(g2, x, y, p0, p1);
            }
            Document doc = this.getDocument();
            if (doc instanceof SmiDocument && (smidoc = (SmiDocument)doc).isUpdated()) {
                smidoc.setUpdated(false);
                this.getContainer().invalidate();
                this.getContainer().repaint();
            }
            Color last = null;
            Font lastFont = null;
            int lastsv = -1;
            int mark = p0;
            while (p0 < p1) {
                this.updateScanner(p0, p1);
                int p2 = Math.min(this.lexer.getEndOffset(), p1);
                p2 = p2 <= p0 ? p1 : p2;
                int sv = this.lexer.getToken().getScanValue();
                Color fg = SmiContext.this.getForeground(sv);
                Font f2 = SmiContext.this.getFont(sv);
                if (!(last == null || lastFont == null || fg == last && f2.equals(lastFont))) {
                    g2.setColor(last);
                    Font bf = g2.getFont();
                    g2.setFont(lastFont);
                    Segment text = this.getLineBuffer();
                    doc.getText(mark, p0 - mark, text);
                    x = Utilities.drawTabbedText(text, x, y, g2, (TabExpander)this, mark);
                    mark = p0;
                    g2.setFont(bf);
                }
                last = fg;
                lastFont = f2;
                lastsv = sv;
                p0 = p2;
            }
            Font bf = g2.getFont();
            g2.setColor(last);
            g2.setFont(lastFont);
            Segment text = this.getLineBuffer();
            doc.getText(mark, p1 - mark, text);
            x = Utilities.drawTabbedText(text, x, y, g2, (TabExpander)this, mark);
            g2.setFont(bf);
            return x;
        }

        void updateScanner(int p0, int p1) {
            try {
                Token t;
                if (!this.lexerValid || p0 < this.lexer.getEndOffset()) {
                    SmiDocument doc = (SmiDocument)this.getDocument();
                    this.lexer.setRange(this.lexer.getScannerStart(p0), this.lexer.getScannerEnd(p1));
                    this.lexerValid = true;
                }
                boolean go = true;
                while (go && this.lexer.getEndOffset() <= p0 && !(t = this.lexer.getNextToken()).equals(Token.ERROR)) {
                }
            }
            catch (Throwable e2) {
                e2.printStackTrace();
            }
        }
    }
}

