/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.common.smi.editor;

import com.agentpp.common.smi.editor.RowRangeMark;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyleConstants;
import javax.swing.text.Utilities;

public class LineNumberRowHeaderView
extends JComponent
implements CaretListener,
DocumentListener,
PropertyChangeListener {
    public static final float LEFT = 0.0f;
    public static final float CENTER = 0.5f;
    public static final float RIGHT = 1.0f;
    private static final Border OUTER = new MatteBorder(0, 0, 0, 2, Color.GRAY);
    private static final int HEIGHT = 2146483647;
    private final JTextComponent component;
    private boolean updateFont;
    private int borderGap;
    private Color currentLineForeground;
    private float digitAlignment;
    private int minimumDisplayDigits;
    private int lastDigits;
    private int lastHeight;
    private int lastLine;
    private HashMap<String, FontMetrics> fonts;
    private SortedMap<Integer, RowRangeMark> rowMarkers = new TreeMap<Integer, RowRangeMark>();

    public LineNumberRowHeaderView(JTextComponent component) {
        this(component, 3);
    }

    public LineNumberRowHeaderView(JTextComponent component, int minimumDisplayDigits) {
        this.component = component;
        this.setFont(component.getFont());
        this.setBorderGap(5);
        this.setCurrentLineForeground(Color.RED);
        this.setDigitAlignment(1.0f);
        this.setMinimumDisplayDigits(minimumDisplayDigits);
        component.getDocument().addDocumentListener(this);
        component.addCaretListener(this);
        component.addPropertyChangeListener("font", this);
    }

    public boolean getUpdateFont() {
        return this.updateFont;
    }

    public void setUpdateFont(boolean updateFont) {
        this.updateFont = updateFont;
    }

    public int getBorderGap() {
        return this.borderGap;
    }

    public void setBorderGap(int borderGap) {
        this.borderGap = borderGap;
        EmptyBorder inner = new EmptyBorder(0, borderGap, 0, borderGap);
        this.setBorder(new CompoundBorder(OUTER, inner));
        this.lastDigits = 0;
        this.setPreferredWidth();
    }

    public Color getCurrentLineForeground() {
        return this.currentLineForeground == null ? this.getForeground() : this.currentLineForeground;
    }

    public void setCurrentLineForeground(Color currentLineForeground) {
        this.currentLineForeground = currentLineForeground;
    }

    public float getDigitAlignment() {
        return this.digitAlignment;
    }

    public void setDigitAlignment(float digitAlignment) {
        this.digitAlignment = digitAlignment > 1.0f ? 1.0f : (digitAlignment < 0.0f ? -1.0f : digitAlignment);
    }

    public int getMinimumDisplayDigits() {
        return this.minimumDisplayDigits;
    }

    public void setMinimumDisplayDigits(int minimumDisplayDigits) {
        this.minimumDisplayDigits = minimumDisplayDigits;
        this.setPreferredWidth();
    }

    private void setPreferredWidth() {
        Element root = this.component.getDocument().getDefaultRootElement();
        int lines = root.getElementCount();
        int digits = Math.max(String.valueOf(lines).length(), this.minimumDisplayDigits);
        if (this.lastDigits != digits) {
            this.lastDigits = digits;
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            int width = fontMetrics.charWidth('0') * digits;
            Insets insets = this.getInsets();
            int preferredWidth = insets.left + insets.right + width;
            Dimension d2 = this.getPreferredSize();
            d2.setSize(preferredWidth, 2146483647);
            this.setPreferredSize(d2);
            this.setSize(d2);
        }
    }

    @Override
    public void paintComponent(Graphics g2) {
        super.paintComponent(g2);
        FontMetrics fontMetrics = this.component.getFontMetrics(this.component.getFont());
        Insets insets = this.getInsets();
        int availableWidth = this.getSize().width - insets.left - insets.right;
        Rectangle clip = g2.getClipBounds();
        int rowStartOffset = this.component.viewToModel(new Point(0, clip.y));
        int endOffset = this.component.viewToModel(new Point(0, clip.y + clip.height));
        while (rowStartOffset <= endOffset) {
            try {
                int row = this.getRow(rowStartOffset);
                String lineNumber = this.getLineNumberText(row);
                int stringWidth = fontMetrics.stringWidth(lineNumber);
                int x = this.getOffsetX(availableWidth, stringWidth) + insets.left;
                int y = this.getOffsetY(rowStartOffset, fontMetrics);
                Color foreground = this.getForeground();
                Color backgroundColor = this.getBackground();
                SortedMap<Integer, RowRangeMark> marker = this.rowMarkers.tailMap(row);
                Rectangle r2 = this.getBoundingBox(rowStartOffset);
                if (!marker.isEmpty()) {
                    RowRangeMark mark = (RowRangeMark)this.rowMarkers.get(marker.firstKey());
                    if (mark != null && mark.getStartRow() <= row && mark.getEndRow() >= row) {
                        backgroundColor = mark.getBackgroundColor();
                        if (mark.getStartRow() == row) {
                            mark.setViewPosition((mark.getEndRow() - mark.getStartRow() + 1) * fontMetrics.getHeight() / 2 + r2.y);
                        }
                    } else if (mark != null && mark.getStartRow() == row && mark.getEndRow() + 1 == row) {
                        g2.setColor(foreground);
                        g2.drawLine(x, r2.y, this.getWidth(), r2.y);
                        mark.setViewPosition(r2.y);
                    }
                }
                if (backgroundColor != null) {
                    g2.setColor(backgroundColor);
                    g2.fillRect(insets.left, r2.y, this.getWidth(), fontMetrics.getHeight());
                }
                if (this.isCurrentLine(rowStartOffset)) {
                    g2.setColor(this.getCurrentLineForeground());
                } else {
                    g2.setColor(foreground);
                }
                g2.drawString(lineNumber, x, y);
                rowStartOffset = Utilities.getRowEnd(this.component, rowStartOffset) + 1;
            }
            catch (Exception e2) {
                break;
            }
        }
    }

    private void resetViewPositions(SortedMap<Integer, RowRangeMark> rowMarkers) {
        for (RowRangeMark mark : rowMarkers.values()) {
            mark.setViewPosition(null);
        }
    }

    private boolean isCurrentLine(int rowStartOffset) {
        int caretPosition = this.component.getCaretPosition();
        Element root = this.component.getDocument().getDefaultRootElement();
        return root.getElementIndex(rowStartOffset) == root.getElementIndex(caretPosition);
    }

    public int getRow(int rowStartOffset) {
        int index;
        Element root = this.component.getDocument().getDefaultRootElement();
        Element line = root.getElement(index = root.getElementIndex(rowStartOffset));
        if (line.getStartOffset() == rowStartOffset) {
            return index;
        }
        return -1;
    }

    public int getBaseRow(int rowStartOffset) {
        Element root = this.component.getDocument().getDefaultRootElement();
        return root.getElementIndex(rowStartOffset);
    }

    protected String getTextLineNumber(int rowStartOffset) {
        int line = this.getRow(rowStartOffset);
        return this.getLineNumberText(line);
    }

    private String getLineNumberText(int line) {
        if (line < 0) {
            return "";
        }
        return String.valueOf(line + 1);
    }

    private int getOffsetX(int availableWidth, int stringWidth) {
        return (int)((float)(availableWidth - stringWidth) * this.digitAlignment);
    }

    private int getOffsetY(int rowStartOffset, FontMetrics fontMetrics) throws BadLocationException {
        Rectangle r2 = this.getBoundingBox(rowStartOffset);
        int y = r2.y + r2.height;
        int lineHeight = fontMetrics.getHeight();
        int descent = 0;
        if (r2.height == lineHeight) {
            descent = fontMetrics.getDescent();
        } else {
            if (this.fonts == null) {
                this.fonts = new HashMap();
            }
            Element root = this.component.getDocument().getDefaultRootElement();
            int index = root.getElementIndex(rowStartOffset);
            Element line = root.getElement(index);
            for (int i2 = 0; i2 < line.getElementCount(); ++i2) {
                Integer fontSize;
                Element child = line.getElement(i2);
                AttributeSet as = child.getAttributes();
                String fontFamily = (String)as.getAttribute(StyleConstants.FontFamily);
                String key = fontFamily + (fontSize = (Integer)as.getAttribute(StyleConstants.FontSize));
                FontMetrics fm = this.fonts.get(key);
                if (fm == null) {
                    Font font = new Font(fontFamily, 0, fontSize);
                    fm = this.component.getFontMetrics(font);
                    this.fonts.put(key, fm);
                }
                descent = Math.max(descent, fm.getDescent());
            }
        }
        return y - descent;
    }

    private Rectangle getBoundingBox(int rowStartOffset) throws BadLocationException {
        return this.component.modelToView(rowStartOffset);
    }

    @Override
    public void caretUpdate(CaretEvent e2) {
        int caretPosition = this.component.getCaretPosition();
        Element root = this.component.getDocument().getDefaultRootElement();
        int currentLine = root.getElementIndex(caretPosition);
        if (this.lastLine != currentLine) {
            this.getParent().repaint();
            this.lastLine = currentLine;
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e2) {
        this.documentChanged();
    }

    @Override
    public void insertUpdate(DocumentEvent e2) {
        this.documentChanged();
    }

    @Override
    public void removeUpdate(DocumentEvent e2) {
        this.documentChanged();
    }

    private void documentChanged() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    LineNumberRowHeaderView.this.resetViewPositions(LineNumberRowHeaderView.this.rowMarkers);
                    int endPos = LineNumberRowHeaderView.this.component.getDocument().getLength();
                    Rectangle rect = LineNumberRowHeaderView.this.component.modelToView(endPos);
                    if (rect != null && rect.y != LineNumberRowHeaderView.this.lastHeight) {
                        LineNumberRowHeaderView.this.setPreferredWidth();
                        LineNumberRowHeaderView.this.getParent().repaint();
                        LineNumberRowHeaderView.this.lastHeight = rect.y;
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        });
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getNewValue() instanceof Font) {
            if (this.updateFont) {
                Font newFont = (Font)evt.getNewValue();
                this.setFont(newFont);
                this.lastDigits = 0;
                this.setPreferredWidth();
            } else {
                this.getParent().repaint();
            }
        }
    }

    public SortedMap<Integer, RowRangeMark> getRowMarkers() {
        return this.rowMarkers;
    }

    public void setRowMarkers(SortedMap<Integer, RowRangeMark> rowMarkers) {
        this.rowMarkers = rowMarkers;
    }
}

