/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.common.smi.editor;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JProgressBar;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.snmp4j.util.WorkerTask;

public class FileLoader
implements Runnable,
WorkerTask {
    protected final Document doc;
    private final File f;
    protected final JTextArea editor;
    private boolean stop;

    public FileLoader(JTextArea editor, File f2, Document doc) {
        this.editor = editor;
        this.f = f2;
        this.doc = doc;
    }

    @Override
    public void run() {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    try {
                        FileLoader.this.doc.remove(0, FileLoader.this.doc.getLength());
                    }
                    catch (BadLocationException e2) {
                        e2.printStackTrace();
                    }
                }
            });
            if (this.f != null && this.f.canRead()) {
                int nch;
                final JProgressBar progress = new JProgressBar();
                progress.setMinimum(0);
                progress.setMaximum((int)this.f.length());
                FileReader in = new FileReader(this.f);
                char[] buff = new char[65535];
                while (!this.stop && (nch = ((Reader)in).read(buff, 0, buff.length)) != -1) {
                    final String text = new String(buff, 0, nch);
                    final int psize = nch;
                    try {
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    if (!FileLoader.this.stop) {
                                        FileLoader.this.doc.insertString(FileLoader.this.doc.getLength(), text, null);
                                        FileLoader.this.editor.setCaretPosition(0);
                                    }
                                }
                                catch (BadLocationException e2) {
                                    e2.printStackTrace();
                                }
                                progress.setValue(progress.getValue() + psize);
                            }
                        });
                    }
                    catch (InterruptedException | InvocationTargetException e2) {
                        e2.printStackTrace();
                    }
                }
                ((Reader)in).close();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        FileLoader.this.afterLoading();
                    }
                });
            }
        }
        catch (IOException e3) {
            System.err.println(e3.toString());
        }
        catch (InterruptedException | InvocationTargetException e4) {
            e4.printStackTrace();
        }
    }

    public void afterLoading() {
    }

    public void stopLoading() {
        this.stop = true;
    }

    @Override
    public void terminate() {
        this.stopLoading();
    }

    @Override
    public void join() throws InterruptedException {
    }

    @Override
    public void interrupt() {
        this.stopLoading();
    }
}

