/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.common.smi.editor;

import com.agentpp.common.smi.editor.RowRangeMark;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.util.Collections;
import java.util.SortedMap;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JViewport;

public class DiffConnectionViewPanel
extends JPanel {
    private final JTextArea leftEditor;
    private final JTextArea rightEditor;
    private SortedMap<Integer, RowRangeMark> leftSideMarks = Collections.emptySortedMap();
    private SortedMap<Integer, RowRangeMark> rightSideMarks = Collections.emptySortedMap();

    public DiffConnectionViewPanel(JTextArea leftEditor, JTextArea rightEditor) {
        this.leftEditor = leftEditor;
        this.rightEditor = rightEditor;
    }

    @Override
    protected void paintComponent(Graphics g2) {
        super.paintComponent(g2);
        for (RowRangeMark leftMark : this.leftSideMarks.values()) {
            RowRangeMark rightMark;
            if (leftMark.getViewPosition() == null || (rightMark = leftMark.getDiffMark()).getViewPosition() == null) continue;
            Graphics2D g22 = (Graphics2D)g2;
            RenderingHints rh = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            rh.add(new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY));
            g22.setRenderingHints(rh);
            g2.setColor(super.getForeground());
            JViewport leftViewPort = (JViewport)this.leftEditor.getParent();
            JViewport rightViewPort = (JViewport)this.rightEditor.getParent();
            if (leftViewPort == null || rightViewPort == null) continue;
            int leftY = leftViewPort.getViewPosition().y;
            int rightY = rightViewPort.getViewPosition().y;
            g2.drawLine(0, leftMark.getViewPosition() - leftY, this.getWidth(), rightMark.getViewPosition() - rightY);
        }
    }

    public SortedMap<Integer, RowRangeMark> getLeftSideMarks() {
        return this.leftSideMarks;
    }

    public void setLeftSideMarks(SortedMap<Integer, RowRangeMark> leftSideMarks) {
        this.leftSideMarks = leftSideMarks;
    }

    public SortedMap<Integer, RowRangeMark> getRightSideMarks() {
        return this.rightSideMarks;
    }

    public void setRightSideMarks(SortedMap<Integer, RowRangeMark> rightSideMarks) {
        this.rightSideMarks = rightSideMarks;
    }
}

