/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.common.smi;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Scanner;

public class ExtractSMI
implements Runnable {
    private InputStream is;
    private PrintStream os;
    private File outFileParent;
    private int maxSkip = 12;
    private int minSkip = 8;

    public ExtractSMI(InputStream is, PrintStream os) {
        this(is, os, 8, 12);
    }

    public ExtractSMI(InputStream is, PrintStream os, int minSkipping, int maxSkipping) {
        this.is = is;
        this.os = os;
        this.minSkip = minSkipping;
        this.maxSkip = maxSkipping;
    }

    public ExtractSMI(InputStream is, File outFileParent, int minSkip, int maxSkip) {
        this.is = is;
        this.outFileParent = outFileParent;
        this.maxSkip = maxSkip;
        this.minSkip = minSkip;
    }

    public static void main(String[] args) {
        try {
            ExtractSMI extractsmi = new ExtractSMI(new FileInputStream(args[0]), System.out);
            extractsmi.run();
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void run() {
        ArrayList<String> emptyLines = new ArrayList<String>();
        Scanner scanner = new Scanner(this.is);
        scanner.useDelimiter("[\n,\r]");
        String moduleBegin = null;
        while ((moduleBegin = scanner.findWithinHorizon("[A-Za-z0-9-]*[\\s]+(PIB-)?DEFINITIONS[\\s]+(::=)?[\\s]*BEGIN", 0)) != null) {
            if (this.outFileParent != null) {
                Scanner moduleNameScanner = new Scanner(moduleBegin);
                moduleNameScanner.useDelimiter("[\\s]+(PIB-)?DEFINITIONS[\\s]+(::=)?[\\s]*BEGIN");
                try {
                    try {
                        String moduleName = moduleNameScanner.next();
                        String parent = this.outFileParent.getParent();
                        String fileName = this.outFileParent.getName();
                        this.os = new PrintStream(Files.newOutputStream(new File(parent, moduleName + "_" + fileName).toPath(), new OpenOption[0]));
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        this.os = new PrintStream(Files.newOutputStream(new File(this.outFileParent.getPath()).toPath(), new OpenOption[0]));
                    }
                }
                catch (IOException e2) {
                    throw new RuntimeException(e2);
                }
            }
            this.os.println(moduleBegin);
            int skipping = 0;
            int inMacro = 0;
            while (inMacro > 0 || !scanner.hasNext("[\\s]*END[\\s]*")) {
                String nextLine;
                if (inMacro > 0 && scanner.hasNext("[\\s]*END[\\s]*")) {
                    skipping = 0;
                    --inMacro;
                    scanner.nextLine();
                    continue;
                }
                if (skipping > 0 && scanner.hasNext("[\\s]*RFC\\s.*")) {
                    skipping = 0;
                    emptyLines.clear();
                    scanner.nextLine();
                    continue;
                }
                String pageBreak = scanner.findInLine(".*\\[[pP]age [iv0-9]*\\].*");
                if (pageBreak != null) {
                    emptyLines.clear();
                    skipping = 1;
                } else {
                    String macro = scanner.findInLine("[A-Za-z0-9-]*[\\s]+MACRO[\\s]+::=");
                    if (macro != null) {
                        ++inMacro;
                        skipping = 0;
                        continue;
                    }
                }
                try {
                    nextLine = scanner.nextLine();
                }
                catch (NoSuchElementException nse) {
                    return;
                }
                if (inMacro > 0) continue;
                if (skipping > 0) {
                    if (++skipping > this.maxSkip) {
                        skipping = 0;
                        emptyLines.clear();
                        this.appendBufferText(emptyLines, nextLine);
                        continue;
                    }
                    if (nextLine.matches("[\\s]*")) {
                        emptyLines.add(nextLine);
                        continue;
                    }
                    if (skipping <= this.minSkip) continue;
                    emptyLines.clear();
                    skipping = 0;
                    this.appendBufferText(emptyLines, nextLine);
                    continue;
                }
                this.os.println(nextLine);
            }
            String moduleEnd = scanner.findWithinHorizon("[\\s]*END[\\s]*", 0);
            this.os.println(moduleEnd);
            if (this.outFileParent == null) continue;
            this.os.close();
            this.os = null;
        }
    }

    private void appendBufferText(List<String> emptyLines, String nextLine) {
        for (String line : emptyLines) {
            this.os.println(line);
        }
        emptyLines.clear();
        this.os.println(nextLine);
    }

    public InputStream getInputStream() {
        return this.is;
    }

    public PrintStream getOutputStream() {
        return this.os;
    }
}

