/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.common.setup;

import com.agentpp.common.MemoryStatus;
import com.agentpp.common.ProgressWatcher;
import com.agentpp.common.setup.AppDownloadInfo;
import com.agentpp.common.setup.JARInstaller;
import com.agentpp.util.OS;
import java.awt.Component;
import java.awt.Desktop;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.apache.commons.codec.binary.Base64;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.smi.OctetString;

public class JARUpdater {
    public static final String CFG_IGNORE_UPDATE = "update.check.ignore";
    public static final String CFG_UPDATE_BACKUP_FILE = "update.backup.file";
    public static final String UPDATE_URL = "https://updates.snmp.app";
    private static final String UPDATER_JAR = "commons-updater.jar";
    private String udapteURL = "https://updates.snmp.app";
    private static final int MBYTE = 0x100000;
    private static final int MIN_JAVA_VERSION_SUPPORTED = 9;
    private static final LogAdapter logger = LogFactory.getLogger(JARUpdater.class);

    public static boolean isInstallerBasedInstallation(File updateDir, String applicationDisplayName) {
        logger.debug((Serializable)((Object)("JARUpdater: updateDir=" + updateDir + "|getName=" + updateDir.getName())));
        if (updateDir.isDirectory() && updateDir.getName().equals("app")) {
            File configFile = new File(updateDir, applicationDisplayName + ".cfg");
            logger.debug((Serializable)((Object)("configFile:" + configFile)));
            return configFile.exists() && configFile.isFile() && configFile.canRead();
        }
        return false;
    }

    public JARUpdater(String updateURL) {
        if (updateURL != null) {
            this.udapteURL = updateURL;
        }
    }

    public static String getPathFor(Class clazz) {
        try {
            return clazz.getProtectionDomain().getCodeSource().getLocation().toURI().getPath();
        }
        catch (URISyntaxException e2) {
            e2.printStackTrace();
            throw new RuntimeException("Path for JAR with " + clazz.getName() + " not found:" + e2.getMessage(), e2);
        }
    }

    public UpdateResult checkForUpdate(int minJavaVersion, String applicationName, String applicationDisplayName, String currentVersion, byte[] id, UUID systemID) {
        URL updateURL = this.buildUpdateURL(applicationName, currentVersion, id, systemID);
        HttpURLConnection connection = null;
        try {
            connection = (HttpURLConnection)updateURL.openConnection();
            connection.setRequestMethod("GET");
            connection.setRequestProperty("Accept", "application/json");
            if (connection.getResponseCode() != 200) {
                connection.disconnect();
                return new UpdateResult(applicationName, applicationDisplayName, connection.getResponseCode(), null, null, null, null);
            }
            JsonReader jsonReader = Json.createReader((InputStream)connection.getContent());
            JsonObject jsonObject = jsonReader.readObject();
            UpdateResult updateResult = new UpdateResult(applicationName, applicationDisplayName, 200, jsonObject.getString("urlPrefix"), jsonObject.getString("update"), jsonObject.getString("latest"));
            updateResult.determineUpdateMethod(minJavaVersion);
            return updateResult;
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
    }

    private URL buildUpdateURL(String applicationName, String currentVersion, byte[] id, UUID systemID) {
        try {
            return new URL(this.udapteURL + "/" + applicationName + "/" + currentVersion + "/" + JARUpdater.anonymize(id) + "/" + JARUpdater.anonymize(systemID.toString().getBytes()));
        }
        catch (MalformedURLException e2) {
            throw new RuntimeException(e2);
        }
    }

    public UpdateResult downloadUpdate(int minJavaVersion, String applicationName, String applicationDisplayName, String currentVersion, byte[] license, UUID systemID, FileInfo targetVersion, ProgressWatcher progressWatcher) throws IOException {
        UpdateResult updateData = this.checkForUpdate(minJavaVersion, applicationName, applicationDisplayName, currentVersion, license, systemID);
        if (updateData.getStatusCode() == 200) {
            URL downloadURL = new URL(updateData.getDownloadURL());
            String destinationDir = updateData.getDownloadDestinationFile().getParent();
            File downloadPath = updateData.getDownloadDestinationFile();
            progressWatcher.progressEvent(0, (int)updateData.getUpdateVersion().getByteCount() / 0x100000, "...");
            File destDir = new File(destinationDir);
            if (!destDir.canWrite()) {
                updateData.downloadedFile = null;
                return updateData;
            }
            JARUpdater.downloadFile(downloadURL, updateData.getUpdateVersion(), downloadPath, progressWatcher);
            updateData.setDownloadedFile(downloadPath);
        }
        return updateData;
    }

    public static long downloadFile(URL source, FileInfo fileInfo, File destination, ProgressWatcher progressWatcher) throws IOException {
        try (ReadableByteChannel byteChannel = Channels.newChannel(source.openStream());){
            long l2;
            try (FileOutputStream fos = new FileOutputStream(destination);){
                InputStream fis;
                byte[] destHash;
                long count = 0L;
                long position = 0L;
                while ((count = fos.getChannel().transferFrom(byteChannel, position, 0x100000L)) > 0L) {
                    if (!progressWatcher.progressEvent((int)(position += count) / 0x100000, (int)fileInfo.getByteCount() / 0x100000, "Loaded... " + MemoryStatus.humanReadableByteCount(position))) continue;
                    throw new IOException("Download canceled by user!");
                }
                fos.close();
                byteChannel.close();
                if (position != fileInfo.getByteCount()) {
                    NumberFormat decimalFormat = DecimalFormat.getIntegerInstance();
                    throw new IOException("Downloaded file '" + destination + "' from '" + source + "' does not match expected size: " + decimalFormat.format(position) + " != " + decimalFormat.format(fileInfo.getByteCount()) + " (expected)");
                }
                if (!(fileInfo.getShaSum() == null || fileInfo.getShaSum().length <= 0 || (destHash = JARInstaller.computeSHA256AndCloseInputStream(fis = Files.newInputStream(destination.toPath(), new OpenOption[0]))) != null && Arrays.equals(destHash, fileInfo.getShaSum()))) {
                    if (destHash == null) {
                        throw new IOException("SHA-256 hash of downloaded file '" + destination + "' could not be determined");
                    }
                    throw new IOException("SHA-256 hash of downloaded file '" + destination + "' is " + new OctetString(destHash).toHexString() + " does not match source " + new OctetString(fileInfo.getShaSum()).toHexString());
                }
                l2 = position;
            }
            return l2;
        }
    }

    public static boolean copyFile(InputStream is, File destination) throws IOException {
        ReadableByteChannel byteChannel = Channels.newChannel(is);
        FileOutputStream fos = new FileOutputStream(destination);
        long count = 0L;
        long position = 0L;
        while ((count = fos.getChannel().transferFrom(byteChannel, position, 0x100000L)) > 0L) {
            position += count;
        }
        fos.close();
        byteChannel.close();
        return position > 0L;
    }

    public static void main(String[] args) {
        for (Map.Entry<String, String> envEntry : System.getenv().entrySet()) {
            System.out.println(envEntry.toString());
        }
        int minVersion = 9;
        if (!JARUpdater.isMinJavaVersionOS(minVersion)) {
            System.out.println("Java version is less than required: " + minVersion);
            System.exit(1);
        }
    }

    public static boolean isMinJavaVersionOS(int minVersion) {
        ProcessBuilder processBuilder = new ProcessBuilder("java", "--version");
        ProcessBuilder.Redirect output = processBuilder.redirectOutput();
        try {
            Process p2 = processBuilder.start();
            BufferedReader reader = new BufferedReader(new InputStreamReader(p2.getInputStream()));
            StringBuilder result = new StringBuilder(reader.readLine());
            StringBuilder versionString = new StringBuilder();
            for (int i2 = 0; i2 < result.length(); ++i2) {
                if (result.charAt(i2) >= '0' && result.charAt(i2) <= '9') {
                    versionString.append(result.charAt(i2));
                    continue;
                }
                if (versionString.length() > 0) break;
            }
            return minVersion <= Integer.parseInt(versionString.toString());
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return false;
        }
    }

    private static String anonymize(byte[] bytes) {
        try {
            MessageDigest sha2 = MessageDigest.getInstance("SHA-256");
            byte[] digest = sha2.digest(bytes);
            return Base64.encodeBase64URLSafeString(digest);
        }
        catch (NoSuchAlgorithmException e2) {
            throw new RuntimeException(e2);
        }
    }

    public static String getUpdateBackupFilePath(String pathApp, String versionOld) {
        return pathApp.substring(0, pathApp.length() - 4) + "-" + versionOld + ".jar";
    }

    public static class UpdateResult {
        private final String applicationName;
        private final String applicationDisplayName;
        private final String downloadUrlPrefix;
        private final FileInfo updateVersion;
        private final FileInfo latestVersion;
        private final int statusCode;
        private File downloadedFile;
        private final String updaterPath = JARUpdater.getPathFor(JARUpdater.class);
        private String downloadURL;
        private File downloadDestinationFile;
        private boolean osInstallerInstallationMethod = false;

        public UpdateResult(String applicationName, String applicationDisplayName, int statusCode, String downloadUrlPrefix, String updateVersion, String latestVersion) {
            this.applicationName = applicationName;
            this.applicationDisplayName = applicationDisplayName;
            this.statusCode = statusCode;
            this.downloadUrlPrefix = downloadUrlPrefix;
            this.updateVersion = updateVersion != null && updateVersion.length() >= 5 ? new FileInfo(updateVersion.split(":")) : null;
            this.latestVersion = latestVersion != null && latestVersion.length() >= 5 ? new FileInfo(latestVersion.split(":")) : null;
        }

        public UpdateResult(String applicationName, String applicationDisplayName, int statusCode, String downloadUrlPrefix, FileInfo updateVersion, FileInfo latestVersion, File downloadedFile) {
            this.applicationName = applicationName;
            this.applicationDisplayName = applicationDisplayName;
            this.downloadUrlPrefix = downloadUrlPrefix;
            this.updateVersion = updateVersion;
            this.latestVersion = latestVersion;
            this.statusCode = statusCode;
            this.downloadedFile = downloadedFile;
        }

        public String getDownloadUrlPrefix() {
            return this.downloadUrlPrefix;
        }

        public FileInfo getUpdateVersion() {
            return this.updateVersion;
        }

        public FileInfo getLatestVersion() {
            return this.latestVersion;
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public File getDownloadedFile() {
            return this.downloadedFile;
        }

        public void setDownloadedFile(File downloadedFile) {
            this.downloadedFile = downloadedFile;
        }

        public String getUpdateDirectory() {
            return new File(this.updaterPath).getParent();
        }

        public String getCurrentJarPath() {
            return this.updaterPath;
        }

        public String getApplicationName() {
            return this.applicationName;
        }

        public String getDownloadURL() {
            return this.downloadURL;
        }

        public File getDownloadDestinationFile() {
            return this.downloadDestinationFile;
        }

        public boolean isOsInstallerInstallationMethod() {
            return this.osInstallerInstallationMethod;
        }

        public boolean determineUpdateMethod(int minJavaVersion) throws IOException {
            AppDownloadInfo downloadInfo = this.updateVersion.osInstaller.get(OS.type.name().toLowerCase());
            if (downloadInfo != null && this.isInstallerBasedInstallation()) {
                this.downloadDestinationFile = File.createTempFile(this.applicationName + "-" + this.updateVersion.getVersion(), downloadInfo.getInstallerFileNameSuffix());
                this.downloadDestinationFile.setExecutable(true, true);
                this.downloadURL = this.getDownloadUrlPrefix() + this.updateVersion.getVersion() + downloadInfo.getInstallerFileNameSuffix();
                this.osInstallerInstallationMethod = true;
                this.updateVersion.selectedInstaller = downloadInfo;
                return true;
            }
            if (JARUpdater.isMinJavaVersionOS(minJavaVersion)) {
                this.downloadURL = this.getDownloadUrlPrefix() + this.updateVersion.getVersion() + ".jar";
                String destinationDir = this.getUpdateDirectory();
                String downloadFilename = this.applicationName + "-" + this.updateVersion.getVersion() + ".jar";
                this.downloadDestinationFile = new File(destinationDir, downloadFilename);
                this.osInstallerInstallationMethod = false;
            }
            return false;
        }

        private boolean isInstallerBasedInstallation() {
            File parentDir = new File(this.getUpdateDirectory());
            return JARUpdater.isInstallerBasedInstallation(parentDir, this.applicationDisplayName);
        }

        public String toString() {
            return "UpdateResult{applicationName='" + this.applicationName + "', downloadUrlPrefix='" + this.downloadUrlPrefix + "', updateVersion=" + this.updateVersion + ", latestVersion=" + this.latestVersion + ", statusCode=" + this.statusCode + ", downloadedFile='" + this.downloadedFile + "', updaterPath='" + this.updaterPath + "', downloadURL='" + this.downloadURL + "', downloadDestinationFile=" + this.downloadDestinationFile + ", osInstallerInstallationMethod=" + this.osInstallerInstallationMethod + "}";
        }
    }

    public static class FileInfo {
        String version;
        byte[] shaSum;
        long byteCount;
        Map<String, AppDownloadInfo> osInstaller = new HashMap<String, AppDownloadInfo>();
        AppDownloadInfo selectedInstaller = null;

        public FileInfo(String version, String byteCount, String shaSum) {
            this.version = version;
            this.shaSum = OctetString.fromString(shaSum, 16).getValue();
            this.byteCount = Long.parseLong(byteCount);
        }

        public FileInfo(String[] info) {
            this(info[0], info[1], info[2]);
            try {
                int i2 = 3;
                while (i2 + 3 < info.length) {
                    AppDownloadInfo appDownloadInfo = new AppDownloadInfo(this.version, info[i2 + 1], Long.parseLong(info[i2 + 2].trim()), OctetString.fromHexStringPairs(info[i2 + 3].trim()).getValue());
                    this.osInstaller.put(info[i2], appDownloadInfo);
                    i2 += 4;
                }
            }
            catch (Exception ex) {
                System.err.println("Parsing OS specific installer data failed: " + ex.getMessage());
            }
        }

        public String getVersion() {
            return this.version;
        }

        public byte[] getShaSum() {
            if (this.selectedInstaller != null) {
                return this.selectedInstaller.getInstallerHash();
            }
            return this.shaSum;
        }

        public long getByteCount() {
            if (this.selectedInstaller != null) {
                return this.selectedInstaller.getByteCount();
            }
            return this.byteCount;
        }

        public Map<String, AppDownloadInfo> getOsInstaller() {
            return this.osInstaller;
        }

        public String toString() {
            return this.version + " [ " + MemoryStatus.humanReadableByteCount(this.byteCount) + " | shaSum=" + OctetString.fromByteArray(this.shaSum).toHexString() + ", osInstaller=" + this.osInstaller + " ]";
        }

        public String getVersionDescription() {
            return this.version + " (" + MemoryStatus.humanReadableByteCount(this.byteCount) + ")";
        }

        public String getHashHexString() {
            return OctetString.fromByteArray(this.shaSum).toHexString();
        }
    }

    public static class UpdateChecker
    implements Runnable {
        private final Component parentComponent;
        private String updateURL;
        private final byte[] license;
        private final String currentVersion;
        private final String applicationName;
        private final String applicationDisplayName;
        private final UUID systemID;
        private UpdateResult updateResult;
        private CheckResult checkResult = CheckResult.none;
        private final Runnable runBeforeExiting;
        private Runnable processResult;
        private final String ignoreUpdate;
        private int minJavaVersion;

        public UpdateChecker(Component parentComponent, String updateURL, int minJavaVersion, String applicationDisplayName, String applicationName, byte[] id, String currentVersion, UUID systemID, Runnable runBeforeExiting, Runnable processResult, String ignoreUpdate) {
            this.parentComponent = parentComponent;
            this.updateURL = updateURL;
            this.license = id;
            this.currentVersion = currentVersion;
            this.applicationName = applicationName;
            this.applicationDisplayName = applicationDisplayName;
            this.systemID = systemID;
            this.runBeforeExiting = runBeforeExiting;
            this.processResult = processResult;
            this.ignoreUpdate = ignoreUpdate;
            this.minJavaVersion = minJavaVersion;
        }

        public String getCurrentVersion() {
            return this.currentVersion;
        }

        public Runnable getProcessResult() {
            return this.processResult;
        }

        public void setProcessResult(Runnable processResult) {
            this.processResult = processResult;
        }

        @Override
        public void run() {
            block2: {
                try {
                    this.checkForUpdateUI(this.minJavaVersion, this.updateURL, this.applicationName, this.currentVersion, this.license, this.systemID, this.runBeforeExiting, this.processResult, this.ignoreUpdate);
                }
                catch (RuntimeException rte) {
                    rte.printStackTrace();
                    this.checkResult = CheckResult.errorOnUpdateCheck;
                    this.updateResult = new UpdateResult(this.applicationName, this.applicationDisplayName, -1, null, "", "");
                    if (this.processResult == null) break block2;
                    this.processResult.run();
                }
            }
        }

        public void checkForUpdateUI(int minJavaVersion, String updateURL, String applicationName, String currentVersion, byte[] license, UUID systemID, Runnable runBeforeExiting, Runnable processResult, String ignoreUpdate) {
            JARUpdater jarUpdater = new JARUpdater(updateURL);
            this.updateResult = jarUpdater.checkForUpdate(minJavaVersion, applicationName, this.applicationDisplayName, currentVersion, license, systemID);
            if (this.updateResult.statusCode == 200) {
                String updateversion = this.updateResult.getUpdateVersion().getVersion();
                if (!(currentVersion.equals(updateversion) || ignoreUpdate != null && ignoreUpdate.equals(updateversion))) {
                    this.checkResult = CheckResult.updateAvailable;
                    SwingUtilities.invokeLater(() -> {
                        int option = JOptionPane.showOptionDialog(this.parentComponent, new String[]{"A new " + this.applicationDisplayName + " version " + this.updateResult.getUpdateVersion().getVersionDescription() + " is available!", "Update method is: " + (this.updateResult.isOsInstallerInstallationMethod() ? "OS specific installer with runtime update" : "In-place JAR update"), " ", "Download URL is:", this.updateResult.getDownloadURL() + " ", "Select Cancel if you have not saved your current work yet!"}, "Update Available", 1, 1, null, new String[]{"Download & Restart", "Skip this Version", "Cancel"}, "Download & Restart");
                        if (option == 0) {
                            this.checkResult = CheckResult.updateError;
                            ProgressWatcher progressWatcher = new ProgressWatcher(this.parentComponent, "Downloading " + this.updateResult.getDownloadUrlPrefix() + ":");
                            Thread updaterThread = new Thread(() -> {
                                try {
                                    UpdateResult updateExecResult = jarUpdater.downloadUpdate(minJavaVersion, applicationName, this.applicationDisplayName, currentVersion, license, systemID, this.updateResult.getUpdateVersion(), progressWatcher);
                                    if (updateExecResult.getDownloadedFile() != null) {
                                        this.checkResult = CheckResult.updated;
                                        this.updateResult = updateExecResult;
                                        this.doUpdate(updateExecResult, applicationName, currentVersion, runBeforeExiting);
                                    } else {
                                        SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(this.parentComponent, new String[]{"Update not possible because Application directory is not writable.", "Please visit https://agentpp.com/download.html to download the update."}, "Update Download Error", 2));
                                    }
                                }
                                catch (IOException e2) {
                                    e2.printStackTrace();
                                    SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(this.parentComponent, "Update operation failed: " + e2.getMessage(), "Update Failed", 0));
                                }
                            });
                            updaterThread.start();
                        } else if (option == 1) {
                            this.checkResult = CheckResult.updateIgnored;
                        }
                        if (processResult != null) {
                            processResult.run();
                        }
                    });
                    return;
                }
                this.checkResult = !this.updateResult.getLatestVersion().getVersion().equals(currentVersion) ? CheckResult.upgradeAvailable : CheckResult.upToDate;
            } else {
                this.checkResult = CheckResult.errorOnUpdateCheck;
            }
            if (processResult != null) {
                processResult.run();
            }
        }

        private void doUpdate(UpdateResult updateResult, String applicationName, String currentVersion, Runnable runBeforeExiting) throws IOException {
            if (updateResult.isOsInstallerInstallationMethod()) {
                File installerFile = updateResult.getDownloadedFile();
                Desktop.getDesktop().open(installerFile);
            } else {
                File updaterJAR = File.createTempFile(applicationName + "-updater", ".jar", new File(updateResult.getUpdateDirectory()));
                InputStream updaterJarStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(JARUpdater.UPDATER_JAR);
                if (updaterJarStream == null) {
                    System.err.println("Updater JAR not found at: commons-updater.jar");
                    throw new IOException("Internal error: Cannot find 'commons-updater.jar' in current JAR");
                }
                boolean success = JARUpdater.copyFile(updaterJarStream, updaterJAR);
                if (success) {
                    System.out.println("Saved updater to " + updaterJAR);
                } else {
                    System.err.println("Failed to save updater JAR to " + updaterJAR);
                }
                String[] commandLine = new String[]{"java", "-jar", updaterJAR.getAbsolutePath(), updateResult.getCurrentJarPath(), updateResult.getDownloadedFile().getAbsolutePath(), currentVersion, updaterJAR.getAbsolutePath()};
                if (this.processResult != null) {
                    this.processResult.run();
                }
                if (runBeforeExiting != null) {
                    runBeforeExiting.run();
                }
                System.out.println("Executing: " + Arrays.asList(commandLine));
                Process p2 = new ProcessBuilder(commandLine).redirectOutput(ProcessBuilder.Redirect.DISCARD).redirectError(ProcessBuilder.Redirect.DISCARD).start();
                System.out.println("Updater process started:" + p2.pid());
            }
            try {
                Thread.sleep(4000L);
            }
            catch (InterruptedException e2) {
                e2.printStackTrace();
            }
            System.exit(0);
        }

        public UpdateResult getUpdateResult() {
            return this.updateResult;
        }

        public CheckResult getCheckResult() {
            return this.checkResult;
        }
    }

    public static enum CheckResult {
        none,
        errorOnUpdateCheck,
        upToDate,
        updateAvailable,
        updateIgnored,
        upgradeAvailable,
        updateError,
        updated;

    }
}

