/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.common.setup;

import com.agentpp.common.ConfirmCallback;
import com.agentpp.common.StandardDialog;
import com.agentpp.common.setup.FileOverwritingCheckPanel;
import com.agentpp.common.setup.InstallOverwriteStatus;
import com.agentpp.repository.ProgressCallback;
import com.agentpp.util.BaseConfig;
import java.awt.Frame;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;

public class JARInstaller {
    private static final int BUFFER_SIZE = 65535;
    private static final String SHA_256_DIGEST_ATTR_NAME = "SHA-256-Digest";
    private BaseConfig config;
    private String propertyPrefix;
    private ClassLoader classLoader;
    private String jarName = "install.jar";
    private boolean fileNamesOnly;
    public static final String INSTALLATION_DIR = "installedPath";
    public static final String INSTALLATION_VERSION = "installedVersion";
    private static final String MANIFEST_VERSION_ATTR = "Implementation-Version";
    private static final String META_INF_DIR = "META-INF/";
    public static final int IO_ERROR = -1;
    public static final int NO_INSTALL = 0;
    public static final int INSTALL_NEW = 1;
    public static final int UPDATE_EXISTING = 2;

    public JARInstaller(BaseConfig config, String propertyPrefix, ClassLoader classLoader) {
        this.config = config;
        this.propertyPrefix = propertyPrefix;
        this.classLoader = classLoader;
    }

    public JARInstaller(BaseConfig config, String propertyPrefix, ClassLoader classLoader, String jarName) {
        this.config = config;
        this.propertyPrefix = propertyPrefix;
        this.classLoader = classLoader;
        this.jarName = jarName;
    }

    public JARInstaller(BaseConfig config, String propertyPrefix, ClassLoader classLoader, String jarName, boolean fileNamesOnly) {
        this.config = config;
        this.propertyPrefix = propertyPrefix;
        this.classLoader = classLoader;
        this.jarName = jarName;
        this.fileNamesOnly = fileNamesOnly;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int needInstallation() {
        InputStream is = this.classLoader.getResourceAsStream(this.jarName);
        if (is == null) {
            return 0;
        }
        try {
            JarInputStream jis = new JarInputStream(is, false);
            Manifest manifest = jis.getManifest();
            String version = JARInstaller.getVersion(manifest);
            if (version == null) {
                System.err.println("No manifest/version info in " + this.jarName + " -> no installation");
                int n2 = 0;
                return n2;
            }
            String installed = this.config.get(this.propertyPrefix + INSTALLATION_VERSION, null);
            File installDir = this.getInstallationDirectory();
            if (installed == null || installDir == null || !installDir.exists()) {
                int n3 = 1;
                return n3;
            }
            if (version.compareTo(installed) != 0) {
                System.out.println("Installation files version is '" + installed + "', available is '" + version + "', requesting update...");
                int n4 = 2;
                return n4;
            }
            int n5 = 0;
            return n5;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            int n6 = -1;
            return n6;
        }
        finally {
            try {
                is.close();
            }
            catch (IOException ex1) {
                ex1.printStackTrace();
            }
        }
    }

    public File getInstallationDirectory() {
        String installDir = this.config.get(this.propertyPrefix + INSTALLATION_DIR, null);
        if (installDir == null) {
            return null;
        }
        return new File(installDir);
    }

    private static String getVersion(Manifest manifest) {
        if (manifest == null) {
            return null;
        }
        return manifest.getMainAttributes().getValue(MANIFEST_VERSION_ATTR);
    }

    public boolean install(File installPath, ProgressCallback progress, ConfirmCallback confirmCallback) {
        InputStream is = this.classLoader.getResourceAsStream(this.jarName);
        return JARInstaller.install(is, installPath, this.config, this.propertyPrefix, progress, this.fileNamesOnly, confirmCallback);
    }

    public boolean install(Frame parent, File installPath, ProgressCallback progress) {
        InputStream is = this.classLoader.getResourceAsStream(this.jarName);
        Map<String, InstallOverwriteStatus> files = JARInstaller.testInstall(is, installPath, progress, this.fileNamesOnly);
        int overwriteCount = JARInstaller.countOverwriteStatus(files, InstallOverwriteStatus.OverwriteStatus.overwrite);
        if (overwriteCount > 0) {
            FileOverwritingCheckPanel fileOverwritingCheckPanel = new FileOverwritingCheckPanel(files);
            StandardDialog standardDialog = new StandardDialog(parent, "Confirm Updated Files", true, true);
            standardDialog.setLocationRelativeTo(parent);
            standardDialog.setCenterPanel(fileOverwritingCheckPanel.getPanel());
            standardDialog.setVisible(true);
            if (standardDialog.getResult() == 0) {
                is = this.classLoader.getResourceAsStream(this.jarName);
                return JARInstaller.commitInstall(is, installPath, this.config, this.propertyPrefix, progress, this.fileNamesOnly, fileOverwritingCheckPanel.getConfirmationStatus());
            }
        } else {
            is = this.classLoader.getResourceAsStream(this.jarName);
            return JARInstaller.commitInstall(is, installPath, this.config, this.propertyPrefix, progress, this.fileNamesOnly, files);
        }
        return true;
    }

    public static int countOverwriteStatus(Map<String, InstallOverwriteStatus> confirmations, InstallOverwriteStatus.OverwriteStatus statusToCount) {
        int counter = 0;
        if (confirmations != null) {
            for (InstallOverwriteStatus status : confirmations.values()) {
                if (status.overwriteStatus != statusToCount) continue;
                ++counter;
            }
        }
        return counter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, InstallOverwriteStatus> testInstall(InputStream is, File installPath, ProgressCallback progress, boolean fileNamesOnly) {
        if (is == null) {
            throw new NullPointerException("Installer JAR not found");
        }
        HashMap<String, InstallOverwriteStatus> status = new HashMap<String, InstallOverwriteStatus>();
        try {
            JarInputStream jis = new JarInputStream(is, false);
            int available = jis.available();
            Manifest manifest = jis.getManifest();
            int totalRead = 0;
            JarEntry entry = jis.getNextJarEntry();
            while (entry != null) {
                block26: {
                    String path = entry.getName();
                    File outputFile = new File(installPath, path);
                    if (!entry.isDirectory()) {
                        if (progress != null) {
                            String progressText = "checking " + outputFile;
                            progress.progressEvent(totalRead, available, progressText);
                        }
                        if (!path.startsWith(META_INF_DIR)) {
                            if (outputFile.exists()) {
                                try {
                                    Attributes attributes = manifest.getAttributes(entry.getName());
                                    if (attributes != null) {
                                        String sha256 = attributes.getValue(SHA_256_DIGEST_ATTR_NAME);
                                        if (sha256 != null) {
                                            FileInputStream existingFileInputStream = new FileInputStream(outputFile);
                                            byte[] digestOld = JARInstaller.computeSHA256AndCloseInputStream(existingFileInputStream);
                                            String sha256Old = Base64.getEncoder().encodeToString(digestOld);
                                            if (sha256.equals(sha256Old)) {
                                                status.put(path, new InstallOverwriteStatus(outputFile, sha256, InstallOverwriteStatus.OverwriteStatus.skip));
                                            } else {
                                                status.put(path, new InstallOverwriteStatus(outputFile, sha256Old, InstallOverwriteStatus.OverwriteStatus.overwrite));
                                            }
                                        } else {
                                            status.put(path, new InstallOverwriteStatus(outputFile, null, InstallOverwriteStatus.OverwriteStatus.overwrite));
                                        }
                                        break block26;
                                    }
                                    status.put(path, new InstallOverwriteStatus(outputFile, null, InstallOverwriteStatus.OverwriteStatus.overwrite));
                                }
                                catch (Exception ex) {
                                    ex.printStackTrace();
                                }
                            } else {
                                status.put(path, new InstallOverwriteStatus(outputFile, null, InstallOverwriteStatus.OverwriteStatus.add));
                            }
                        }
                    }
                }
                entry = jis.getNextJarEntry();
            }
            if (progress != null) {
                progress.progressEvent(-1, available, "update check done, waiting for confirmation...");
            }
            HashMap<String, InstallOverwriteStatus> hashMap = status;
            return hashMap;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            Map<String, InstallOverwriteStatus> map = null;
            return map;
        }
        finally {
            try {
                is.close();
            }
            catch (IOException ex1) {
                ex1.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean commitInstall(InputStream is, File installPath, BaseConfig config, String propertyPrefix, ProgressCallback progress, boolean fileNamesOnly, Map<String, InstallOverwriteStatus> confirmations) {
        if (is == null) {
            System.err.println("Installer JAR not found");
            return false;
        }
        SimpleDateFormat uniqueSuffixFormat = new SimpleDateFormat("ddMMyy-hhmmss.SSS");
        String uniqueSuffix = "." + uniqueSuffixFormat.format(new Date()) + ".bak";
        try {
            JarInputStream jis = new JarInputStream(is, false);
            int available = jis.available();
            Manifest manifest = jis.getManifest();
            int totalRead = 0;
            JarEntry entry = jis.getNextJarEntry();
            while (entry != null) {
                String path = entry.getName();
                File outputFile = new File(installPath, path);
                if (entry.isDirectory()) {
                    if (!outputFile.exists() && !outputFile.mkdirs()) {
                        System.err.println("Failed to create directory '" + outputFile + "'");
                    }
                } else {
                    InstallOverwriteStatus status = confirmations.get(path);
                    if (status != null) {
                        if (status.overwriteStatus == null) {
                            status.setOverwriteStatus(InstallOverwriteStatus.OverwriteStatus.skip);
                        }
                        if (status.overwriteStatus != InstallOverwriteStatus.OverwriteStatus.skip) {
                            File renameToFile;
                            File renamedFile2;
                            if (progress != null) {
                                Object progressText = fileNamesOnly ? outputFile.getName() : "Writing " + outputFile;
                                progress.progressEvent(totalRead, available, (String)progressText);
                            }
                            if (!(path.startsWith(META_INF_DIR) || outputFile.exists() && status.overwriteStatus == InstallOverwriteStatus.OverwriteStatus.add && !(renamedFile2 = new File(outputFile.getPath())).renameTo(renameToFile = new File(outputFile.getPath() + uniqueSuffix)))) {
                                int read;
                                if (!outputFile.getParentFile().exists() && !outputFile.getParentFile().mkdirs()) {
                                    progress.progressEvent(totalRead, available, "Failed to create directory for file '" + outputFile + "'");
                                    System.err.println("Failed to create directory for file '" + outputFile + "'");
                                    boolean renamedFile2 = false;
                                    return renamedFile2;
                                }
                                FileOutputStream os = new FileOutputStream(outputFile);
                                byte[] buf = new byte[65535];
                                while ((read = jis.read(buf)) >= 0) {
                                    totalRead += read;
                                    os.write(buf, 0, read);
                                }
                                os.flush();
                                os.close();
                            }
                        }
                    }
                }
                entry = jis.getNextJarEntry();
            }
            if (progress != null) {
                progress.progressEvent(-1, available, "done");
            }
            if (config != null) {
                config.put(propertyPrefix + INSTALLATION_DIR, installPath.getPath());
                config.put(propertyPrefix + INSTALLATION_VERSION, JARInstaller.getVersion(manifest));
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                is.close();
            }
            catch (IOException ex1) {
                ex1.printStackTrace();
            }
        }
    }

    /*
     * Exception decompiling
     */
    public static boolean install(InputStream is, File installPath, BaseConfig config, String propertyPrefix, ProgressCallback progress, boolean fileNamesOnly, ConfirmCallback confirmCallback) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Statement already marked as first in another block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.markFirstStatementInBlock(Op03SimpleStatement.java:461)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Misc.markWholeBlock(Misc.java:251)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ConditionalRewriter.considerAsSimpleIf(ConditionalRewriter.java:673)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ConditionalRewriter.identifyNonjumpingConditionals(ConditionalRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:760)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void setJarName(String jarName) {
        this.jarName = jarName;
    }

    public String getJarName() {
        return this.jarName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] computeSHA256AndCloseInputStream(InputStream is) {
        byte[] buffer = new byte[65535];
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException ex) {
            return null;
        }
        try {
            try {
                int read;
                while ((read = is.read(buffer)) > 0) {
                    md.update(buffer, 0, read);
                }
            }
            catch (IOException ex1) {
                byte[] byArray = null;
                try {
                    is.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return byArray;
            }
        }
        finally {
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
        return md.digest();
    }
}

