/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.common.setup;

import com.agentpp.common.TableSorter;
import com.agentpp.common.setup.InstallOverwriteStatus;
import com.agentpp.common.table.ExtendedListTable;
import com.agentpp.common.table.TableUtils;
import com.klg.jclass.cell.JCCellInfo;
import com.klg.jclass.cell.renderers.JCLabelCellRenderer;
import com.klg.jclass.table.data.JCVectorDataSource;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class FileOverwritingCheckPanel {
    private static final String[] COLUMS = new String[]{"Path", "Update Needed?", "Selected Operation"};
    private static final int COL_PATH = 0;
    private static final int COL_UPDATED_NEEDED = 1;
    private static final int COL_OPERATION = 2;
    private ExtendedListTable filesTable;
    private JCheckBox checkBoxSelectAll;
    private JComboBox assignNewStatus;
    private JPanel panel;
    private JLabel labelAction;
    private TableSorter tableSorter;
    private JCVectorDataSource tableModel;
    private Map<String, InstallOverwriteStatus> fileList;

    public FileOverwritingCheckPanel(final Map<String, InstallOverwriteStatus> fileList) {
        this.$$$setupUI$$$();
        this.fileList = new TreeMap<String, InstallOverwriteStatus>(fileList);
        this.tableModel = new JCVectorDataSource();
        this.tableModel.setColumnLabels(COLUMS);
        this.tableModel.setNumRows(0);
        this.tableModel.setNumColumns(COLUMS.length);
        this.filesTable.setDataSource(this.tableModel);
        this.filesTable.setVertSBDisplay(0);
        this.filesTable.setHorizSBDisplay(0);
        this.filesTable.setVisibleRows(20);
        this.filesTable.setColumnHidden(-1, true);
        this.tableSorter = new TableSorter(this.filesTable, this.tableModel);
        for (Map.Entry<String, InstallOverwriteStatus> entry : this.fileList.entrySet()) {
            Vector<Object> row = new Vector<Object>(COLUMS.length);
            row.add(entry.getKey());
            row.add(entry.getValue().getOverwriteStatus() == InstallOverwriteStatus.OverwriteStatus.overwrite || entry.getValue().getOverwriteStatus() == InstallOverwriteStatus.OverwriteStatus.add ? "yes" : "no");
            row.add(entry.getValue());
            this.tableModel.addRow(Integer.MAX_VALUE, null, row);
        }
        this.filesTable.setSelectionPolicy(3);
        this.filesTable.setPixelWidth(-997, 33002);
        this.filesTable.setCellRenderer(InstallOverwriteStatus.OverwriteStatus.class, new JCLabelCellRenderer(){

            @Override
            public Component getRendererComponent(JCCellInfo jcCellInfo, Object o2, boolean b2) {
                JLabel label = (JLabel)super.getRendererComponent(jcCellInfo, o2, b2);
                label.setText(o2.toString());
                return label;
            }
        });
        this.filesTable.setCellRenderer(InstallOverwriteStatus.class, new JCLabelCellRenderer(){

            @Override
            public Component getRendererComponent(JCCellInfo jcCellInfo, Object o2, boolean b2) {
                JLabel label = (JLabel)super.getRendererComponent(jcCellInfo, o2, b2);
                label.setText(((InstallOverwriteStatus)o2).getOverwriteStatus().toString());
                return label;
            }
        });
        this.checkBoxSelectAll.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e2) {
                if (e2.getStateChange() == 1) {
                    FileOverwritingCheckPanel.this.filesTable.setRowSelection(0, Integer.MAX_VALUE);
                } else {
                    FileOverwritingCheckPanel.this.filesTable.clearSelection();
                }
            }
        });
        this.assignNewStatus.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e2) {
                if (e2.getStateChange() == 1 && !"".equals(e2.getItem())) {
                    FileOverwritingCheckPanel.this.filesTable.setRepaintEnabled(false);
                    int[] selectedRows = TableUtils.getSelectedRows(FileOverwritingCheckPanel.this.filesTable);
                    InstallOverwriteStatus.OverwriteStatus newStatus = null;
                    if (!"default".equals(FileOverwritingCheckPanel.this.assignNewStatus.getSelectedItem())) {
                        newStatus = InstallOverwriteStatus.OverwriteStatus.valueOf(Objects.requireNonNull(FileOverwritingCheckPanel.this.assignNewStatus.getSelectedItem()).toString());
                    }
                    for (int row : selectedRows) {
                        InstallOverwriteStatus currentStatus;
                        String path;
                        InstallOverwriteStatus status;
                        InstallOverwriteStatus.OverwriteStatus newRowStatus = newStatus;
                        if (newRowStatus == null && (status = (InstallOverwriteStatus)fileList.get(path = (String)FileOverwritingCheckPanel.this.tableModel.getTableDataItem(row, 0))) != null) {
                            newRowStatus = status.overwriteStatus;
                        }
                        if ((currentStatus = (InstallOverwriteStatus)FileOverwritingCheckPanel.this.tableModel.getTableDataItem(row, 2)) != null) {
                            currentStatus.setOverwriteStatus(newRowStatus);
                        } else {
                            currentStatus = new InstallOverwriteStatus(new File((String)FileOverwritingCheckPanel.this.tableModel.getTableDataItem(row, 0)), null, newRowStatus);
                        }
                        FileOverwritingCheckPanel.this.tableModel.setCell(row, 2, currentStatus);
                    }
                    FileOverwritingCheckPanel.this.filesTable.setRepaintEnabled(true);
                    FileOverwritingCheckPanel.this.filesTable.repaint();
                    FileOverwritingCheckPanel.this.assignNewStatus.setSelectedIndex(0);
                }
            }
        });
    }

    public Map<String, InstallOverwriteStatus> getConfirmationStatus() {
        TreeMap<String, InstallOverwriteStatus> result = new TreeMap<String, InstallOverwriteStatus>(this.fileList);
        for (int i2 = 0; i2 < this.tableModel.getNumRows(); ++i2) {
            InstallOverwriteStatus newOverwriteStatus = (InstallOverwriteStatus)this.tableModel.getTableDataItem(i2, 2);
            this.fileList.put((String)this.tableModel.getTableDataItem(i2, 0), newOverwriteStatus);
        }
        return result;
    }

    public JPanel getPanel() {
        return this.panel;
    }

    private void $$$setupUI$$$() {
        this.panel = new JPanel();
        this.panel.setLayout(new GridBagLayout());
        this.filesTable = new ExtendedListTable();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 3;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(10, 10, 10, 10);
        this.panel.add((Component)this.filesTable, gbc);
        JPanel spacer1 = new JPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.fill = 3;
        this.panel.add((Component)spacer1, gbc);
        this.checkBoxSelectAll = new JCheckBox();
        this.checkBoxSelectAll.setText("Select All / Unselect All");
        this.checkBoxSelectAll.setToolTipText("Select all files");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.anchor = 17;
        gbc.insets = new Insets(10, 10, 10, 10);
        this.panel.add((Component)this.checkBoxSelectAll, gbc);
        this.assignNewStatus = new JComboBox();
        DefaultComboBoxModel<String> defaultComboBoxModel1 = new DefaultComboBoxModel<String>();
        defaultComboBoxModel1.addElement("");
        defaultComboBoxModel1.addElement("default");
        defaultComboBoxModel1.addElement("overwrite");
        defaultComboBoxModel1.addElement("skip");
        defaultComboBoxModel1.addElement("add");
        this.assignNewStatus.setModel(defaultComboBoxModel1);
        this.assignNewStatus.setToolTipText("Choose the new status for the selected files (empty = no change)");
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 2;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.insets = new Insets(10, 10, 10, 10);
        this.panel.add((Component)this.assignNewStatus, gbc);
        this.labelAction = new JLabel();
        this.labelAction.setText("Change Selected:");
        this.labelAction.setToolTipText("");
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.anchor = 13;
        gbc.insets = new Insets(10, 15, 10, 0);
        this.panel.add((Component)this.labelAction, gbc);
    }

    public JComponent $$$getRootComponent$$$() {
        return this.panel;
    }
}

