/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.common.net;

import com.agentpp.common.OptionPanel;
import com.agentpp.common.PreferencesItem;
import com.agentpp.util.UserConfigFile;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ProxySettings
implements OptionPanel,
PreferencesItem {
    public static final String CFG_PROXY_USE_SYSTEM = "java.net.useSystemProxies";
    public static final String CFG_PROXY_HOST = "https.proxyHost";
    public static final String CFG_PROXY_PORT = "https.proxyPort";
    public static final String CFG_PROXY_USER = "http.proxyUser";
    public static final String CFG_PROXY_PASSWORD = "http.proxyPassword";
    public static final String CFG_PROXY_NOPROXY_HOSTS = "http.nonProxyHosts";
    public static final String NOPROXY_DEFAULT = "localhost|127.*|[::1]";
    private JPanel panel;
    private JCheckBox checkBoxSystemProxy;
    private JTextField proxyHostField;
    private JTextField proxyPortField;
    private JCheckBox checkBoxProxyAuthentication;
    private JTextField proxyUserField;
    private JPasswordField proxyPasswordField;
    private JTextField noproxyHostsField;
    private JButton buttonTestConnection;
    private UserConfigFile config;
    private String configPrefix;
    private URL testPage;

    private void createUIComponents() {
        this.panel = new JPanel();
    }

    public ProxySettings(UserConfigFile config, String configPrefix, final URL testPage) {
        this.config = config;
        this.configPrefix = configPrefix;
        this.testPage = testPage;
        this.$$$setupUI$$$();
        this.checkBoxSystemProxy.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e2) {
                ProxySettings.this.updateProxyActivation();
            }
        });
        this.checkBoxProxyAuthentication.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e2) {
                ProxySettings.this.updateProxyAuthActivation();
            }
        });
        this.updateProxyActivation();
        this.updateProxyAuthActivation();
        this.buttonTestConnection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                try {
                    ProxySettings.this.save();
                    HttpURLConnection connection = (HttpURLConnection)testPage.openConnection();
                    connection.setRequestMethod("GET");
                    if (connection.getResponseCode() == 200) {
                        JOptionPane.showMessageDialog(ProxySettings.this.getPanel(), new String[]{"Server returned: ", connection.getResponseMessage()}, "Connection Test Succeeded", 1, null);
                    } else {
                        JOptionPane.showMessageDialog(ProxySettings.this.getPanel(), new String[]{"Connection test failed with status code:", "" + connection.getResponseCode()}, "Connect Error", 0);
                    }
                }
                catch (IOException iox) {
                    JOptionPane.showMessageDialog(ProxySettings.this.getPanel(), new String[]{"IO Exception during connection test:", iox.getMessage()}, "Connect Error", 0);
                }
            }
        });
    }

    private void updateProxyAuthActivation() {
        boolean activateAuthProxySettings = this.checkBoxProxyAuthentication.isSelected();
        this.proxyUserField.setEnabled(activateAuthProxySettings);
        this.proxyPasswordField.setEnabled(activateAuthProxySettings);
    }

    private void updateProxyActivation() {
        boolean activateProxySettings = !this.checkBoxSystemProxy.isSelected();
        this.proxyHostField.setEnabled(activateProxySettings);
        this.proxyPortField.setEnabled(activateProxySettings);
        this.noproxyHostsField.setEnabled(activateProxySettings);
        this.proxyUserField.setEnabled(activateProxySettings);
        this.proxyPasswordField.setEnabled(activateProxySettings);
        this.checkBoxProxyAuthentication.setEnabled(activateProxySettings);
    }

    @Override
    public JPanel getPanel() {
        return this.panel;
    }

    @Override
    public String getShortTitle() {
        return this.getName();
    }

    @Override
    public String getTitle() {
        return this.getName();
    }

    @Override
    public String getDescription() {
        return "Configure Internet Proxy for application updates and update-to-date online manual.\nIf you do not need to use a proxy to connect to the Internet,\nthen make sure the host field is empty and the 'Use system proxy' checkbox is not checked.";
    }

    @Override
    public String getTooltip() {
        return "Configure Internet proxy settings for application updates (if needed)";
    }

    @Override
    public void saveProperties(UserConfigFile config) {
        this.saveConfig(config, this.configPrefix);
        this.applyConfig(config, this.configPrefix);
    }

    @Override
    public boolean isOK() {
        return true;
    }

    @Override
    public void loadProperties(UserConfigFile config) {
        this.loadProperties(config, this.configPrefix);
    }

    public void applyConfig(UserConfigFile config, String configPrefix) {
        String systemProxy = config.get(configPrefix + CFG_PROXY_USE_SYSTEM, "true");
        System.setProperty(CFG_PROXY_USE_SYSTEM, systemProxy);
        if (!"true".equals(systemProxy.toLowerCase())) {
            String proxyHost = config.get(configPrefix + CFG_PROXY_HOST, null);
            if (proxyHost == null || proxyHost.trim().length() == 0) {
                this.clearProxySystemProperties();
            } else {
                System.setProperty(CFG_PROXY_HOST, proxyHost);
                String proxyPort = config.get(configPrefix + CFG_PROXY_PORT, "3128");
                System.setProperty(CFG_PROXY_PORT, proxyPort);
                String noproxyHosts = config.get(configPrefix + CFG_PROXY_NOPROXY_HOSTS, NOPROXY_DEFAULT);
                System.setProperty(CFG_PROXY_NOPROXY_HOSTS, noproxyHosts);
                String proxyPassword = config.get(configPrefix + CFG_PROXY_PASSWORD, null);
                String proxyUser = config.get(configPrefix + CFG_PROXY_USER, null);
                if (proxyPassword != null && proxyUser != null) {
                    System.setProperty(CFG_PROXY_USER, proxyUser);
                    System.setProperty(CFG_PROXY_PASSWORD, proxyPassword);
                } else {
                    System.clearProperty(CFG_PROXY_USER);
                    System.clearProperty(CFG_PROXY_PASSWORD);
                }
            }
        } else {
            this.clearProxySystemProperties();
        }
    }

    private void clearProxySystemProperties() {
        System.clearProperty(CFG_PROXY_HOST);
        System.clearProperty(CFG_PROXY_PORT);
        System.clearProperty(CFG_PROXY_NOPROXY_HOSTS);
        System.clearProperty(CFG_PROXY_USER);
        System.clearProperty(CFG_PROXY_PASSWORD);
    }

    @Override
    public String getName() {
        return "Internet Proxy";
    }

    @Override
    public Component getComponent() {
        return this.panel;
    }

    @Override
    public void init() {
        this.loadProperties(this.config, this.configPrefix);
    }

    private void loadProperties(UserConfigFile config, String configPrefix) {
        this.checkBoxSystemProxy.setSelected(config.getBoolean(configPrefix + CFG_PROXY_USE_SYSTEM, true));
        this.proxyHostField.setText(config.get(configPrefix + CFG_PROXY_HOST, ""));
        this.proxyPortField.setText(config.get(configPrefix + CFG_PROXY_PORT, ""));
        this.noproxyHostsField.setText(config.get(configPrefix + CFG_PROXY_NOPROXY_HOSTS, NOPROXY_DEFAULT));
        this.proxyUserField.setText(config.get(configPrefix + CFG_PROXY_USER, ""));
        this.proxyPasswordField.setText(config.get(configPrefix + CFG_PROXY_PASSWORD, ""));
        this.checkBoxProxyAuthentication.setSelected(config.get(configPrefix + CFG_PROXY_PASSWORD, null) != null);
    }

    @Override
    public void save() {
        this.saveConfig(this.config, this.configPrefix);
        this.applyConfig(this.config, this.configPrefix);
    }

    private void saveConfig(UserConfigFile config, String configPrefix) {
        config.putBoolean(configPrefix + CFG_PROXY_USE_SYSTEM, this.checkBoxSystemProxy.isSelected());
        config.put(configPrefix + CFG_PROXY_HOST, this.proxyHostField.getText());
        config.put(configPrefix + CFG_PROXY_PORT, this.proxyPortField.getText());
        config.put(configPrefix + CFG_PROXY_USER, this.proxyUserField.getText());
        config.put(configPrefix + CFG_PROXY_NOPROXY_HOSTS, this.noproxyHostsField.getText());
        if (this.checkBoxProxyAuthentication.isSelected()) {
            config.put(configPrefix + CFG_PROXY_PASSWORD, String.valueOf(this.proxyPasswordField.getPassword()));
        } else {
            config.remove(configPrefix + CFG_PROXY_PASSWORD);
        }
    }

    private void $$$setupUI$$$() {
        this.createUIComponents();
        this.panel.setLayout(new GridBagLayout());
        this.checkBoxSystemProxy = new JCheckBox();
        this.checkBoxSystemProxy.setText("Use system proxy");
        this.checkBoxSystemProxy.setToolTipText("Use system proxy settings");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.anchor = 18;
        gbc.insets = new Insets(10, 10, 10, 10);
        this.panel.add((Component)this.checkBoxSystemProxy, gbc);
        JPanel spacer1 = new JPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 6;
        gbc.gridwidth = 2;
        gbc.fill = 3;
        this.panel.add((Component)spacer1, gbc);
        JLabel label1 = new JLabel();
        label1.setText("Proxy Host:Port:");
        label1.setToolTipText("");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 17;
        gbc.insets = new Insets(10, 10, 10, 10);
        this.panel.add((Component)label1, gbc);
        this.proxyHostField = new JTextField();
        this.proxyHostField.setToolTipText("Host name or IP address of the proxy");
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.weightx = 0.5;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.insets = new Insets(10, 10, 10, 10);
        this.panel.add((Component)this.proxyHostField, gbc);
        this.checkBoxProxyAuthentication = new JCheckBox();
        this.checkBoxProxyAuthentication.setText("Proxy server requires password");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.gridwidth = 2;
        gbc.anchor = 17;
        gbc.insets = new Insets(20, 10, 10, 10);
        this.panel.add((Component)this.checkBoxProxyAuthentication, gbc);
        JLabel label2 = new JLabel();
        label2.setText("Proxy User:");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.anchor = 17;
        gbc.insets = new Insets(10, 10, 10, 10);
        this.panel.add((Component)label2, gbc);
        JLabel label3 = new JLabel();
        label3.setText("Proxy Password");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 5;
        gbc.anchor = 17;
        gbc.insets = new Insets(10, 10, 10, 10);
        this.panel.add((Component)label3, gbc);
        this.proxyUserField = new JTextField();
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 4;
        gbc.gridwidth = 3;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.insets = new Insets(10, 10, 10, 10);
        this.panel.add((Component)this.proxyUserField, gbc);
        this.proxyPasswordField = new JPasswordField();
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 5;
        gbc.gridwidth = 3;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.insets = new Insets(10, 10, 10, 10);
        this.panel.add((Component)this.proxyPasswordField, gbc);
        JLabel label4 = new JLabel();
        label4.setText("No Proxy Hosts:");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.anchor = 17;
        gbc.insets = new Insets(10, 10, 10, 10);
        this.panel.add((Component)label4, gbc);
        this.noproxyHostsField = new JTextField();
        this.noproxyHostsField.setToolTipText("A pipe character (|) separated list of host names and IP addresses");
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.gridwidth = 3;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.insets = new Insets(10, 10, 10, 10);
        this.panel.add((Component)this.noproxyHostsField, gbc);
        JLabel label5 = new JLabel();
        label5.setText(":");
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 1;
        gbc.anchor = 17;
        gbc.insets = new Insets(10, 0, 10, 0);
        this.panel.add((Component)label5, gbc);
        this.proxyPortField = new JTextField();
        this.proxyPortField.setToolTipText("Port number of the proxy service");
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 1;
        gbc.weightx = 0.5;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.insets = new Insets(10, 10, 10, 10);
        this.panel.add((Component)this.proxyPortField, gbc);
        this.buttonTestConnection = new JButton();
        this.buttonTestConnection.setText("Apply and Test Connection");
        this.buttonTestConnection.setToolTipText("Tests if AGENTPP update site can be contacted through the proxy settings");
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 7;
        gbc.fill = 2;
        gbc.insets = new Insets(10, 10, 10, 10);
        this.panel.add((Component)this.buttonTestConnection, gbc);
    }

    public JComponent $$$getRootComponent$$$() {
        return this.panel;
    }
}

