/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.common.log;

import java.awt.Color;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogLevel;

public class CategoryTreeCellRenderer
extends DefaultTreeCellRenderer {
    private static final Color COLOR_INFO = Color.GREEN.darker();
    private Map<String, String> nameFilters = new HashMap<String, String>();
    private TreeSet<Integer> filterLength = new TreeSet();

    public void addNameFilter(String logAdapterName, String displayName) {
        this.nameFilters.put(logAdapterName, displayName);
        this.filterLength.add(logAdapterName.length());
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Object obj = ((DefaultMutableTreeNode)value).getUserObject();
        if (obj instanceof LogAdapter) {
            LogAdapter node = (LogAdapter)obj;
            this.setForegroundColor(node);
            super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            String s2 = this.displayName(node);
            int ind = s2.lastIndexOf(46);
            if (ind >= 0) {
                this.setText(s2.substring(ind + 1));
            } else {
                this.setText(s2);
            }
        }
        return this;
    }

    public String displayName(LogAdapter node) {
        Object s2 = node.getName();
        if (!this.nameFilters.isEmpty()) {
            String matchedPrefix = s2;
            for (Integer prefixLength : this.filterLength.descendingSet()) {
                String filteredPrefix;
                if (((String)s2).length() < prefixLength || (filteredPrefix = this.nameFilters.get(matchedPrefix = matchedPrefix.substring(0, prefixLength))) == null) continue;
                s2 = filteredPrefix + ((String)s2).substring(prefixLength);
                break;
            }
        }
        return s2;
    }

    private void setForegroundColor(LogAdapter c2) {
        LogLevel p2 = c2.getLogLevel();
        if (p2 == null) {
            this.setTextNonSelectionColor(Color.black);
        } else if (p2.equals(LogLevel.WARN)) {
            this.setTextNonSelectionColor(Color.orange.darker());
        } else if (p2.equals(LogLevel.DEBUG)) {
            this.setTextNonSelectionColor(Color.blue);
        } else if (p2.equals(LogLevel.INFO)) {
            this.setTextNonSelectionColor(COLOR_INFO);
        } else if (p2.equals(LogLevel.TRACE)) {
            this.setTextNonSelectionColor(Color.orange);
        } else if (p2.equals(LogLevel.ERROR)) {
            this.setTextNonSelectionColor(Color.red);
        } else {
            this.setTextNonSelectionColor(Color.gray);
        }
    }
}

