/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.common.io;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ZipFileOperations {
    public static List<String> zipDirs(Collection<Path> dirs, File zipFile) throws IOException {
        ArrayList<String> fileList = new ArrayList<String>();
        FileOutputStream zipStream = new FileOutputStream(zipFile, false);
        ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(zipStream));
        for (Path dir : dirs) {
            fileList.addAll(ZipFileOperations.zipDir(dir, out));
        }
        out.flush();
        out.close();
        return fileList;
    }

    public static List<String> zipDir(final Path dir, final ZipOutputStream out) throws IOException {
        final ArrayList<String> fileList = new ArrayList<String>();
        Files.walkFileTree(dir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if (!Files.isDirectory(file, new LinkOption[0])) {
                    String fileName = file.subpath(dir.getNameCount(), file.getNameCount()).toString();
                    fileList.add(fileName);
                    ZipEntry entry = new ZipEntry(fileName);
                    out.putNextEntry(entry);
                    Files.copy(file, out);
                }
                return FileVisitResult.CONTINUE;
            }
        });
        return fileList;
    }
}

