/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.common.help;

import com.agentpp.common.help.HelpViewer;
import com.agentpp.util.gui.BrowserUtil;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.WindowListener;
import java.net.HttpURLConnection;
import java.net.URL;

public class HelpViewerFactory {
    public HelpViewer create(String frameTitle, int posX, int posY, int width, int height, String[] urls, ViewerType viewerType) {
        boolean isOnlineHelpReachable = HelpViewerFactory.checkConnectivity(urls[urls.length - 1], 1000);
        return new HelpViewerOS(isOnlineHelpReachable ? urls[urls.length - 1] : urls[0]);
    }

    public static boolean checkConnectivity(String url, int timeout) {
        try {
            HttpURLConnection connection = (HttpURLConnection)new URL(url).openConnection();
            connection.setConnectTimeout(timeout);
            connection.setReadTimeout(timeout);
            connection.setRequestMethod("HEAD");
            int responseCode = connection.getResponseCode();
            return 200 == responseCode;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public class HelpViewerOS
    implements HelpViewer {
        private String domain;

        public HelpViewerOS(String url) {
            this.domain = url.toLowerCase().startsWith("https://") ? url.substring(8) : url;
        }

        @Override
        public void initAndShowGUI(WindowListener windowListener) {
            BrowserUtil.openURL(this.domain);
        }

        @Override
        public boolean isInitialized() {
            return true;
        }

        @Override
        public String getToolBarColor() {
            return null;
        }

        @Override
        public void setToolBarColor(String toolBarColor) {
        }

        @Override
        public String getToolBarStylesheet() {
            return null;
        }

        @Override
        public void setToolBarStylesheet(String toolBarStylesheet) {
        }

        @Override
        public Point getLocation() {
            return null;
        }

        @Override
        public Dimension getSize() {
            return null;
        }
    }

    public static enum ViewerType {
        bestFit,
        builtin,
        external;

    }
}

