/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.common.base.io;

import com.agentpp.common.base.io.StreamEvent;
import com.agentpp.common.base.io.StreamListener;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;

public class MonitoredOutputStream
extends OutputStream {
    private OutputStream outputStream;
    private transient Vector streamListeners;

    public MonitoredOutputStream() {
    }

    public MonitoredOutputStream(OutputStream os) {
        this.outputStream = os;
    }

    public void setOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    @Override
    public void close() throws IOException {
        this.outputStream.close();
        this.fireStreamEvent(new StreamEvent(this, -2L));
    }

    @Override
    public void flush() throws IOException {
        this.outputStream.flush();
    }

    @Override
    public void write(int b2) throws IOException {
        this.outputStream.write(b2);
        this.fireStreamEvent(new StreamEvent(this, 1L));
    }

    @Override
    public void write(byte[] b2, int offset, int len) throws IOException {
        this.outputStream.write(b2, offset, len);
        this.fireStreamEvent(new StreamEvent(this, len));
    }

    @Override
    public void write(byte[] b2) throws IOException {
        this.outputStream.write(b2);
        this.fireStreamEvent(new StreamEvent(this, b2.length));
    }

    public synchronized void removeStreamListener(StreamListener l2) {
        if (this.streamListeners != null && this.streamListeners.contains(l2)) {
            Vector v = (Vector)this.streamListeners.clone();
            v.removeElement(l2);
            this.streamListeners = v;
        }
    }

    public synchronized void addStreamListener(StreamListener l2) {
        Vector v;
        Vector vector = v = this.streamListeners == null ? new Vector(2) : (Vector)this.streamListeners.clone();
        if (!v.contains(l2)) {
            v.addElement(l2);
            this.streamListeners = v;
        }
    }

    protected void fireStreamEvent(StreamEvent e2) {
        if (this.streamListeners != null) {
            Vector listeners = this.streamListeners;
            int count = listeners.size();
            for (int i2 = 0; i2 < count; ++i2) {
                ((StreamListener)listeners.elementAt(i2)).streamEvent(e2);
            }
        }
    }
}

