/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.common.base.io;

import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.filechooser.FileFilter;

public class ExampleFileFilter
extends FileFilter {
    private static String TYPE_UNKNOWN = "Type Unknown";
    private static String HIDDEN_FILE = "Hidden File";
    private Hashtable filters = new Hashtable();
    private String description = null;
    private String fullDescription = null;
    private boolean useExtensionsInDescription = true;

    public ExampleFileFilter() {
    }

    public ExampleFileFilter(String extension) {
        this(extension, null);
    }

    public ExampleFileFilter(String extension, String description) {
        this();
        if (extension != null) {
            this.addExtension(extension);
        }
        if (description != null) {
            this.setDescription(description);
        }
    }

    public ExampleFileFilter(String[] filters) {
        this(filters, null);
    }

    public ExampleFileFilter(String[] filters, String description) {
        this();
        for (int i2 = 0; i2 < filters.length; ++i2) {
            if (filters[i2].charAt(0) == '.') {
                this.addExtension(filters[i2].substring(1));
                continue;
            }
            this.addExtension(filters[i2]);
        }
        if (description != null) {
            this.setDescription(description);
        }
    }

    @Override
    public boolean accept(File f2) {
        if (f2 != null) {
            if (f2.isDirectory()) {
                return true;
            }
            String extension = this.getExtension(f2);
            if (extension != null && this.filters.get(this.getExtension(f2)) != null) {
                return true;
            }
        }
        return false;
    }

    public String getExtension(File f2) {
        String filename;
        int i2;
        if (f2 != null && (i2 = (filename = f2.getName()).lastIndexOf(46)) > 0 && i2 < filename.length() - 1) {
            return filename.substring(i2 + 1).toLowerCase();
        }
        return null;
    }

    public void addExtension(String extension) {
        if (this.filters == null) {
            this.filters = new Hashtable(5);
        }
        this.filters.put(extension.toLowerCase(), this);
        this.fullDescription = null;
    }

    @Override
    public String getDescription() {
        if (this.fullDescription == null) {
            if (this.description == null || this.isExtensionListInDescription()) {
                this.fullDescription = this.description == null ? "(" : this.description + " (";
                Enumeration extensions = this.filters.keys();
                if (extensions != null) {
                    this.fullDescription = this.fullDescription + "." + (String)extensions.nextElement();
                    while (extensions.hasMoreElements()) {
                        this.fullDescription = this.fullDescription + ", ." + (String)extensions.nextElement();
                    }
                }
                this.fullDescription = this.fullDescription + ")";
            } else {
                this.fullDescription = this.description;
            }
        }
        return this.fullDescription;
    }

    public void setDescription(String description) {
        this.description = description;
        this.fullDescription = null;
    }

    public void setExtensionListInDescription(boolean b2) {
        this.useExtensionsInDescription = b2;
        this.fullDescription = null;
    }

    public boolean isExtensionListInDescription() {
        return this.useExtensionsInDescription;
    }
}

