/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.common;

import com.agentpp.common.SortLabel;
import com.agentpp.common.SortLabelRenderer;
import com.klg.jclass.table.JCCellPosition;
import com.klg.jclass.table.JCSelectEvent;
import com.klg.jclass.table.JCSelectListener;
import com.klg.jclass.table.JCTable;
import com.klg.jclass.table.Sort;
import com.klg.jclass.table.data.JCVectorDataSource;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Comparator;

public class TableSorter
extends MouseAdapter
implements JCSelectListener {
    private Comparator comparator;
    private JCTable table;
    private JCVectorDataSource data;
    private static SortLabelRenderer renderer;
    private boolean sortingByUserAllowed = true;
    private int frozenColumn = 0;

    public TableSorter(JCTable table, JCVectorDataSource data) {
        this(table, data, true);
    }

    public TableSorter(JCTable table, JCVectorDataSource data, boolean sortingByUser) {
        this.table = table;
        this.data = data;
        if (renderer == null) {
            renderer = new SortLabelRenderer();
        }
        this.sortingByUserAllowed = sortingByUser;
        this.makeSortLabels();
    }

    public TableSorter(JCTable table, JCVectorDataSource data, Comparator comparator) {
        this.table = table;
        this.comparator = comparator;
        this.data = data;
        this.makeSortLabels();
    }

    public SortLabelRenderer getLabelRenderer() {
        return renderer;
    }

    protected void makeSortLabels() {
        for (int i2 = 0; i2 < this.data.getNumColumns(); ++i2) {
            if (this.data.getTableColumnLabel(i2) == null) continue;
            if (this.data.getTableColumnLabel(i2) instanceof SortLabel) {
                this.data.setColumnLabel(i2, new SortLabel(((SortLabel)this.data.getTableColumnLabel(i2)).getLabel(), 0));
                continue;
            }
            this.data.setColumnLabel(i2, new SortLabel(this.data.getTableColumnLabel(i2).toString(), 0));
        }
        if (this.sortingByUserAllowed) {
            this.table.setCellRenderer(SortLabel.class, renderer);
            this.table.addMouseListener(this);
        }
    }

    public void unsort() {
        for (int i2 = 0; i2 < this.table.getDataSource().getNumColumns(); ++i2) {
            ((SortLabel)this.data.getTableColumnLabel(i2)).setDirection(0);
        }
        this.table.resetSortedRows();
    }

    public void setData(JCVectorDataSource data) {
        this.data = data;
    }

    public void sort() {
        Comparator comp = this.comparator;
        int j2 = 0;
        int[] columns = new int[this.data.getNumColumns()];
        int[] dirs = new int[columns.length];
        for (int i2 = 0; i2 < columns.length; ++i2) {
            int dir = ((SortLabel)this.data.getTableColumnLabel(i2)).getDirection();
            if (dir == 0) continue;
            columns[j2] = i2;
            dirs[j2] = dir;
            ++j2;
        }
        if (j2 == 0) {
            this.table.resetSortedRows();
            return;
        }
        int[] cs = new int[j2];
        int[] d2 = new int[j2];
        System.arraycopy(columns, 0, cs, 0, j2);
        System.arraycopy(dirs, 0, d2, 0, j2);
        Sort.sortByColumn(this.table, cs, d2, comp);
    }

    @Override
    public void beforeSelect(JCSelectEvent e2) {
        if (e2.getStartRow() == -1) {
            this.addSortColumn(e2.getStartColumn());
        }
    }

    public void addSortColumn(int col) {
        Object o2 = this.data.getTableColumnLabel(col);
        if (!(o2 instanceof SortLabel)) {
            return;
        }
        SortLabel l2 = (SortLabel)o2;
        switch (l2.getDirection()) {
            case -1: {
                l2.setDirection(1);
                break;
            }
            case 0: {
                l2.setDirection(-1);
                break;
            }
            case 1: {
                l2.setDirection(0);
            }
        }
        this.sort();
    }

    @Override
    public void afterSelect(JCSelectEvent e2) {
    }

    @Override
    public void select(JCSelectEvent e2) {
    }

    @Override
    public void mouseClicked(MouseEvent e2) {
        JCCellPosition p2 = this.table.XYToCell((int)e2.getPoint().getX(), (int)e2.getPoint().getY());
        if (p2 == null || p2.column < this.frozenColumn) {
            return;
        }
        if (p2.row == -1) {
            this.addSortColumn(p2.column);
        }
    }

    public void setFrozenColumn(int frozenColumn) {
        this.frozenColumn = frozenColumn;
    }

    public int getFrozenColumn() {
        return this.frozenColumn;
    }
}

