/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.common;

import com.agentpp.common.TableSorter;
import com.agentpp.common.table.ExtendedListTable;
import com.agentpp.common.table.JTableColumnResizeEmulator;
import com.agentpp.common.table.TableUtils;
import com.klg.jclass.table.JCCellPosition;
import com.klg.jclass.table.JCCellRange;
import com.klg.jclass.table.JCSelectEvent;
import com.klg.jclass.table.JCSelectListener;
import com.klg.jclass.table.JCTable;
import com.klg.jclass.table.data.JCVectorDataSource;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.ToolTipManager;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class ShufflePanel
extends JPanel
implements JCSelectListener {
    protected JCVectorDataSource leftData;
    protected JCVectorDataSource rightData;
    JPanel jPanelLeft = new JPanel();
    JPanel jPanelRight = new JPanel();
    JCTable jCTableLeft = new ExtendedListTable(){

        @Override
        public String getToolTipText(MouseEvent event) {
            JCCellPosition cp = this.XYToCell(event.getX(), event.getY());
            if (cp.column < 0 || cp.row < 0) {
                return null;
            }
            Object data = this.getDataView().getTableDataItem(cp.row, cp.column);
            if (data == null) {
                return null;
            }
            return data.toString();
        }
    };
    JCTable jCTableRight = new ExtendedListTable(){

        @Override
        public String getToolTipText(MouseEvent event) {
            JCCellPosition cp = this.XYToCell(event.getX(), event.getY());
            if (cp.column < 0 || cp.row < 0) {
                return null;
            }
            Object data = this.getDataView().getTableDataItem(cp.row, cp.column);
            if (data == null) {
                return null;
            }
            return data.toString();
        }
    };
    JPanel jPanelCenter = new JPanel();
    JButton jButtonL2R = new JButton();
    JButton jButtonR2L = new JButton();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    Border border1;
    Border borderLeft;
    Border borderRight;
    Border border4;
    JButton jButtonAddAll = new JButton();
    JButton jButtonAddSpecial = new JButton();
    JButton jButtonRemoveAll = new JButton();
    BorderLayout borderLayout1 = new BorderLayout();
    BorderLayout borderLayout2 = new BorderLayout();
    private JTableColumnResizeEmulator resizer = new JTableColumnResizeEmulator(3);
    TableSorter leftSorter;
    TableSorter rightSorter;
    GridBagLayout gridBagLayout2 = new GridBagLayout();
    boolean removeEnabled = true;
    boolean removeAllEnabled = true;
    private ShuffleRowFilter specialAddButtonRowFilter;
    private String specialAddButtonLabel;

    public ShufflePanel() {
        this((ShuffleRowFilter)null, null);
    }

    public ShufflePanel(ShuffleRowFilter specialAddButtonRowFilter, String specialAddButtonLabel) {
        this.jCTableLeft.setRowLabelDisplay(false);
        this.jCTableRight.setRowLabelDisplay(false);
        this.jCTableLeft.addSelectListener(this);
        this.jCTableRight.addSelectListener(this);
        this.jCTableRight.setIgnoreContainerSize(true);
        this.jCTableLeft.setIgnoreContainerSize(true);
        this.jCTableRight.setResizeEven(false);
        this.jCTableLeft.setResizeEven(false);
        this.jCTableLeft.addResizeCellMotionListener(this.resizer);
        this.jCTableRight.addResizeCellMotionListener(this.resizer);
        this.specialAddButtonLabel = specialAddButtonLabel;
        this.specialAddButtonRowFilter = specialAddButtonRowFilter;
        try {
            this.jbInit();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        ToolTipManager.sharedInstance().registerComponent(this.jCTableLeft);
        ToolTipManager.sharedInstance().registerComponent(this.jCTableRight);
    }

    public ShufflePanel(JCVectorDataSource sa, JCVectorDataSource sb) {
        this();
        this.setLeftData(sa);
        this.setRightData(sb);
    }

    public ShufflePanel(ShuffleRowFilter specialAddRowFilter, String specialAddButtonLabel, JCVectorDataSource sa, JCVectorDataSource sb) {
        this(specialAddRowFilter, specialAddButtonLabel);
        this.setLeftData(sa);
        this.setRightData(sb);
    }

    public JCVectorDataSource getLeftData() {
        this.leftData.deleteRows(0, 1);
        return this.leftData;
    }

    public TableSorter getLeftTableSorter() {
        return this.leftSorter;
    }

    public TableSorter getRightTableSorter() {
        return this.rightSorter;
    }

    public void setLeftData(JCVectorDataSource newLeftData) {
        this.leftData = newLeftData;
        Vector<String> v = new Vector<String>();
        for (int i2 = 0; i2 < this.leftData.getNumColumns(); ++i2) {
            v.add("");
        }
        this.leftData.addRow(0, null, v);
        this.jCTableLeft.setDataSource(this.leftData);
        this.jCTableLeft.setRowHidden(0, true);
        this.jCTableLeft.setFrozenRows(0);
        this.jCTableLeft.clearSelection();
        this.jCTableLeft.setVisibleRows(10);
        this.jCTableLeft.setVariableEstimateCount(10);
        this.setVariableWidth(this.jCTableLeft);
        this.leftSorter = new TableSorter(this.jCTableLeft, this.leftData);
        this.updateButtons();
    }

    private void setVariableWidth(JCTable t) {
        for (int i2 = 0; i2 < t.getDataSource().getNumColumns(); ++i2) {
            t.setPixelWidth(i2, 33002);
        }
    }

    public void setRightData(JCVectorDataSource newRightData) {
        this.rightData = newRightData;
        Vector<String> v = new Vector<String>();
        for (int i2 = 0; i2 < this.rightData.getNumColumns(); ++i2) {
            v.add("");
        }
        this.rightData.addRow(0, null, v);
        this.jCTableRight.setDataSource(this.rightData);
        this.jCTableRight.setRowHidden(0, true);
        this.jCTableRight.setFrozenRows(0);
        this.jCTableRight.clearSelection();
        this.jCTableRight.setVisibleRows(10);
        this.jCTableRight.setVariableEstimateCount(10);
        this.setVariableWidth(this.jCTableRight);
        this.rightSorter = new TableSorter(this.jCTableRight, this.rightData);
        this.updateButtons();
    }

    public JCVectorDataSource getRightData() {
        this.rightData.deleteRows(0, 1);
        return this.rightData;
    }

    public void setRemoveEnabled(boolean enabled) {
        this.removeEnabled = enabled;
        this.updateButtons();
    }

    public void setRemoveAllEnabled(boolean enabled) {
        this.removeAllEnabled = enabled;
        this.updateButtons();
    }

    private void jbInit() throws Exception {
        this.border1 = BorderFactory.createEmptyBorder(10, 10, 10, 10);
        this.borderLeft = new TitledBorder(new EtchedBorder(1, Color.white, new Color(148, 145, 140)), "Left");
        this.borderRight = new TitledBorder(new EtchedBorder(1, Color.white, new Color(148, 145, 140)), "Right");
        this.border4 = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        this.setLayout(this.gridBagLayout2);
        this.jPanelCenter.setLayout(this.gridBagLayout1);
        this.jButtonL2R.setText("Add");
        this.jButtonL2R.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                ShufflePanel.this.jButtonL2R_actionPerformed(e2);
            }
        });
        this.jButtonR2L.setText("Remove");
        this.jButtonR2L.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                ShufflePanel.this.jButtonR2L_actionPerformed(e2);
            }
        });
        this.setBorder(this.border1);
        this.jPanelLeft.setBorder(this.borderLeft);
        this.jPanelLeft.setMinimumSize(new Dimension(120, 50));
        this.jPanelLeft.setPreferredSize(new Dimension(200, 180));
        this.jPanelLeft.setLayout(this.borderLayout2);
        this.jPanelRight.setBorder(this.borderRight);
        this.jPanelRight.setMinimumSize(new Dimension(120, 50));
        this.jPanelRight.setPreferredSize(new Dimension(200, 180));
        this.jPanelRight.setLayout(this.borderLayout1);
        this.jPanelCenter.setBorder(this.border4);
        this.jPanelCenter.setMinimumSize(new Dimension(100, 178));
        this.jPanelCenter.setPreferredSize(new Dimension(70, 170));
        this.jButtonAddAll.setText("Add All");
        this.jButtonAddAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                ShufflePanel.this.jButtonAddAll_actionPerformed(e2);
            }
        });
        if (this.specialAddButtonLabel != null) {
            this.jButtonAddSpecial.setText(this.specialAddButtonLabel);
            this.jButtonAddSpecial.addActionListener(e2 -> this.jButtonAddSpecial_actionPerformed(e2));
        }
        this.jButtonRemoveAll.setText("Remove All");
        this.jButtonRemoveAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                ShufflePanel.this.jButtonRemoveAll_actionPerformed(e2);
            }
        });
        this.jPanelLeft.add((Component)this.jCTableLeft, "Center");
        this.jPanelCenter.add((Component)this.jButtonL2R, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(10, 10, 5, 10), 0, 0));
        this.jPanelCenter.add((Component)this.jButtonR2L, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(10, 10, 5, 10), 0, 0));
        this.jPanelCenter.add((Component)this.jButtonAddAll, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 10, this.isSpecialButton() ? 5 : 10, 10), 0, 0));
        if (this.isSpecialButton()) {
            this.jPanelCenter.add((Component)this.jButtonAddSpecial, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 10, 10, 10), 0, 0));
        }
        this.jPanelCenter.add((Component)this.jButtonRemoveAll, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 10, 10, 10), 0, 0));
        this.jPanelRight.add((Component)this.jCTableRight, "Center");
        this.add((Component)this.jPanelCenter, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 78, 110));
        this.add((Component)this.jPanelLeft, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.jPanelRight, new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private boolean isSpecialButton() {
        return this.specialAddButtonLabel != null;
    }

    public JCTable getLeftTable() {
        return this.jCTableLeft;
    }

    public JCTable getRightTable() {
        return this.jCTableRight;
    }

    private void jButtonL2R_actionPerformed(ActionEvent e2) {
        this.jCTableRight.resetSortedRows();
        Collection c2 = this.jCTableLeft.getSelectedCells();
        if (c2 == null) {
            return;
        }
        JCCellRange[] r2 = new JCCellRange[c2.size()];
        c2.toArray(r2);
        for (int i2 = 0; i2 < r2.length; ++i2) {
            TableUtils.setRangeAfterCopy(r2[i2]);
        }
        Vector rows = new Vector();
        for (int i3 = 0; i3 < r2.length; ++i3) {
            if (r2[i3].start_row >= this.leftData.getNumRows()) continue;
            for (int y = r2[i3].start_row; y <= r2[i3].end_row; ++y) {
                Vector<Object> row = new Vector<Object>();
                row.addElement(this.jCTableLeft.getDataView().getTableRowLabel(y));
                int notNull = 0;
                for (int x = 0; x <= this.jCTableLeft.getNumColumns(); ++x) {
                    row.addElement(this.jCTableLeft.getDataView().getTableDataItem(y, x));
                    if (row.lastElement() == null) continue;
                    ++notNull;
                }
                if (notNull <= 0) continue;
                rows.addElement(row);
            }
        }
        TreeMap<Integer, Integer> map = new TreeMap<Integer, Integer>();
        for (int i4 = 0; i4 < r2.length; ++i4) {
            block5: for (int n2 = 0; n2 <= r2[i4].end_row - r2[i4].start_row; ++n2) {
                Object o2 = this.jCTableLeft.getDataView().getTableDataItem(r2[i4].start_row + n2, 0);
                for (int j2 = 1; j2 < this.leftData.getNumRows(); ++j2) {
                    if (this.leftData.getTableDataItem(j2, 0) != o2) continue;
                    Integer pos = j2;
                    map.put(pos, pos);
                    continue block5;
                }
            }
        }
        while (!map.isEmpty()) {
            this.leftData.deleteRows((Integer)map.lastKey(), 1);
            map.remove(map.lastKey());
        }
        Enumeration en = rows.elements();
        while (en.hasMoreElements()) {
            Vector row = (Vector)en.nextElement();
            Object label = row.firstElement();
            if (label != null) {
                boolean skip = false;
                for (int rr = 1; rr < this.rightData.getNumRows(); ++rr) {
                    Object l2 = this.rightData.getTableRowLabel(rr);
                    if (l2 == null || !l2.equals(label)) continue;
                    skip = true;
                    break;
                }
                if (skip) continue;
            }
            row.removeElementAt(0);
            this.rightData.addRow(Integer.MAX_VALUE, label, row);
        }
        this.updateButtons();
        this.jCTableLeft.resetSortedRows();
        this.leftSorter.sort();
        this.rightSorter.sort();
    }

    private void jButtonR2L_actionPerformed(ActionEvent e2) {
        this.jCTableLeft.resetSortedRows();
        Collection c2 = this.jCTableRight.getSelectedCells();
        if (c2 == null) {
            return;
        }
        JCCellRange[] r2 = new JCCellRange[c2.size()];
        c2.toArray(r2);
        for (int i2 = 0; i2 < r2.length; ++i2) {
            TableUtils.setRangeAfterCopy(r2[i2]);
        }
        Vector rows = new Vector();
        for (int i3 = 0; i3 < r2.length; ++i3) {
            if (r2[i3].start_row >= this.rightData.getNumRows()) continue;
            for (int y = r2[i3].start_row; y <= r2[i3].end_row; ++y) {
                Vector<Object> row = new Vector<Object>();
                row.addElement(this.jCTableRight.getDataView().getTableRowLabel(y));
                int notNull = 0;
                for (int x = 0; x <= this.jCTableRight.getNumColumns(); ++x) {
                    row.addElement(this.jCTableRight.getDataView().getTableDataItem(y, x));
                    if (row.lastElement() == null) continue;
                    ++notNull;
                }
                if (notNull <= 0) continue;
                rows.addElement(row);
            }
        }
        TreeMap<Integer, Integer> map = new TreeMap<Integer, Integer>();
        for (int i4 = 0; i4 < r2.length; ++i4) {
            block5: for (int n2 = 0; n2 <= r2[i4].end_row - r2[i4].start_row; ++n2) {
                Object o2 = this.jCTableRight.getDataView().getTableDataItem(r2[i4].start_row + n2, 0);
                for (int j2 = 1; j2 < this.rightData.getNumRows(); ++j2) {
                    if (this.rightData.getTableDataItem(j2, 0) != o2) continue;
                    Integer pos = new Integer(j2);
                    map.put(pos, pos);
                    continue block5;
                }
            }
        }
        while (!map.isEmpty()) {
            this.rightData.deleteRows((Integer)map.lastKey(), 1);
            map.remove(map.lastKey());
        }
        Enumeration en = rows.elements();
        while (en.hasMoreElements()) {
            Vector row = (Vector)en.nextElement();
            Object label = row.firstElement();
            if (label != null) {
                boolean skip = false;
                for (int rr = 1; rr < this.leftData.getNumRows(); ++rr) {
                    Object l2 = this.leftData.getTableRowLabel(rr);
                    if (l2 == null || !l2.equals(label)) continue;
                    skip = true;
                    break;
                }
                if (skip) continue;
            }
            row.removeElementAt(0);
            this.leftData.addRow(Integer.MAX_VALUE, label, row);
        }
        this.updateButtons();
        this.jCTableRight.resetSortedRows();
        this.leftSorter.sort();
        this.rightSorter.sort();
    }

    public void setSingleColumnData(List<?> columnData, boolean setLeftData, String titleLabel) {
        JCVectorDataSource dataSource = new JCVectorDataSource();
        dataSource.setNumColumns(1);
        dataSource.setNumRows(0);
        dataSource.setColumnLabel(0, titleLabel);
        if (setLeftData) {
            this.leftData = dataSource;
        } else {
            this.rightData = dataSource;
        }
        for (Object row : columnData) {
            Vector v = new Vector(1);
            v.add(row);
            dataSource.addRow(Integer.MAX_VALUE, null, v);
        }
        if (setLeftData) {
            this.setLeftData(dataSource);
            this.getLeftTable().setVisibleColumns(1);
        } else {
            this.setRightData(dataSource);
            this.getRightTable().setVisibleColumns(1);
        }
    }

    public List<Object> getSingeColumnData(boolean getRightData) {
        JCVectorDataSource dataSource = getRightData ? this.rightData : this.leftData;
        ArrayList<Object> result = new ArrayList<Object>();
        for (int i2 = 1; i2 < dataSource.getNumRows(); ++i2) {
            result.add(dataSource.getTableDataItem(i2, 0));
        }
        return result;
    }

    @Override
    public void beforeSelect(JCSelectEvent e2) {
    }

    @Override
    public void afterSelect(JCSelectEvent e2) {
        if (e2.isCancelled()) {
            return;
        }
        JCTable s2 = (JCTable)e2.getSource();
        s2.addRowSelection(e2.getStartRow(), e2.getEndRow());
        this.updateButtons();
    }

    @Override
    public void select(JCSelectEvent e2) {
    }

    private void jButtonAddSpecial_actionPerformed(ActionEvent e2) {
        this.jCTableLeft.resetSortedRows();
        this.jCTableRight.resetSortedRows();
        Vector rows = new Vector();
        LinkedList<Integer> shuffledRowIDs = new LinkedList<Integer>();
        for (int i2 = 1; i2 < this.leftData.getNumRows(); ++i2) {
            Vector<Object> row = new Vector<Object>();
            row.addElement(this.leftData.getTableRowLabel(i2));
            for (int x = 0; x <= this.leftData.getNumColumns(); ++x) {
                row.addElement(this.leftData.getTableDataItem(i2, x));
            }
            if (this.specialAddButtonRowFilter != null && !this.specialAddButtonRowFilter.passesFilter(row)) continue;
            rows.addElement(row);
            shuffledRowIDs.add(i2);
        }
        while (!shuffledRowIDs.isEmpty()) {
            this.leftData.deleteRows((Integer)shuffledRowIDs.removeLast(), 1);
        }
        this.addRows(rows, this.rightData);
    }

    private void addRows(Vector rows, JCVectorDataSource rightData) {
        Enumeration en = rows.elements();
        while (en.hasMoreElements()) {
            Vector row = (Vector)en.nextElement();
            Object label = row.firstElement();
            row.removeElementAt(0);
            rightData.addRow(Integer.MAX_VALUE, label, row);
        }
        this.updateButtons();
        this.leftSorter.sort();
        this.rightSorter.sort();
    }

    private void jButtonAddAll_actionPerformed(ActionEvent e2) {
        this.jCTableLeft.resetSortedRows();
        this.jCTableRight.resetSortedRows();
        Vector rows = new Vector();
        for (int i2 = 1; i2 < this.leftData.getNumRows(); ++i2) {
            Vector<Object> row = new Vector<Object>();
            row.addElement(this.leftData.getTableRowLabel(i2));
            for (int x = 0; x <= this.leftData.getNumColumns(); ++x) {
                row.addElement(this.leftData.getTableDataItem(i2, x));
            }
            rows.addElement(row);
        }
        this.leftData.deleteRows(1, this.leftData.getNumRows() - 1);
        this.addRows(rows, this.rightData);
    }

    private void jButtonRemoveAll_actionPerformed(ActionEvent e2) {
        this.jCTableLeft.resetSortedRows();
        this.jCTableRight.resetSortedRows();
        Vector rows = new Vector();
        for (int i2 = 1; i2 < this.rightData.getNumRows(); ++i2) {
            Vector<Object> row = new Vector<Object>();
            row.addElement(this.rightData.getTableRowLabel(i2));
            for (int x = 0; x <= this.rightData.getNumColumns(); ++x) {
                row.addElement(this.rightData.getTableDataItem(i2, x));
            }
            rows.addElement(row);
        }
        this.rightData.deleteRows(1, this.rightData.getNumRows() - 1);
        this.addRows(rows, this.leftData);
    }

    private void updateButtons() {
        if (this.leftData != null && this.leftData.getNumRows() > 0) {
            this.jButtonAddAll.setEnabled(true);
            if (this.jCTableLeft.getSelectedCells() != null) {
                this.jButtonL2R.setEnabled(true);
            } else {
                this.jButtonL2R.setEnabled(false);
            }
        } else {
            this.jButtonAddAll.setEnabled(false);
            this.jButtonL2R.setEnabled(false);
        }
        if (this.rightData != null && this.rightData.getNumRows() > 0) {
            this.jButtonRemoveAll.setEnabled(this.removeAllEnabled);
            if (this.jCTableRight.getSelectedCells() != null) {
                this.jButtonR2L.setEnabled(this.removeEnabled);
            } else {
                this.jButtonR2L.setEnabled(false);
            }
        } else {
            this.jButtonRemoveAll.setEnabled(false);
            this.jButtonR2L.setEnabled(false);
        }
    }

    public void setLeftTitle(String newLeftTitle) {
        ((TitledBorder)this.borderLeft).setTitle(newLeftTitle);
    }

    public String getLeftTitle() {
        return ((TitledBorder)this.borderLeft).getTitle();
    }

    public void setRightTitle(String newRightTitle) {
        ((TitledBorder)this.borderRight).setTitle(newRightTitle);
    }

    public String getRightTitle() {
        return ((TitledBorder)this.borderRight).getTitle();
    }

    @Override
    public void setEnabled(boolean b2) {
        super.setEnabled(b2);
        this.jButtonAddAll.setEnabled(b2);
        this.jButtonL2R.setEnabled(b2);
        this.jButtonR2L.setEnabled(b2);
        this.jButtonRemoveAll.setEnabled(b2);
        this.jCTableLeft.removeSelectListener(this);
        this.jCTableRight.removeSelectListener(this);
        if (b2) {
            this.updateButtons();
            this.jCTableLeft.addSelectListener(this);
            this.jCTableRight.addSelectListener(this);
        }
    }

    public static interface ShuffleRowFilter {
        public boolean passesFilter(Collection var1);
    }
}

