/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.common;

import com.agentpp.common.SearchConfig;
import com.klg.jclass.field.JCComboField;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class SearchPanel
extends JPanel
implements SearchConfig {
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JLabel jLabelSearch = new JLabel();
    ButtonGroup buttonGroupSearch = new ButtonGroup();
    JRadioButton all = new JRadioButton();
    JLabel jLabelSearchFor = new JLabel();
    JLabel jLabelReplaceWith = new JLabel();
    JCheckBox jCheckBoxCase = new JCheckBox();
    JCComboField searchExpression = new JCComboField(String.class);
    JCComboField replaceExpression = new JCComboField(String.class);
    Vector buttons = new Vector();
    boolean replaceEnabled = false;

    public SearchPanel() {
        this(false);
    }

    public SearchPanel(boolean replaceEnabled) {
        this.replaceEnabled = replaceEnabled;
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.all.setSelected(true);
        this.searchExpression.setModel(new DefaultComboBoxModel());
        this.replaceExpression.setModel(new DefaultComboBoxModel());
    }

    public void setSearchCategories(String[] categories) {
        for (int i2 = 0; i2 < categories.length; ++i2) {
            JRadioButton cat = new JRadioButton(categories[i2]);
            this.buttonGroupSearch.add(cat);
            this.buttons.addElement(cat);
            this.add((Component)cat, new GridBagConstraints(1, 3 + this.buttons.size(), 1, 1, 0.9, 1.0, 11, 2, new Insets(0, 10, i2 + 1 < categories.length ? 0 : 10, 10), 0, 0));
        }
    }

    public void setSearchOptionsEnabled(boolean[] enabled) {
        for (int i2 = 0; i2 < this.buttons.size() && i2 < enabled.length; ++i2) {
            ((JRadioButton)this.buttons.get(i2)).setEnabled(enabled[i2]);
        }
    }

    @Override
    public String getSearchExpression() {
        if (this.searchExpression.getSelectedItem() != null) {
            return this.searchExpression.getSelectedItem().toString();
        }
        return "";
    }

    public void setSearchExpressions(Vector v) {
        Enumeration en = v.elements();
        while (en.hasMoreElements()) {
            this.searchExpression.addItem(en.nextElement());
        }
    }

    public String getReplaceExpression() {
        if (this.replaceExpression.getSelectedItem() != null) {
            return this.replaceExpression.getSelectedItem().toString();
        }
        return "";
    }

    public void setReplaceExpressions(Vector v) {
        Enumeration en = v.elements();
        while (en.hasMoreElements()) {
            this.replaceExpression.addItem(en.nextElement());
        }
    }

    public Vector getSearchExpressions() {
        Vector<Object> v = new Vector<Object>(this.searchExpression.getItemCount() + 1);
        if (this.searchExpression.getSelectedItem() == null) {
            return null;
        }
        int max = Math.min(this.searchExpression.getItemCount(), 10);
        for (int i2 = 0; i2 < max; ++i2) {
            v.addElement(this.searchExpression.getItemAt(i2));
        }
        v.removeElement(this.searchExpression.getSelectedItem());
        v.insertElementAt(this.searchExpression.getSelectedItem(), 0);
        return v;
    }

    public Vector getReplaceExpressions() {
        Vector<Object> v = new Vector<Object>(this.replaceExpression.getItemCount() + 1);
        if (this.replaceExpression.getSelectedItem() == null) {
            return null;
        }
        int max = Math.min(this.replaceExpression.getItemCount(), 10);
        for (int i2 = 0; i2 < max; ++i2) {
            v.addElement(this.replaceExpression.getItemAt(i2));
        }
        v.removeElement(this.replaceExpression.getSelectedItem());
        v.insertElementAt(this.replaceExpression.getSelectedItem(), 0);
        return v;
    }

    void jbInit() throws Exception {
        this.searchExpression.setSelectOnEnter(true);
        this.jLabelSearch.setText("Search:");
        this.setLayout(this.gridBagLayout1);
        this.all.setText("All");
        this.jLabelSearchFor.setText("Search Expression:");
        this.jLabelReplaceWith.setText("Replace With:");
        this.jCheckBoxCase.setText("Match Case");
        this.jCheckBoxCase.setActionCommand("jCheckBoxCase");
        this.searchExpression.setEditable(true);
        this.add((Component)this.searchExpression, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this.all, new GridBagConstraints(1, 3, 1, 1, 0.9, 1.0, 11, 2, new Insets(10, 10, 5, 10), 0, 0));
        this.add((Component)this.jCheckBoxCase, new GridBagConstraints(1, 2, 1, 1, 0.9, 0.0, 11, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this.jLabelSearchFor, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this.jLabelSearch, new GridBagConstraints(0, 3, 1, 1, 0.1, 0.0, 18, 0, new Insets(10, 10, 10, 10), 0, 0));
        if (this.replaceEnabled) {
            this.add((Component)this.jLabelReplaceWith, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 10, 10, 10), 0, 0));
            this.add((Component)this.replaceExpression, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(10, 10, 10, 10), 0, 0));
        }
        this.buttonGroupSearch.add(this.all);
        this.setPreferredSize(new Dimension(600, 300));
    }

    public void setIgnoreCase(boolean ignore) {
        this.jCheckBoxCase.setSelected(!ignore);
    }

    @Override
    public boolean isIgnoreCase() {
        return !this.jCheckBoxCase.isSelected();
    }

    @Override
    public boolean[] getSearchOptions() {
        boolean[] flags = new boolean[this.buttons.size() + 1];
        flags[0] = this.all.isSelected();
        for (int i2 = 0; i2 < this.buttons.size(); ++i2) {
            flags[i2 + 1] = ((JRadioButton)this.buttons.elementAt(i2)).isSelected();
        }
        return flags;
    }

    public int getSearchConfig() {
        boolean[] flags = this.getSearchOptions();
        int r2 = 0;
        for (int i2 = 0; i2 < flags.length; ++i2) {
            if (!flags[i2]) continue;
            r2 |= 1 << i2;
        }
        return r2;
    }

    public void setSearchConfig(int opt) {
        for (int i2 = 0; i2 < this.buttons.size() + 1; ++i2) {
            boolean select;
            boolean bl = select = (opt & 1 << i2) > 0;
            if (!select) continue;
            if (i2 <= 0) {
                this.all.setSelected(true);
                continue;
            }
            if (i2 - 1 >= this.buttons.size()) continue;
            ((JRadioButton)this.buttons.elementAt(i2 - 1)).setSelected(true);
        }
    }
}

