/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.common;

import com.agentpp.repository.ProgressCallback;
import java.awt.Component;
import java.lang.reflect.InvocationTargetException;
import javax.swing.ProgressMonitor;
import javax.swing.SwingUtilities;

public class ProgressWatcher
implements ProgressCallback {
    private ProgressMonitor pm;
    private Component parent;
    private Object message;
    private int millisToDecice = 200;
    private int millisToPopup = 500;

    public ProgressWatcher(Component c2, Object message) {
        this.parent = c2;
        this.message = message;
    }

    public ProgressWatcher(Component c2, Object message, int millisToDecideToPopup, int millisToPopup) {
        this.parent = c2;
        this.message = message;
        this.millisToDecice = millisToDecideToPopup;
        this.millisToPopup = millisToPopup;
    }

    public void close() {
        if (this.pm != null) {
            SwingUtilities.invokeLater(() -> this.pm.close());
        }
    }

    @Override
    public boolean progressEvent(int current, int total, String descr) {
        if (this.pm == null) {
            if (!SwingUtilities.isEventDispatchThread()) {
                try {
                    SwingUtilities.invokeAndWait(() -> {
                        this.pm = new ProgressMonitor(this.parent, this.message, descr, 0, total);
                        this.pm.setMillisToDecideToPopup(this.millisToDecice);
                        this.pm.setMillisToPopup(this.millisToPopup);
                        this.pm.setProgress(current);
                    });
                }
                catch (InterruptedException | InvocationTargetException e2) {
                    return true;
                }
            } else {
                this.pm = new ProgressMonitor(this.parent, this.message, descr, 0, total);
                this.pm.setMillisToDecideToPopup(this.millisToDecice);
                this.pm.setMillisToPopup(this.millisToPopup);
                this.pm.setProgress(current);
            }
        } else {
            if (this.pm.isCanceled()) {
                return true;
            }
            if (!SwingUtilities.isEventDispatchThread()) {
                SwingUtilities.invokeLater(() -> {
                    this.pm.setNote(descr);
                    this.pm.setProgress(current);
                });
            } else {
                this.pm.setNote(descr);
                this.pm.setProgress(current);
            }
        }
        return false;
    }
}

