/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.common;

import com.agentpp.common.MIBCompiler;
import com.agentpp.mib.MIBRepository;
import com.agentpp.repository.DefaultRepositoryManager;
import com.agentpp.smiparser.SMIParseException;
import com.klg.jclass.datasource.BaseColumn;
import com.klg.jclass.datasource.BaseDataTable;
import com.klg.jclass.datasource.BaseMetaData;
import com.klg.jclass.datasource.DataModelException;
import com.klg.jclass.datasource.DataModelListener;
import com.klg.jclass.datasource.DataSourceTreeModel;
import com.klg.jclass.datasource.DataTableModel;
import com.klg.jclass.datasource.MetaDataModel;
import com.klg.jclass.datasource.TreeData;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import javax.swing.tree.TreeNode;

public class ParserLogTree
extends TreeData {
    private static final Object[][] COLUMNS_FILES_TABLE = new Object[][]{{"Status", String.class}, {"File", String.class}, {"Errors", Integer.class}, {"Path", String.class}, {"MIB Modules", String.class}};
    private static final Object[][] COLUMNS_ERRORS_TABLE = new Object[][]{{"Number", Integer.class}, {"Error Code", Integer.class}, {"Description", String.class}};
    static final int COL_STATUS = 0;
    static final int COL_FILE = 1;
    static final int COL_ERRORS = 2;
    static final int COL_PATH = 3;
    static final int COL_MODULES = 4;
    private BaseMetaData filesMetaData;
    private BaseMetaData errorsMetaData;
    private FilesTable root;
    private DataModelListener listener;
    private HashMap errorTables = new HashMap();
    private static final String STATUS_OK = "OK";

    public ParserLogTree() {
        try {
            this.createMetaData();
        }
        catch (DataModelException ex) {
            ex.printStackTrace();
        }
    }

    public List getFiles() {
        return (List)this.root.getUserData("files");
    }

    protected void createMetaData() throws DataModelException {
        BaseColumn column;
        int i2;
        this.filesMetaData = new BaseMetaData(this);
        this.filesMetaData.setDescription("MIB Files");
        this.errorsMetaData = new BaseMetaData(this);
        this.errorsMetaData.setDescription("Compilation Errors");
        ((DataSourceTreeModel)this.getMetaDataTree()).setRoot(this.filesMetaData);
        this.filesMetaData.add(this.errorsMetaData);
        this.filesMetaData.setCacheChildren(true);
        for (i2 = 0; i2 < COLUMNS_FILES_TABLE.length; ++i2) {
            column = new BaseColumn();
            column.setColumnName((String)COLUMNS_FILES_TABLE[i2][0]);
            column.setColumnClassName(((Class)COLUMNS_FILES_TABLE[i2][1]).getName());
            this.filesMetaData.addColumn(column);
        }
        for (i2 = 0; i2 < COLUMNS_ERRORS_TABLE.length; ++i2) {
            column = new BaseColumn();
            column.setColumnName((String)COLUMNS_ERRORS_TABLE[i2][0]);
            column.setColumnClassName(((Class)COLUMNS_ERRORS_TABLE[i2][1]).getName());
            this.errorsMetaData.addColumn(column);
        }
        this.root = new FilesTable(this.filesMetaData);
        ((DataSourceTreeModel)this.getDataTableTree()).setRoot(this.root);
    }

    BaseMetaData getErrorsListMetaData() {
        return this.errorsMetaData;
    }

    public void replaceModules(int fileIndex, Vector modules) {
        Object[] row = (Object[])this.getFiles().get(fileIndex);
        row[4] = modules != null ? MIBRepository.buildStringEnumeration(modules.elements()) : "";
        row[0] = STATUS_OK;
        row[2] = new Integer(0);
        try {
            this.replaceErrors(fileIndex, null);
        }
        catch (DataModelException ex) {
            ex.printStackTrace();
        }
    }

    public void replaceErrors(int fileIndex, SMIParseException pex) throws DataModelException {
        Object[] row = (Object[])this.getFiles().get(fileIndex);
        row[2] = new Integer(this.getErrors(pex));
        long bookmark = this.root.getRowIdentifier(fileIndex);
        Object old = this.errorTables.remove(new Long(bookmark));
        for (int i2 = 0; i2 < this.root.getChildCount(); ++i2) {
            BaseDataTable node = (BaseDataTable)this.root.getChildAt(i2);
            if (node != old) continue;
            node.removeFromParent();
            break;
        }
        if (pex != null) {
            this.createErrorTable(bookmark, (Object[])this.getFiles().get(fileIndex), pex);
        }
    }

    public long add(Object file, SMIParseException pex, Vector modules) throws DataModelException {
        LinkedList<Object[]> files;
        this.enableDataModelEvents(false);
        Object[] row = new Object[COLUMNS_FILES_TABLE.length];
        int errors = 0;
        if (pex != null) {
            row[0] = "Failed";
            errors = this.getErrors(pex);
        } else {
            row[0] = STATUS_OK;
        }
        row[1] = file instanceof MIBCompiler.ZipReference ? ((MIBCompiler.ZipReference)file).entry.getName() : ((File)file).getName();
        row[2] = new Integer(errors);
        row[3] = file;
        row[4] = modules != null ? MIBRepository.buildStringEnumeration(modules.elements()) : "";
        long id = this.root.addInternalRow(row);
        if (pex != null) {
            this.createErrorTable(id, row, pex);
        }
        if ((files = this.getFiles()) == null) {
            files = new LinkedList<Object[]>();
            this.root.setUserData("files", files);
        }
        files.add(row);
        this.enableDataModelEvents(true);
        return id;
    }

    private int getErrors(SMIParseException pex) {
        if (pex == null) {
            return 0;
        }
        return pex.getErrorList() != null && pex.getErrorList().size() > 0 ? pex.getErrorList().size() : 1;
    }

    private DataTableModel createErrorTable(long id, Object[] parentRow, SMIParseException pex) throws DataModelException {
        ErrorsTable errorsTable = (ErrorsTable)this.root.createTable(this.listener, id, this.errorsMetaData);
        this.errorTables.put(new Long(id), errorsTable);
        List<SMIParseException> errorList = pex.getErrorList();
        if (errorList == null || errorList.size() == 0) {
            errorList = Arrays.asList(pex);
        }
        for (int i2 = 0; i2 < errorList.size(); ++i2) {
            SMIParseException ex = errorList.get(i2);
            Object[] errRow = new Object[COLUMNS_ERRORS_TABLE.length];
            int n2 = 0;
            errRow[n2++] = new Integer(i2 + 1);
            errRow[n2++] = new Integer(ex.errorType);
            errRow[n2++] = DefaultRepositoryManager.getErrorText(ex, false).replace('\r', ' ').replace('\n', ' ');
            errorsTable.addInternalRow(errRow);
        }
        errorsTable.setUserData("errors", errorList);
        errorsTable.setUserData("file", parentRow);
        return errorsTable;
    }

    public ErrorsTable getErrorTable(long bookmark) {
        return (ErrorsTable)this.errorTables.get(new Long(bookmark));
    }

    protected void refreshFinished() {
        this.enableDataModelEvents(true);
        try {
            super.requeryAll(this.listener);
        }
        catch (DataModelException ex) {
            ex.printStackTrace();
        }
    }

    public void setDataModelListener(DataModelListener dataModelListener) {
        this.listener = dataModelListener;
    }

    public BaseDataTable getRoot() {
        return this.root;
    }

    public class FilesTable
    extends BaseDataTable {
        public FilesTable(MetaDataModel model) {
            super(model);
        }

        @Override
        public DataTableModel materializeTable(DataModelListener listener, long bookmark, TreeNode node) throws DataModelException {
            ErrorsTable newTable = ParserLogTree.this.getErrorTable(bookmark);
            if (newTable != null) {
                return newTable;
            }
            newTable = new ErrorsTable((BaseMetaData)node, bookmark);
            this.add(newTable);
            return newTable;
        }
    }

    public class ErrorsTable
    extends BaseDataTable {
        public ErrorsTable(MetaDataModel model, long parentRow) {
            super(model, parentRow);
        }
    }
}

