/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.common;

import com.agentpp.common.StatusBar;
import com.agentpp.common.TableSorter;
import com.agentpp.common.base.io.ExampleFileFilter;
import com.agentpp.common.table.TableUtils;
import com.agentpp.common.table.print.JCTableView;
import com.agentpp.common.table.print.PrintActionPanel;
import com.agentpp.common.table.print.TableFlow;
import com.agentpp.mib.MIBModule;
import com.agentpp.mib.MIBObject;
import com.agentpp.mib.MIBRepository;
import com.agentpp.mib.event.MIBModuleEvent;
import com.agentpp.mib.event.MIBModuleListener;
import com.agentpp.notepad.MIBImporter;
import com.agentpp.notepad.Notepad;
import com.agentpp.repository.DefaultRepositoryManager;
import com.agentpp.repository.RepositoryManager;
import com.agentpp.smiparser.ModuleInfo;
import com.agentpp.smiparser.ModuleInfoSorter;
import com.agentpp.smiparser.SMIParseException;
import com.agentpp.util.UserConfigFile;
import com.agentpp.util.gui.ShowDialogLater;
import com.klg.jclass.table.JCCellPosition;
import com.klg.jclass.table.JCCellRange;
import com.klg.jclass.table.JCCellStyle;
import com.klg.jclass.table.JCTable;
import com.klg.jclass.table.data.JCEditableVectorDataSource;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Objects;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.ProgressMonitor;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;

public class ParseDialog
extends JDialog
implements MIBImporter,
ActionListener,
WindowListener {
    public static final String[] PARSE_TABLE_HEADERS = new String[]{"Status", "File", "MIB Module(s) / Error Text", "Path"};
    private static final int COL_PATH = 4;
    private static final String[] ZIP_EXT = new String[]{"ZIP"};
    public static final char NEW_LINE_DELIM = '\n';
    public static final char TAB_DELIM = '\t';
    public static final String EMPTY_STRING = "";
    public static final String NEWLINE = "\n";
    public static final String NULL = "null";
    public static final String TAB = "\t";
    public static final DataFlavor data_flavour = new DataFlavor(String.class, "ExcelTokenizedString");
    private Clipboard clip_board;
    private int curr_row;
    private int curr_col;
    private int upper_row_bound;
    private int upper_col_bound;
    private StringSelection string_selection;
    private Collection selection;
    JPanel panel1 = new JPanel();
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel jPanelSouth = new JPanel();
    JPanel jPanelBorder = new JPanel();
    BorderLayout borderLayout2 = new BorderLayout();
    Border border1;
    JPanel jPanelButtons = new JPanel();
    JButton jButtonClose = new JButton();
    FlowLayout flowLayout1 = new FlowLayout();
    JCTable table = new JCTable();
    JCEditableVectorDataSource data;
    JButton jButtonPrint = new JButton();
    JFrame myFrame;
    MIBImporter importer;
    Image stop;
    private TableSorter tableSorter;
    private UserConfigFile config = new UserConfigFile();
    JButton jButtonReport = new JButton();
    static ExampleFileFilter filter = new ExampleFileFilter(ZIP_EXT);

    public ParseDialog(Image iStop, MIBImporter importer, JFrame frame, String title, boolean modal) {
        super(frame, title, modal);
        this.myFrame = frame;
        this.stop = iStop;
        this.importer = importer;
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.data = new JCEditableVectorDataSource();
        this.data.setNumColumns(PARSE_TABLE_HEADERS.length);
        this.data.setNumRows(0);
        this.data.setColumnLabels(PARSE_TABLE_HEADERS);
        this.tableSorter = new TableSorter(this.table, this.data);
        JCCellStyle colors = new JCCellStyle();
        colors.setCellEditor(null);
        colors.setEditable(false);
        this.table.setCellStyle(-997, -997, colors);
        JCCellStyle iconStyle = new JCCellStyle(colors);
        iconStyle.setHorizontalAlignment(0);
        iconStyle.setVerticalAlignment(0);
        this.table.setCellStyle(-997, 0, iconStyle);
        this.table.setPopupMenuEnabled(false);
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e2) {
                JCCellPosition cp = ParseDialog.this.table.XYToCell(e2.getX(), e2.getY());
                Object data = ParseDialog.this.table.getDataView().getTableRowLabel(cp.row);
                if (data == null) {
                    return;
                }
                if (e2.getClickCount() == 2 && data instanceof SMIParseException) {
                    Object path = ParseDialog.this.table.getDataView().getTableDataItem(cp.row, ParseDialog.this.table.getDataView().getNumColumns() - 1);
                    if (path instanceof ZipReference) {
                        try {
                            byte[] b2;
                            int l2;
                            ZipReference ref = (ZipReference)path;
                            File n2 = new File(ref.entry.getName());
                            File f2 = File.createTempFile("MIB_" + n2.getName(), ".txt");
                            FileOutputStream fos = new FileOutputStream(f2);
                            InputStream is = ref.file.getInputStream(ref.entry);
                            while (is.available() > 0 && (l2 = is.read(b2 = new byte[is.available()])) > 0) {
                                fos.write(b2, 0, l2);
                            }
                            fos.close();
                            is.close();
                            ParseDialog.this.table.getDataView().setTableDataItem(f2.getPath(), cp.row, 4);
                            ParseDialog.this.showFile((SMIParseException)data, f2);
                        }
                        catch (IOException iox) {
                            JOptionPane.showMessageDialog(ParseDialog.this, "Could not create temporary file: " + iox.getMessage(), "IO Error", 0);
                        }
                    } else {
                        ParseDialog.this.showFile((SMIParseException)data, new File(path.toString()));
                    }
                }
            }
        });
        KeyStroke copy = KeyStroke.getKeyStroke(67, 2, false);
        this.table.registerKeyboardAction(this, "copy", copy, 0);
        this.addWindowListener(this);
    }

    public ParseDialog() {
        this(null, null, null, EMPTY_STRING, false);
    }

    protected void showFile(SMIParseException pex, File file) {
        StringTokenizer st;
        final Notepad np = pex.fileError != null ? (pex.fileError.getFoundTokenImage() != null ? new Notepad(this.myFrame, file, pex.fileError.getLine(), pex.fileError.getColumn(), pex.fileError.getFoundTokenImage().length()) : new Notepad(this.myFrame, file, pex.fileError.getLine(), pex.fileError.getColumn())) : (pex.objects != null ? new Notepad(this.myFrame, file, pex.objects.get(0).toString()) : ((st = new StringTokenizer(pex.getMessage(), ", ")).hasMoreTokens() ? new Notepad(this.myFrame, file, st.nextToken()) : new Notepad(this.myFrame, file)));
        np.setConfig(this.config);
        np.setImporter(this);
        np.setError(pex);
        np.setTitle(file.getName());
        np.setLocationRelativeTo(this.myFrame);
        np.setParserMode(1);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                np.setVisible(true);
            }
        });
    }

    void jbInit() throws Exception {
        this.table.setResizeEven(false);
        this.border1 = new EtchedBorder(0, Color.white, new Color(142, 142, 142));
        this.panel1.setLayout(this.borderLayout1);
        this.jPanelSouth.setLayout(this.borderLayout2);
        this.jPanelBorder.setBorder(this.border1);
        this.jPanelBorder.setPreferredSize(new Dimension(14, 2));
        this.jButtonClose.setText("Close");
        this.jButtonClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                ParseDialog.this.jButtonClose_actionPerformed(e2);
            }
        });
        this.jPanelButtons.setLayout(this.flowLayout1);
        this.flowLayout1.setAlignment(2);
        this.table.setPopupMenuEnabled(true);
        this.table.setRowLabelDisplay(false);
        this.jButtonPrint.setText("Print");
        this.jButtonPrint.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                ParseDialog.this.jButtonPrint_actionPerformed(e2);
            }
        });
        this.jButtonReport.setToolTipText("Save report on failed MIB files to a text file");
        this.jButtonReport.setText("Save Report...");
        this.jButtonReport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                ParseDialog.this.jButtonReport_actionPerformed(e2);
            }
        });
        this.getContentPane().add(this.panel1);
        this.panel1.add((Component)this.jPanelSouth, "South");
        this.jPanelSouth.add((Component)this.jPanelBorder, "North");
        this.jPanelSouth.add((Component)this.jPanelButtons, "Center");
        this.jPanelButtons.add((Component)this.jButtonReport, null);
        this.jPanelButtons.add((Component)this.jButtonPrint, null);
        this.jPanelButtons.add((Component)this.jButtonClose, null);
        this.table.setPreferredSize(new Dimension(600, 400));
        this.table.setSelectionPolicy(2);
        this.panel1.add((Component)this.table, "Center");
        this.table.setAutoEdit(false);
        this.getRootPane().setDefaultButton(this.jButtonClose);
    }

    public void create() {
        int i2;
        this.table.setDataSource(this.data);
        for (i2 = 0; i2 < this.data.getNumRows(); ++i2) {
            this.table.setPixelHeight(i2, 33001);
        }
        for (i2 = 0; i2 < this.data.getNumColumns(); ++i2) {
            this.table.setPixelWidth(i2, 33001);
        }
        this.table.setVisibleColumns(this.data.getNumColumns() - 1);
        this.table.setVisibleRows(10);
        this.pack();
    }

    public void copySelectionToClipBoard() {
        JCCellRange range2 = null;
        String copy_value = null;
        StringBuffer buffer = new StringBuffer();
        try {
            this.selection = this.table.getSelectedCells();
            for (JCCellRange range2 : this.selection) {
                TableUtils.setRangeAfterCopy(range2);
                for (int row = range2.start_row; row <= this.upper_row_bound; ++row) {
                    for (int column = range2.start_column; column <= this.upper_col_bound; ++column) {
                        copy_value = this.table.getDataView().getObject(row, column).toString();
                        if (copy_value == null) {
                            copy_value = EMPTY_STRING;
                        } else {
                            copy_value = copy_value.replace('\t', ' ');
                            copy_value = copy_value.replace('\n', ' ');
                        }
                        if (copy_value == NULL) continue;
                        buffer.append(copy_value);
                        if (column < this.upper_col_bound) {
                            buffer.append(TAB);
                        }
                        if (column != this.upper_col_bound) continue;
                        buffer.append(NEWLINE);
                    }
                }
            }
            this.string_selection = new StringSelection(buffer.toString());
            this.clip_board = Toolkit.getDefaultToolkit().getSystemClipboard();
            this.clip_board.setContents(this.string_selection, this.string_selection);
        }
        catch (NullPointerException e2) {
            Toolkit.getDefaultToolkit().beep();
        }
        this.string_selection = null;
    }

    void jButtonClose_actionPerformed(ActionEvent e2) {
        for (int i2 = 0; i2 < this.table.getNumRows(); ++i2) {
            Object o2 = this.table.getDataSource().getTableDataItem(i2, 4);
            if (!(o2 instanceof ZipReference)) continue;
            try {
                ZipReference ref = (ZipReference)o2;
                ref.file.close();
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.dispose();
    }

    void jButtonPrint_actionPerformed(ActionEvent e2) {
        TableFlow flow = new TableFlow();
        JCTableView tableView = new JCTableView();
        tableView.setTable(this.table);
        flow.setCurrentTable(tableView);
        PrintActionPanel action = new PrintActionPanel(this.myFrame, "ParseReport");
        action.setDocumentFlow(flow);
        if (JOptionPane.showConfirmDialog(this, action, "Print Parse Report", 2, -1) == 0) {
            action.getActionPanel().actionPerformed(new ActionEvent(this, 0, "Print"));
        }
    }

    @Override
    public ModuleInfo[] importMIB(Object caller, File file, int mode) throws SMIParseException, IOException {
        Vector<Integer> rows = new Vector<Integer>();
        for (int i2 = 0; i2 < this.table.getDataSource().getNumRows(); ++i2) {
            File f2 = new File(this.table.getDataSource().getTableDataItem(i2, this.table.getDataSource().getNumColumns() - 1).toString());
            if (!f2.equals(file)) continue;
            rows.add(i2);
        }
        try {
            int i3;
            ModuleInfo[] info = this.importer.importMIB(caller, file, mode);
            Vector<String> v = new Vector<String>();
            for (i3 = 0; i3 < info.length; ++i3) {
                v.add(info[i3].moduleName);
            }
            for (i3 = 0; i3 < rows.size(); ++i3) {
                this.setRow((int)((Integer)rows.get(i3)), file, null, v);
            }
            return info;
        }
        catch (SMIParseException pex) {
            for (int i4 = 0; i4 < rows.size(); ++i4) {
                this.setRow((int)((Integer)rows.get(i4)), file, pex, null);
            }
            throw pex;
        }
        catch (IOException iox) {
            throw iox;
        }
    }

    private Vector buildRow(File f2, SMIParseException pex, Vector modules) {
        Vector<Object> r2 = new Vector<Object>();
        if (pex == null) {
            r2.addElement(EMPTY_STRING);
        } else {
            r2.addElement(this.stop);
        }
        r2.addElement(f2.getName());
        if (modules == null && pex != null) {
            r2.addElement(DefaultRepositoryManager.getErrorText(pex).replace('\r', ' '));
        } else {
            r2.addElement(MIBRepository.buildStringEnumeration(modules.elements()));
        }
        r2.addElement(f2.getPath());
        return r2;
    }

    private Vector buildRow(ZipReference f2, SMIParseException pex, Vector modules) {
        Vector<Object> r2 = new Vector<Object>();
        if (pex == null) {
            r2.addElement(EMPTY_STRING);
        } else {
            r2.addElement(this.stop);
        }
        if (f2.entry != null) {
            r2.addElement(f2.entry.getName());
        } else {
            r2.add(EMPTY_STRING);
        }
        if (modules == null && pex != null) {
            r2.addElement(DefaultRepositoryManager.getErrorText(pex).replace('\r', ' '));
        } else {
            r2.addElement(MIBRepository.buildStringEnumeration(modules.elements()));
        }
        r2.addElement(f2);
        return r2;
    }

    public void setRow(int row, File f2, SMIParseException pex, Vector modules) {
        Vector r2 = this.buildRow(f2, pex, modules);
        int col = 0;
        Enumeration en = r2.elements();
        while (en.hasMoreElements()) {
            this.data.setTableDataItem(en.nextElement(), row, col);
            ++col;
        }
        this.data.setRowLabel(row, pex);
    }

    public void addRow(File f2, SMIParseException pex, Vector modules) {
        Vector r2 = this.buildRow(f2, pex, modules);
        this.data.addRow(Integer.MAX_VALUE, pex, r2);
    }

    public void setRow(int row, ZipReference f2, SMIParseException pex, Vector modules) {
        Vector r2 = this.buildRow(f2, pex, modules);
        int col = 0;
        Enumeration en = r2.elements();
        while (en.hasMoreElements()) {
            this.data.setTableDataItem(en.nextElement(), row, col);
            ++col;
        }
        this.data.setRowLabel(row, pex);
    }

    public void addRow(ZipReference f2, SMIParseException pex, Vector modules) {
        Vector r2 = this.buildRow(f2, pex, modules);
        this.data.addRow(Integer.MAX_VALUE, pex, r2);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String cmd = event.getActionCommand();
        if (cmd.equals("copy")) {
            this.copySelectionToClipBoard();
        }
    }

    public void setConfig(UserConfigFile newConfig) {
        this.config = newConfig;
    }

    public UserConfigFile getConfig() {
        return this.config;
    }

    void jButtonReport_actionPerformed(ActionEvent e2) {
        JFileChooser fc = new JFileChooser();
        fc.setFileSelectionMode(0);
        if (fc.showSaveDialog(this) == 0) {
            Object[] options;
            int n2;
            if (fc.getSelectedFile().exists() && (n2 = JOptionPane.showOptionDialog(this, "File already exists! Replace it?", "Confirm Replace", 0, 3, null, options = new Object[]{"Yes", "Cancel"}, options[1])) == 1) {
                return;
            }
            try {
                FileOutputStream fos = new FileOutputStream(fc.getSelectedFile());
                StringBuffer buf = new StringBuffer();
                for (int i2 = 0; i2 < this.data.getNumRows(); ++i2) {
                    if (this.data.getTableDataItem(i2, 0) instanceof String) continue;
                    buf.append(this.data.getTableDataItem(i2, 1).toString());
                    buf.append(" (");
                    buf.append(this.data.getTableDataItem(i2, 3).toString());
                    buf.append("):\n");
                    SMIParseException pex = (SMIParseException)this.data.getTableRowLabel(i2);
                    buf.append(MIBObject.formatLines(TAB, DefaultRepositoryManager.getErrorText(pex) + "."));
                    buf.append("\n\n");
                }
                fos.write(buf.toString().getBytes());
                fos.close();
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this, "Error writing report: " + ex.getMessage(), "File Error", 0);
            }
        }
    }

    private static boolean isZIPFile(File f2) {
        return f2.isFile() && filter.accept(f2);
    }

    public static void compileMIBs(MIBModuleListener listener, JFrame frame, RepositoryManager repMan, File[] files, StatusBar statusBar, boolean openZIPFiles, boolean updateExistant) {
        ParseDialog.compileMIBs(listener, frame, repMan, files, statusBar, openZIPFiles, updateExistant, false);
    }

    public static void compileMIBs(MIBModuleListener listener, JFrame frame, RepositoryManager repMan, File[] files, StatusBar statusBar, boolean openZIPFiles, boolean updateExistant, boolean compileLeniently) {
        ParseDialog.compileMIBs(listener, frame, repMan, files, statusBar, openZIPFiles, updateExistant, compileLeniently, false);
    }

    public static void compileMIBs(final MIBModuleListener listener, JFrame frame, RepositoryManager repMan, File[] files, StatusBar statusBar, boolean openZIPFiles, boolean updateExistant, boolean compileLeniently, boolean silent) {
        URL url = Thread.currentThread().getContextClassLoader().getResource("toolbarButtonGraphics/general/Stop16.gif");
        ImageIcon imageStop = new ImageIcon(url);
        ParseDialog pd = new ParseDialog(imageStop.getImage(), (MIBImporter)((Object)frame), frame, "Parser Log", false);
        boolean errorsDetected = false;
        int total = 0;
        int ok = 0;
        try {
            int k2;
            ProgressMonitor pm = new ProgressMonitor(frame, "Sorting...", files[0].getPath(), 0, files.length);
            Vector<ModuleInfo> v = new Vector<ModuleInfo>(files.length + 1, 10);
            for (int j2 = 0; !pm.isCanceled() && j2 < files.length; ++j2) {
                try {
                    ModuleInfo[] info;
                    ParseDialog parseDialog = pd;
                    Objects.requireNonNull(parseDialog);
                    SwingUtilities.invokeLater(parseDialog.new ProgressUpdater(pm, j2, files[j2].getPath()));
                    if (openZIPFiles && ParseDialog.isZIPFile(files[j2])) {
                        ZipFile zipFile = new ZipFile(files[j2]);
                        info = repMan.getModuleInfo(zipFile);
                    } else {
                        info = repMan.getModuleInfo(files[j2]);
                    }
                    for (int k3 = 0; k3 < info.length; ++k3) {
                        v.add(info[k3]);
                    }
                    continue;
                }
                catch (Exception ex) {
                    ModuleInfo inf = new ModuleInfo("invalid ");
                    inf.path = files[j2];
                    v.addElement(inf);
                }
            }
            if (pm.isCanceled()) {
                return;
            }
            ModuleInfo[] existant = repMan.getModuleInfos();
            if (!updateExistant) {
                ModuleInfo inf;
                for (int i2 = 0; i2 < existant.length; ++i2) {
                    for (int j3 = 0; j3 < v.size(); ++j3) {
                        inf = (ModuleInfo)v.elementAt(j3);
                        if (!inf.getModuleName().equals(existant[i2].getModuleName())) continue;
                        v.remove(j3);
                        --j3;
                    }
                }
                Hashtable<String, String> h2 = new Hashtable<String, String>(v.size() + 10);
                for (int j4 = 0; j4 < v.size(); ++j4) {
                    inf = (ModuleInfo)v.elementAt(j4);
                    if (h2.get(inf.getModuleName()) != null) {
                        v.remove(j4);
                        --j4;
                        continue;
                    }
                    h2.put(inf.getModuleName(), inf.getModuleName());
                }
            }
            Object[] list = new ModuleInfo[v.size()];
            v.copyInto(list);
            ModuleInfoSorter s2 = new ModuleInfoSorter((ModuleInfo[])list);
            s2.setPool(existant);
            s2.sort();
            ModuleInfo[] sorted = s2.getSortedList();
            ModuleInfo[] failed = s2.getFailedList();
            files = new File[sorted.length + failed.length];
            Object[][] zipFiles = new Object[sorted.length + failed.length][];
            for (k2 = 0; k2 < sorted.length; ++k2) {
                files[k2] = sorted[k2].path;
                zipFiles[k2] = sorted[k2].userObject instanceof Object[] ? (Object[])sorted[k2].userObject : null;
            }
            while (k2 < files.length) {
                int p2 = k2 - sorted.length;
                files[k2] = failed[p2].path;
                zipFiles[k2] = failed[p2].userObject instanceof Object[] ? (Object[])failed[p2].userObject : null;
                ++k2;
            }
            ParseDialog parseDialog = pd;
            Objects.requireNonNull(parseDialog);
            SwingUtilities.invokeLater(parseDialog.new EventTrigger(pm));
            pm = new ProgressMonitor(frame, "Compiling...", files[0].getPath(), 0, files.length);
            Hashtable<Object, Object> parsed = new Hashtable<Object, Object>(files.length + 10);
            for (int j5 = 0; !pm.isCanceled() && j5 < files.length; ++j5) {
                ZipEntry entry = null;
                if (zipFiles[j5] != null) {
                    String name = files[j5].getPath();
                    entry = (ZipEntry)zipFiles[j5][1];
                    if (entry == null) {
                        ParseDialog parseDialog2 = pd;
                        Objects.requireNonNull(parseDialog2);
                        pd.addRow(parseDialog2.new ZipReference(entry, (ZipFile)zipFiles[j5][0]), new SMIParseException(name, 10), new Vector(1));
                        continue;
                    }
                }
                try {
                    int i3;
                    Vector<String> m3;
                    ModuleInfo[] info;
                    if (entry != null) {
                        if (parsed.get(entry) != null) continue;
                        parsed.put(entry, entry);
                        ++total;
                        info = compileLeniently ? repMan.addModulesLeniently(((ZipFile)zipFiles[j5][0]).getInputStream(entry), files[j5].getPath()) : repMan.addModules(((ZipFile)zipFiles[j5][0]).getInputStream(entry), files[j5].getPath());
                        ++ok;
                        m3 = new Vector();
                        for (i3 = 0; i3 < info.length; ++i3) {
                            m3.addElement(info[i3].moduleName);
                        }
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                listener.moduleEvent(new MIBModuleEvent(listener, m3, 4));
                            }
                        });
                        ParseDialog parseDialog3 = pd;
                        Objects.requireNonNull(parseDialog3);
                        pd.addRow(parseDialog3.new ZipReference(entry, (ZipFile)zipFiles[j5][0]), null, m3);
                    } else {
                        if (parsed.get(files[j5]) != null) continue;
                        ++total;
                        parsed.put(files[j5], files[j5]);
                        info = compileLeniently ? repMan.addModulesLeniently(files[j5]) : repMan.addModules(files[j5]);
                        ++ok;
                        m3 = new Vector<String>();
                        for (i3 = 0; i3 < info.length; ++i3) {
                            m3.addElement(info[i3].moduleName);
                        }
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                listener.moduleEvent(new MIBModuleEvent(listener, m3, 4));
                            }
                        });
                        pd.addRow(files[j5], null, m3);
                    }
                    ParseDialog parseDialog4 = pd;
                    Objects.requireNonNull(parseDialog4);
                    SwingUtilities.invokeLater(parseDialog4.new ProgressUpdater(pm, j5, files[j5].getPath()));
                    continue;
                }
                catch (SMIParseException pex) {
                    if (zipFiles[j5] != null) {
                        ParseDialog parseDialog5 = pd;
                        Objects.requireNonNull(parseDialog5);
                        pd.addRow(parseDialog5.new ZipReference(entry, (ZipFile)zipFiles[j5][0]), pex, null);
                        continue;
                    }
                    pd.addRow(files[j5], pex, null);
                }
            }
            ParseDialog parseDialog6 = pd;
            Objects.requireNonNull(parseDialog6);
            SwingUtilities.invokeLater(parseDialog6.new EventTrigger(pm));
            String message = "Compiled " + ok + " file(s) out of " + total + " successfully.";
            statusBar.setMessage(message);
            errorsDetected = ok < total;
        }
        catch (IOException iox) {
            String s3 = "Cannot open file: " + iox.getMessage();
            statusBar.setMessage(s3);
        }
        if (!silent) {
            Object[] options;
            if (errorsDetected) {
                options = new String[]{"OK", "Details..."};
                if (JOptionPane.showOptionDialog(frame, new String[]{"Compilation failed for " + (total - ok) + " out of " + total + " MIB modules.", "Click on 'Details...' to view the parser log to correct errors."}, "Compilation Errors", 0, 0, null, options, options[1]) == 1) {
                    pd.create();
                    pd.setLocationRelativeTo(frame);
                    SwingUtilities.invokeLater(new ShowDialogLater(pd));
                }
            } else {
                options = new String[]{"OK", "Details..."};
                if (JOptionPane.showOptionDialog(frame, "Successfully compiled all " + total + " MIB modules.", "Compilation Success", 0, 1, null, options, options[0]) == 1) {
                    pd.create();
                    pd.setLocationRelativeTo(frame);
                    SwingUtilities.invokeLater(new ShowDialogLater(pd));
                }
            }
        }
    }

    @Override
    public void windowOpened(WindowEvent e2) {
    }

    @Override
    public void windowClosing(WindowEvent e2) {
        this.jButtonClose_actionPerformed(null);
    }

    @Override
    public void windowClosed(WindowEvent e2) {
    }

    @Override
    public void windowIconified(WindowEvent e2) {
    }

    @Override
    public void windowDeiconified(WindowEvent e2) {
    }

    @Override
    public void windowActivated(WindowEvent e2) {
    }

    @Override
    public void windowDeactivated(WindowEvent e2) {
    }

    @Override
    public ModuleInfo[] checkMIB(Object caller, InputStream file, int mode) throws IOException, SMIParseException {
        ModuleInfo[] info = this.importer.checkMIB(caller, file, mode);
        return info;
    }

    @Override
    public ModuleInfo[] importMIB(Object caller, InputStream is, String path, int mode) throws IOException, SMIParseException {
        ModuleInfo[] info = this.importer.importMIB(caller, is, path, mode);
        return info;
    }

    @Override
    public MIBModule[] parseMIBs(Object caller, InputStream is, String path, int mode) throws IOException, SMIParseException {
        throw new UnsupportedOperationException();
    }

    class ZipReference {
        public ZipFile file;
        public ZipEntry entry;

        public ZipReference(ZipEntry entry, ZipFile file) {
            this.file = file;
            this.entry = entry;
        }

        public String toString() {
            return this.file.getName();
        }
    }

    class ProgressUpdater
    implements Runnable {
        private int p;
        private String note;
        private ProgressMonitor pm;

        public ProgressUpdater(ProgressMonitor pm, int p2, String note) {
            this.pm = pm;
            this.note = note;
            this.p = p2;
        }

        @Override
        public void run() {
            this.pm.setNote(this.note);
            this.pm.setProgress(this.p);
        }
    }

    class EventTrigger
    implements Runnable {
        private ProgressMonitor pm;

        public EventTrigger(ProgressMonitor pm) {
            this.pm = pm;
        }

        @Override
        public void run() {
            this.pm.close();
        }
    }
}

