/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.common;

import com.agentpp.common.ShufflePanel;
import com.agentpp.repository.RepositoryManager;
import com.agentpp.smiparser.ModuleInfo;
import com.klg.jclass.table.JCTableDataEvent;
import com.klg.jclass.table.JCTableDataListener;
import com.klg.jclass.table.data.JCVectorDataSource;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;

public class ModulesSelectionPanel
extends JPanel
implements JCTableDataListener {
    BorderLayout borderLayout1 = new BorderLayout();
    private RepositoryManager repMan;
    private Hashtable modulesExcluded;
    Border border1;
    FlowLayout flowLayout1 = new FlowLayout();
    private ModuleInfo[] modules = null;
    private static String[] HEADER = new String[]{"MIB Module"};
    private JCVectorDataSource modelLeft = new JCVectorDataSource();
    private JCVectorDataSource modelRight = new JCVectorDataSource();
    private Vector result = null;
    ShufflePanel shufflePanel = new ShufflePanel();
    private boolean forceDependencies = true;

    public ModulesSelectionPanel(ModuleInfo[] modules, Hashtable exclude) {
        this.modules = modules;
        this.modulesExcluded = exclude;
        this.modelLeft.setNumColumns(1);
        this.modelLeft.setNumRows(0);
        this.modelLeft.setColumnLabel(0, HEADER[0]);
        this.modelRight.setNumRows(0);
        this.modelRight.setNumColumns(1);
        this.modelRight.setColumnLabel(0, HEADER[0]);
        this.shufflePanel.setLeftData(this.modelLeft);
        this.shufflePanel.setRightData(this.modelRight);
        this.shufflePanel.getLeftTable().setVisibleColumns(1);
        this.shufflePanel.getRightTable().setVisibleColumns(1);
        for (int i2 = 0; i2 < modules.length; ++i2) {
            Vector<ModuleInfo> v = new Vector<ModuleInfo>(1);
            v.addElement(modules[i2]);
            if (this.modulesExcluded.get(modules[i2].getModuleName()) == null) {
                this.modelLeft.addRow(Integer.MAX_VALUE, modules[i2].getModuleName(), v);
                continue;
            }
            this.modelRight.addRow(Integer.MAX_VALUE, modules[i2].getModuleName(), v);
        }
        this.modelRight.addTableDataListener(this);
        this.modelLeft.addTableDataListener(this);
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public ModulesSelectionPanel() {
        this(null, null);
    }

    void jbInit() throws Exception {
        this.border1 = new EtchedBorder(0, Color.white, new Color(142, 142, 142));
        this.setLayout(this.borderLayout1);
        this.setBorder(this.border1);
        this.setPreferredSize(new Dimension(14, 2));
        this.flowLayout1.setAlignment(2);
        this.shufflePanel.setLeftTitle("Available");
        this.shufflePanel.setRightTitle("Loaded");
        this.add((Component)this.shufflePanel, "North");
    }

    private HashSet missingModules(boolean all) {
        ModuleInfo m3;
        int i2;
        Hashtable<String, ModuleInfo> h2 = new Hashtable<String, ModuleInfo>(this.modules.length + 1);
        HashSet<String> missing = new HashSet<String>();
        for (i2 = 1; i2 < this.modelRight.getNumRows(); ++i2) {
            m3 = (ModuleInfo)this.modelRight.getTableDataItem(i2, 0);
            h2.put(m3.getModuleName(), m3);
            if (!all) continue;
            missing.add(m3.getModuleName());
        }
        if (this.forceDependencies) {
            for (i2 = 1; i2 < this.modelRight.getNumRows(); ++i2) {
                m3 = (ModuleInfo)this.modelRight.getTableDataItem(i2, 0);
                String[] imp = m3.getImports();
                for (int j2 = 0; j2 < imp.length; ++j2) {
                    if (h2.get(imp[j2]) != null) continue;
                    missing.add(imp[j2]);
                }
            }
        }
        return missing;
    }

    public Vector getModules() {
        HashSet set = this.missingModules(true);
        this.result = new Vector(set.size() + 1);
        Iterator it = set.iterator();
        while (it.hasNext()) {
            this.result.addElement(it.next());
        }
        return this.result;
    }

    public Vector getObsoleteModules() {
        Vector<String> v = new Vector<String>();
        for (int i2 = 1; i2 < this.modelLeft.getNumRows(); ++i2) {
            String s2 = ((ModuleInfo)this.modelLeft.getTableDataItem(i2, 0)).getModuleName();
            if (this.modulesExcluded.get(s2) == null) continue;
            v.addElement(s2);
        }
        return v;
    }

    public void setModuleTitle(String title) {
        this.shufflePanel.setRightTitle(title);
    }

    @Override
    public void dataChanged(JCTableDataEvent e2) {
        block6: {
            block5: {
                if (!this.forceDependencies) {
                    return;
                }
                if (e2.getSource() != this.modelLeft || e2.getCommand() != 3) break block5;
                String s2 = ((ModuleInfo)this.modelLeft.getTableDataItem(e2.getRow(), 0)).getModuleName();
                block0: for (int i2 = 1; i2 < this.modelRight.getNumRows(); ++i2) {
                    ModuleInfo info = (ModuleInfo)this.modelRight.getTableDataItem(i2, 0);
                    if (s2.equals(info.getModuleName())) continue;
                    String[] imports = info.getImports();
                    for (int j2 = 0; j2 < imports.length; ++j2) {
                        if (!imports[j2].equals(s2)) continue;
                        Object o2 = this.modelRight.getTableDataItem(i2, 0);
                        Object l2 = this.modelRight.getTableRowLabel(i2);
                        Vector<Object> v = new Vector<Object>(1);
                        v.addElement(o2);
                        this.modelRight.deleteRows(i2, 1);
                        this.modelLeft.addRow(Integer.MAX_VALUE, l2, v);
                        --i2;
                        continue block0;
                    }
                }
                break block6;
            }
            if (e2.getSource() != this.modelRight || e2.getCommand() != 3) break block6;
            HashSet missing = this.missingModules(false);
            block2: for (String s3 : missing) {
                for (int i3 = 1; i3 < this.modelLeft.getNumRows(); ++i3) {
                    if (!((ModuleInfo)this.modelLeft.getTableDataItem(i3, 0)).getModuleName().equals(s3)) continue;
                    Object o3 = this.modelLeft.getTableDataItem(i3, 0);
                    Object l3 = this.modelLeft.getTableRowLabel(i3);
                    Vector<Object> v = new Vector<Object>(1);
                    v.addElement(o3);
                    this.modelLeft.deleteRows(i3, 1);
                    this.modelRight.addRow(Integer.MAX_VALUE, l3, v);
                    continue block2;
                }
            }
        }
    }

    public boolean isForceDependencies() {
        return this.forceDependencies;
    }

    public void setForceDependencies(boolean forceDependencies) {
        this.forceDependencies = forceDependencies;
    }
}

