/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.common;

import com.agentpp.common.ShufflePanel;
import com.agentpp.smiparser.ModuleInfo;
import com.klg.jclass.table.JCTable;
import com.klg.jclass.table.JCTableDataEvent;
import com.klg.jclass.table.JCTableDataListener;
import com.klg.jclass.table.data.JCVectorDataSource;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;

public class ModulesDeletionDialog
extends JDialog
implements JCTableDataListener {
    JPanel panel1 = new JPanel();
    BorderLayout borderLayout1 = new BorderLayout();
    private Hashtable modulesExcluded;
    JPanel jPanelSouth = new JPanel();
    JPanel jPanelButton = new JPanel();
    BorderLayout borderLayout2 = new BorderLayout();
    JPanel jPanel1 = new JPanel();
    BorderLayout borderLayout3 = new BorderLayout();
    Border border1;
    JPanel jPanel2 = new JPanel();
    JButton jButtonOK = new JButton();
    JButton jButtonCancel = new JButton();
    FlowLayout flowLayout1 = new FlowLayout();
    private ModuleInfo[] modules = null;
    private static String[] HEADER = new String[]{"MIB Module"};
    private JCVectorDataSource modelLeft = new JCVectorDataSource();
    private JCVectorDataSource modelRight = new JCVectorDataSource();
    private List<String> result = null;
    ShufflePanel shufflePanel = new ShufflePanel();

    public ModulesDeletionDialog(ModuleInfo[] modules, Hashtable exclude, Frame frame, String title, boolean modal) {
        super(frame, title, modal);
        this.modules = modules;
        this.modulesExcluded = exclude;
        this.modelLeft.setNumColumns(1);
        this.modelLeft.setNumRows(0);
        this.modelLeft.setColumnLabel(0, HEADER[0]);
        this.modelRight.setNumRows(0);
        this.modelRight.setNumColumns(1);
        this.modelRight.setColumnLabel(0, HEADER[0]);
        this.shufflePanel.setLeftData(this.modelLeft);
        this.shufflePanel.setRightData(this.modelRight);
        this.shufflePanel.getLeftTable().setVisibleColumns(1);
        this.shufflePanel.getRightTable().setVisibleColumns(1);
        for (ModuleInfo module : modules) {
            Vector<ModuleInfo> v = new Vector<ModuleInfo>(1);
            v.add(module);
            if (this.modulesExcluded.get(module.getModuleName()) == null) {
                this.modelLeft.addRow(Integer.MAX_VALUE, module.getModuleName(), v);
                continue;
            }
            this.modelRight.addRow(Integer.MAX_VALUE, module.getModuleName(), v);
        }
        this.modelRight.addTableDataListener(this);
        this.modelLeft.addTableDataListener(this);
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public ModulesDeletionDialog() {
        this(null, null, null, "", false);
    }

    void jbInit() throws Exception {
        this.border1 = new EtchedBorder(0, Color.white, new Color(142, 142, 142));
        this.panel1.setLayout(this.borderLayout1);
        this.jPanelSouth.setLayout(this.borderLayout2);
        this.jPanelButton.setLayout(this.borderLayout3);
        this.jPanel1.setBorder(this.border1);
        this.jPanel1.setPreferredSize(new Dimension(14, 2));
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                ModulesDeletionDialog.this.jButtonOK_actionPerformed(e2);
            }
        });
        this.jPanel2.setLayout(this.flowLayout1);
        this.jButtonCancel.setToolTipText("");
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                ModulesDeletionDialog.this.jButtonCancel_actionPerformed(e2);
            }
        });
        this.flowLayout1.setAlignment(2);
        this.shufflePanel.setLeftTitle("Available");
        this.shufflePanel.setRightTitle("Delete");
        this.getContentPane().add(this.panel1);
        this.panel1.add((Component)this.jPanelSouth, "South");
        this.jPanelSouth.add((Component)this.jPanelButton, "Center");
        this.jPanelButton.add((Component)this.jPanel1, "North");
        this.jPanelButton.add((Component)this.jPanel2, "East");
        this.jPanel2.add((Component)this.jButtonOK, null);
        this.jPanel2.add((Component)this.jButtonCancel, null);
        this.panel1.add((Component)this.shufflePanel, "Center");
    }

    private Set<String> missingModules(boolean all) {
        ModuleInfo m3;
        int i2;
        HashMap<String, ModuleInfo> h2 = new HashMap<String, ModuleInfo>(this.modules.length + 1);
        HashSet<String> missing = new HashSet<String>();
        for (i2 = 1; i2 < this.modelRight.getNumRows(); ++i2) {
            m3 = (ModuleInfo)this.modelRight.getTableDataItem(i2, 0);
            h2.put(m3.getModuleName(), m3);
            if (!all) continue;
            missing.add(m3.getModuleName());
        }
        for (i2 = 1; i2 < this.modelLeft.getNumRows(); ++i2) {
            String[] imp;
            m3 = (ModuleInfo)this.modelLeft.getTableDataItem(i2, 0);
            for (String s2 : imp = m3.getImports()) {
                if (h2.get(s2) == null) continue;
                missing.add(m3.getModuleName());
            }
        }
        return missing;
    }

    void jButtonOK_actionPerformed(ActionEvent e2) {
        Set<String> set = this.missingModules(true);
        this.result = new ArrayList<String>(set.size());
        this.result.addAll(set);
        this.dispose();
    }

    void jButtonCancel_actionPerformed(ActionEvent e2) {
        this.dispose();
    }

    public List<String> getModules() {
        return this.result;
    }

    public List<String> getObsoleteModules() {
        ArrayList<String> v = new ArrayList<String>();
        for (int i2 = 1; i2 < this.modelLeft.getNumRows(); ++i2) {
            String s2 = ((ModuleInfo)this.modelLeft.getTableDataItem(i2, 0)).getModuleName();
            if (this.modulesExcluded.get(s2) == null) continue;
            v.add(s2);
        }
        return v;
    }

    public void setModuleTitle(String title) {
        this.shufflePanel.setRightTitle(title);
    }

    @Override
    public void dataChanged(JCTableDataEvent e2) {
        block4: {
            block3: {
                if (e2.getSource() != this.modelLeft || e2.getCommand() != 3) break block3;
                ModuleInfo s2 = (ModuleInfo)this.modelLeft.getTableDataItem(e2.getRow(), 0);
                for (int i2 = 1; i2 < this.modelRight.getNumRows(); ++i2) {
                    ModuleInfo info = (ModuleInfo)this.modelRight.getTableDataItem(i2, 0);
                    if (!s2.importsFrom(info.getModuleName())) continue;
                    Object o2 = this.modelRight.getTableDataItem(i2, 0);
                    Object l2 = this.modelRight.getTableRowLabel(i2);
                    Vector<Object> v = new Vector<Object>(1);
                    v.add(o2);
                    this.modelRight.deleteRows(i2, 1);
                    this.modelLeft.addRow(Integer.MAX_VALUE, l2, v);
                    --i2;
                }
                break block4;
            }
            if (e2.getSource() != this.modelRight || e2.getCommand() != 3) break block4;
            Set<String> missing = this.missingModules(false);
            block1: for (String s3 : missing) {
                for (int i3 = 1; i3 < this.modelLeft.getNumRows(); ++i3) {
                    if (!((ModuleInfo)this.modelLeft.getTableDataItem(i3, 0)).getModuleName().equals(s3)) continue;
                    Object o3 = this.modelLeft.getTableDataItem(i3, 0);
                    Object l3 = this.modelLeft.getTableRowLabel(i3);
                    Vector<Object> v = new Vector<Object>(1);
                    v.add(o3);
                    this.modelLeft.deleteRows(i3, 1);
                    this.modelRight.addRow(Integer.MAX_VALUE, l3, v);
                    continue block1;
                }
            }
        }
    }

    public JCTable getSelectionTable() {
        return this.shufflePanel.getLeftTable();
    }
}

