/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.common;

import com.agentpp.common.ModulesDeletionDialog;
import com.agentpp.common.StatusBar;
import com.agentpp.repository.RepositoryManager;
import com.agentpp.smiparser.ModuleInfo;
import com.klg.jclass.table.JCTable;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class MIBDeletionDialog
extends ModulesDeletionDialog {
    private final Logger logger;
    private final StatusBar statusBar;
    private final RepositoryManager repMan;

    public MIBDeletionDialog(Logger l2, StatusBar statusBar, ModuleInfo[] moduleInfo, RepositoryManager repMan, JFrame frame, String title) throws IOException {
        super(moduleInfo, new Hashtable(2), frame, title, true);
        this.logger = l2;
        this.statusBar = statusBar;
        this.repMan = repMan;
    }

    public JCTable getLeftTable() {
        return this.shufflePanel.getLeftTable();
    }

    @Override
    public void jButtonOK_actionPerformed(ActionEvent e2) {
        super.jButtonOK_actionPerformed(e2);
        List<String> v = this.getModules();
        if (v.size() > 0) {
            String[] txt = new String[]{"Continue deleting " + v.size() + " MIB module" + (v.size() > 1 ? "s" : ""), "from the current MIB Repository?"};
            if (JOptionPane.showConfirmDialog(this, txt, "Confirm MIB Deletion", 0, 2) == 1) {
                return;
            }
            try {
                int deleted = 0;
                ArrayList<String> victims = new ArrayList<String>(v.size());
                victims.addAll(v);
                for (String victim : victims) {
                    this.repMan.removeModule(victim);
                    if (this.logger == null) continue;
                    this.logger.info(victim);
                }
                for (String victim : victims) {
                    this.repMan.removeModule(victim);
                    if (this.logger == null) continue;
                    this.logger.info(victim);
                }
                deleted = victims.size();
                if (deleted == 1) {
                    this.statusBar.setMessage("Removed " + (String)victims.get(0) + " from MIB repository");
                } else if (deleted > 1) {
                    this.statusBar.setMessage("Removed " + deleted + " MIB modules from MIB Repository");
                }
            }
            catch (IOException iox) {
                if (this.logger != null) {
                    this.logger.severe(iox.getMessage());
                }
                this.statusBar.setMessage("Error while deleting MIBs: " + iox.getMessage());
            }
        }
    }
}

