/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.common;

import com.agentpp.common.ParserLog;
import com.agentpp.common.StandardDialog;
import com.agentpp.common.StatusBar;
import com.agentpp.common.base.io.ExampleFileFilter;
import com.agentpp.mib.event.MIBModuleEvent;
import com.agentpp.mib.event.MIBModuleListener;
import com.agentpp.notepad.MIBImporter;
import com.agentpp.repository.RepositoryManager;
import com.agentpp.smiparser.ModuleInfo;
import com.agentpp.smiparser.ModuleInfoSorter;
import com.agentpp.smiparser.SMIParseException;
import com.agentpp.util.UserConfigFile;
import com.agentpp.util.gui.ShowDialogLater;
import java.awt.Dimension;
import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.ProgressMonitor;
import javax.swing.SwingUtilities;

public class MIBCompiler {
    private static final String[] ZIP_EXT = new String[]{"ZIP"};
    static ExampleFileFilter filter = new ExampleFileFilter(ZIP_EXT);
    private static boolean lookupEnabled;

    public static void compileMIBs(UserConfigFile config, MIBModuleListener listener, JFrame frame, RepositoryManager repMan, File[] files, StatusBar statusBar, boolean openZIPFiles, UpdateMode updateExistant) {
        MIBCompiler.compileMIBs(config, listener, frame, repMan, files, statusBar, openZIPFiles, updateExistant, false);
    }

    public static void compileMIBs(UserConfigFile config, MIBModuleListener listener, JFrame frame, RepositoryManager repMan, File[] files, StatusBar statusBar, boolean openZIPFiles, UpdateMode updateExistant, boolean compileLeniently) {
        MIBCompiler.compileMIBs(config, listener, frame, repMan, files, statusBar, openZIPFiles, updateExistant, compileLeniently, false);
    }

    public static List compileMIBs(UserConfigFile config, final MIBModuleListener listener, JFrame frame, RepositoryManager repMan, File[] files, StatusBar statusBar, boolean openZIPFiles, UpdateMode updateExistant, boolean compileLeniently, boolean silent) {
        ArrayList<CompilationResult> results = new ArrayList<CompilationResult>();
        StandardDialog sd = null;
        ParserLog pd = null;
        if (frame != null) {
            sd = new StandardDialog((Frame)frame, "Compiler Log", false, false);
            pd = new ParserLog(config, frame, (MIBImporter)((Object)frame));
            pd.setPreferredSize(new Dimension(800, 500));
            pd.setLookupEnabled(lookupEnabled);
        }
        boolean errorsDetected = false;
        int total = 0;
        int ok = 0;
        try {
            int k2;
            ProgressMonitor pm = null;
            if (frame != null) {
                pm = new ProgressMonitor(frame, "Sorting...", files[0].getPath(), 0, files.length);
            }
            ArrayList<ModuleInfo> v = new ArrayList<ModuleInfo>(files.length + 1);
            for (int j2 = 0; !(pm != null && pm.isCanceled() || j2 >= files.length); ++j2) {
                try {
                    ModuleInfo[] info;
                    if (frame != null) {
                        SwingUtilities.invokeLater(new ProgressUpdater(pm, j2, files[j2].getPath()));
                    }
                    if (openZIPFiles && MIBCompiler.isZIPFile(files[j2])) {
                        ZipFile zipFile = new ZipFile(files[j2]);
                        info = repMan.getModuleInfo(zipFile);
                    } else {
                        info = repMan.getModuleInfo(files[j2]);
                    }
                    Collections.addAll(v, info);
                    continue;
                }
                catch (Exception ex) {
                    ModuleInfo inf = new ModuleInfo("invalid ");
                    inf.path = files[j2];
                    v.add(inf);
                }
            }
            if (pm != null && pm.isCanceled()) {
                return results;
            }
            ModuleInfo[] existant = repMan.getModuleInfos();
            if (updateExistant != UpdateMode.updateAlways) {
                ModuleInfo inf;
                for (int i2 = 0; i2 < existant.length; ++i2) {
                    for (int j3 = 0; j3 < v.size(); ++j3) {
                        inf = (ModuleInfo)v.get(j3);
                        if (!inf.getModuleName().equals(existant[i2].getModuleName()) || updateExistant == UpdateMode.updateIfNewer && inf.getLastUpdated() != null && (inf.getLastUpdated() == null || existant[i2].getLastUpdated() != null && (existant[i2].getLastUpdated() == null || inf.getLastUpdated().compareTo(existant[i2].getLastUpdated()) > 0))) continue;
                        v.remove(j3);
                        --j3;
                    }
                }
                HashMap<String, ModuleInfo> h2 = new HashMap<String, ModuleInfo>(v.size() + 10);
                for (int j4 = 0; j4 < v.size(); ++j4) {
                    inf = (ModuleInfo)v.get(j4);
                    if (h2.containsKey(inf.getModuleName())) {
                        ModuleInfo ex;
                        if (updateExistant == UpdateMode.updateIfNewer && ((ex = (ModuleInfo)h2.get(inf.getModuleName())).getLastUpdated() == null && inf.getLastUpdated() != null || ex.getLastUpdated() != null && inf.getLastUpdated() != null && ex.getLastUpdated().compareTo(inf.getLastUpdated()) < 0)) {
                            v.remove(ex);
                            --j4;
                            continue;
                        }
                        v.remove(j4);
                        --j4;
                        continue;
                    }
                    h2.put(inf.getModuleName(), inf);
                }
            }
            ModuleInfo[] list = new ModuleInfo[v.size()];
            v.toArray(list);
            v = null;
            ModuleInfoSorter s2 = new ModuleInfoSorter(list);
            s2.setPool(existant);
            s2.setBackupPool(repMan.getBuiltinModuleNames());
            s2.sort();
            ModuleInfo[] sorted = s2.getSortedList();
            ModuleInfo[] failed = s2.getFailedList();
            files = new File[sorted.length + failed.length];
            Object[][] zipFiles = new Object[sorted.length + failed.length][];
            for (k2 = 0; k2 < sorted.length; ++k2) {
                files[k2] = sorted[k2].path;
                zipFiles[k2] = sorted[k2].userObject instanceof Object[] ? (Object[])sorted[k2].userObject : null;
            }
            while (k2 < files.length) {
                int p2 = k2 - sorted.length;
                files[k2] = failed[p2].path;
                zipFiles[k2] = failed[p2].userObject instanceof Object[] ? (Object[])failed[p2].userObject : null;
                ++k2;
            }
            if (frame != null) {
                SwingUtilities.invokeLater(new EventTrigger(pm));
                pm = new ProgressMonitor(frame, "Compiling...", files[0].getPath(), 0, files.length);
            }
            HashSet<Object> parsed = new HashSet<Object>(files.length + 10);
            ProgressUpdater progressUpdater = null;
            for (int j5 = 0; !(pm != null && pm.isCanceled() || j5 >= files.length); ++j5) {
                ZipEntry entry = null;
                if (zipFiles[j5] != null) {
                    String name = files[j5].getPath();
                    entry = (ZipEntry)zipFiles[j5][1];
                    if (entry == null && pd != null) {
                        pd.addResult(new ZipReference(entry, (ZipFile)zipFiles[j5][0]), new SMIParseException(name, 10), new Vector(1));
                        continue;
                    }
                }
                try {
                    Vector<String> m3;
                    ModuleInfo[] info;
                    if (entry != null) {
                        if (parsed.contains(entry.getName())) continue;
                        parsed.add(entry.getName());
                        ++total;
                        info = compileLeniently ? repMan.addModulesLeniently(((ZipFile)zipFiles[j5][0]).getInputStream(entry), files[j5].getPath()) : repMan.addModules(((ZipFile)zipFiles[j5][0]).getInputStream(entry), files[j5].getPath());
                        ++ok;
                        m3 = new Vector();
                        for (ModuleInfo anInfo : info) {
                            m3.addElement(anInfo.moduleName);
                        }
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                listener.moduleEvent(new MIBModuleEvent(listener, m3, 4));
                            }
                        });
                        if (pd != null) {
                            pd.addResult(new ZipReference(entry, (ZipFile)zipFiles[j5][0]), null, m3);
                        }
                        results.add(new CompilationResult(entry.getName(), null, m3));
                    } else {
                        if (parsed.contains(files[j5])) continue;
                        ++total;
                        parsed.add(files[j5]);
                        info = compileLeniently ? repMan.addModulesLeniently(files[j5]) : repMan.addModules(files[j5]);
                        ++ok;
                        m3 = new Vector<String>();
                        for (ModuleInfo anInfo : info) {
                            m3.add(anInfo.moduleName);
                        }
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                listener.moduleEvent(new MIBModuleEvent(listener, m3, 4));
                            }
                        });
                        if (pd != null) {
                            pd.addResult(files[j5], null, m3);
                        }
                    }
                    if (progressUpdater != null && !progressUpdater.isFinished()) {
                        progressUpdater.note = files[j5].getPath();
                        progressUpdater.p = j5;
                        continue;
                    }
                    if (pm == null) continue;
                    progressUpdater = new ProgressUpdater(pm, j5, files[j5].getPath());
                    SwingUtilities.invokeLater(progressUpdater);
                    continue;
                }
                catch (SMIParseException pex) {
                    pex.freeUnusedTokens();
                    if (pd != null) {
                        if (zipFiles[j5] != null) {
                            pd.addResult(new ZipReference(entry, (ZipFile)zipFiles[j5][0]), pex, null);
                        } else {
                            pd.addResult(files[j5], pex, null);
                        }
                    }
                    results.add(new CompilationResult(zipFiles[j5] != null && entry != null ? entry.getName() : files[j5].getPath(), pex, null));
                }
            }
            if (pm != null) {
                SwingUtilities.invokeLater(new EventTrigger(pm));
            }
            errorsDetected = ok < total;
            String message = errorsDetected ? "Compilation failed for " + (total - ok) + " out of " + total + " MIB modules." : "Successfully compiled all " + total + " MIB modules.";
            statusBar.setMessage(message);
        }
        catch (IOException iox) {
            String s3 = "Cannot open file: " + iox.getMessage();
            statusBar.setMessage(s3);
        }
        if (frame != null && !silent) {
            Object[] options;
            if (errorsDetected) {
                options = new String[]{"OK", "Details..."};
                if (JOptionPane.showOptionDialog(frame, new String[]{"Compilation failed for " + (total - ok) + " out of " + total + " MIB modules.", "Click on 'Details...' to view the compiler log to correct errors."}, "Compilation Errors", 0, 0, null, options, options[1]) == 1) {
                    sd.setCenterPanel(pd);
                    pd.refresh();
                    sd.setLocationRelativeTo(frame);
                    SwingUtilities.invokeLater(new ShowDialogLater(sd));
                }
            } else {
                options = new String[]{"OK", "Details..."};
                if (JOptionPane.showOptionDialog(frame, "Successfully compiled all " + total + " MIB modules.", "Compilation Success", 0, 1, null, options, options[0]) == 1) {
                    sd.setCenterPanel(pd);
                    pd.refresh();
                    sd.setLocationRelativeTo(frame);
                    SwingUtilities.invokeLater(new ShowDialogLater(sd));
                }
            }
        }
        return results;
    }

    private static boolean isZIPFile(File f2) {
        return f2.isFile() && filter.accept(f2);
    }

    public static void setLookupEnabled(boolean parserLookupEnabled) {
        lookupEnabled = parserLookupEnabled;
    }

    public static enum UpdateMode {
        addNewOnly,
        updateIfNewer,
        updateAlways;

    }

    public static class ProgressUpdater
    implements Runnable {
        private int p;
        private String note;
        private ProgressMonitor pm;
        private boolean finished;

        public ProgressUpdater(ProgressMonitor pm, int p2, String note) {
            this.pm = pm;
            this.note = note;
            this.p = p2;
        }

        @Override
        public void run() {
            this.finished = true;
            this.pm.setNote(this.note);
            this.pm.setProgress(this.p);
        }

        public boolean isFinished() {
            return this.finished;
        }
    }

    public static class EventTrigger
    implements Runnable {
        private ProgressMonitor pm;

        public EventTrigger(ProgressMonitor pm) {
            this.pm = pm;
        }

        @Override
        public void run() {
            this.pm.close();
        }
    }

    public static class ZipReference
    implements Comparable {
        public ZipFile file;
        public ZipEntry entry;

        public ZipReference(ZipEntry entry, ZipFile file) {
            this.file = file;
            this.entry = entry;
        }

        public String toString() {
            return this.file.getName();
        }

        public int compareTo(Object o2) {
            if (o2 instanceof File) {
                return this.toString().compareTo(o2.toString());
            }
            if (o2 instanceof ZipReference) {
                int c2 = this.file.getName().compareTo(((ZipReference)o2).file.getName());
                if (c2 == 0) {
                    return this.entry.getName().compareTo(((ZipReference)o2).entry.getName());
                }
                return c2;
            }
            throw new ClassCastException();
        }
    }

    public static class CompilationResult
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String fileName;
        private SMIParseException pex;
        private List modules;

        public CompilationResult(String fname, SMIParseException pex, List modules) {
            this.fileName = fname;
            this.pex = pex;
            this.modules = modules;
        }

        public String getFilename() {
            return this.fileName;
        }

        public SMIParseException getParseException() {
            return this.pex;
        }

        public List getModules() {
            return this.modules;
        }
    }
}

