/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.common;

import com.agentpp.common.ListEditorPanel_jButtonAdd_actionAdapter;
import com.agentpp.common.ListEditorPanel_jButtonDown_actionAdapter;
import com.agentpp.common.ListEditorPanel_jButtonEdit_actionAdapter;
import com.agentpp.common.ListEditorPanel_jButtonRemove_actionAdapter;
import com.agentpp.common.ListEditorPanel_jButtonUp_actionAdapter;
import com.agentpp.common.ListItemEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ListEditorPanel
extends JPanel
implements ListSelectionListener {
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel jPanelList = new JPanel();
    JPanel jPanelButtons = new JPanel();
    JButton jButtonAdd = new JButton();
    JButton jButtonEdit = new JButton();
    JButton jButtonRemove = new JButton();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JButton jButtonUp = new JButton();
    JButton jButtonDown = new JButton();
    JLabel jLabelList = new JLabel();
    JList list = new JList();
    BorderLayout verticalFlowLayout1 = new BorderLayout();
    JScrollPane jScrollPane1 = new JScrollPane();
    Border border1;
    DefaultListModel listModel = new DefaultListModel();
    private HierarchyListener editorPaneListener;
    private ListItemEditor editor;

    public ListEditorPanel() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.list.setModel(this.listModel);
        this.list.addListSelectionListener(this);
    }

    void jbInit() throws Exception {
        this.border1 = BorderFactory.createEmptyBorder(5, 0, 10, 0);
        this.setLayout(this.borderLayout1);
        this.jPanelButtons.setLayout(this.gridBagLayout1);
        this.jButtonAdd.setText("Add");
        this.jButtonAdd.addActionListener(new ListEditorPanel_jButtonAdd_actionAdapter(this));
        this.jButtonEdit.setText("Edit");
        this.jButtonEdit.addActionListener(new ListEditorPanel_jButtonEdit_actionAdapter(this));
        this.jButtonRemove.setText("Remove");
        this.jButtonRemove.addActionListener(new ListEditorPanel_jButtonRemove_actionAdapter(this));
        this.jButtonUp.setText("Move Up");
        this.jButtonUp.addActionListener(new ListEditorPanel_jButtonUp_actionAdapter(this));
        this.jButtonDown.setText("Move Down");
        this.jButtonDown.addActionListener(new ListEditorPanel_jButtonDown_actionAdapter(this));
        this.jPanelList.setLayout(this.verticalFlowLayout1);
        this.jLabelList.setText("List:");
        this.borderLayout1.setHgap(0);
        this.borderLayout1.setVgap(0);
        this.jPanelList.setBorder(this.border1);
        this.list.setMinimumSize(new Dimension(100, 50));
        this.list.setPreferredSize(new Dimension(200, 200));
        this.add((Component)this.jPanelList, "Center");
        this.add((Component)this.jPanelButtons, "East");
        this.jPanelButtons.add((Component)this.jButtonAdd, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(10, 10, 5, 10), 18, 0));
        this.jPanelButtons.add((Component)this.jButtonEdit, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 10, 5, 10), 22, 0));
        this.jPanelButtons.add((Component)this.jButtonRemove, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 10, 10, 10), 0, 0));
        this.jPanelButtons.add((Component)this.jButtonUp, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 15, 2, new Insets(5, 10, 5, 10), 0, 0));
        this.jPanelButtons.add((Component)this.jButtonDown, new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 15, 2, new Insets(5, 10, 10, 10), 0, 0));
        this.jPanelList.add((Component)this.jLabelList, "North");
        this.jPanelList.add((Component)this.jScrollPane1, "Center");
        this.jScrollPane1.getViewport().add((Component)this.list, null);
    }

    private void populateValues(Vector values) {
        this.listModel.removeAllElements();
        for (int i2 = 0; i2 < values.size(); ++i2) {
            this.listModel.addElement(values.get(i2));
        }
        this.updateButtons();
    }

    public Vector getValues() {
        Vector v = new Vector(this.listModel.size());
        for (int i2 = 0; i2 < this.listModel.size(); ++i2) {
            v.add(this.listModel.get(i2));
        }
        return v;
    }

    public void setValues(Vector values) {
        this.populateValues(values);
    }

    void jButtonUp_actionPerformed(ActionEvent e2) {
        int index = this.list.getSelectedIndex();
        if (index > 0) {
            ListEditorPanel.swap(this.listModel, index, index - 1);
            this.list.setSelectedIndex(index - 1);
        }
        this.updateButtons();
    }

    private static void swap(DefaultListModel l2, int from, int to) {
        Object o2 = l2.get(from);
        l2.set(from, l2.get(to));
        l2.set(to, o2);
    }

    void jButtonDown_actionPerformed(ActionEvent e2) {
        int index = this.list.getSelectedIndex();
        if (index < this.listModel.size() - 1) {
            ListEditorPanel.swap(this.listModel, index, index + 1);
            this.list.setSelectedIndex(index + 1);
        }
        this.updateButtons();
    }

    private void updateButtons() {
        int index = this.list.getSelectedIndex();
        this.jButtonUp.setEnabled(this.listModel.size() > 1 && index > 0);
        this.jButtonDown.setEnabled(this.listModel.size() > 1 && index < this.listModel.size() - 1);
        this.jButtonEdit.setEnabled(index >= 0);
        this.jButtonRemove.setEnabled(index >= 0);
    }

    public ListItemEditor getEditor() {
        return this.editor;
    }

    public void setTitle(String title) {
        this.jLabelList.setText(title);
    }

    public void setEditor(ListItemEditor editor) {
        if (this.editor != null && this.editorPaneListener != null) {
            this.editor.getEditorPanel().removeHierarchyListener(this.editorPaneListener);
        }
        this.editor = editor;
        this.editorPaneListener = new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e2) {
                Dialog dialog;
                Window window = SwingUtilities.getWindowAncestor(ListEditorPanel.this.editor.getEditorPanel());
                if (window instanceof Dialog && !(dialog = (Dialog)window).isResizable()) {
                    dialog.setResizable(true);
                }
            }
        };
        this.editor.getEditorPanel().addHierarchyListener(this.editorPaneListener);
    }

    void jButtonEdit_actionPerformed(ActionEvent e2) {
        if (this.list.getSelectedValue() != null) {
            this.editor.setItem(this.list.getSelectedValue());
            int selection = JOptionPane.showConfirmDialog(this, this.editor.getEditorPanel(), "Edit Item", 2, -1, null);
            if (selection != 2 && this.editor.isItemValid()) {
                this.listModel.set(this.list.getSelectedIndex(), this.editor.getItem());
            }
            this.updateButtons();
        }
    }

    void jButtonAdd_actionPerformed(ActionEvent e2) {
        this.editor.setItem(null);
        int selection = JOptionPane.showConfirmDialog(this, this.editor.getEditorPanel(), "Add Item", 2, -1, null);
        if (selection != 2 && this.editor.isItemValid()) {
            Object o2 = this.editor.getItem();
            this.listModel.addElement(o2);
        }
        this.updateButtons();
    }

    void jButtonRemove_actionPerformed(ActionEvent e2) {
        int index = this.list.getSelectedIndex();
        if (index >= 0) {
            this.listModel.remove(index);
        }
        this.updateButtons();
    }

    @Override
    public void valueChanged(ListSelectionEvent e2) {
        this.updateButtons();
    }
}

