/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.common;

import com.agentpp.common.ConfirmCallback;
import java.awt.Component;
import java.text.MessageFormat;
import javax.swing.JOptionPane;

public class ConfirmCallbackImpl
implements ConfirmCallback {
    private static final String[][] OPTIONS = new String[][]{{"Yes", "No", "Cancel"}, {"Yes", "Yes to All", "No", "No to All", "Cancel"}};
    private Component parent;
    private String[] message;
    private String title;
    private boolean autoConfirm;

    public ConfirmCallbackImpl(Component parent, String[] message, String title) {
        this.parent = parent;
        this.message = message;
        this.title = title;
    }

    @Override
    public int confirmAction(String action, String target, boolean allowAll) {
        if (this.autoConfirm) {
            return 1;
        }
        Object[] args = new Object[]{action, target};
        String[] msg = new String[this.message.length];
        for (int i2 = 0; i2 < this.message.length; ++i2) {
            msg[i2] = MessageFormat.format(this.message[i2], args);
        }
        int a2 = allowAll ? 1 : 0;
        int o2 = JOptionPane.showOptionDialog(this.parent, msg, this.title, 2, 3, null, OPTIONS[a2], OPTIONS[a2][0]);
        if (!allowAll) {
            o2 *= 2;
        }
        switch (o2) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return -1;
            }
            case 3: {
                return -2;
            }
        }
        return 0;
    }

    public void setAutoConfirm(boolean autoConfirm) {
        this.autoConfirm = autoConfirm;
    }

    public boolean isAutoConfirm() {
        return this.autoConfirm;
    }
}

