/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.common;

import java.util.List;
import java.util.Vector;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;

public class ChangeManager
implements UndoableEdit {
    private Vector edits = new Vector();
    private int curEdit = 0;
    private static int maxChanges = 100;

    @Override
    public boolean addEdit(UndoableEdit edit) {
        this.trimChanges();
        if (this.curEdit == this.edits.size()) {
            this.edits.addElement(edit);
            ++this.curEdit;
        }
        if (this.edits.size() > maxChanges) {
            this.edits.removeElementAt(0);
            --this.curEdit;
        }
        return true;
    }

    @Override
    public boolean canRedo() {
        return this.edits.size() > this.curEdit && ((UndoableEdit)this.edits.elementAt(this.curEdit)).canRedo();
    }

    @Override
    public boolean canUndo() {
        return this.curEdit >= 1 && ((UndoableEdit)this.edits.elementAt(this.curEdit - 1)).canUndo();
    }

    @Override
    public void undo() {
        if (!this.canUndo()) {
            throw new CannotUndoException();
        }
        ((UndoableEdit)this.edits.elementAt(--this.curEdit)).undo();
    }

    @Override
    public void redo() {
        if (!this.canRedo()) {
            throw new CannotRedoException();
        }
        ((UndoableEdit)this.edits.elementAt(this.curEdit++)).redo();
    }

    @Override
    public void die() {
    }

    public void reset() {
        this.curEdit = 0;
        this.edits = new Vector();
    }

    public void trimChanges() {
        while (this.curEdit < this.edits.size()) {
            ((UndoableEdit)this.edits.elementAt(this.curEdit)).die();
            this.edits.remove(this.curEdit);
        }
    }

    public Vector getChanges() {
        this.trimChanges();
        return this.edits;
    }

    public List getCurrentChanges() {
        return this.edits.subList(0, this.curEdit);
    }

    public boolean canUndo(Class editType) {
        boolean canUndo = this.canUndo();
        if (!canUndo) {
            return false;
        }
        for (int i2 = this.curEdit - 1; i2 >= 0; --i2) {
            if (!editType.isInstance(this.edits.elementAt(i2))) continue;
            return true;
        }
        return false;
    }

    public void removeLast() {
        this.trimChanges();
        if (this.curEdit <= 0) {
            return;
        }
        this.edits.removeElementAt(--this.curEdit);
    }

    @Override
    public boolean isSignificant() {
        return true;
    }

    @Override
    public boolean replaceEdit(UndoableEdit e2) {
        return false;
    }

    @Override
    public String getPresentationName() {
        return null;
    }

    @Override
    public String getUndoPresentationName() {
        return null;
    }

    @Override
    public String getRedoPresentationName() {
        return null;
    }

    public static void setMaximumNumberOfChanges(int max) {
        maxChanges = max > 1 ? max : 1;
    }

    public static int getMaximumNumberOfChanges() {
        return maxChanges;
    }
}

