/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.agenpro.util;

import com.agentpp.mib.IndexStruct;
import com.agentpp.mib.MIBObjectType;
import com.agentpp.mib.MIBRepository;
import com.agentpp.mib.MIBTextualConvention;
import com.agentpp.mib.ObjectID;
import com.agentpp.snmp.ValueConverter;
import java.util.Vector;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.IpAddress;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.TimeTicks;
import org.snmp4j.smi.Variable;

public class IndexConverter {
    /*
     * WARNING - void declaration
     */
    public static Variable getIndexVariable(IndexStruct index, ObjectID indexValue) {
        try {
            Object object;
            switch (index.baseType) {
                case 1: {
                    if (index.impliedLength || index.minLength == index.maxLength) {
                        index = new OctetString(indexValue.asByteArray());
                        return index;
                    }
                    ObjectID objectID = indexValue;
                    object = objectID.getSuffix(objectID.size() - 1);
                    return new OctetString(((ObjectID)object).asByteArray());
                }
                case 0: {
                    return new Integer32((int)indexValue.getLastSubID());
                }
                case 9: {
                    return new TimeTicks(indexValue.getLastSubID());
                }
                case 5: {
                    return new IpAddress(indexValue.toString());
                }
                case 12: {
                    Object object2 = object = indexValue.toString();
                    return new IpAddress(((String)object2).substring(((String)object2).indexOf(".") + 1));
                }
            }
            if (((IndexStruct)object).impliedLength || ((IndexStruct)object).minLength == ((IndexStruct)object).maxLength) {
                return new OID(indexValue.toString());
            }
            ObjectID objectID = indexValue;
            return new OID(objectID.getSuffix(objectID.size() - 1).toString());
        }
        catch (Exception exception) {
            void var1_1;
            return new OID(var1_1.toString());
        }
    }

    public static Variable[] getIndexVariables(IndexStruct[] indexes, ObjectID[] indexValues) {
        int n2 = Math.min(indexes.length, indexValues.length);
        Variable[] variableArray = new Variable[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            variableArray[i2] = IndexConverter.getIndexVariable(indexes[i2], indexValues[i2]);
        }
        return variableArray;
    }

    /*
     * WARNING - void declaration
     */
    public static String getIndexString(ValueConverter converter, IndexStruct index, ObjectID indexValue) {
        void var2_2;
        void var1_1;
        Object object = converter.toNative(IndexConverter.getIndexVariable((IndexStruct)var1_1, (ObjectID)var2_2), true);
        if (object == null) {
            return "?";
        }
        return object.toString();
    }

    public static String getIndexString(ValueConverter[] converter, IndexStruct[] indexes, ObjectID[] indexValues) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < indexes.length && i2 < indexValues.length && i2 < converter.length; ++i2) {
            stringBuffer.append(IndexConverter.getIndexString(converter[i2], indexes[i2], indexValues[i2]));
            if (i2 + 1 >= indexes.length || i2 + 1 >= indexValues.length || i2 + 1 >= converter.length) continue;
            stringBuffer.append(".");
        }
        return stringBuffer.toString();
    }

    public static ValueConverter[] getIndexValueConverter(MIBRepository rep, MIBObjectType table) {
        Vector<? extends MIBObjectType> vector;
        if (!table.isTable()) {
            return null;
        }
        vector = rep.getColumnarObjectsOfTable((MIBObjectType)((Object)vector), true, false);
        ValueConverter[] valueConverterArray = new ValueConverter[vector.size()];
        for (int i2 = 0; i2 < valueConverterArray.length; ++i2) {
            MIBObjectType mIBObjectType = vector.elementAt(i2);
            MIBTextualConvention mIBTextualConvention = rep.getEffectiveSyntax(mIBObjectType.getSyntax());
            valueConverterArray[i2] = new ValueConverter(mIBObjectType, mIBTextualConvention.getSyntax(), mIBTextualConvention.getDisplayHint());
        }
        return valueConverterArray;
    }
}

