/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tidy;

import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.w3c.tidy.Lexer;
import org.w3c.tidy.MutableInteger;
import org.w3c.tidy.Node;
import org.w3c.tidy.PPrint;
import org.w3c.tidy.TagTable;

public class Report {
    public static final String ACCESS_URL = "http://www.w3.org/WAI/GL";
    public static final String RELEASE_DATE = "4th August 2000";
    public static String currentFile;
    public static final short MISSING_SEMICOLON = 1;
    public static final short UNKNOWN_ENTITY = 2;
    public static final short UNESCAPED_AMPERSAND = 3;
    public static final short MISSING_ENDTAG_FOR = 1;
    public static final short MISSING_ENDTAG_BEFORE = 2;
    public static final short DISCARDING_UNEXPECTED = 3;
    public static final short NESTED_EMPHASIS = 4;
    public static final short NON_MATCHING_ENDTAG = 5;
    public static final short TAG_NOT_ALLOWED_IN = 6;
    public static final short MISSING_STARTTAG = 7;
    public static final short UNEXPECTED_ENDTAG = 8;
    public static final short USING_BR_INPLACE_OF = 9;
    public static final short INSERTING_TAG = 10;
    public static final short SUSPECTED_MISSING_QUOTE = 11;
    public static final short MISSING_TITLE_ELEMENT = 12;
    public static final short DUPLICATE_FRAMESET = 13;
    public static final short CANT_BE_NESTED = 14;
    public static final short OBSOLETE_ELEMENT = 15;
    public static final short PROPRIETARY_ELEMENT = 16;
    public static final short UNKNOWN_ELEMENT = 17;
    public static final short TRIM_EMPTY_ELEMENT = 18;
    public static final short COERCE_TO_ENDTAG = 19;
    public static final short ILLEGAL_NESTING = 20;
    public static final short NOFRAMES_CONTENT = 21;
    public static final short CONTENT_AFTER_BODY = 22;
    public static final short INCONSISTENT_VERSION = 23;
    public static final short MALFORMED_COMMENT = 24;
    public static final short BAD_COMMENT_CHARS = 25;
    public static final short BAD_XML_COMMENT = 26;
    public static final short BAD_CDATA_CONTENT = 27;
    public static final short INCONSISTENT_NAMESPACE = 28;
    public static final short DOCTYPE_AFTER_TAGS = 29;
    public static final short MALFORMED_DOCTYPE = 30;
    public static final short UNEXPECTED_END_OF_FILE = 31;
    public static final short DTYPE_NOT_UPPER_CASE = 32;
    public static final short TOO_MANY_ELEMENTS = 33;
    public static final short UNKNOWN_ATTRIBUTE = 1;
    public static final short MISSING_ATTRIBUTE = 2;
    public static final short MISSING_ATTR_VALUE = 3;
    public static final short BAD_ATTRIBUTE_VALUE = 4;
    public static final short UNEXPECTED_GT = 5;
    public static final short PROPRIETARY_ATTR_VALUE = 6;
    public static final short REPEATED_ATTRIBUTE = 7;
    public static final short MISSING_IMAGEMAP = 8;
    public static final short XML_ATTRIBUTE_VALUE = 9;
    public static final short UNEXPECTED_QUOTEMARK = 10;
    public static final short ID_NAME_MISMATCH = 11;
    public static final short MISSING_IMAGE_ALT = 1;
    public static final short MISSING_LINK_ALT = 2;
    public static final short MISSING_SUMMARY = 4;
    public static final short MISSING_IMAGE_MAP = 8;
    public static final short USING_FRAMES = 16;
    public static final short USING_NOFRAMES = 32;
    public static final short USING_SPACER = 1;
    public static final short USING_LAYER = 2;
    public static final short USING_NOBR = 4;
    public static final short USING_FONT = 8;
    public static final short USING_BODY = 16;
    public static final short WINDOWS_CHARS = 1;
    public static final short NON_ASCII = 2;
    public static final short FOUND_UTF16 = 4;
    private static short optionerrors;
    private static ResourceBundle res;

    public static void tidyPrint(PrintWriter printWriter, String string) {
        printWriter.print(string);
    }

    public static void tidyPrintln(PrintWriter printWriter, String string) {
        printWriter.println(string);
    }

    public static void tidyPrintln(PrintWriter printWriter) {
        printWriter.println();
    }

    public static void showVersion(PrintWriter printWriter) {
        printWriter.println("Java HTML Tidy release date: 4th August 2000");
        printWriter.println("See http://www.w3.org/People/Raggett for details");
    }

    public static void tag(Lexer lexer, Node node) {
        if (node != null) {
            if (node.type == 5) {
                PrintWriter printWriter = lexer.errout;
                String string = "<" + node.element + ">";
                printWriter.print(string);
                return;
            }
            if (node.type == 6) {
                PrintWriter printWriter = lexer.errout;
                String string = "</" + node.element + ">";
                printWriter.print(string);
                return;
            }
            if (node.type == 1) {
                PrintWriter printWriter = lexer.errout;
                printWriter.print("<!DOCTYPE>");
                return;
            }
            if (node.type == 4) {
                PrintWriter printWriter = lexer.errout;
                printWriter.print("plain text");
                return;
            }
            PrintWriter printWriter = lexer.errout;
            String string = node.element;
            printWriter.print(string);
        }
    }

    public static void unknownOption(String string) {
        optionerrors = (short)(optionerrors + 1);
        try {
            System.err.println(MessageFormat.format(res.getString("unknown_option"), string));
            return;
        }
        catch (MissingResourceException missingResourceException) {
            System.err.println(missingResourceException.toString());
            return;
        }
    }

    public static void badArgument(String string) {
        optionerrors = (short)(optionerrors + 1);
        try {
            System.err.println(MessageFormat.format(res.getString("bad_argument"), string));
            return;
        }
        catch (MissingResourceException missingResourceException) {
            System.err.println(missingResourceException.toString());
            return;
        }
    }

    public static void position(Lexer lexer) {
        try {
            if (lexer.configuration.Emacs) {
                PrintWriter printWriter = lexer.errout;
                String string = MessageFormat.format(res.getString("emacs_format"), currentFile, new Integer(lexer.lines), new Integer(lexer.columns));
                printWriter.print(string);
                printWriter = lexer.errout;
                printWriter.print(" ");
                return;
            }
            PrintWriter printWriter = lexer.errout;
            String string = MessageFormat.format(res.getString("line_column"), new Integer(lexer.lines), new Integer(lexer.columns));
            printWriter.print(string);
            return;
        }
        catch (MissingResourceException missingResourceException) {
            lexer.errout.println(missingResourceException.toString());
            return;
        }
    }

    public static void encodingError(Lexer lexer, short s, int n2) {
        lexer.warnings = (short)(lexer.warnings + 1);
        if (lexer.configuration.ShowWarnings) {
            PrintWriter printWriter;
            Report.position(lexer);
            if (s == 1) {
                lexer.badChars = (short)(lexer.badChars | 1);
                try {
                    printWriter = lexer.errout;
                    String string = MessageFormat.format(res.getString("illegal_char"), new Integer(n2));
                    printWriter.print(string);
                }
                catch (MissingResourceException missingResourceException) {
                    lexer.errout.println(missingResourceException.toString());
                }
            }
            printWriter = lexer.errout;
            printWriter.println();
        }
    }

    public static void entityError(Lexer lexer, short s, String string, int n2) {
        lexer.warnings = (short)(lexer.warnings + 1);
        if (lexer.configuration.ShowWarnings) {
            PrintWriter printWriter;
            Report.position(lexer);
            if (s == 1) {
                try {
                    printWriter = lexer.errout;
                    String string2 = MessageFormat.format(res.getString("missing_semicolon"), string);
                    printWriter.print(string2);
                }
                catch (MissingResourceException missingResourceException) {
                    lexer.errout.println(missingResourceException.toString());
                }
            } else if (s == 2) {
                try {
                    printWriter = lexer.errout;
                    String string3 = MessageFormat.format(res.getString("unknown_entity"), string);
                    printWriter.print(string3);
                }
                catch (MissingResourceException missingResourceException) {
                    lexer.errout.println(missingResourceException.toString());
                }
            } else if (s == 3) {
                try {
                    printWriter = lexer.errout;
                    String string4 = res.getString("unescaped_ampersand");
                    printWriter.print(string4);
                }
                catch (MissingResourceException missingResourceException) {
                    lexer.errout.println(missingResourceException.toString());
                }
            }
            printWriter = lexer.errout;
            printWriter.println();
        }
    }

    public static void attrError(Lexer lexer, Node node, String string, short s) {
        lexer.warnings = (short)(lexer.warnings + 1);
        if (lexer.errors > 6) {
            return;
        }
        if (lexer.configuration.ShowWarnings) {
            PrintWriter printWriter;
            if (s == 31) {
                lexer.lines = lexer.in.curline;
                lexer.columns = lexer.in.curcol;
            }
            Report.position(lexer);
            if (s == 1) {
                try {
                    printWriter = lexer.errout;
                    String string2 = MessageFormat.format(res.getString("unknown_attribute"), string);
                    printWriter.print(string2);
                }
                catch (MissingResourceException missingResourceException) {
                    lexer.errout.println(missingResourceException.toString());
                }
            } else if (s == 2) {
                try {
                    printWriter = lexer.errout;
                    String string3 = res.getString("warning");
                    printWriter.print(string3);
                    Report.tag(lexer, node);
                    printWriter = lexer.errout;
                    string3 = MessageFormat.format(res.getString("missing_attribute"), string);
                    printWriter.print(string3);
                }
                catch (MissingResourceException missingResourceException) {
                    lexer.errout.println(missingResourceException.toString());
                }
            } else if (s == 3) {
                try {
                    printWriter = lexer.errout;
                    String string4 = res.getString("warning");
                    printWriter.print(string4);
                    Report.tag(lexer, node);
                    printWriter = lexer.errout;
                    string4 = MessageFormat.format(res.getString("missing_attr_value"), string);
                    printWriter.print(string4);
                }
                catch (MissingResourceException missingResourceException) {
                    lexer.errout.println(missingResourceException.toString());
                }
            } else if (s == 8) {
                try {
                    printWriter = lexer.errout;
                    String string5 = res.getString("warning");
                    printWriter.print(string5);
                    Report.tag(lexer, node);
                    printWriter = lexer.errout;
                    string5 = res.getString("missing_imagemap");
                    printWriter.print(string5);
                }
                catch (MissingResourceException missingResourceException) {
                    lexer.errout.println(missingResourceException.toString());
                }
                lexer.badAccess = (short)(lexer.badAccess | 8);
            } else if (s == 4) {
                try {
                    printWriter = lexer.errout;
                    String string6 = res.getString("warning");
                    printWriter.print(string6);
                    Report.tag(lexer, node);
                    printWriter = lexer.errout;
                    string6 = MessageFormat.format(res.getString("bad_attribute_value"), string);
                    printWriter.print(string6);
                }
                catch (MissingResourceException missingResourceException) {
                    lexer.errout.println(missingResourceException.toString());
                }
            } else if (s == 9) {
                try {
                    printWriter = lexer.errout;
                    String string7 = res.getString("warning");
                    printWriter.print(string7);
                    Report.tag(lexer, node);
                    printWriter = lexer.errout;
                    string7 = MessageFormat.format(res.getString("xml_attribute_value"), string);
                    printWriter.print(string7);
                }
                catch (MissingResourceException missingResourceException) {
                    lexer.errout.println(missingResourceException.toString());
                }
            } else if (s == 5) {
                try {
                    printWriter = lexer.errout;
                    String string8 = res.getString("error");
                    printWriter.print(string8);
                    Report.tag(lexer, node);
                    printWriter = lexer.errout;
                    string8 = res.getString("unexpected_gt");
                    printWriter.print(string8);
                }
                catch (MissingResourceException missingResourceException) {
                    lexer.errout.println(missingResourceException.toString());
                }
                lexer.errors = (short)(lexer.errors + 1);
            } else if (s == 10) {
                try {
                    printWriter = lexer.errout;
                    String string9 = res.getString("warning");
                    printWriter.print(string9);
                    Report.tag(lexer, node);
                    printWriter = lexer.errout;
                    string9 = res.getString("unexpected_quotemark");
                    printWriter.print(string9);
                }
                catch (MissingResourceException missingResourceException) {
                    lexer.errout.println(missingResourceException.toString());
                }
            } else if (s == 7) {
                try {
                    printWriter = lexer.errout;
                    String string10 = res.getString("warning");
                    printWriter.print(string10);
                    Report.tag(lexer, node);
                    printWriter = lexer.errout;
                    string10 = res.getString("repeated_attribute");
                    printWriter.print(string10);
                }
                catch (MissingResourceException missingResourceException) {
                    lexer.errout.println(missingResourceException.toString());
                }
            } else if (s == 6) {
                try {
                    printWriter = lexer.errout;
                    String string11 = res.getString("warning");
                    printWriter.print(string11);
                    Report.tag(lexer, node);
                    printWriter = lexer.errout;
                    string11 = MessageFormat.format(res.getString("proprietary_attr_value"), string);
                    printWriter.print(string11);
                }
                catch (MissingResourceException missingResourceException) {
                    lexer.errout.println(missingResourceException.toString());
                }
            } else if (s == 31) {
                try {
                    printWriter = lexer.errout;
                    String string12 = res.getString("unexpected_end_of_file");
                    printWriter.print(string12);
                }
                catch (MissingResourceException missingResourceException) {
                    lexer.errout.println(missingResourceException.toString());
                }
            } else if (s == 11) {
                try {
                    printWriter = lexer.errout;
                    String string13 = res.getString("warning");
                    printWriter.print(string13);
                    Report.tag(lexer, node);
                    printWriter = lexer.errout;
                    string13 = res.getString("id_name_mismatch");
                    printWriter.print(string13);
                }
                catch (MissingResourceException missingResourceException) {
                    lexer.errout.println(missingResourceException.toString());
                }
            }
            printWriter = lexer.errout;
            printWriter.println();
            return;
        }
        if (s == 5) {
            PrintWriter printWriter;
            Report.position(lexer);
            try {
                printWriter = lexer.errout;
                String string14 = res.getString("error");
                printWriter.print(string14);
                Report.tag(lexer, node);
                printWriter = lexer.errout;
                string14 = res.getString("unexpected_gt");
                printWriter.print(string14);
            }
            catch (MissingResourceException missingResourceException) {
                lexer.errout.println(missingResourceException.toString());
            }
            printWriter = lexer.errout;
            printWriter.println();
            lexer.errors = (short)(lexer.errors + 1);
        }
    }

    public static void warning(Lexer lexer, Node node, Node node2, short s) {
        lexer.warnings = (short)(lexer.warnings + 1);
        if (lexer.errors > 6) {
            return;
        }
        if (lexer.configuration.ShowWarnings) {
            PrintWriter printWriter;
            if (s == 31) {
                lexer.lines = lexer.in.curline;
                lexer.columns = lexer.in.curcol;
            }
            Report.position(lexer);
            if (s == 1) {
                try {
                    printWriter = lexer.errout;
                    String string = MessageFormat.format(res.getString("missing_endtag_for"), node.element);
                    printWriter.print(string);
                }
                catch (MissingResourceException missingResourceException) {
                    lexer.errout.println(missingResourceException.toString());
                }
            } else if (s == 2) {
                try {
                    printWriter = lexer.errout;
                    String string = MessageFormat.format(res.getString("missing_endtag_before"), node.element);
                    printWriter.print(string);
                }
                catch (MissingResourceException missingResourceException) {
                    lexer.errout.println(missingResourceException.toString());
                }
                Report.tag(lexer, node2);
            } else if (s == 3) {
                try {
                    printWriter = lexer.errout;
                    String string = res.getString("discarding_unexpected");
                    printWriter.print(string);
                }
                catch (MissingResourceException missingResourceException) {
                    lexer.errout.println(missingResourceException.toString());
                }
                Report.tag(lexer, node2);
            } else if (s == 4) {
                try {
                    printWriter = lexer.errout;
                    String string = res.getString("nested_emphasis");
                    printWriter.print(string);
                }
                catch (MissingResourceException missingResourceException) {
                    lexer.errout.println(missingResourceException.toString());
                }
                Report.tag(lexer, node2);
            } else if (s == 19) {
                try {
                    printWriter = lexer.errout;
                    String string = MessageFormat.format(res.getString("coerce_to_endtag"), node.element);
                    printWriter.print(string);
                }
                catch (MissingResourceException missingResourceException) {
                    lexer.errout.println(missingResourceException.toString());
                }
            } else if (s == 5) {
                String string;
                try {
                    printWriter = lexer.errout;
                    string = res.getString("non_matching_endtag_1");
                    printWriter.print(string);
                }
                catch (MissingResourceException missingResourceException) {
                    lexer.errout.println(missingResourceException.toString());
                }
                Report.tag(lexer, node2);
                try {
                    printWriter = lexer.errout;
                    string = MessageFormat.format(res.getString("non_matching_endtag_2"), node.element);
                    printWriter.print(string);
                }
                catch (MissingResourceException missingResourceException) {
                    lexer.errout.println(missingResourceException.toString());
                }
            } else if (s == 6) {
                String string;
                try {
                    printWriter = lexer.errout;
                    string = res.getString("warning");
                    printWriter.print(string);
                }
                catch (MissingResourceException missingResourceException) {
                    lexer.errout.println(missingResourceException.toString());
                }
                Report.tag(lexer, node2);
                try {
                    printWriter = lexer.errout;
                    string = MessageFormat.format(res.getString("tag_not_allowed_in"), node.element);
                    printWriter.print(string);
                }
                catch (MissingResourceException missingResourceException) {
                    lexer.errout.println(missingResourceException.toString());
                }
            } else if (s == 29) {
                try {
                    printWriter = lexer.errout;
                    String string = res.getString("doctype_after_tags");
                    printWriter.print(string);
                }
                catch (MissingResourceException missingResourceException) {
                    lexer.errout.println(missingResourceException.toString());
                }
            } else if (s == 7) {
                try {
                    printWriter = lexer.errout;
                    String string = MessageFormat.format(res.getString("missing_starttag"), node2.element);
                    printWriter.print(string);
                }
                catch (MissingResourceException missingResourceException) {
                    lexer.errout.println(missingResourceException.toString());
                }
            } else if (s == 8) {
                try {
                    printWriter = lexer.errout;
                    String string = MessageFormat.format(res.getString("unexpected_endtag"), node2.element);
                    printWriter.print(string);
                    if (node != null) {
                        printWriter = lexer.errout;
                        string = MessageFormat.format(res.getString("unexpected_endtag_suffix"), node.element);
                        printWriter.print(string);
                    }
                }
                catch (MissingResourceException missingResourceException) {
                    lexer.errout.println(missingResourceException.toString());
                }
            } else if (s == 33) {
                try {
                    printWriter = lexer.errout;
                    String string = MessageFormat.format(res.getString("too_many_elements"), node2.element);
                    printWriter.print(string);
                    if (node != null) {
                        printWriter = lexer.errout;
                        string = MessageFormat.format(res.getString("too_many_elements_suffix"), node.element);
                        printWriter.print(string);
                    }
                }
                catch (MissingResourceException missingResourceException) {
                    lexer.errout.println(missingResourceException.toString());
                }
            } else if (s == 9) {
                try {
                    printWriter = lexer.errout;
                    String string = res.getString("using_br_inplace_of");
                    printWriter.print(string);
                }
                catch (MissingResourceException missingResourceException) {
                    lexer.errout.println(missingResourceException.toString());
                }
                Report.tag(lexer, node2);
            } else if (s == 10) {
                try {
                    printWriter = lexer.errout;
                    String string = MessageFormat.format(res.getString("inserting_tag"), node2.element);
                    printWriter.print(string);
                }
                catch (MissingResourceException missingResourceException) {
                    lexer.errout.println(missingResourceException.toString());
                }
            } else if (s == 14) {
                String string;
                try {
                    printWriter = lexer.errout;
                    string = res.getString("warning");
                    printWriter.print(string);
                }
                catch (MissingResourceException missingResourceException) {
                    lexer.errout.println(missingResourceException.toString());
                }
                Report.tag(lexer, node2);
                try {
                    printWriter = lexer.errout;
                    string = res.getString("cant_be_nested");
                    printWriter.print(string);
                }
                catch (MissingResourceException missingResourceException) {
                    lexer.errout.println(missingResourceException.toString());
                }
            } else if (s == 16) {
                String string;
                try {
                    printWriter = lexer.errout;
                    string = res.getString("warning");
                    printWriter.print(string);
                }
                catch (MissingResourceException missingResourceException) {
                    lexer.errout.println(missingResourceException.toString());
                }
                Report.tag(lexer, node2);
                try {
                    printWriter = lexer.errout;
                    string = res.getString("proprietary_element");
                    printWriter.print(string);
                }
                catch (MissingResourceException missingResourceException) {
                    lexer.errout.println(missingResourceException.toString());
                }
                if (node2.tag == TagTable.tagLayer) {
                    lexer.badLayout = (short)(lexer.badLayout | 2);
                } else if (node2.tag == TagTable.tagSpacer) {
                    lexer.badLayout = (short)(lexer.badLayout | 1);
                } else if (node2.tag == TagTable.tagNobr) {
                    lexer.badLayout = (short)(lexer.badLayout | 4);
                }
            } else if (s == 15) {
                String string;
                try {
                    if (node.tag != null && (node.tag.model & 0x80000) != 0) {
                        printWriter = lexer.errout;
                        string = res.getString("obsolete_element");
                        printWriter.print(string);
                    } else {
                        printWriter = lexer.errout;
                        string = res.getString("replacing_element");
                        printWriter.print(string);
                    }
                }
                catch (MissingResourceException missingResourceException) {
                    lexer.errout.println(missingResourceException.toString());
                }
                Report.tag(lexer, node);
                try {
                    printWriter = lexer.errout;
                    string = res.getString("by");
                    printWriter.print(string);
                }
                catch (MissingResourceException missingResourceException) {
                    lexer.errout.println(missingResourceException.toString());
                }
                Report.tag(lexer, node2);
            } else if (s == 18) {
                try {
                    printWriter = lexer.errout;
                    String string = res.getString("trim_empty_element");
                    printWriter.print(string);
                }
                catch (MissingResourceException missingResourceException) {
                    lexer.errout.println(missingResourceException.toString());
                }
                Report.tag(lexer, node);
            } else if (s == 12) {
                try {
                    printWriter = lexer.errout;
                    String string = res.getString("missing_title_element");
                    printWriter.print(string);
                }
                catch (MissingResourceException missingResourceException) {
                    lexer.errout.println(missingResourceException.toString());
                }
            } else if (s == 20) {
                String string;
                try {
                    printWriter = lexer.errout;
                    string = res.getString("warning");
                    printWriter.print(string);
                }
                catch (MissingResourceException missingResourceException) {
                    lexer.errout.println(missingResourceException.toString());
                }
                Report.tag(lexer, node);
                try {
                    printWriter = lexer.errout;
                    string = res.getString("illegal_nesting");
                    printWriter.print(string);
                }
                catch (MissingResourceException missingResourceException) {
                    lexer.errout.println(missingResourceException.toString());
                }
            } else if (s == 21) {
                String string;
                try {
                    printWriter = lexer.errout;
                    string = res.getString("warning");
                    printWriter.print(string);
                }
                catch (MissingResourceException missingResourceException) {
                    lexer.errout.println(missingResourceException.toString());
                }
                Report.tag(lexer, node2);
                try {
                    printWriter = lexer.errout;
                    string = res.getString("noframes_content");
                    printWriter.print(string);
                }
                catch (MissingResourceException missingResourceException) {
                    lexer.errout.println(missingResourceException.toString());
                }
            } else if (s == 23) {
                try {
                    printWriter = lexer.errout;
                    String string = res.getString("inconsistent_version");
                    printWriter.print(string);
                }
                catch (MissingResourceException missingResourceException) {
                    lexer.errout.println(missingResourceException.toString());
                }
            } else if (s == 30) {
                try {
                    printWriter = lexer.errout;
                    String string = res.getString("malformed_doctype");
                    printWriter.print(string);
                }
                catch (MissingResourceException missingResourceException) {
                    lexer.errout.println(missingResourceException.toString());
                }
            } else if (s == 22) {
                try {
                    printWriter = lexer.errout;
                    String string = res.getString("content_after_body");
                    printWriter.print(string);
                }
                catch (MissingResourceException missingResourceException) {
                    lexer.errout.println(missingResourceException.toString());
                }
            } else if (s == 24) {
                try {
                    printWriter = lexer.errout;
                    String string = res.getString("malformed_comment");
                    printWriter.print(string);
                }
                catch (MissingResourceException missingResourceException) {
                    lexer.errout.println(missingResourceException.toString());
                }
            } else if (s == 25) {
                try {
                    printWriter = lexer.errout;
                    String string = res.getString("bad_comment_chars");
                    printWriter.print(string);
                }
                catch (MissingResourceException missingResourceException) {
                    lexer.errout.println(missingResourceException.toString());
                }
            } else if (s == 26) {
                try {
                    printWriter = lexer.errout;
                    String string = res.getString("bad_xml_comment");
                    printWriter.print(string);
                }
                catch (MissingResourceException missingResourceException) {
                    lexer.errout.println(missingResourceException.toString());
                }
            } else if (s == 27) {
                try {
                    printWriter = lexer.errout;
                    String string = res.getString("bad_cdata_content");
                    printWriter.print(string);
                }
                catch (MissingResourceException missingResourceException) {
                    lexer.errout.println(missingResourceException.toString());
                }
            } else if (s == 28) {
                try {
                    printWriter = lexer.errout;
                    String string = res.getString("inconsistent_namespace");
                    printWriter.print(string);
                }
                catch (MissingResourceException missingResourceException) {
                    lexer.errout.println(missingResourceException.toString());
                }
            } else if (s == 32) {
                try {
                    printWriter = lexer.errout;
                    String string = res.getString("dtype_not_upper_case");
                    printWriter.print(string);
                }
                catch (MissingResourceException missingResourceException) {
                    lexer.errout.println(missingResourceException.toString());
                }
            } else if (s == 31) {
                try {
                    printWriter = lexer.errout;
                    String string = res.getString("unexpected_end_of_file");
                    printWriter.print(string);
                }
                catch (MissingResourceException missingResourceException) {
                    lexer.errout.println(missingResourceException.toString());
                }
                Report.tag(lexer, node);
            }
            printWriter = lexer.errout;
            printWriter.println();
        }
    }

    public static void error(Lexer lexer, Node node, Node node2, short s) {
        PrintWriter printWriter;
        lexer.warnings = (short)(lexer.warnings + 1);
        if (lexer.errors > 6) {
            return;
        }
        lexer.errors = (short)(lexer.errors + 1);
        Report.position(lexer);
        if (s == 11) {
            try {
                printWriter = lexer.errout;
                String string = res.getString("suspected_missing_quote");
                printWriter.print(string);
            }
            catch (MissingResourceException missingResourceException) {
                lexer.errout.println(missingResourceException.toString());
            }
        } else if (s == 13) {
            try {
                printWriter = lexer.errout;
                String string = res.getString("duplicate_frameset");
                printWriter.print(string);
            }
            catch (MissingResourceException missingResourceException) {
                lexer.errout.println(missingResourceException.toString());
            }
        } else if (s == 17) {
            String string;
            try {
                printWriter = lexer.errout;
                string = res.getString("error");
                printWriter.print(string);
            }
            catch (MissingResourceException missingResourceException) {
                lexer.errout.println(missingResourceException.toString());
            }
            Report.tag(lexer, node2);
            try {
                printWriter = lexer.errout;
                string = res.getString("unknown_element");
                printWriter.print(string);
            }
            catch (MissingResourceException missingResourceException) {
                lexer.errout.println(missingResourceException.toString());
            }
        } else if (s == 8) {
            try {
                printWriter = lexer.errout;
                String string = MessageFormat.format(res.getString("unexpected_endtag"), node2.element);
                printWriter.print(string);
                if (node != null) {
                    printWriter = lexer.errout;
                    string = MessageFormat.format(res.getString("unexpected_endtag_suffix"), node.element);
                    printWriter.print(string);
                }
            }
            catch (MissingResourceException missingResourceException) {
                lexer.errout.println(missingResourceException.toString());
            }
        }
        printWriter = lexer.errout;
        printWriter.println();
    }

    public static void errorSummary(Lexer lexer) {
        String string;
        PrintWriter printWriter;
        if ((lexer.badAccess & 0x30) != 0 && ((lexer.badAccess & 0x10) == 0 || (lexer.badAccess & 0x20) != 0)) {
            lexer.badAccess = (short)(lexer.badAccess & 0xFFFFFFCF);
        }
        if (lexer.badChars != 0 && (lexer.badChars & 1) != 0) {
            try {
                printWriter = lexer.errout;
                string = res.getString("badchars_summary");
                printWriter.print(string);
            }
            catch (MissingResourceException missingResourceException) {
                lexer.errout.println(missingResourceException.toString());
            }
        }
        if (lexer.badForm != 0) {
            try {
                printWriter = lexer.errout;
                string = res.getString("badform_summary");
                printWriter.print(string);
            }
            catch (MissingResourceException missingResourceException) {
                lexer.errout.println(missingResourceException.toString());
            }
        }
        if (lexer.badAccess != 0) {
            if ((lexer.badAccess & 4) != 0) {
                try {
                    printWriter = lexer.errout;
                    string = res.getString("badaccess_missing_summary");
                    printWriter.print(string);
                }
                catch (MissingResourceException missingResourceException) {
                    lexer.errout.println(missingResourceException.toString());
                }
            }
            if ((lexer.badAccess & 1) != 0) {
                try {
                    printWriter = lexer.errout;
                    string = res.getString("badaccess_missing_image_alt");
                    printWriter.print(string);
                }
                catch (MissingResourceException missingResourceException) {
                    lexer.errout.println(missingResourceException.toString());
                }
            }
            if ((lexer.badAccess & 8) != 0) {
                try {
                    printWriter = lexer.errout;
                    string = res.getString("badaccess_missing_image_map");
                    printWriter.print(string);
                }
                catch (MissingResourceException missingResourceException) {
                    lexer.errout.println(missingResourceException.toString());
                }
            }
            if ((lexer.badAccess & 2) != 0) {
                try {
                    printWriter = lexer.errout;
                    string = res.getString("badaccess_missing_link_alt");
                    printWriter.print(string);
                }
                catch (MissingResourceException missingResourceException) {
                    lexer.errout.println(missingResourceException.toString());
                }
            }
            if ((lexer.badAccess & 0x10) != 0 && (lexer.badAccess & 0x20) == 0) {
                try {
                    printWriter = lexer.errout;
                    string = res.getString("badaccess_frames");
                    printWriter.print(string);
                }
                catch (MissingResourceException missingResourceException) {
                    lexer.errout.println(missingResourceException.toString());
                }
            }
            try {
                printWriter = lexer.errout;
                string = MessageFormat.format(res.getString("badaccess_summary"), ACCESS_URL);
                printWriter.print(string);
            }
            catch (MissingResourceException missingResourceException) {
                lexer.errout.println(missingResourceException.toString());
            }
        }
        if (lexer.badLayout != 0) {
            if ((lexer.badLayout & 2) != 0) {
                try {
                    printWriter = lexer.errout;
                    string = res.getString("badlayout_using_layer");
                    printWriter.print(string);
                }
                catch (MissingResourceException missingResourceException) {
                    lexer.errout.println(missingResourceException.toString());
                }
            }
            if ((lexer.badLayout & 1) != 0) {
                try {
                    printWriter = lexer.errout;
                    string = res.getString("badlayout_using_spacer");
                    printWriter.print(string);
                }
                catch (MissingResourceException missingResourceException) {
                    lexer.errout.println(missingResourceException.toString());
                }
            }
            if ((lexer.badLayout & 8) != 0) {
                try {
                    printWriter = lexer.errout;
                    string = res.getString("badlayout_using_font");
                    printWriter.print(string);
                }
                catch (MissingResourceException missingResourceException) {
                    lexer.errout.println(missingResourceException.toString());
                }
            }
            if ((lexer.badLayout & 4) != 0) {
                try {
                    printWriter = lexer.errout;
                    string = res.getString("badlayout_using_nobr");
                    printWriter.print(string);
                }
                catch (MissingResourceException missingResourceException) {
                    lexer.errout.println(missingResourceException.toString());
                }
            }
            if ((lexer.badLayout & 0x10) != 0) {
                try {
                    printWriter = lexer.errout;
                    string = res.getString("badlayout_using_body");
                    printWriter.print(string);
                    return;
                }
                catch (MissingResourceException missingResourceException) {
                    lexer.errout.println(missingResourceException.toString());
                    return;
                }
            }
        }
    }

    public static void unknownOption(PrintWriter printWriter, char c2) {
        try {
            String string = MessageFormat.format(res.getString("unrecognized_option"), new String(new char[]{c2}));
            printWriter.println(string);
            return;
        }
        catch (MissingResourceException missingResourceException) {
            printWriter.println(missingResourceException.toString());
            return;
        }
    }

    public static void unknownFile(PrintWriter printWriter, String string, String string2) {
        try {
            String string3 = MessageFormat.format(res.getString("unknown_file"), string, string2);
            printWriter.println(string3);
            return;
        }
        catch (MissingResourceException missingResourceException) {
            printWriter.println(missingResourceException.toString());
            return;
        }
    }

    public static void needsAuthorIntervention(PrintWriter printWriter) {
        try {
            String string = res.getString("needs_author_intervention");
            printWriter.println(string);
            return;
        }
        catch (MissingResourceException missingResourceException) {
            printWriter.println(missingResourceException.toString());
            return;
        }
    }

    public static void missingBody(PrintWriter printWriter) {
        try {
            String string = res.getString("missing_body");
            printWriter.println(string);
            return;
        }
        catch (MissingResourceException missingResourceException) {
            printWriter.println(missingResourceException.toString());
            return;
        }
    }

    public static void reportNumberOfSlides(PrintWriter printWriter, int n2) {
        try {
            String string = MessageFormat.format(res.getString("slides_found"), new Integer(n2));
            printWriter.println(string);
            return;
        }
        catch (MissingResourceException missingResourceException) {
            printWriter.println(missingResourceException.toString());
            return;
        }
    }

    public static void generalInfo(PrintWriter printWriter) {
        try {
            String string = res.getString("general_info");
            printWriter.println(string);
            return;
        }
        catch (MissingResourceException missingResourceException) {
            printWriter.println(missingResourceException.toString());
            return;
        }
    }

    public static void helloMessage(PrintWriter printWriter, String string, String string2) {
        currentFile = string2;
        try {
            String string3 = MessageFormat.format(res.getString("hello_message"), string, string2);
            printWriter.println(string3);
            return;
        }
        catch (MissingResourceException missingResourceException) {
            printWriter.println(missingResourceException.toString());
            return;
        }
    }

    public static void reportVersion(PrintWriter printWriter, Lexer lexer, String string, Node node) {
        int n2 = 0;
        String string2 = lexer.HTMLVersionName();
        MutableInteger mutableInteger = new MutableInteger();
        try {
            String string3;
            if (node != null) {
                string3 = MessageFormat.format(res.getString("doctype_given"), string);
                printWriter.print(string3);
                int n3 = node.start;
                while (n3 < node.end) {
                    int n4 = node.textarray[n3];
                    if (n4 < 0) {
                        n3 += PPrint.getUTF8(node.textarray, n3, mutableInteger);
                        n4 = mutableInteger.value;
                    }
                    if (n4 == 34) {
                        ++n2;
                    } else if (n2 == 1) {
                        printWriter.print((char)n4);
                    }
                    ++n3;
                }
                printWriter.print('\"');
            }
            string3 = MessageFormat.format(res.getString("report_version"), string, string2 != null ? string2 : "HTML proprietary");
            printWriter.println(string3);
            return;
        }
        catch (MissingResourceException missingResourceException) {
            printWriter.println(missingResourceException.toString());
            return;
        }
    }

    public static void reportNumWarnings(PrintWriter printWriter, Lexer lexer) {
        if (lexer.warnings > 0) {
            try {
                String string = MessageFormat.format(res.getString("num_warnings"), new Integer(lexer.warnings));
                printWriter.println(string);
                return;
            }
            catch (MissingResourceException missingResourceException) {
                printWriter.println(missingResourceException.toString());
                return;
            }
        }
        try {
            String string = res.getString("no_warnings");
            printWriter.println(string);
            return;
        }
        catch (MissingResourceException missingResourceException) {
            printWriter.println(missingResourceException.toString());
            return;
        }
    }

    public static void helpText(PrintWriter printWriter, String string) {
        try {
            String string2 = MessageFormat.format(res.getString("help_text"), string, RELEASE_DATE);
            printWriter.println(string2);
            return;
        }
        catch (MissingResourceException missingResourceException) {
            printWriter.println(missingResourceException.toString());
            return;
        }
    }

    public static void badTree(PrintWriter printWriter) {
        try {
            String string = res.getString("bad_tree");
            printWriter.println(string);
            return;
        }
        catch (MissingResourceException missingResourceException) {
            printWriter.println(missingResourceException.toString());
            return;
        }
    }

    static {
        res = null;
        try {
            res = ResourceBundle.getBundle("org/w3c/tidy/TidyMessages");
            return;
        }
        catch (MissingResourceException missingResourceException) {
            throw new Error(missingResourceException.toString());
        }
    }
}

