/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tidy;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.w3c.tidy.AttVal;
import org.w3c.tidy.AttributeTable;
import org.w3c.tidy.Configuration;
import org.w3c.tidy.EntityTable;
import org.w3c.tidy.Lexer;
import org.w3c.tidy.MutableInteger;
import org.w3c.tidy.Node;
import org.w3c.tidy.Out;
import org.w3c.tidy.OutImpl;
import org.w3c.tidy.ParserImpl;
import org.w3c.tidy.TagTable;

public class PPrint {
    public static final short EFFECT_BLEND = -1;
    public static final short EFFECT_BOX_IN = 0;
    public static final short EFFECT_BOX_OUT = 1;
    public static final short EFFECT_CIRCLE_IN = 2;
    public static final short EFFECT_CIRCLE_OUT = 3;
    public static final short EFFECT_WIPE_UP = 4;
    public static final short EFFECT_WIPE_DOWN = 5;
    public static final short EFFECT_WIPE_RIGHT = 6;
    public static final short EFFECT_WIPE_LEFT = 7;
    public static final short EFFECT_VERT_BLINDS = 8;
    public static final short EFFECT_HORZ_BLINDS = 9;
    public static final short EFFECT_CHK_ACROSS = 10;
    public static final short EFFECT_CHK_DOWN = 11;
    public static final short EFFECT_RND_DISSOLVE = 12;
    public static final short EFFECT_SPLIT_VIRT_IN = 13;
    public static final short EFFECT_SPLIT_VIRT_OUT = 14;
    public static final short EFFECT_SPLIT_HORZ_IN = 15;
    public static final short EFFECT_SPLIT_HORZ_OUT = 16;
    public static final short EFFECT_STRIPS_LEFT_DOWN = 17;
    public static final short EFFECT_STRIPS_LEFT_UP = 18;
    public static final short EFFECT_STRIPS_RIGHT_DOWN = 19;
    public static final short EFFECT_STRIPS_RIGHT_UP = 20;
    public static final short EFFECT_RND_BARS_HORZ = 21;
    public static final short EFFECT_RND_BARS_VERT = 22;
    public static final short EFFECT_RANDOM = 23;
    private static final short NORMAL = 0;
    private static final short PREFORMATTED = 1;
    private static final short COMMENT = 2;
    private static final short ATTRIBVALUE = 4;
    private static final short NOWRAP = 8;
    private static final short CDATA = 16;
    private int[] linebuf;
    private int lbufsize;
    private int linelen;
    private int wraphere;
    private boolean inAttVal = false;
    private boolean InString = false;
    private int slide;
    private int count;
    private Node slidecontent;
    private Configuration configuration;

    public PPrint(Configuration configuration) {
        this.configuration = configuration;
    }

    public static int getUTF8(byte[] byArray, int n2, MutableInteger mutableInteger) {
        int n3;
        int n4;
        int n5 = byArray[n2] & 0xFF;
        if ((n5 & 0xE0) == 192) {
            n4 = n5 & 0x1F;
            n3 = 2;
        } else if ((n5 & 0xF0) == 224) {
            n4 = n5 & 0xF;
            n3 = 3;
        } else if ((n5 & 0xF8) == 240) {
            n4 = n5 & 7;
            n3 = 4;
        } else if ((n5 & 0xFC) == 248) {
            n4 = n5 & 3;
            n3 = 5;
        } else if ((n5 & 0xFE) == 252) {
            n4 = n5 & 1;
            n3 = 6;
        } else {
            mutableInteger.value = n5;
            return 0;
        }
        int n6 = 1;
        while (n6 < n3) {
            n5 = byArray[n2 + n6] & 0xFF;
            n4 = n4 << 6 | n5 & 0x3F;
            ++n6;
        }
        mutableInteger.value = n4;
        return n3 - 1;
    }

    public static int putUTF8(byte[] byArray, int n2, int n3) {
        if (n3 < 128) {
            byArray[n2++] = (byte)n3;
        } else if (n3 <= 2047) {
            byArray[n2++] = (byte)(0xC0 | n3 >> 6);
            byArray[n2++] = (byte)(0x80 | n3 & 0x3F);
        } else if (n3 <= 65535) {
            byArray[n2++] = (byte)(0xE0 | n3 >> 12);
            byArray[n2++] = (byte)(0x80 | n3 >> 6 & 0x3F);
            byArray[n2++] = (byte)(0x80 | n3 & 0x3F);
        } else if (n3 <= 0x1FFFFF) {
            byArray[n2++] = (byte)(0xF0 | n3 >> 18);
            byArray[n2++] = (byte)(0x80 | n3 >> 12 & 0x3F);
            byArray[n2++] = (byte)(0x80 | n3 >> 6 & 0x3F);
            byArray[n2++] = (byte)(0x80 | n3 & 0x3F);
        } else {
            byArray[n2++] = (byte)(0xF8 | n3 >> 24);
            byArray[n2++] = (byte)(0x80 | n3 >> 18 & 0x3F);
            byArray[n2++] = (byte)(0x80 | n3 >> 12 & 0x3F);
            byArray[n2++] = (byte)(0x80 | n3 >> 6 & 0x3F);
            byArray[n2++] = (byte)(0x80 | n3 & 0x3F);
        }
        return n2;
    }

    private void addC(int n2, int n3) {
        if (n3 + 1 >= this.lbufsize) {
            while (n3 + 1 >= this.lbufsize) {
                if (this.lbufsize == 0) {
                    this.lbufsize = 256;
                    continue;
                }
                this.lbufsize *= 2;
            }
            int[] nArray = new int[this.lbufsize];
            if (this.linebuf != null) {
                System.arraycopy(this.linebuf, 0, nArray, 0, n3);
            }
            this.linebuf = nArray;
        }
        this.linebuf[n3] = n2;
    }

    private void wrapLine(Out out, int n2) {
        if (this.wraphere == 0) {
            return;
        }
        int n3 = 0;
        while (n3 < n2) {
            out.outc(32);
            ++n3;
        }
        n3 = 0;
        while (n3 < this.wraphere) {
            out.outc(this.linebuf[n3]);
            ++n3;
        }
        if (this.InString) {
            out.outc(32);
            out.outc(92);
        }
        out.newline();
        if (this.linelen > this.wraphere) {
            int n4 = 0;
            if (this.linebuf[this.wraphere] == 32) {
                ++this.wraphere;
            }
            int n5 = this.wraphere;
            this.addC(0, this.linelen);
            while (true) {
                this.linebuf[n4] = this.linebuf[n5];
                if (this.linebuf[n5] == 0) break;
                ++n4;
                ++n5;
            }
            this.linelen -= this.wraphere;
        } else {
            this.linelen = 0;
        }
        this.wraphere = 0;
    }

    private void wrapAttrVal(Out out, int n2, boolean bl) {
        int n3 = 0;
        while (n3 < n2) {
            out.outc(32);
            ++n3;
        }
        n3 = 0;
        while (n3 < this.wraphere) {
            out.outc(this.linebuf[n3]);
            ++n3;
        }
        out.outc(32);
        if (bl) {
            out.outc(92);
        }
        out.newline();
        if (this.linelen > this.wraphere) {
            int n4 = 0;
            if (this.linebuf[this.wraphere] == 32) {
                ++this.wraphere;
            }
            int n5 = this.wraphere;
            this.addC(0, this.linelen);
            while (true) {
                this.linebuf[n4] = this.linebuf[n5];
                if (this.linebuf[n5] == 0) break;
                ++n4;
                ++n5;
            }
            this.linelen -= this.wraphere;
        } else {
            this.linelen = 0;
        }
        this.wraphere = 0;
    }

    public void flushLine(Out out, int n2) {
        if (this.linelen > 0) {
            int n3;
            if (n2 + this.linelen >= this.configuration.wraplen) {
                this.wrapLine(out, n2);
            }
            if (!this.inAttVal || this.configuration.IndentAttributes) {
                n3 = 0;
                while (n3 < n2) {
                    out.outc(32);
                    ++n3;
                }
            }
            n3 = 0;
            while (n3 < this.linelen) {
                out.outc(this.linebuf[n3]);
                ++n3;
            }
        }
        out.newline();
        this.linelen = 0;
        this.wraphere = 0;
        this.inAttVal = false;
    }

    public void condFlushLine(Out out, int n2) {
        if (this.linelen > 0) {
            int n3;
            if (n2 + this.linelen >= this.configuration.wraplen) {
                this.wrapLine(out, n2);
            }
            if (!this.inAttVal || this.configuration.IndentAttributes) {
                n3 = 0;
                while (n3 < n2) {
                    out.outc(32);
                    ++n3;
                }
            }
            n3 = 0;
            while (n3 < this.linelen) {
                out.outc(this.linebuf[n3]);
                ++n3;
            }
            out.newline();
            this.linelen = 0;
            this.wraphere = 0;
            this.inAttVal = false;
        }
    }

    private void printChar(int n2, short s) {
        if (n2 == 32 && (s & 7) == 0) {
            if ((s & 8) != 0) {
                if (this.configuration.NumEntities || this.configuration.XmlTags) {
                    this.addC(38, this.linelen++);
                    this.addC(35, this.linelen++);
                    this.addC(49, this.linelen++);
                    this.addC(54, this.linelen++);
                    this.addC(48, this.linelen++);
                    this.addC(59, this.linelen++);
                    return;
                }
                this.addC(38, this.linelen++);
                this.addC(110, this.linelen++);
                this.addC(98, this.linelen++);
                this.addC(115, this.linelen++);
                this.addC(112, this.linelen++);
                this.addC(59, this.linelen++);
                return;
            }
            this.wraphere = this.linelen;
        }
        if ((s & 2) != 0) {
            this.addC(n2, this.linelen++);
            return;
        }
        if ((s & 0x10) == 0) {
            if (n2 == 60) {
                this.addC(38, this.linelen++);
                this.addC(108, this.linelen++);
                this.addC(116, this.linelen++);
                this.addC(59, this.linelen++);
                return;
            }
            if (n2 == 62) {
                this.addC(38, this.linelen++);
                this.addC(103, this.linelen++);
                this.addC(116, this.linelen++);
                this.addC(59, this.linelen++);
                return;
            }
            if (n2 == 38 && this.configuration.QuoteAmpersand) {
                this.addC(38, this.linelen++);
                this.addC(97, this.linelen++);
                this.addC(109, this.linelen++);
                this.addC(112, this.linelen++);
                this.addC(59, this.linelen++);
                return;
            }
            if (n2 == 34 && this.configuration.QuoteMarks) {
                this.addC(38, this.linelen++);
                this.addC(113, this.linelen++);
                this.addC(117, this.linelen++);
                this.addC(111, this.linelen++);
                this.addC(116, this.linelen++);
                this.addC(59, this.linelen++);
                return;
            }
            if (n2 == 39 && this.configuration.QuoteMarks) {
                this.addC(38, this.linelen++);
                this.addC(35, this.linelen++);
                this.addC(51, this.linelen++);
                this.addC(57, this.linelen++);
                this.addC(59, this.linelen++);
                return;
            }
            if (n2 == 160 && this.configuration.CharEncoding != 0) {
                if (this.configuration.QuoteNbsp) {
                    this.addC(38, this.linelen++);
                    if (this.configuration.NumEntities) {
                        this.addC(35, this.linelen++);
                        this.addC(49, this.linelen++);
                        this.addC(54, this.linelen++);
                        this.addC(48, this.linelen++);
                    } else {
                        this.addC(110, this.linelen++);
                        this.addC(98, this.linelen++);
                        this.addC(115, this.linelen++);
                        this.addC(112, this.linelen++);
                    }
                    this.addC(59, this.linelen++);
                    return;
                }
                this.addC(n2, this.linelen++);
                return;
            }
        }
        if (this.configuration.CharEncoding == 4 || this.configuration.CharEncoding == 0) {
            this.addC(n2, this.linelen++);
            return;
        }
        if (n2 == 160 && (s & 1) != 0) {
            this.addC(32, this.linelen++);
            return;
        }
        if (this.configuration.MakeClean && n2 >= 8211 && n2 <= 8222) {
            switch (n2) {
                case 8211: 
                case 8212: {
                    n2 = 45;
                    break;
                }
                case 8216: 
                case 8217: 
                case 8218: {
                    n2 = 39;
                    break;
                }
                case 8220: 
                case 8221: 
                case 8222: {
                    n2 = 34;
                }
            }
        }
        if (this.configuration.CharEncoding == 2) {
            if (n2 > 255) {
                String string;
                string = !this.configuration.NumEntities ? ((string = EntityTable.getDefaultEntityTable().entityName((short)n2)) != null ? "&" + string + ";" : "&#" + n2 + ";") : "&#" + n2 + ";";
                int n3 = 0;
                while (n3 < string.length()) {
                    this.addC(string.charAt(n3), this.linelen++);
                    ++n3;
                }
                return;
            }
            if (n2 > 126 && n2 < 160) {
                String string = "&#" + n2 + ";";
                int n4 = 0;
                while (n4 < string.length()) {
                    this.addC(string.charAt(n4), this.linelen++);
                    ++n4;
                }
                return;
            }
            this.addC(n2, this.linelen++);
            return;
        }
        if (this.configuration.CharEncoding == 3) {
            this.addC(n2, this.linelen++);
            return;
        }
        if (this.configuration.XmlTags) {
            if (n2 > 127 && this.configuration.CharEncoding == 1) {
                String string = "&#" + n2 + ";";
                int n5 = 0;
                while (n5 < string.length()) {
                    this.addC(string.charAt(n5), this.linelen++);
                    ++n5;
                }
                return;
            }
            this.addC(n2, this.linelen++);
            return;
        }
        if (n2 > 126 || n2 < 32 && n2 != 9) {
            String string;
            string = !this.configuration.NumEntities ? ((string = EntityTable.getDefaultEntityTable().entityName((short)n2)) != null ? "&" + string + ";" : "&#" + n2 + ";") : "&#" + n2 + ";";
            int n6 = 0;
            while (n6 < string.length()) {
                this.addC(string.charAt(n6), this.linelen++);
                ++n6;
            }
            return;
        }
        this.addC(n2, this.linelen++);
    }

    private void printText(Out out, short s, int n2, byte[] byArray, int n3, int n4) {
        MutableInteger mutableInteger = new MutableInteger();
        int n5 = n3;
        while (n5 < n4) {
            int n6;
            if (n2 + this.linelen >= this.configuration.wraplen) {
                this.wrapLine(out, n2);
            }
            if ((n6 = byArray[n5] & 0xFF) > 127) {
                n5 += PPrint.getUTF8(byArray, n5, mutableInteger);
                n6 = mutableInteger.value;
            }
            if (n6 == 10) {
                this.flushLine(out, n2);
            } else {
                this.printChar(n6, s);
            }
            ++n5;
        }
    }

    private void printString(Out out, int n2, String string) {
        int n3 = 0;
        while (n3 < string.length()) {
            this.addC(string.charAt(n3), this.linelen++);
            ++n3;
        }
    }

    private void printAttrValue(Out out, int n2, String string, int n3, boolean bl) {
        short s;
        MutableInteger mutableInteger = new MutableInteger();
        boolean bl2 = false;
        byte[] byArray = null;
        short s2 = s = bl ? (short)4 : 5;
        if (string != null) {
            byArray = Lexer.getBytes(string);
        }
        if (byArray != null && byArray.length >= 5 && byArray[0] == 60 && (byArray[1] == 37 || byArray[1] == 64 || new String(byArray, 0, 5).equals("<?php"))) {
            s = (short)(s | 0x10);
        }
        if (n3 == 0) {
            n3 = 34;
        }
        this.addC(61, this.linelen++);
        if (!this.configuration.XmlOut) {
            if (n2 + this.linelen < this.configuration.wraplen) {
                this.wraphere = this.linelen;
            }
            if (n2 + this.linelen >= this.configuration.wraplen) {
                this.wrapLine(out, n2);
            }
            if (n2 + this.linelen < this.configuration.wraplen) {
                this.wraphere = this.linelen;
            } else {
                this.condFlushLine(out, n2);
            }
        }
        this.addC(n3, this.linelen++);
        if (string != null) {
            this.InString = false;
            int n4 = 0;
            while (n4 < byArray.length) {
                int n5 = byArray[n4] & 0xFF;
                if (bl && n5 == 32 && n2 + this.linelen < this.configuration.wraplen) {
                    this.wraphere = this.linelen;
                    bl2 = this.InString;
                }
                if (bl && this.wraphere > 0 && n2 + this.linelen >= this.configuration.wraplen) {
                    this.wrapAttrVal(out, n2, bl2);
                }
                if (n5 == n3) {
                    String string2 = n5 == 34 ? "&quot;" : "&#39;";
                    int n6 = 0;
                    while (n6 < string2.length()) {
                        this.addC(string2.charAt(n6), this.linelen++);
                        ++n6;
                    }
                    ++n4;
                    continue;
                }
                if (n5 == 34) {
                    if (this.configuration.QuoteMarks) {
                        this.addC(38, this.linelen++);
                        this.addC(113, this.linelen++);
                        this.addC(117, this.linelen++);
                        this.addC(111, this.linelen++);
                        this.addC(116, this.linelen++);
                        this.addC(59, this.linelen++);
                    } else {
                        this.addC(34, this.linelen++);
                    }
                    if (n3 == 39) {
                        this.InString = !this.InString;
                    }
                    ++n4;
                    continue;
                }
                if (n5 == 39) {
                    if (this.configuration.QuoteMarks) {
                        this.addC(38, this.linelen++);
                        this.addC(35, this.linelen++);
                        this.addC(51, this.linelen++);
                        this.addC(57, this.linelen++);
                        this.addC(59, this.linelen++);
                    } else {
                        this.addC(39, this.linelen++);
                    }
                    if (n3 == 34) {
                        this.InString = !this.InString;
                    }
                    ++n4;
                    continue;
                }
                if (n5 > 127) {
                    n4 += PPrint.getUTF8(byArray, n4, mutableInteger);
                    n5 = mutableInteger.value;
                }
                ++n4;
                if (n5 == 10) {
                    this.flushLine(out, n2);
                    continue;
                }
                this.printChar(n5, s);
            }
        }
        this.InString = false;
        this.addC(n3, this.linelen++);
    }

    private void printAttribute(Out out, int n2, Node node, AttVal attVal) {
        boolean bl = false;
        if (this.configuration.IndentAttributes) {
            this.flushLine(out, n2);
            n2 += this.configuration.spaces;
        }
        String string = attVal.attribute;
        if (n2 + this.linelen >= this.configuration.wraplen) {
            this.wrapLine(out, n2);
        }
        if (!this.configuration.XmlTags && !this.configuration.XmlOut && attVal.dict != null) {
            if (AttributeTable.getDefaultAttributeTable().isScript(string)) {
                bl = this.configuration.WrapScriptlets;
            } else if (!attVal.dict.nowrap && this.configuration.WrapAttVals) {
                bl = true;
            }
        }
        if (n2 + this.linelen < this.configuration.wraplen) {
            this.wraphere = this.linelen;
            this.addC(32, this.linelen++);
        } else {
            this.condFlushLine(out, n2);
            this.addC(32, this.linelen++);
        }
        int n3 = 0;
        while (n3 < string.length()) {
            this.addC(Lexer.foldCase(string.charAt(n3), this.configuration.UpperCaseAttrs, this.configuration.XmlTags), this.linelen++);
            ++n3;
        }
        if (n2 + this.linelen >= this.configuration.wraplen) {
            this.wrapLine(out, n2);
        }
        if (attVal.value == null) {
            if (this.configuration.XmlTags || this.configuration.XmlOut) {
                this.printAttrValue(out, n2, attVal.attribute, attVal.delim, true);
                return;
            }
            if (!attVal.isBoolAttribute() && node != null && node.tag != null && (node.tag.model & 0x100000) == 0 && !false) {
                this.printAttrValue(out, n2, "", attVal.delim, true);
                return;
            }
            if (n2 + this.linelen < this.configuration.wraplen) {
                this.wraphere = this.linelen;
                return;
            }
        } else {
            this.printAttrValue(out, n2, attVal.value, attVal.delim, bl);
        }
    }

    private void printAttrs(Out out, int n2, Node node, AttVal attVal) {
        if (attVal != null) {
            if (attVal.next != null) {
                this.printAttrs(out, n2, node, attVal.next);
            }
            if (attVal.attribute != null) {
                this.printAttribute(out, n2, node, attVal);
            } else if (attVal.asp != null) {
                this.addC(32, this.linelen++);
                this.printAsp(out, n2, attVal.asp);
            } else if (attVal.php != null) {
                this.addC(32, this.linelen++);
                this.printPhp(out, n2, attVal.php);
            }
        }
        if (this.configuration.XmlOut && this.configuration.XmlSpace && ParserImpl.XMLPreserveWhiteSpace(node) && node.getAttrByName("xml:space") == null) {
            this.printString(out, n2, " xml:space=\"preserve\"");
        }
    }

    private static boolean afterSpace(Node node) {
        if (node == null || node.tag == null || (node.tag.model & 0x10) == 0) {
            return true;
        }
        Node node2 = node.prev;
        if (node2 != null) {
            int n2;
            return node2.type == 4 && node2.end > node2.start && ((n2 = node2.textarray[node2.end - 1] & 0xFF) == 160 || n2 == 32 || n2 == 10);
        }
        return PPrint.afterSpace(node.parent);
    }

    private void printTag(Lexer lexer, Out out, short s, int n2, Node node) {
        this.addC(60, this.linelen++);
        if (node.type == 6) {
            this.addC(47, this.linelen++);
        }
        String string = node.element;
        int n3 = 0;
        while (n3 < string.length()) {
            this.addC(Lexer.foldCase(string.charAt(n3), this.configuration.UpperCaseTags, this.configuration.XmlTags), this.linelen++);
            ++n3;
        }
        this.printAttrs(out, n2, node, node.attributes);
        if ((this.configuration.XmlOut || lexer != null && lexer.isvoyager) && (node.type == 7 || (node.tag.model & 1) != 0)) {
            this.addC(32, this.linelen++);
            this.addC(47, this.linelen++);
        }
        this.addC(62, this.linelen++);
        if (node.type != 7 && (s & 1) == 0) {
            if (n2 + this.linelen >= this.configuration.wraplen) {
                this.wrapLine(out, n2);
            }
            if (n2 + this.linelen < this.configuration.wraplen) {
                if (PPrint.afterSpace(node) && (s & 8) == 0) {
                    if ((node.tag.model & 0x10) == 0 || node.tag == TagTable.tagBr || (node.tag.model & 1) != 0 && node.next == null && node.parent.tag == TagTable.tagA) {
                        this.wraphere = this.linelen;
                    }
                    return;
                }
            } else {
                this.condFlushLine(out, n2);
            }
        }
    }

    private void printEndTag(Out out, short s, int n2, Node node) {
        this.addC(60, this.linelen++);
        this.addC(47, this.linelen++);
        String string = node.element;
        int n3 = 0;
        while (n3 < string.length()) {
            this.addC(Lexer.foldCase(string.charAt(n3), this.configuration.UpperCaseTags, this.configuration.XmlTags), this.linelen++);
            ++n3;
        }
        this.addC(62, this.linelen++);
    }

    private void printComment(Out out, int n2, Node node) {
        if (n2 + this.linelen < this.configuration.wraplen) {
            this.wraphere = this.linelen;
        }
        this.addC(60, this.linelen++);
        this.addC(33, this.linelen++);
        this.addC(45, this.linelen++);
        this.addC(45, this.linelen++);
        this.printText(out, (short)2, n2, node.textarray, node.start, node.end);
        this.addC(45, this.linelen++);
        this.addC(45, this.linelen++);
        this.addC(62, this.linelen++);
        if (node.linebreak) {
            this.flushLine(out, n2);
        }
    }

    private void printDocType(Out out, int n2, Node node) {
        boolean bl = this.configuration.QuoteMarks;
        this.configuration.QuoteMarks = false;
        if (n2 + this.linelen < this.configuration.wraplen) {
            this.wraphere = this.linelen;
        }
        this.condFlushLine(out, n2);
        this.addC(60, this.linelen++);
        this.addC(33, this.linelen++);
        this.addC(68, this.linelen++);
        this.addC(79, this.linelen++);
        this.addC(67, this.linelen++);
        this.addC(84, this.linelen++);
        this.addC(89, this.linelen++);
        this.addC(80, this.linelen++);
        this.addC(69, this.linelen++);
        this.addC(32, this.linelen++);
        if (n2 + this.linelen < this.configuration.wraplen) {
            this.wraphere = this.linelen;
        }
        this.printText(out, (short)0, n2, node.textarray, node.start, node.end);
        if (this.linelen < this.configuration.wraplen) {
            this.wraphere = this.linelen;
        }
        this.addC(62, this.linelen++);
        this.configuration.QuoteMarks = bl;
        this.condFlushLine(out, n2);
    }

    private void printPI(Out out, int n2, Node node) {
        if (n2 + this.linelen < this.configuration.wraplen) {
            this.wraphere = this.linelen;
        }
        this.addC(60, this.linelen++);
        this.addC(63, this.linelen++);
        this.printText(out, (short)16, n2, node.textarray, node.start, node.end);
        if (node.textarray[node.end - 1] != 63) {
            this.addC(63, this.linelen++);
        }
        this.addC(62, this.linelen++);
        this.condFlushLine(out, n2);
    }

    private void printAsp(Out out, int n2, Node node) {
        int n3 = this.configuration.wraplen;
        if (!this.configuration.WrapAsp || !this.configuration.WrapJste) {
            this.configuration.wraplen = 0xFFFFFF;
        }
        this.addC(60, this.linelen++);
        this.addC(37, this.linelen++);
        this.printText(out, this.configuration.WrapAsp ? (short)16 : 2, n2, node.textarray, node.start, node.end);
        this.addC(37, this.linelen++);
        this.addC(62, this.linelen++);
        this.configuration.wraplen = n3;
    }

    private void printJste(Out out, int n2, Node node) {
        int n3 = this.configuration.wraplen;
        if (!this.configuration.WrapJste) {
            this.configuration.wraplen = 0xFFFFFF;
        }
        this.addC(60, this.linelen++);
        this.addC(35, this.linelen++);
        this.printText(out, this.configuration.WrapJste ? (short)16 : 2, n2, node.textarray, node.start, node.end);
        this.addC(35, this.linelen++);
        this.addC(62, this.linelen++);
        this.configuration.wraplen = n3;
    }

    private void printPhp(Out out, int n2, Node node) {
        int n3 = this.configuration.wraplen;
        if (!this.configuration.WrapPhp) {
            this.configuration.wraplen = 0xFFFFFF;
        }
        this.addC(60, this.linelen++);
        this.addC(63, this.linelen++);
        this.printText(out, this.configuration.WrapPhp ? (short)16 : 2, n2, node.textarray, node.start, node.end);
        this.addC(63, this.linelen++);
        this.addC(62, this.linelen++);
        this.configuration.wraplen = n3;
    }

    private void printCDATA(Out out, int n2, Node node) {
        int n3 = this.configuration.wraplen;
        this.condFlushLine(out, n2);
        this.configuration.wraplen = 0xFFFFFF;
        this.addC(60, this.linelen++);
        this.addC(33, this.linelen++);
        this.addC(91, this.linelen++);
        this.addC(67, this.linelen++);
        this.addC(68, this.linelen++);
        this.addC(65, this.linelen++);
        this.addC(84, this.linelen++);
        this.addC(65, this.linelen++);
        this.addC(91, this.linelen++);
        this.printText(out, (short)2, n2, node.textarray, node.start, node.end);
        this.addC(93, this.linelen++);
        this.addC(93, this.linelen++);
        this.addC(62, this.linelen++);
        this.condFlushLine(out, n2);
        this.configuration.wraplen = n3;
    }

    private void printSection(Out out, int n2, Node node) {
        int n3 = this.configuration.wraplen;
        if (!this.configuration.WrapSection) {
            this.configuration.wraplen = 0xFFFFFF;
        }
        this.addC(60, this.linelen++);
        this.addC(33, this.linelen++);
        this.addC(91, this.linelen++);
        this.printText(out, this.configuration.WrapSection ? (short)16 : 2, n2, node.textarray, node.start, node.end);
        this.addC(93, this.linelen++);
        this.addC(62, this.linelen++);
        this.configuration.wraplen = n3;
    }

    private boolean shouldIndent(Node node) {
        if (!this.configuration.IndentContent) {
            return false;
        }
        if (this.configuration.SmartIndent) {
            if (node.content != null && (node.tag.model & 0x40000) != 0) {
                node = node.content;
                while (node != null) {
                    if (node.tag != null && (node.tag.model & 8) != 0) {
                        return true;
                    }
                    node = node.next;
                }
                return false;
            }
            if ((node.tag.model & 0x4000) != 0) {
                return false;
            }
            if (node.tag == TagTable.tagP) {
                return false;
            }
            if (node.tag == TagTable.tagTitle) {
                return false;
            }
        }
        if ((node.tag.model & 0xC00) != 0) {
            return true;
        }
        if (node.tag == TagTable.tagMap) {
            return true;
        }
        return (node.tag.model & 0x10) == 0;
    }

    public void printTree(Out out, short s, int n2, Lexer lexer, Node node) {
        if (node == null) {
            return;
        }
        if (node.type == 4) {
            this.printText(out, s, n2, node.textarray, node.start, node.end);
            return;
        }
        if (node.type == 2) {
            this.printComment(out, n2, node);
            return;
        }
        if (node.type == 0) {
            Node node2 = node.content;
            while (node2 != null) {
                this.printTree(out, s, n2, lexer, node2);
                node2 = node2.next;
            }
            return;
        }
        if (node.type == 1) {
            this.printDocType(out, n2, node);
            return;
        }
        if (node.type == 3) {
            this.printPI(out, n2, node);
            return;
        }
        if (node.type == 8) {
            this.printCDATA(out, n2, node);
            return;
        }
        if (node.type == 9) {
            this.printSection(out, n2, node);
            return;
        }
        if (node.type == 10) {
            this.printAsp(out, n2, node);
            return;
        }
        if (node.type == 11) {
            this.printJste(out, n2, node);
            return;
        }
        if (node.type == 12) {
            this.printPhp(out, n2, node);
            return;
        }
        if ((node.tag.model & 1) != 0 || node.type == 7) {
            if ((node.tag.model & 0x10) == 0) {
                this.condFlushLine(out, n2);
            }
            if (node.tag == TagTable.tagBr && node.prev != null && node.prev.tag != TagTable.tagBr && this.configuration.BreakBeforeBR) {
                this.flushLine(out, n2);
            }
            if (this.configuration.MakeClean && node.tag == TagTable.tagWbr) {
                this.printString(out, n2, " ");
            } else {
                this.printTag(lexer, out, s, n2, node);
            }
            if (node.tag == TagTable.tagParam || node.tag == TagTable.tagArea) {
                this.condFlushLine(out, n2);
                return;
            }
            if (node.tag == TagTable.tagBr || node.tag == TagTable.tagHr) {
                this.flushLine(out, n2);
            }
            return;
        }
        if (node.tag != null && node.tag.parser == ParserImpl.getParsePre()) {
            this.condFlushLine(out, n2);
            n2 = 0;
            this.condFlushLine(out, n2);
            this.printTag(lexer, out, s, n2, node);
            this.flushLine(out, n2);
            Node node3 = node.content;
            while (node3 != null) {
                this.printTree(out, (short)(s | 1 | 8), n2, lexer, node3);
                node3 = node3.next;
            }
            this.condFlushLine(out, n2);
            this.printEndTag(out, s, n2, node);
            this.flushLine(out, n2);
            if (!this.configuration.IndentContent && node.next != null) {
                this.flushLine(out, n2);
                return;
            }
        } else if (node.tag == TagTable.tagStyle || node.tag == TagTable.tagScript) {
            this.condFlushLine(out, n2);
            n2 = 0;
            this.condFlushLine(out, n2);
            this.printTag(lexer, out, s, n2, node);
            this.flushLine(out, n2);
            Node node4 = node.content;
            while (node4 != null) {
                this.printTree(out, (short)(s | 1 | 8 | 0x10), n2, lexer, node4);
                node4 = node4.next;
            }
            this.condFlushLine(out, n2);
            this.printEndTag(out, s, n2, node);
            this.flushLine(out, n2);
            if (!this.configuration.IndentContent && node.next != null) {
                this.flushLine(out, n2);
                return;
            }
        } else {
            if ((node.tag.model & 0x10) != 0) {
                if (this.configuration.MakeClean) {
                    if (node.tag == TagTable.tagFont) {
                        Node node5 = node.content;
                        while (node5 != null) {
                            this.printTree(out, s, n2, lexer, node5);
                            node5 = node5.next;
                        }
                        return;
                    }
                    if (node.tag == TagTable.tagNobr) {
                        Node node6 = node.content;
                        while (node6 != null) {
                            this.printTree(out, (short)(s | 8), n2, lexer, node6);
                            node6 = node6.next;
                        }
                        return;
                    }
                }
                this.printTag(lexer, out, s, n2, node);
                if (this.shouldIndent(node)) {
                    this.condFlushLine(out, n2);
                    n2 += this.configuration.spaces;
                    Node node7 = node.content;
                    while (node7 != null) {
                        this.printTree(out, s, n2, lexer, node7);
                        node7 = node7.next;
                    }
                    this.condFlushLine(out, n2);
                    this.condFlushLine(out, n2 -= this.configuration.spaces);
                } else {
                    Node node8 = node.content;
                    while (node8 != null) {
                        this.printTree(out, s, n2, lexer, node8);
                        node8 = node8.next;
                    }
                }
                this.printEndTag(out, s, n2, node);
                return;
            }
            this.condFlushLine(out, n2);
            if (this.configuration.SmartIndent && node.prev != null) {
                this.flushLine(out, n2);
            }
            if (!this.configuration.HideEndTags || node.tag == null || (node.tag.model & 0x200000) == 0) {
                this.printTag(lexer, out, s, n2, node);
                if (this.shouldIndent(node)) {
                    this.condFlushLine(out, n2);
                } else if ((node.tag.model & 2) != 0 || node.tag == TagTable.tagNoframes || (node.tag.model & 4) != 0 && node.tag != TagTable.tagTitle) {
                    this.flushLine(out, n2);
                }
            }
            if (node.tag == TagTable.tagBody && this.configuration.BurstSlides) {
                this.printSlide(out, s, this.configuration.IndentContent ? n2 + this.configuration.spaces : n2, lexer);
            } else {
                Node node9 = null;
                Node node10 = node.content;
                while (node10 != null) {
                    if (node9 != null && !this.configuration.IndentContent && node9.type == 4 && node10.tag != null && (node10.tag.model & 8) != 0) {
                        this.flushLine(out, n2);
                        this.flushLine(out, n2);
                    }
                    this.printTree(out, s, this.shouldIndent(node) ? n2 + this.configuration.spaces : n2, lexer, node10);
                    node9 = node10;
                    node10 = node10.next;
                }
            }
            if (this.shouldIndent(node) || ((node.tag.model & 2) != 0 || node.tag == TagTable.tagNoframes || (node.tag.model & 4) != 0 && node.tag != TagTable.tagTitle) && !this.configuration.HideEndTags) {
                this.condFlushLine(out, this.configuration.IndentContent ? n2 + this.configuration.spaces : n2);
                if (!this.configuration.HideEndTags || (node.tag.model & 0x8000) == 0) {
                    this.printEndTag(out, s, n2, node);
                    this.flushLine(out, n2);
                }
            } else {
                if (!this.configuration.HideEndTags || (node.tag.model & 0x8000) == 0) {
                    this.printEndTag(out, s, n2, node);
                }
                this.flushLine(out, n2);
            }
            if (!this.configuration.IndentContent && node.next != null && !this.configuration.HideEndTags && (node.tag.model & 0xE8) != 0) {
                this.flushLine(out, n2);
            }
        }
    }

    public void printXMLTree(Out out, short s, int n2, Lexer lexer, Node node) {
        if (node == null) {
            return;
        }
        if (node.type == 4) {
            this.printText(out, s, n2, node.textarray, node.start, node.end);
            return;
        }
        if (node.type == 2) {
            this.condFlushLine(out, n2);
            this.printComment(out, 0, node);
            this.condFlushLine(out, 0);
            return;
        }
        if (node.type == 0) {
            Node node2 = node.content;
            while (node2 != null) {
                this.printXMLTree(out, s, n2, lexer, node2);
                node2 = node2.next;
            }
            return;
        }
        if (node.type == 1) {
            this.printDocType(out, n2, node);
            return;
        }
        if (node.type == 3) {
            this.printPI(out, n2, node);
            return;
        }
        if (node.type == 9) {
            this.printSection(out, n2, node);
            return;
        }
        if (node.type == 10) {
            this.printAsp(out, n2, node);
            return;
        }
        if (node.type == 11) {
            this.printJste(out, n2, node);
            return;
        }
        if (node.type == 12) {
            this.printPhp(out, n2, node);
            return;
        }
        if ((node.tag.model & 1) != 0 || node.type == 7) {
            this.condFlushLine(out, n2);
            this.printTag(lexer, out, s, n2, node);
            this.flushLine(out, n2);
            if (node.next != null) {
                this.flushLine(out, n2);
                return;
            }
        } else {
            int n3;
            boolean bl = false;
            Node node3 = node.content;
            while (node3 != null) {
                if (node3.type == 4) {
                    bl = true;
                    break;
                }
                node3 = node3.next;
            }
            this.condFlushLine(out, n2);
            if (ParserImpl.XMLPreserveWhiteSpace(node)) {
                n2 = 0;
                n3 = 0;
                bl = false;
            } else {
                n3 = bl ? n2 : n2 + this.configuration.spaces;
            }
            this.printTag(lexer, out, s, n2, node);
            if (!bl) {
                this.flushLine(out, n2);
            }
            node3 = node.content;
            while (node3 != null) {
                this.printXMLTree(out, s, n3, lexer, node3);
                node3 = node3.next;
            }
            if (!bl) {
                this.condFlushLine(out, n3);
            }
            this.printEndTag(out, s, n2, node);
            this.condFlushLine(out, n2);
            if (node.next != null) {
                this.flushLine(out, n2);
            }
        }
    }

    public static int countSlides(Node node) {
        int n2 = 1;
        node = node.content;
        while (node != null) {
            if (node.tag == TagTable.tagH2) {
                ++n2;
            }
            node = node.next;
        }
        return n2;
    }

    private void printVertSpacer(Out out, int n2) {
        this.condFlushLine(out, n2);
        this.printString(out, n2, "<img width=\"0\" height=\"0\" hspace=\"1\" src=\"dot.gif\" vspace=\"%d\" align=\"left\">");
        this.condFlushLine(out, n2);
    }

    private void printNavBar(Out out, int n2) {
        String string;
        this.condFlushLine(out, n2);
        this.printString(out, n2, "<center><small>");
        if (this.slide > 1) {
            string = "<a href=\"slide" + new Integer(this.slide - 1).toString() + ".html\">previous</a> | ";
            this.printString(out, n2, string);
            this.condFlushLine(out, n2);
            if (this.slide < this.count) {
                this.printString(out, n2, "<a href=\"slide1.html\">start</a> | ");
            } else {
                this.printString(out, n2, "<a href=\"slide1.html\">start</a>");
            }
            this.condFlushLine(out, n2);
        }
        if (this.slide < this.count) {
            string = "<a href=\"slide" + new Integer(this.slide + 1).toString() + ".html\">next</a>";
            this.printString(out, n2, string);
        }
        this.printString(out, n2, "</small></center>");
        this.condFlushLine(out, n2);
    }

    public void printSlide(Out out, short s, int n2, Lexer lexer) {
        String string = "<div onclick=\"document.location='slide" + new Integer(this.slide < this.count ? this.slide + 1 : 1).toString() + ".html'\">";
        this.printString(out, n2, string);
        this.condFlushLine(out, n2);
        if (this.slidecontent.tag == TagTable.tagH2) {
            this.printNavBar(out, n2);
            this.addC(60, this.linelen++);
            this.addC(Lexer.foldCase('h', this.configuration.UpperCaseTags, this.configuration.XmlTags), this.linelen++);
            this.addC(Lexer.foldCase('r', this.configuration.UpperCaseTags, this.configuration.XmlTags), this.linelen++);
            if (this.configuration.XmlOut) {
                this.printString(out, n2, " />");
            } else {
                this.addC(62, this.linelen++);
            }
            if (this.configuration.IndentContent) {
                this.condFlushLine(out, n2);
            }
            this.printTree(out, s, this.configuration.IndentContent ? n2 + this.configuration.spaces : n2, lexer, this.slidecontent);
            this.slidecontent = this.slidecontent.next;
        }
        Node node = null;
        Node node2 = this.slidecontent;
        while (node2 != null) {
            if (node2.tag == TagTable.tagH2) break;
            if (node != null && !this.configuration.IndentContent && node.type == 4 && node2.tag != null && (node2.tag.model & 8) != 0) {
                this.flushLine(out, n2);
                this.flushLine(out, n2);
            }
            this.printTree(out, s, this.configuration.IndentContent ? n2 + this.configuration.spaces : n2, lexer, node2);
            node = node2;
            node2 = node2.next;
        }
        this.slidecontent = node2;
        this.condFlushLine(out, n2);
        this.printString(out, n2, "<br clear=\"all\">");
        this.condFlushLine(out, n2);
        this.addC(60, this.linelen++);
        this.addC(Lexer.foldCase('h', this.configuration.UpperCaseTags, this.configuration.XmlTags), this.linelen++);
        this.addC(Lexer.foldCase('r', this.configuration.UpperCaseTags, this.configuration.XmlTags), this.linelen++);
        if (this.configuration.XmlOut) {
            this.printString(out, n2, " />");
        } else {
            this.addC(62, this.linelen++);
        }
        if (this.configuration.IndentContent) {
            this.condFlushLine(out, n2);
        }
        this.printNavBar(out, n2);
        this.printString(out, n2, "</div>");
        this.condFlushLine(out, n2);
    }

    public void addTransitionEffect(Lexer lexer, Node node, short s, double d2) {
        Node node2 = Node.findHead(node);
        String string = s >= 0 && s <= 23 ? "revealTrans(Duration=" + new Double(d2).toString() + ",Transition=" + s + ")" : "blendTrans(Duration=" + new Double(d2).toString() + ")";
        if (node2 != null) {
            Node node3 = lexer.inferredTag("meta");
            node3.addAttribute("http-equiv", "Page-Enter");
            node3.addAttribute("content", string);
            Node.insertNodeAtStart(node2, node3);
        }
    }

    public void createSlides(Lexer lexer, Node node) {
        String string;
        OutImpl outImpl = new OutImpl();
        Node node2 = Node.findBody(node);
        this.count = PPrint.countSlides(node2);
        this.slidecontent = node2.content;
        this.addTransitionEffect(lexer, node, (short)-1, 3.0);
        this.slide = 1;
        while (this.slide <= this.count) {
            string = "slide" + this.slide + ".html";
            outImpl.state = 0;
            outImpl.encoding = this.configuration.CharEncoding;
            try {
                outImpl.out = new FileOutputStream(string);
                this.printTree(outImpl, (short)0, 0, lexer, node);
                this.flushLine(outImpl, 0);
                outImpl.out.close();
            }
            catch (IOException iOException) {
                System.err.println(String.valueOf(string) + iOException.toString());
            }
            ++this.slide;
        }
        while (new File(string = "slide" + this.slide + "html").delete()) {
            ++this.slide;
        }
    }
}

