/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.util;

import java.text.ParseException;
import java.util.StringTokenizer;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.util.OIDTextFormat;

public class SimpleOIDTextFormat
implements OIDTextFormat {
    public static String formatOID(int[] value) {
        StringBuilder buf = new StringBuilder(3 * value.length);
        for (int i2 = 0; i2 < value.length; ++i2) {
            if (i2 != 0) {
                buf.append('.');
            }
            buf.append((long)value[i2] & 0xFFFFFFFFL);
        }
        return buf.toString();
    }

    @Override
    public String format(int[] value) {
        return SimpleOIDTextFormat.formatOID(value);
    }

    @Override
    public String formatForRoundTrip(int[] value) {
        return this.format(value);
    }

    public static int[] parseOID(String text) throws ParseException {
        StringTokenizer st = new StringTokenizer(text, ".", true);
        int size = st.countTokens();
        int[] value = new int[size];
        size = 0;
        StringBuffer buf = null;
        while (st.hasMoreTokens()) {
            String t = st.nextToken();
            if (buf == null && t.startsWith("'")) {
                buf = new StringBuffer();
                t = t.substring(1);
            }
            if (buf != null && t.endsWith("'")) {
                buf.append(t.substring(0, t.length() - 1));
                OID o2 = new OctetString(buf.toString()).toSubIndex(true);
                int[] h2 = value;
                value = new int[st.countTokens() + h2.length + o2.size()];
                System.arraycopy(h2, 0, value, 0, size);
                System.arraycopy(o2.getValue(), 0, value, size, o2.size());
                size += o2.size();
                buf = null;
                continue;
            }
            if (buf != null) {
                buf.append(t);
                continue;
            }
            if (".".equals(t)) continue;
            value[size++] = (int)Long.parseLong(t.trim());
        }
        if (size < value.length) {
            int[] h3 = value;
            value = new int[size];
            System.arraycopy(h3, 0, value, 0, size);
        }
        return value;
    }

    @Override
    public int[] parse(String text) throws ParseException {
        return SimpleOIDTextFormat.parseOID(text);
    }
}

