/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.security;

import java.io.Serializable;
import javax.crypto.Cipher;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.mp.SnmpConstants;
import org.snmp4j.security.AuthenticationProtocol;
import org.snmp4j.security.CipherPool;
import org.snmp4j.security.DecryptParams;
import org.snmp4j.security.PrivacyGeneric;
import org.snmp4j.security.Salt;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;

public class Priv3DES
extends PrivacyGeneric {
    public static final OID ID = new OID(SnmpConstants.usm3DESEDEPrivProtocol);
    private static final String PROTOCOL_ID = "DESede/CBC/NoPadding";
    private static final String PROTOCOL_CLASS = "DESede";
    private static final int DECRYPT_PARAMS_LENGTH = 8;
    private static final int INIT_VECTOR_LENGTH = 8;
    private static final int INPUT_KEY_LENGTH = 32;
    private static final int KEY_LENGTH = 24;
    protected Salt salt;
    private static final LogAdapter logger = LogFactory.getLogger(Priv3DES.class);

    public Priv3DES() {
        this.initVectorLength = 8;
        this.protocolId = PROTOCOL_ID;
        this.protocolClass = PROTOCOL_CLASS;
        this.keyBytes = 24;
        this.salt = Salt.getInstance();
        this.cipherPool = new CipherPool();
    }

    @Override
    public byte[] encrypt(byte[] unencryptedData, int offset, int length, byte[] encryptionKey, long engineBoots, long engineTime, DecryptParams decryptParams) {
        byte[] encryptedData;
        block9: {
            int mySalt = (int)this.salt.getNext();
            if (encryptionKey.length < 32) {
                logger.error((Serializable)((Object)("Wrong Key length: need at least 32 bytes, is " + encryptionKey.length + " bytes.")));
                throw new IllegalArgumentException("encryptionKey has illegal length " + encryptionKey.length + " (should be at least 32).");
            }
            if (decryptParams.array == null || decryptParams.length < 8) {
                decryptParams.array = new byte[8];
            }
            decryptParams.length = 8;
            decryptParams.offset = 0;
            if (logger.isDebugEnabled()) {
                logger.debug((Serializable)((Object)"Preparing decrypt_params."));
            }
            for (int i2 = 0; i2 < 4; ++i2) {
                decryptParams.array[3 - i2] = (byte)(0xFFL & engineBoots >> 8 * i2);
                decryptParams.array[7 - i2] = (byte)(0xFF & mySalt >> 8 * i2);
            }
            byte[] iv = new byte[8];
            if (logger.isDebugEnabled()) {
                logger.debug((Serializable)((Object)"Preparing iv for encryption."));
            }
            for (int i3 = 0; i3 < 8; ++i3) {
                iv[i3] = (byte)(encryptionKey[24 + i3] ^ decryptParams.array[i3]);
            }
            encryptedData = null;
            try {
                Cipher alg = this.doInit(encryptionKey, iv);
                encryptedData = this.doFinalWithPadding(unencryptedData, offset, length, alg);
                this.cipherPool.offerCipher(alg);
            }
            catch (Exception e2) {
                logger.error(e2);
                if (!logger.isDebugEnabled()) break block9;
                e2.printStackTrace();
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Serializable)((Object)"Encryption finished."));
        }
        return encryptedData;
    }

    @Override
    public byte[] decrypt(byte[] cryptedData, int offset, int length, byte[] decryptionKey, long engineBoots, long engineTime, DecryptParams decryptParams) {
        if (length % 8 != 0 || length < 8 || decryptParams.length != 8) {
            throw new IllegalArgumentException("Length (" + length + ") is not multiple of 8 or decrypt params has not length 8 (" + decryptParams.length + ").");
        }
        if (decryptionKey.length < 32) {
            logger.error((Serializable)((Object)("Wrong Key length: need at least 32 bytes, is " + decryptionKey.length + " bytes.")));
            throw new IllegalArgumentException("decryptionKey has illegal length " + decryptionKey.length + " (should be at least 32).");
        }
        byte[] iv = new byte[8];
        for (int i2 = 0; i2 < 8; ++i2) {
            iv[i2] = (byte)(decryptionKey[24 + i2] ^ decryptParams.array[i2]);
        }
        byte[] decryptedData = this.doDecrypt(cryptedData, offset, length, decryptionKey, iv);
        return decryptedData;
    }

    @Override
    public OID getID() {
        return (OID)ID.clone();
    }

    @Override
    public int getEncryptedLength(int scopedPDULength) {
        if (scopedPDULength % 8 == 0) {
            return scopedPDULength;
        }
        return 8 * (scopedPDULength / 8 + 1);
    }

    @Override
    public int getMinKeyLength() {
        return 32;
    }

    @Override
    public int getDecryptParamsLength() {
        return 8;
    }

    @Override
    public int getMaxKeyLength() {
        return this.getMinKeyLength();
    }

    @Override
    public byte[] extendShortKey(byte[] shortKey, OctetString password, byte[] engineID, AuthenticationProtocol authProtocol) {
        int copyBytes;
        byte[] extendedKey = new byte[this.getMinKeyLength()];
        System.arraycopy(shortKey, 0, extendedKey, 0, shortKey.length);
        byte[] key = new byte[this.getMinKeyLength()];
        System.arraycopy(shortKey, 0, key, 0, shortKey.length);
        for (int length = shortKey.length; length < this.getMinKeyLength(); length += copyBytes) {
            key = authProtocol.passwordToKey(new OctetString(key, 0, length), engineID);
            copyBytes = Math.min(this.getMinKeyLength() - length, authProtocol.getDigestLength());
            System.arraycopy(key, 0, extendedKey, length, copyBytes);
        }
        return extendedKey;
    }
}

