/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.asn1;

import java.io.IOException;
import java.io.InputStream;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;

public class BERInputStream
extends InputStream {
    private ByteBuffer buffer;

    public BERInputStream(ByteBuffer buffer) {
        this.buffer = buffer;
        buffer.mark();
    }

    public ByteBuffer getBuffer() {
        return this.buffer;
    }

    public void setBuffer(ByteBuffer buf) {
        this.buffer = buf;
    }

    @Override
    public int read() throws IOException {
        try {
            return this.buffer.get() & 0xFF;
        }
        catch (BufferUnderflowException ex) {
            throw new IOException("Unexpected end of input stream at position " + this.getPosition());
        }
    }

    @Override
    public int available() throws IOException {
        return this.buffer.remaining();
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.buffer.mark();
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public int read(byte[] b2) throws IOException {
        if (this.buffer.remaining() <= 0) {
            return -1;
        }
        int read = Math.min(this.buffer.remaining(), b2.length);
        this.buffer.get(b2, 0, read);
        return read;
    }

    @Override
    public int read(byte[] b2, int off, int len) throws IOException {
        if (this.buffer.remaining() <= 0) {
            return -1;
        }
        int read = Math.min(this.buffer.remaining(), b2.length);
        this.buffer.get(b2, off, len);
        return read;
    }

    @Override
    public synchronized void reset() throws IOException {
        this.buffer.reset();
    }

    @Override
    public long skip(long n2) throws IOException {
        long skipped = Math.min((long)this.buffer.remaining(), n2);
        this.buffer.position((int)((long)this.buffer.position() + skipped));
        return skipped;
    }

    public long getPosition() {
        return this.buffer.position();
    }

    public boolean isMarked() {
        return true;
    }

    public int getAvailableBytes() {
        return this.buffer.limit();
    }
}

